// -*- C++ -*-

/* 
 * GChemPaint library
 * fragment.h 
 *
 * Copyright (C) 2002-2004
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GCHEMPAINT_FRAGMENT_H
#define GCHEMPAINT_FRAGMENT_H

#include "text-object.h"
#include "libgnomecanvas/gnome-canvas.h"

using namespace gcu;

class gcpFragmentAtom;
class gcpAtom;

class gcpFragment: public gcpTextObject
{
friend class gcpFragmentTool;
public:
	gcpFragment();
	gcpFragment(double x, double y);
	virtual ~gcpFragment();

	virtual void SetSelected(GtkWidget* w, int state);
	virtual void Add(GtkWidget* w);
	virtual void Update(GtkWidget* w);
	virtual xmlNodePtr Save(xmlDocPtr xml);
	xmlNodePtr SaveSelection(xmlDocPtr xml);
	virtual bool Load(xmlNodePtr);
	virtual bool OnChanged(GtkTextBuffer *textbuffer);
	virtual bool OnMarkSet(GtkTextBuffer *textbuffer, GtkTextIter *iter, GtkTextMark *mark);
	virtual bool OnInsertText(GtkTextBuffer *textbuffer, GtkTextIter *iter, gchar* newtext, gint length);
	virtual bool OnEndUserAction(GtkTextBuffer *textbuffer);
	void AnalContent();
	void AnalContent(GtkTextIter& start, GtkTextIter &end);
	virtual Object* GetAtomAt(double x, double y, double z = 0.);
	virtual void Move(double x, double y, double z = 0);
	virtual void Transform2D(Matrix2D& m, double x, double y);
	void OnChangeAtom();
	gcpAtom* GetAtom() {return (gcpAtom*)m_Atom;}
	int GetElementAtIter(GtkTextIter* start, GtkTextIter *end);
	int GetChargePosition(gcpFragmentAtom* pAtom, double& x, double& y);
	bool Validate();
	virtual double GetYAlign ();

private:
	bool SavePortion(xmlDocPtr xml, xmlNodePtr node, GtkTextIter& start, GtkTextIter& end);
	void AddChargeItem(GnomeCanvasGroup* group);

private:
	gcpFragmentAtom *m_Atom;
	GtkTextMark *m_BeginAtom, *m_EndAtom;
	int m_lbearing;
	double m_CHeight;
};

#endif	//GCHEMPAINT_FRAGMENT_H
