// -*- C++ -*-

/* 
 * GChemPaint library
 * reaction.h 
 *
 * Copyright (C) 2002-2004
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GCHEMPAINT_REACTION_H
#define GCHEMPAINT_REACTION_H

#include "molecule.h"
#include "arrow.h"
#include <stdexcept>

class gcpReaction;

extern TypeId ReactionStepType;

class gcpReactionStep: public Object
{
public:
	gcpReactionStep ();
	virtual ~gcpReactionStep ();

	gcpReactionStep (gcpReaction *reaction, map<double, Object*>& Children, map<Object*, ArtDRect> Objects);

	virtual xmlNodePtr Save(xmlDocPtr xml);
	virtual bool Load(xmlNodePtr);
	virtual double GetYAlign ();
};

class gcpReactant: public Object
{
public:
	gcpReactant ();
	virtual ~gcpReactant ();

	gcpReactant (gcpReactionStep* step, Object* object) throw (std::invalid_argument);
	
//	virtual xmlNodePtr Save(xmlDocPtr xml);
//	virtual bool Load(xmlNodePtr);
	unsigned GetStoech() {return m_Stoech;}
	void SetStoech(unsigned Stoech) {m_Stoech = Stoech;}

	unsigned GetStoichiometry () {return m_Stoech;}
	void SetStoechiometry (unsigned coef) {m_Stoech = coef;}
	virtual double GetYAlign ();

private:
	unsigned m_Stoech;	//always positive
};

class gcpReactionOperator: public Object
{
public:
	gcpReactionOperator(gcpReaction* react, unsigned Step = 0);
	virtual ~gcpReactionOperator();
	
	virtual xmlNodePtr Save(xmlDocPtr xml);
	virtual bool Load(xmlNodePtr);
	virtual void Add(GtkWidget* w);
	virtual void Update(GtkWidget* w);
	virtual void Move(double x, double y, double z = 0);
	virtual void SetSelected(GtkWidget* w, int state);
	unsigned GetStep() {return m_Step;}
	void SetStep(unsigned Step) {m_Step = Step;}
	void SetCoords(double x, double y);
	bool GetCoords(double* x, double* y);
	virtual double GetYAlign ();
	
private:
	unsigned m_Step;
	double m_x, m_y;
};

class gcpReactionArrow: public gcpArrow
{
public:
	gcpReactionArrow(gcpReaction* react, gcpArrowType Type = gcpSimpleArrow);
	virtual ~gcpReactionArrow();
	
	virtual xmlNodePtr Save(xmlDocPtr xml);
	virtual bool Load(xmlNodePtr);
	virtual void Add(GtkWidget* w);
	virtual void Update(GtkWidget* w);
	void SetStartStep (gcpReactionStep *Step) {m_Start = Step;}
	gcpReactionStep* GetStartStep () {return m_Start;}
	void SetEndStep (gcpReactionStep *Step) {m_End = Step;}
	gcpReactionStep* GetEndStep () {return m_End;}

private:
	gcpArrowType m_Type;
	gcpReactionStep *m_Start, *m_End;
};

class gcpReaction: public Object
{
public:
	gcpReaction();
	virtual ~gcpReaction();
	
	virtual void Add(GtkWidget* w);
	virtual bool Build (list<Object*>& Children) throw (invalid_argument);
	virtual void Transform2D(Matrix2D& m, double x, double y);
};

#endif	//GCHEMPAINT_REACTION_H
