// -*- C++ -*-

/* 
 * GChemPaint cycles plugin
 * plugin.cc 
 *
 * Copyright (C) 2004
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "gchempaint-config.h"
#include "plugin.h"
#include "lib/application.h"
#include "cycletool.h"

gcpCyclesPlugin plugin;

gcpCyclesPlugin::gcpCyclesPlugin(): gcpPlugin()
{
}

gcpCyclesPlugin::~gcpCyclesPlugin()
{
}

void gcpCyclesPlugin::Populate (gcpApplication* App)
{
	App->AddUI (DATADIR"/gchempaint/ui/cycles.xml");
	new gcpCycleTool (App, 3);
	new gcpCycleTool (App, 4);
	new gcpCycleTool (App, 5);
	new gcpCycleTool (App, 6);
	new gcpCycleTool (App, 7);
	new gcpCycleTool (App, 8);
	new gcpNCycleTool (App, 9);
}
