// -*- C++ -*-

/* 
 * GChemPaint library
 * chain.h 
 *
 * Copyright (C) 2001-2004
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GCHEMPAINT_CHAIN_H
#define GCHEMPAINT_CHAIN_H

#include "atom.h"
#include "bond.h"
#include <map>

using namespace gcu;

class gcpMolecule;

typedef struct
{
	gcpBond *fwd, *rev;
} gcpChainElt;

class gcpChain: public Object
{
public:
	gcpChain(gcpBond* pBond, gcpAtom* pAtom = NULL, TypeId Type = ChainType);
	gcpChain(gcpMolecule* Molecule, gcpBond* pBond, TypeId Type = ChainType);
	gcpChain(gcpMolecule* Molecule, gcpAtom* pAtom, TypeId Type = ChainType);
	virtual ~gcpChain();
	
	void FindCycles(gcpAtom* pAtom);
	bool FindCycle(gcpAtom* pAtom, gcpBond* pBond);
	virtual void Erase(gcpAtom* pAtom1, gcpAtom* pAtom2);
	virtual void Insert(gcpAtom* pAtom1, gcpAtom* pAtom2, gcpChain& Chain);
	void Extract(gcpAtom* pAtom1, gcpAtom* pAtom2, gcpChain& Chain);
	void Reverse();
	void AddBond(gcpAtom* start, gcpAtom* end);
	unsigned GetUnsaturations();
	unsigned GetHeteroatoms();
	bool Contains(gcpAtom* pAtom);
	bool Contains(gcpBond* pBond);
	unsigned GetLength();
	double GetMeanBondLength();
	gcpAtom* GetNextAtom(gcpAtom* pAtom);

protected:
	map<gcpAtom*, gcpChainElt> m_Bonds;
	gcpMolecule* m_Molecule;
	guint m_nMolIndex;
};

#endif // GCHEMPAINT_CHAIN_H
