// -*- C++ -*-

/* 
 * GChemPaint library
 * widgetdata.h
 *
 * Copyright (C) 2002-2004
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GCHEMPAINT_WIDGET_DATA_H
#define GCHEMPAINT_WIDGET_DATA_H

#include <libgnomecanvas/gnome-canvas.h>
#include <map>
#include <list>
#include <gcu/object.h>

using namespace gcu;

class gcpApplication;

extern guint ClipboardDataType, ClipboardDataType1;
extern xmlChar* ClipboardData;
extern bool cleared;
void on_receive_targets(GtkClipboard *clipboard, GtkSelectionData *selection_data, gcpApplication *App);
void on_clear_data(GtkClipboard *clipboard, gcpApplication *App);

enum
{
	SelStateUnselected = 0,
	SelStateSelected,
	SelStateUpdating,
	SelStateErasing
};

class gcpView;

class gcpWidgetData
{
public:
	gcpView* View;
	GtkWidget *Canvas;
	GnomeCanvasGroup *Group;
	GnomeCanvasItem* Background;
	double ZoomFactor;
	double Padding;
	double StereoBondWidth;
	double BondWidth;
	double BondDist;
	double HashWidth;
	double HashDist;
	double BondLength;
	double ArrowLength;
	double ArrowHeadA;
	double ArrowHeadB;
	double ArrowHeadC;
	double ArrowDist;
	double ArrowPadding;
	double SignPadding;
	std::map<Object*, GnomeCanvasGroup*>Items;
	std::list<Object*>SelectedObjects;
	
	bool IsSelected(Object* obj);
	void SetSelected(Object* obj);
	void Unselect(Object* obj);
	void UnselectAll();
	void MoveSelectedItems(double dx, double dy);
	void MoveSelection(double dx, double dy);
	void RotateSelection(double dx, double dy, double angle);
	bool ClearSelection() {SelectedObjects.clear();}
	void Copy(GtkClipboard* clipboard);
	void GetSelectionBounds(ArtDRect &rect);
	bool HasSelection() {return !(SelectedObjects.empty());}
	void SelectAll();
	static xmlDocPtr GetXmlDoc(GtkClipboard* clipboard);
	void ShowSelection(bool state);
	void GetObjectBounds(Object* obj, ArtDRect *rect);

private:
	void MoveItems(Object *obj, double dx, double dy);
	void GetObjectBounds(Object* obj, ArtDRect &rect);
};


#endif //GCHEMPAINT_WIDGET_DATA_H
