// -*- C++ -*-

/* 
 * GChemPaint library
 * plugin.cc 
 *
 * Copyright (C) 2004
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */
 
#include "gchempaint-config.h"
#include "plugin.h"
#include "application.h"
#include <dlfcn.h>
#include <glib.h>

set<gcpPlugin*> Plugins;

gcpPlugin::gcpPlugin ()
{
	Plugins.insert (this);
}

gcpPlugin::~gcpPlugin ()
{
}

void gcpPlugin::LoadPlugins ()
{
	GDir* dir = g_dir_open (LIBDIR"/gchempaint/plugins", 0, NULL);
	if (dir ==  NULL) return;
	const char* name;
	while (name = g_dir_read_name (dir)) {
		if (strcmp (name + strlen (name) - 3, ".so")) continue;
		name = g_strconcat (LIBDIR"/gchempaint/plugins/", name);
		if (!dlopen (name, RTLD_NOW)) puts (dlerror());
		g_free ((void*) name);
	}
	g_dir_close(dir);
	set<gcpPlugin*>::iterator i = Plugins.begin (), end = Plugins.end ();
	while (i != end) (*i++)->AddRules ();
}

void gcpPlugin::Populate (gcpApplication* App)
{
}

void gcpPlugin::AddRules ()
{
}
