// -*- C++ -*-

/* 
 * GChemPaint arrows plugin
 * plugin.cc 
 *
 * Copyright (C) 2004
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "gchempaint-config.h"
#include "plugin.h"
#include "lib/application.h"
#include "arrowtool.h"
#include "retrosynthesis.h"
#include "retrosynthesisarrow.h"
#include <glib/gi18n.h>
	
gcpArrowsPlugin plugin;

static Object* CreateRetrosynthesis ()
{
	return new gcpRetrosynthesis ();
}

static Object* CreateRetrosynthesisArrow ()
{
	return new gcpRetrosynthesisArrow ();
}

gcpArrowsPlugin::gcpArrowsPlugin (): gcpPlugin ()
{
	RetrosynthesisType = Object::AddType ("retrosynthesis", CreateRetrosynthesis);
	Object::SetCreationLabel (RetrosynthesisType, _("Create a new retrosynthesis pathway"));
	RetrosynthesisArrowType = Object::AddType ("retrosynthesis-arrow", CreateRetrosynthesisArrow);
}

gcpArrowsPlugin::~gcpArrowsPlugin ()
{
}

void gcpArrowsPlugin::Populate (gcpApplication* App)
{
	App->AddUI (DATADIR"/gchempaint/ui/arrows.xml");
	new gcpArrowTool (App);
	new gcpArrowTool (App, gcpReversibleArrow);
	new gcpArrowTool (App, gcpDoubleHeadedArrow);
	new gcpArrowTool (App, gcpDoubleQueuedArrow);
	Object::AddRule ("retrosynthesis", RuleMustContain, "molecule");
	Object::AddRule ("retrosynthesis", RuleMustContain, "retrosynthesis-arrow");
	Object::AddRule ("retrosynthesis-arrow", RuleMustBeIn, "retrosynthesis");
}
