// -*- C++ -*-

/* 
 * GChemPaint library
 * reactant.h 
 *
 * Copyright (C) 2004-2005
 *
 * Developed by Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GCHEMPAINT_REACTANT_H
#define GCHEMPAINT_REACTANT_H

#include <gcu/object.h>

using namespace gcu;

class gcpReactionStep;

class gcpReactant: public Object
{
public:
	gcpReactant ();
	virtual ~gcpReactant ();

	gcpReactant (gcpReactionStep* step, Object* object) throw (std::invalid_argument);
	
	virtual xmlNodePtr Save (xmlDocPtr xml);
	virtual bool Load (xmlNodePtr);
	unsigned GetStoech () {return m_Stoech;}
	void SetStoech (unsigned Stoech) {m_Stoech = Stoech;}

	unsigned GetStoechiometry () {return m_Stoech;}
	void SetStoechiometry (unsigned coef) {m_Stoech = coef;}
	virtual double GetYAlign ();
	virtual bool BuildContextualMenu (GtkUIManager *UIManager, Object *object);
	virtual bool OnSignal (SignalId Signal, Object *Child);
	
	void AddStoechiometry ();
	Object *GetChild () {return Child;}
	Object *GetStoechChild () {return Stoechiometry;}

private:
	unsigned m_Stoech;	//always positive
	Object *Stoechiometry;
	Object *Child;
};

#endif //	GCHEMPAINT_REACTANT_H
