// -*- C++ -*-

/* 
 * GChemPaint library
 * about.cc 
 *
 * Copyright (C) 2004-2005
 *
 * Developed by Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "gchempaint-config.h"
#include "about.h"
#include <glib/gi18n.h>
#include <gtk/gtk.h>
#include <string.h>

void on_about (GtkWidget* widget, void* data)
{
	char * authors[] = {"Jean Bréfort", NULL};
	char * artists[] = {"Nestor Diaz", NULL};
	char * documentors[] = {NULL};
	char license[] = "This program is free software; you can redistribute it and/or" 
		"modify it under the terms of the GNU General Public License as"
 		"published by the Free Software Foundation; either version 2 of the"
		"License, or (at your option) any later version.\n\n"
		"This program is distributed in the hope that it will be useful,"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the"
		"GNU General Public License for more details.\n\n"
		"You should have received a copy of the GNU General Public License"
		"along with this program; if not, write to the Free Software"
		"Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307"
		"USA";
/* Note to translators: replace the following string with the appropriate credits for you lang */
	char *translator_credits = _("translator_credits");
/*	char * translators = g_strconcat (
		_("Jean Bréfort <jean.brefort@ac-dijon.fr>: French"), "\n",
		_("Christian Neumair <christian-neumair@web.de>: German"), "\n",
		_("Costantino Ceoldo: Italian"), "\n",
		_("Ben Luo: Chinese"), "\n",
		_("Michał Sałaban: Polish"), "\n",
		_("Nikodem Kuznik: Polish"),
		NULL);*/
	GdkPixbuf* pixbuf = gdk_pixbuf_new_from_file ( DATADIR"/pixmaps/gchempaint_logo.png", NULL);
	gtk_show_about_dialog (NULL,
					"name", "GChemPaint",
					"authors", authors,
					"artists", artists,
					"comments", _("GChemPaint is a 2D chemical structures editor for Gnome"),
					"copyright", _("(C) 2001-2005 by Jean Bréfort"),
					"license", license,
					"logo", pixbuf,
					"translator_credits", strcmp (translator_credits, "translator_credits") != 0 ? 
											(const char *)translator_credits : NULL,
					"version", VERSION,
					"website", "http://www.nongnu.org/gchempaint",
					NULL);
	/*gnome_about_new (_("GChemPaint"), VERSION,
										_("(C) 2001-2005 by Jean Bréfort"),
										_("GChemPaint is a 2D chemical structures editor for Gnome"),
										(const gchar**) authors, (const gchar**) documentors,
										strcmp (translator_credits, "translator_credits") != 0 ? 
											(const char *)translator_credits : NULL,
										pixbuf);*/
	if (pixbuf != NULL)
		g_object_unref (pixbuf);
//	g_free (translators);
//	gtk_widget_show_all (about);
}
