// -*- C++ -*-

/* 
 * GChemPaint library
 * fragment-atom.h 
 *
 * Copyright (C) 2003-2004
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GCHEMPAINT_FRAGMENT_ATOM_H
#define GCHEMPAINT_FRAGMENT_ATOM_H

#include "atom.h"

class gcpFragment;

class gcpFragmentAtom: public gcpAtom
{
public:
	gcpFragmentAtom();
	gcpFragmentAtom(gcpFragment *fragment, int Z);
	virtual ~gcpFragmentAtom();

	virtual void SetZ(int Z);
	virtual bool AcceptNewBonds(int nb);
	virtual void Add(GtkWidget* w);
	virtual void Update(GtkWidget* w);
	virtual void SetSelected(GtkWidget* w, int state);
	virtual xmlNodePtr Save(xmlDocPtr xml);
	virtual bool Load(xmlNodePtr node);
	virtual int GetChargePosition(char& Pos, double Angle, double& x, double& y);
	virtual int GetAvailablePosition(double& x, double& y);
	virtual bool GetPosition(double angle, double& x, double& y);
	virtual bool AcceptCharge (int charge);

/*!
@param Mol: a pointer to a molecule

Adds the fragment containing the atom to the molecule calling gcpMolecule::AddFragment()
*/
	virtual void AddToMolecule(gcpMolecule* Mol);

private:
	gcpFragment *m_Fragment;
};

#endif // GCHEMPAINT_FRAGMENT_ATOM_H
