// -*- C++ -*-

/* 
 * GChemPaint cycles plugin
 * cycletool.h 
 *
 * Copyright (C) 2001-2004
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GCHEMPAINT_CYCLE_TOOL_H
#define GCHEMPAINT_CYCLE_TOOL_H

#include "lib/tool.h"

class gcpAtom;
class gcpChain;

class gcpCycleTool: public gcpTool
{
public:
	gcpCycleTool(gcpApplication *App, unsigned char size);
	virtual ~gcpCycleTool();

	virtual bool OnClicked();
	virtual void OnDrag();
	virtual void OnRelease();
	virtual void OnChangeState();
	
protected:
	void Init();
	bool CheckIfAllowed();

protected:
	double *m_xn;
	unsigned char m_size;
	GnomeCanvasPoints *points;

private:
	double m_dAngle, m_dDev;	//m_dAngle gives the direction of the first bond, m_dDev is deviation between two successive bonds
	double m_dDefAngle;	//default angle when appropriate
	double m_dLength;	//Lenght of newly created bonds
	gcpAtom *m_pAtom, *m_Start, *m_End;
	gcpChain *m_Chain;
	bool m_Direct;
};

class gcpNCycleTool: public gcpCycleTool
{
public:
	gcpNCycleTool(gcpApplication *App, unsigned char size);
	virtual ~gcpNCycleTool();

	void SetSize(unsigned char size);
	unsigned char GetSize() {return m_size;}
	virtual void SetOptions();
};

#endif	//GCHEMPAINT_CYCLE_TOOL_H
