// -*- C++ -*-

/* 
 * GChemPaint library
 * mesomery-arrow.h 
 *
 * Copyright (C) 2004-2005
 *
 * Developed by Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#ifndef GCHEMPAINT_MESOMERY_ARROW_H
#define GCHEMPAINT_MESOMERY_ARROW_H

#include "arrow.h"

class gcpMesomery;
class gcpMesomer;

class gcpMesomeryArrow: public gcpArrow
{
public:
	gcpMesomeryArrow (gcpMesomery* mesomery);
	virtual ~gcpMesomeryArrow ();
	
	virtual xmlNodePtr Save (xmlDocPtr xml);
	virtual bool Load (xmlNodePtr);
	virtual void Add (GtkWidget* w);
	virtual void Update (GtkWidget* w);
	void SetStartMesomer (gcpMesomer *Mesomer) {m_Start = Mesomer;}
	gcpMesomer* GetStartMesomer () {return m_Start;}
	void SetEndMesomer (gcpMesomer *Mesomer) {m_End = Mesomer;}
	gcpMesomer* GetEndMesomer () {return m_End;}
	void RemoveMesomer (gcpMesomer *Mesomer);
	void Reverse ();

private:
	gcpMesomer *m_Start, *m_End;
};

#endif	//	GCHEMPAINT_MESOMERY_ARROW_H
