// -*- C++ -*-

/* 
 * GChemPaint library
 * operation.h 
 *
 * Copyright (C) 2002-2004
 *
 * Developed by Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */


#ifndef GCHEMPAINT_OPERATION_H
#define GCHEMPAINT_OPERATION_H

#include <gcu/object.h>

using namespace gcu; 

class gcpDocument;

typedef enum
{
	GCP_ADD_OPERATION,
	GCP_DELETE_OPERATION,
	GCP_MODIFY_OPERATION,
} gcpOperationType;

class gcpOperation
{
public:
	gcpOperation(gcpDocument *pDoc);
	virtual ~gcpOperation();

	virtual void Undo();
	virtual void Redo();
	virtual void AddObject(Object* pObject, unsigned type = 0);
	virtual void AddNode(xmlNodePtr node, unsigned type = 0);

protected:
	void Add(unsigned type = 0);
	void Delete(unsigned type = 0);

protected:
	gcpDocument* m_pDoc;
	xmlNodePtr* m_Nodes;
};

class gcpAddOperation: public gcpOperation
{
public:
	gcpAddOperation(gcpDocument *pDoc);
	virtual ~gcpAddOperation();

	virtual void Undo();
	virtual void Redo();
};

class gcpDeleteOperation: public gcpOperation
{
public:
	gcpDeleteOperation(gcpDocument *pDoc);
	virtual ~gcpDeleteOperation();

	virtual void Undo();
	virtual void Redo();
};

class gcpModifyOperation: public gcpOperation
{
public:
	gcpModifyOperation(gcpDocument *pDoc);
	virtual ~gcpModifyOperation();

	virtual void Undo();
	virtual void Redo();
};

#endif //GCHEMPAINT_OPERATION_H
