// -*- C++ -*-

/* 
 * GChemPaint bonds plugin
 * bondtool.h 
 *
 * Copyright (C) 2001-2004
 *
 * Developed by Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#ifndef GCHEMPAINT_BOND_TOOL_H
#define GCHEMPAINT_BOND_TOOL_H

#include "lib/tool.h"
class gcpAtom;
class gcpOperation;

class gcpBondTool: public gcpTool
{
public:
	gcpBondTool(gcpApplication *App, string ToolId = "Bond", unsigned nPoints = 2);
	virtual ~gcpBondTool();
	
	virtual bool OnClicked();
	virtual void OnDrag();
	virtual void OnRelease();

protected:
	virtual void Draw();
	virtual void UpdateBond();
	virtual void FinalizeBond();
	virtual void SetType(gcpBond* pBond);

protected:
	double m_dAngle;
	gcpAtom* m_pAtom;
	GnomeCanvasPoints *points;
	unsigned char BondOrder;

private:
	gcpOperation *m_pOp;
};

class gcpUpBondTool: public gcpBondTool
{
public:
	gcpUpBondTool(gcpApplication *App);
	virtual ~gcpUpBondTool();

protected:
	virtual void Draw();
	virtual void UpdateBond();
	virtual void FinalizeBond();
	virtual void SetType(gcpBond* pBond);
};

class gcpDownBondTool: public gcpBondTool
{
public:
	gcpDownBondTool(gcpApplication *App);
	virtual ~gcpDownBondTool();

protected:
	virtual void Draw();
	virtual void UpdateBond();
	virtual void FinalizeBond();
	virtual void SetType(gcpBond* pBond);
};

class gcpSquiggleBondTool: public gcpBondTool
{
public:
	gcpSquiggleBondTool(gcpApplication *App);
	virtual ~gcpSquiggleBondTool();

protected:
	virtual void Draw();
	virtual void UpdateBond();
	virtual void FinalizeBond();
	virtual void SetType(gcpBond* pBond);
};

#endif // GCHEMPAINT_BOND_TOOL_H
