// -*- C++ -*-

/* 
 * GChemPaint library
 * docprop.cc 
 *
 * Copyright (C) 2002-2005
 *
 * Developed by Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include "gchempaint-config.h"
#include "docprop.h"
#include "document.h"
#include "application.h"

gcpDocPropDlg::gcpDocPropDlg(gcpDocument* pDoc): Dialog(pDoc->GetApplication(), DATADIR"/gchempaint-unstable/ui/docprop.glade", "properties")
{
	m_pDoc = pDoc;
	Title = GTK_ENTRY(glade_xml_get_widget(xml, "title"));
	const gchar* chn;
	chn = m_pDoc->GetTitle();
	if (chn) gtk_entry_set_text(Title, chn);
	Name = GTK_ENTRY(glade_xml_get_widget(xml, "name"));
	chn = m_pDoc->GetAuthor();
	if (chn) gtk_entry_set_text(Name, chn);
	Mail = GTK_ENTRY(glade_xml_get_widget(xml, "mail"));
	chn = m_pDoc->GetMail();
	if (chn) gtk_entry_set_text(Mail, chn);
	CreationDate = GTK_ENTRY(glade_xml_get_widget(xml, "creation"));
	const GDate* Date = pDoc->GetCreationDate();
	gchar tmp[64];
	/* The following format prints date as "Monday, July 8, 2002" */
	if (g_date_valid(Date))
	{
		g_date_strftime(tmp, sizeof(tmp), _("%A, %B %d, %Y"), Date);
		gtk_entry_set_text(CreationDate, tmp);
	}
	RevisionDate = GTK_ENTRY(glade_xml_get_widget(xml, "revision"));
	Date = pDoc->GetRevisionDate();
	if (g_date_valid(Date))
	{
		g_date_strftime(tmp, sizeof(tmp), _("%A, %B %d, %Y"), Date);
		gtk_entry_set_text(RevisionDate, tmp);
	}
	Comments = GTK_TEXT_VIEW(glade_xml_get_widget(xml, "comments"));
	Buffer = gtk_text_view_get_buffer(Comments);
	chn = m_pDoc->GetComment();
	if(chn) gtk_text_buffer_set_text(Buffer, chn , -1);
	gtk_widget_show(GTK_WIDGET(dialog));
}
	
gcpDocPropDlg::~gcpDocPropDlg()
{
	m_pDoc->OnCloseProperties();
}

bool gcpDocPropDlg::Apply()
{
	const gchar* chn;
	chn = gtk_entry_get_text(Title);
	m_pDoc->SetTitle(chn);
	chn = gtk_entry_get_text(Name);
	m_pDoc->SetAuthor(chn);
	chn = gtk_entry_get_text(Mail);
	m_pDoc->SetMail(chn);
	if	(gtk_text_buffer_get_modified(Buffer))
	{
		GtkTextIter begin, end;
		gtk_text_buffer_get_bounds(Buffer, &begin, &end);
		chn = gtk_text_buffer_get_text(Buffer, &begin, &end, true);
		m_pDoc->SetComment(chn);
	}
	return true;
}
