/* 
 * GChemPaint selection plugin
 * groupdlg.h
 *
 * Copyright (C) 2004-2005
 *
 * Developed by Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#ifndef GCHEMPAINT_GROUP_DLG_H
#define GCHEMPAINT_GROUP_DLG_H

#include "lib/document.h"
#include "lib/widgetdata.h"
#include "group.h"
#include <gcu/dialog.h>

using namespace gcu;

class gcpGroupDlg: public Dialog
{
public:
	gcpGroupDlg (gcpDocument *Doc, gcpGroup *group);
	virtual ~gcpGroupDlg ();

	virtual bool Apply ();
	void SetAlignType (gcpAlignType type);

	void OnAlignToggled ();
	void OnSpaceToggled ();

private:
	GtkComboBox *align_box;
	GtkToggleButton *align_btn, *group_btn, *space_btn;
	GtkSpinButton *padding_btn;
	GtkWidget *dist_lbl;
	gcpDocument *m_Doc;
	gcpWidgetData *m_Data;
	gcpGroup *m_Group;
};

#endif	// GCHEMPAINT_GROUP_DLG_H
