// -*- C++ -*-

/* 
 * GChemPaint
 * tools.cc 
 *
 * Copyright (C) 2001-2006 Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include "gchempaint-config.h"
#include "application.h"
#include "mendeleiev.h"
#include "tools.h"
#include <gcu/gtkcomboperiodic.h>
#include <goffice/gtk/go-combo-box.h>

static void element_changed_cb (gcpApplication *App, unsigned newZ)
{
	App->SetCurZ (newZ);
	gcpMendeleievDlg::SetElement (App, newZ);
}

gcpTools::gcpTools (Application *App): Dialog (App, DATADIR"/gchempaint-unstable/ui/tools.glade", "tools")
{
	gcpApplication *pApp = dynamic_cast<gcpApplication*> (App);
	pApp->SetDialog ("Tools", this);
	m_UIManager = NULL;
	m_ButtonsBox = GTK_BOX (glade_xml_get_widget (xml, "tools-buttons"));
	m_Book = GTK_NOTEBOOK (glade_xml_get_widget (xml, "tools-book"));
	GtkWidget *w = glade_xml_get_widget (xml, "mendeleiev");
	gtk_combo_periodic_set_element (GTK_COMBO_PERIODIC (w), pApp->GetCurZ ());
//	go_combo_box_set_tearable (GO_COMBO_BOX (w), true);
	g_signal_connect_swapped (G_OBJECT (w), "changed", G_CALLBACK (element_changed_cb), App);
}

gcpTools::~gcpTools ()
{
	reinterpret_cast<gcpApplication*> (m_App)->SetDialog ("Tools", NULL);
	if (m_UIManager) {
		g_object_unref (m_UIManager);
		m_UIManager = NULL;
	}
}

void gcpTools::Show (bool visible)
{
	if (visible)
		gtk_widget_show (GTK_WIDGET (dialog));
	else
		gtk_widget_hide (GTK_WIDGET (dialog));
}

void register_item_cb (GtkWidget *w, gcpTools *Dlg)
{
	Dlg->RegisterTool (w);
}

void gcpTools::AddToolbar (string &name)
{
	if (m_UIManager) {
		GtkWidget *w = gtk_ui_manager_get_widget (m_UIManager, name.c_str ()),
			*h = gtk_handle_box_new ();
		gtk_container_foreach (GTK_CONTAINER (w), (GtkCallback) register_item_cb, this);
		gtk_toolbar_set_style (GTK_TOOLBAR (w), GTK_TOOLBAR_ICONS);
		gtk_toolbar_set_show_arrow (GTK_TOOLBAR (w), false);
		gtk_toolbar_set_tooltips (GTK_TOOLBAR (w), true);
		gtk_container_add (GTK_CONTAINER (h), w);
		gtk_box_pack_start_defaults (m_ButtonsBox, h);
		gtk_widget_show_all (h);
	}
}

void gcpTools::SetUIManager (GtkUIManager *manager)
{
	m_UIManager = manager;
	g_object_ref (m_UIManager);
}

void gcpTools::SetPage (gcpTool *tool, int i)
{
	m_Pages[tool] = i;
}

void gcpTools::OnSelectTool (gcpTool *tool)
{
	if (m_Pages[tool] < 0) {
		GtkWidget *w = tool->GetPropertyPage ();
		if (w)
			m_Pages[tool] = gtk_notebook_append_page (m_Book, w, NULL);
		else
			m_Pages[tool] = 0;
	}
	gtk_notebook_set_current_page (m_Book, m_Pages[tool]);
}

void gcpTools::RegisterTool (GtkWidget *w)
{
	char const *name = gtk_widget_get_name (w);
	gcpApplication *App = dynamic_cast<gcpApplication*> (m_App);
	if (strncmp (name, "Gtk", 3))
		App->SetToolItem (name, w);
	gcpTool *tool = App->GetTool (name);
	m_Pages[tool] = -1;
}
