// -*- C++ -*-

/* 
 * GChemPaint library
 * zoomdlg.cc 
 *
 * Copyright (C) 2005 Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include "gchempaint-config.h"
#include "zoomdlg.h"
#include "view.h"
#include "document.h"
#include "application.h"

static void on_focus_in (gcpZoomDlg *dlg)
{
	dlg->OnFocusIn ();
}

gcpZoomDlg::gcpZoomDlg (gcpApplication *pApp):
	Dialog (pApp, DATADIR"/gchempaint-unstable/ui/zoom.glade", "zoomdlg")
{
	pApp->SetDialog ("Zoom", this);
	g_signal_connect_swapped (G_OBJECT (dialog), "focus_in_event", G_CALLBACK (on_focus_in), this);
	btn = (GtkSpinButton*) glade_xml_get_widget (xml, "zoom");
}

gcpZoomDlg::~gcpZoomDlg ()
{
	reinterpret_cast<gcpApplication*> (m_App)->SetDialog ("Zoom", NULL);
}
	
bool gcpZoomDlg::Apply ()
{
	gcpView *pView = reinterpret_cast<gcpApplication*> (m_App)->GetActiveDocument ()->GetView ();
	if (pView)
		pView->Zoom (gtk_spin_button_get_value (btn) / 100.);
	return true;
}
	
void gcpZoomDlg::OnFocusIn ()
{
	gcpDocument *pDoc = reinterpret_cast<gcpApplication*> (m_App)->GetActiveDocument ();
	if (!pDoc)
		return;
	gcpWidgetData *pData = (gcpWidgetData*) g_object_get_data (G_OBJECT (pDoc->GetWidget ()), "data");
	if (!pData)
		return;
	gtk_spin_button_set_value (btn, pData->Zoom * 100.);
}
