/* 
 * GChemPaint GOffice component
 * gofficeapp.cc
 *
 * Copyright (C) 2005-2006 Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "gchempaint-config.h"
#include "gchempaint-priv.h"
#include "gofficeapp.h"
#include "gofficewin.h"
#include <lib/document.h>

gcpGOfficeApplication::gcpGOfficeApplication (): gcpApplication ()
{
}

gcpGOfficeApplication::~gcpGOfficeApplication ()
{
}

GtkWindow* gcpGOfficeApplication::GetWindow()
{
	return NULL;
}

void gcpGOfficeApplication::RemoveDocument(gcpDocument* pDoc)
{
	m_Docs.remove (pDoc);
}

void gcpGOfficeApplication::ToggleMenu (const string& menuname, bool active)
{
}

void gcpGOfficeApplication::AddDocument (gcpDocument* pDoc)
{
	m_Docs.push_back (pDoc);
}

gcpDocument *gcpGOfficeApplication::ImportDocument (const string& mime_type, const char* data, int length)
{
	gcpDocument *pDoc = NULL;
	char *old_num_locale, *old_time_locale;
	if (mime_type == "application/x-gchempaint") {
		xmlDocPtr xml;
		if (!(xml = xmlParseMemory(data, length)) ||
			xml->children == NULL ||
			strcmp((char*)xml->children->name, "chemistry"))
			return NULL;
		old_num_locale = g_strdup(setlocale(LC_NUMERIC, NULL));
		setlocale(LC_NUMERIC, "C");
		old_time_locale = g_strdup(setlocale(LC_TIME, NULL));
		setlocale(LC_TIME, "C");
		pDoc = new gcpDocument(this, false);
		pDoc->GetView ()->CreateNewWidget ();
		bool result = pDoc->Load(xml->children);
		setlocale(LC_NUMERIC, old_num_locale);
		g_free(old_num_locale);
		setlocale(LC_TIME, old_time_locale);
		g_free(old_time_locale);
		if (!result)
		{
			delete pDoc;
			return NULL;
		}
		AddDocument(pDoc);
	} else {
	}
	return (pDoc);
}

bool gcpGOfficeApplication::EditDocument (GOGChemPaintComponent *gogcp)
{
	gcpGOfficeWindow *win = NULL;
	try {
		win = new gcpGOfficeWindow (this, gogcp);
		if (!win)
			return false;
		AddDocument (win->GetDocument ());
		return true;
	}
	catch (int i) {
		if (win)
			delete win;
		return false;
	}
}

void gcpGOfficeApplication::OnFileNew ()
{
	gchar tmp[32];
	if (m_pActiveDoc && !m_pActiveDoc->GetView ()->PrepareUnselect ())
		return;
	g_snprintf (tmp, sizeof (tmp), _("Untitled %d"), m_NumWindow++);
	gcpWindow *win = new gcpWindow (this);
	m_Docs.push_back (win->GetDocument ());
}

void gcpGOfficeApplication::OnFileClose ()
{
}
