// -*- C++ -*-

/* 
 * GChemPaint bonds plugin
 * chaintool.h
 *
 * Copyright (C) 2006 Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#ifndef GCHEMPAINT_CHAIN_TOOL_H
#define GCHEMPAINT_CHAIN_TOOL_H

#include "lib/tool.h"
#include <gtk/gtkspinbutton.h>
#include <gtk/gtktogglebutton.h>
#include <vector>

class gcpAtom;
class gcpOperation;

class gcpChainTool: public gcpTool
{
public:
	gcpChainTool(gcpApplication *App);
	virtual ~gcpChainTool();
	
	bool OnClicked();
	void OnDrag();
	void OnRelease();
	GtkWidget *GetPropertyPage ();
	void Activate ();

	void SetAutoNumber (bool state) {gtk_widget_set_sensitive (GTK_WIDGET (m_NumberBtn), state);}
	void SetChainLength (unsigned length) {m_Length = length;}

private:
	void FindAtoms ();
	bool CheckIfAllowed();

private:
	unsigned m_Length, m_CurPoints;
	bool m_Positive, m_AutoNb, m_Allowed;
	double m_dAngle, m_dMeanLength, m_BondLength;
	vector <gcpAtom *> m_Atoms;
	GnomeCanvasPoints *m_Points;
	GtkSpinButton *m_LengthBtn, *m_AngleBtn, *m_NumberBtn;
	GtkToggleButton *m_MergeBtn;
};

#endif	//	GCHEMPAINT_CHAIN_TOOL_H
