// -*- C++ -*-

/* 
 * GChemPaint library
 * preferences.cc 
 *
 * Copyright (C) 2006 Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include "gchempaint-config.h"
#include "preferences.h"
#include "application.h"
#include "document.h"
#include "fontsel.h"
#include "theme.h"

static void on_new_theme (gcpPrefsDlg *dlg)
{
	dlg->OnNewTheme ();
}

static void on_select_theme (GtkTreeSelection *selection, gcpPrefsDlg *dlg)
{
	dlg->OnSelectTheme (selection);
}

gcpPrefsDlg::gcpPrefsDlg (gcpApplication *pApp): Dialog (pApp, DATADIR"/gchempaint-unstable/ui/preferences.glade", "preferences")
{
	// add font selector
	GtkWidget *fontsel = GTK_WIDGET (g_object_new (GCP_FONT_SEL_TYPE, NULL));
	GtkWidget *w = glade_xml_get_widget (xml, "text-box");
	gtk_box_pack_start_defaults (GTK_BOX (w), fontsel);
	// get notebook
	m_Book = GTK_NOTEBOOK (glade_xml_get_widget (xml, "theme-book"));
	// create themes list and select active document theme
	m_ThemesView = GTK_TREE_VIEW (glade_xml_get_widget (xml, "themes"));
	themes = gtk_tree_store_new (1, G_TYPE_STRING);
	gtk_tree_sortable_set_sort_column_id (GTK_TREE_SORTABLE (themes), 0, GTK_SORT_ASCENDING);
	gtk_tree_view_set_model (m_ThemesView, GTK_TREE_MODEL (themes));
	GtkCellRenderer *renderer = gtk_cell_renderer_text_new ();
	GtkTreeViewColumn *column = gtk_tree_view_column_new_with_attributes (NULL, renderer, "text", 0, NULL);
	gtk_tree_view_append_column (m_ThemesView, column);
	m_ThemesSelection = gtk_tree_view_get_selection (m_ThemesView);
	list<string> theme_names = ThemeManager.GetThemesNames ();
	list<string>::iterator i, iend = theme_names.end ();
	GtkTreeIter iter, selected, child;
	string &default_name = pApp->GetActiveDocument ()->GetTheme ()->GetName ();
	for (i = theme_names.begin (); i != iend; i++) {
		gtk_tree_store_append (themes, &iter, NULL);
		gtk_tree_store_set (themes, &iter,
				  0, (*i).c_str (),
				  -1);
		gtk_tree_store_append (themes, &child, &iter);
		gtk_tree_store_set (themes, &child,
				  0, _("General"),
				  -1);
		if (*i == default_name)
			selected = child;
		gtk_tree_store_append (themes, &child, &iter);
		gtk_tree_store_set (themes, &child,
				  0, _("Atoms"),
				  -1);
		gtk_tree_store_append (themes, &child, &iter);
		gtk_tree_store_set (themes, &child,
				  0, _("Bonds"),
				  -1);
		gtk_tree_store_append (themes, &child, &iter);
		gtk_tree_store_set (themes, &child,
				  0, _("Arrows"),
				  -1);
		gtk_tree_store_append (themes, &child, &iter);
		gtk_tree_store_set (themes, &child,
				  0, _("Text"),
				  -1);
	}
	GtkTreePath *path = gtk_tree_model_get_path (GTK_TREE_MODEL (themes), &selected);
	gtk_tree_selection_set_mode (m_ThemesSelection, GTK_SELECTION_BROWSE);
	g_signal_connect (m_ThemesSelection, "changed", G_CALLBACK (on_select_theme), this);
	if (path) {
		gtk_tree_view_expand_to_path (m_ThemesView, path);
		gtk_tree_selection_select_path (m_ThemesSelection, path);
		gtk_tree_view_scroll_to_cell (m_ThemesView, path, column, FALSE, 0., 0.);
		gtk_tree_path_free (path);
	}
	// add event handler to new theme button
	g_signal_connect_swapped (G_OBJECT (glade_xml_get_widget (xml, "new-theme")), "clicked", G_CALLBACK (on_new_theme), this);
	gtk_widget_show_all (GTK_WIDGET (dialog));
}

gcpPrefsDlg::~gcpPrefsDlg ()
{
}

void gcpPrefsDlg::OnNewTheme ()
{
	gcpTheme *pTheme = ThemeManager.CreateNewTheme ();
	string &name = pTheme->GetName ();
	GtkTreeIter iter, child;
	gtk_tree_store_append (themes, &iter, NULL);
	gtk_tree_store_set (themes, &iter,
			  0, name.c_str (),
			  -1);
	gtk_tree_store_append (themes, &child, &iter);
	gtk_tree_store_set (themes, &child,
			  0, _("General"),
			  -1);
	GtkTreePath *path = gtk_tree_model_get_path (GTK_TREE_MODEL (themes), &child);
	if (path) {
		gtk_tree_view_expand_to_path (m_ThemesView, path);
		gtk_tree_selection_select_path (m_ThemesSelection, path);
		gtk_tree_view_scroll_to_cell (m_ThemesView, path, 0, FALSE, 0., 0.);
		gtk_tree_path_free (path);
	}
	gtk_tree_store_append (themes, &child, &iter);
	gtk_tree_store_set (themes, &child,
			  0, _("Atoms"),
			  -1);
	gtk_tree_store_append (themes, &child, &iter);
	gtk_tree_store_set (themes, &child,
			  0, _("Bonds"),
			  -1);
	gtk_tree_store_append (themes, &child, &iter);
	gtk_tree_store_set (themes, &child,
			  0, _("Arrows"),
			  -1);
	gtk_tree_store_append (themes, &child, &iter);
	gtk_tree_store_set (themes, &child,
			  0, _("Text"),
			  -1);
}

void gcpPrefsDlg::OnSelectTheme (GtkTreeSelection *selection)
{
	// we must fill the theme widgets with the corresponding data
	GtkTreeIter iter, parent;
	char *name;
	char *page;
	GtkTreeModel *model;
	gtk_tree_selection_get_selected (selection, &model, &iter);
	if (gtk_tree_model_iter_parent (model, &parent, &iter)) {
		gtk_tree_model_get (model, &parent, 0, &name, -1);
		gtk_tree_model_get (model, &iter, 0, &page, -1);
		if (!strcmp (page, _("General")))
			gtk_notebook_set_current_page (m_Book, 1);
		else if (!strcmp (page, _("Atoms")))
			gtk_notebook_set_current_page (m_Book, 2);
		else if (!strcmp (page, _("Bonds")))
			gtk_notebook_set_current_page (m_Book, 3);
		else if (!strcmp (page, _("Arrows")))
			gtk_notebook_set_current_page (m_Book, 4);
		else if (!strcmp (page, _("Text")))
			gtk_notebook_set_current_page (m_Book, 5);
	} else {
		gtk_tree_model_get (model, &iter, 0, &name, -1);
		gtk_notebook_set_current_page (m_Book, 0);
	}
}
