// -*- C++ -*-

/* 
 * GChemPaint libray
 * newfiledlg.cc 
 *
 * Copyright (C) 2007 Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include "gchempaint-config.h"
#include "newfiledlg.h"
#include "application.h"
#include "theme.h"

static void on_theme_changed (GtkComboBox *box, gcpNewFileDlg *dlg)
{
	dlg->SetTheme (ThemeManager.GetTheme (gtk_combo_box_get_active_text (box)));
}

gcpNewFileDlg::gcpNewFileDlg (gcpApplication *App):
	Dialog (App, DATADIR"/gchempaint-unstable/ui/newfiledlg.glade", "newfile", App),
	Object ()
{
	if (!xml) {
		delete this;
		return;
	}
	list <string> names = ThemeManager.GetThemesNames ();
	list <string>::iterator i = names.begin (), end = names.end ();
	GtkWidget *w = glade_xml_get_widget (xml, "themes-box");
	m_Box = GTK_COMBO_BOX (gtk_combo_box_new_text ());
	gtk_box_pack_start (GTK_BOX (w), GTK_WIDGET (m_Box), true, true, 0);
	gcpTheme *theme;
	m_Theme = ThemeManager.GetTheme (*i);
	m_Lines = names.size ();
	for (; i != end; i++) {
		gtk_combo_box_append_text (m_Box, (*i).c_str ());
		theme = ThemeManager.GetTheme (*i);
		if (theme)
			theme->AddClient (this);
	}
	gtk_combo_box_set_active (m_Box, 0);
	m_ChangedSignal = g_signal_connect (G_OBJECT (m_Box), "changed", G_CALLBACK (on_theme_changed), this);
	gtk_widget_show_all (GTK_WIDGET (dialog));
}

gcpNewFileDlg::~gcpNewFileDlg ()
{
	list <string> names = ThemeManager.GetThemesNames ();
	list <string>::iterator i, end = names.end ();
	gcpTheme *theme;
	for (i = names.begin (); i != end; i++) {
		theme = ThemeManager.GetTheme (*i);
		if (theme)
			theme->RemoveClient (this);
	}
}

bool gcpNewFileDlg::Apply ()
{
	dynamic_cast <gcpApplication*> (m_App)->OnFileNew (gtk_combo_box_get_active_text (m_Box));
	return true;
}

void gcpNewFileDlg::OnThemeNamesChanged ()
{
	list <string> names = ThemeManager.GetThemesNames ();
	list <string>::iterator i, end = names.end ();
	int n, nb = gtk_combo_box_get_active (m_Box);
	g_signal_handler_block (m_Box, m_ChangedSignal);
	while (m_Lines--)
		gtk_combo_box_remove_text (m_Box, 0);
	for (i = names.begin (), n = 0; i != end; i++, n++) {
		gtk_combo_box_append_text (m_Box, (*i).c_str ());
		if (m_Theme == ThemeManager.GetTheme (*i))
			nb = n;
	}
	m_Lines = names.size ();
	gtk_combo_box_set_active (m_Box, nb);
	g_signal_handler_unblock (m_Box, m_ChangedSignal);
}
