// -*- C++ -*-

/* 
 * GChemPaint library
 * mechanism-step.h 
 *
 * Copyright (C) 2009-2010 Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#ifndef GCHEMPAINT_MECHANISM_STEP_H
#define GCHEMPAINT_MECHANISM_STEP_H

#include <gcu/object.h>

namespace gcp {

extern gcu::TypeId MechanismStepType;

class MechanismStep: public gcu::Object
{
public:
	MechanismStep (gcu::TypeId type = MechanismStepType);
	virtual ~MechanismStep ();

	double GetYAlign ();
	bool OnSignal (gcu::SignalId Signal, gcu::Object *Child);
	bool Load (xmlNodePtr node);

	std::string Name ();

private:
	bool m_bLoading;
};

}	//	namespace gcp

#endif	//	GCHEMPAINT_MECHANISM_STEP_H