/* gcjwebplugin - Webbrowser plugin to execute Java (tm) applets.
   Copyright (C) 2003  Michael Koch <konqueror@gmx.de>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307  USA

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


#include <cassert>

#include <nsplugindefs.h>
#include <nsIJVMPluginTagInfo.h>
#include <nsIPluginInstancePeer.h>
#include <nsIPluginTagInfo2.h>
#include <plugin/npapi.h>

#include "GCJPluginInstance.h"
#include "jniHelp.h"
#include "pluginDebug.h"

NS_IMPL_ISUPPORTS1 (GCJPluginInstance, nsIJVMPluginInstance)

static NS_DEFINE_IID (kIJVMPluginTagInfoIID, NS_IJVMPLUGINTAGINFO_IID);
static NS_DEFINE_IID (kIPluginTagInfo2IID, NS_IPLUGINTAGINFO2_IID);

GCJPluginInstance::GCJPluginInstance (GCJPluginFactory* factory, JNIEnv* jniEnv)
  : m_peer (NULL)
  , m_jniEnv (jniEnv)
  , m_applet (NULL)
  , m_appletLoader (NULL)
  , m_embeddedWindow (NULL)
{
  PLUGIN_DEBUG ("GCJPluginInstance::GCJPluginInstance\n");
}

GCJPluginInstance::~GCJPluginInstance ()
{
  PLUGIN_DEBUG ("GCJPluginInstance::~GCJPluginInstance\n");
}

NS_IMETHODIMP
GCJPluginInstance::Initialize (nsIPluginInstancePeer* peer)
{
  PLUGIN_DEBUG ("GCJPluginInstance::Initialize\n");
  
  m_peer = peer;
  m_peer->AddRef ();

  jstring code;
  jstring codeBase;
  jstring documentBase;
  jstring archive;
  
  nsresult result;
  nsIJVMPluginTagInfo* pluginTagInfo;
  nsIPluginTagInfo2* pluginTagInfo2;
  
  result = peer->QueryInterface (kIJVMPluginTagInfoIID,
					  (void**) &pluginTagInfo);
  result = peer->QueryInterface (kIPluginTagInfo2IID, (void**) &pluginTagInfo2);

  if (NS_SUCCEEDED (result))
    {
      const char* tmp_code = NULL;
      const char* tmp_codeBase = NULL;
      const char* tmp_documentBase = NULL;
      const char* tmp_archive = NULL;
      
      PRUint16 numParams;
      const char* const* tmp_paramNames = NULL;
      const char* const* tmp_paramValues = NULL;
      
      // Extract plugin data got from web browser
      // 
      pluginTagInfo->GetCode (&tmp_code);
      pluginTagInfo->GetCodeBase (&tmp_codeBase);
      pluginTagInfo->GetArchive (&tmp_archive);
      pluginTagInfo2->GetDocumentBase (&tmp_documentBase);
      pluginTagInfo2->GetParameters (numParams, tmp_paramNames, tmp_paramValues);
      
      if (tmp_code != NULL)
	code = m_jniEnv->NewStringUTF (tmp_code);
      
      if (tmp_codeBase != NULL)
	codeBase = m_jniEnv->NewStringUTF (tmp_codeBase);
      
      if (tmp_documentBase != NULL)
	documentBase = m_jniEnv->NewStringUTF (tmp_documentBase);

      if (tmp_archive != NULL)
	archive = m_jniEnv->NewStringUTF (tmp_archive);

      // Get references to classes and methods via JNI
      //
      jclass appletLoader_cl = m_jniEnv->FindClass ("gnu/applet/AppletLoader");
      assert (appletLoader_cl != NULL);

      jmethodID appletLoader_init = m_jniEnv->GetMethodID (appletLoader_cl, "<init>", "()V");
      assert (appletLoader_init != NULL);

      jmethodID appletLoader_setCode = m_jniEnv->GetMethodID (appletLoader_cl, "setCode", "(Ljava.lang.String;)V");
      assert (appletLoader_setCode != NULL);

      jmethodID appletLoader_setCodeBase = m_jniEnv->GetMethodID (appletLoader_cl, "setCodeBase", "(Ljava.lang.String;)V");
      assert (appletLoader_setCodeBase != NULL);
      
      jmethodID appletLoader_setDocumentBase = m_jniEnv->GetMethodID (appletLoader_cl, "setDocumentBase", "(Ljava.lang.String;)V");
      assert (appletLoader_setDocumentBase != NULL);
      
      jmethodID appletLoader_setArchive = m_jniEnv->GetMethodID (appletLoader_cl, "setArchive", "(Ljava.lang.String;)V");
      assert (appletLoader_setArchive != NULL);

      jmethodID appletLoader_addParameter = m_jniEnv->GetMethodID (appletLoader_cl, "addParameter", "(Ljava.lang.String;Ljava.lang.String;)V");
      assert (appletLoader_addParameter != NULL);

      jmethodID appletLoader_loadApplet  = m_jniEnv->GetMethodID (appletLoader_cl, "loadApplet", "()Ljava.applet.Applet;");
      assert (appletLoader_loadApplet != NULL);
      
      // Load applet
      //
      PLUGIN_DEBUG ("GCJPluginInstance::Initialize: AppletLoader.<init>\n");
      JNI_NewObject0 (m_jniEnv, appletLoader_cl, appletLoader_init, m_appletLoader);

      if (tmp_code != NULL)
	{
          PLUGIN_DEBUG ("GCJPluginInstance::Initialize: AppletLoader.setCode\n");
	  JNI_CallVoidMethod1 (m_jniEnv, m_appletLoader, appletLoader_setCode, code);
	}

      if (tmp_codeBase != NULL)
	{
          PLUGIN_DEBUG ("GCJPluginInstance::Initialize: AppletLoader.setCodeBase\n");
	  JNI_CallVoidMethod1 (m_jniEnv, m_appletLoader, appletLoader_setCodeBase, codeBase);
	}

      if (tmp_documentBase != NULL)
	{
          PLUGIN_DEBUG ("GCJPluginInstance::Initialize: AppletLoader.setDocumentBase\n");
	  JNI_CallVoidMethod1 (m_jniEnv, m_appletLoader, appletLoader_setDocumentBase, documentBase);
	}

      if (tmp_archive != NULL)
	{
          PLUGIN_DEBUG ("GCJPluginInstance::Initialize: AppletLoader.setArchive\n");
	  JNI_CallVoidMethod1 (m_jniEnv, m_appletLoader, appletLoader_setArchive, archive);
	}

      for (int count = 0; count < numParams; count++)
        {
          PLUGIN_DEBUG ("GCJPluginInstance::Initialize: AppletLoader.addParameter\n");
	  JNI_CallVoidMethod2 (m_jniEnv, m_appletLoader, appletLoader_addParameter,
			       m_jniEnv->NewStringUTF (tmp_paramNames [count]),
			       m_jniEnv->NewStringUTF (tmp_paramValues [count]));
	}

      PLUGIN_DEBUG ("GCJPluginInstance::Initialize: AppletLoader.loadApplet\n");
      JNI_CallObjectMethod0 (m_jniEnv, m_appletLoader, appletLoader_loadApplet, m_applet);
    }

  pluginTagInfo->Release();
  pluginTagInfo2->Release();

  if (m_applet == NULL)
    {
      PLUGIN_DEBUG ("GCJPluginInstance::Initialize: Applet couldn't be loaded\n");
      return  NS_ERROR_FAILURE;
    }

  jclass applet_cl;
  jmethodID applet_init;

  JNI_GetObjectClass (m_jniEnv, m_applet, applet_cl);
  JNI_GetMethodID (m_jniEnv, applet_cl, "init", "()V", applet_init);
  JNI_CallVoidMethod0 (m_jniEnv, m_applet, applet_init);
  
  return NS_OK;
}

NS_IMETHODIMP
GCJPluginInstance::GetPeer (nsIPluginInstancePeer** result)
{
  PLUGIN_DEBUG ("GCJPluginInstance::GetPeer\n");
  
  (*result) = m_peer;
  return NS_OK;
}

NS_IMETHODIMP 
GCJPluginInstance::Start ()
{
  PLUGIN_DEBUG ("GCJPluginInstance::Start\n");

  if (m_applet != NULL)
    {
      jclass applet_cl;
      jmethodID applet_start;
      
      JNI_GetObjectClass (m_jniEnv, m_applet, applet_cl);
      JNI_GetMethodID (m_jniEnv, applet_cl, "start", "()V", applet_start);
      JNI_CallVoidMethod0 (m_jniEnv, m_applet, applet_start);
    }
  
  return NS_OK;
}

NS_IMETHODIMP 
GCJPluginInstance::Stop ()
{
  PLUGIN_DEBUG ("GCJPluginInstance::Stop\n");

  if (m_applet != NULL)
    {
      jclass applet_cl;
      jmethodID applet_stop;
      
      JNI_GetObjectClass (m_jniEnv, m_applet, applet_cl);
      JNI_GetMethodID (m_jniEnv, applet_cl, "stop", "()V", applet_stop);
      JNI_CallVoidMethod0 (m_jniEnv, m_applet, applet_stop);
    }
  
  return NS_OK;
}

NS_IMETHODIMP 
GCJPluginInstance::Destroy ()
{
  PLUGIN_DEBUG ("GCJPluginInstance::Destroy\n");
  
  if (m_applet != NULL)
    {
      jclass applet_cl;
      jmethodID applet_destroy;
      
      JNI_GetObjectClass (m_jniEnv, m_applet, applet_cl);
      JNI_GetMethodID (m_jniEnv, applet_cl, "destroy", "()V", applet_destroy);
      JNI_CallVoidMethod0 (m_jniEnv, m_applet, applet_destroy);
    }
  
  return NS_OK;
}

NS_IMETHODIMP 
GCJPluginInstance::SetWindow (nsPluginWindow* window)
{
  PLUGIN_DEBUG ("GCJPluginInstance::SetWindow\n");

  if (m_applet != NULL)
    {
      // First, create an embedded window.
      PLUGIN_DEBUG (" Finding EmbeddedWindow methods...\n");

      jclass embeddedWindow_cl;
      jmethodID embeddedWindow_init;
      jmethodID embeddedWindow_setSize;
      
      JNI_FindClass (m_jniEnv, "gnu/java/awt/EmbeddedWindow",
		     embeddedWindow_cl);
      JNI_GetMethodID (m_jniEnv, embeddedWindow_cl, "<init>", "(I)V",
		       embeddedWindow_init);
      JNI_GetMethodID (m_jniEnv, embeddedWindow_cl, "setSize", "(II)V",
		       embeddedWindow_setSize);

      PLUGIN_DEBUG2 (" Initializing EmbeddedWindow: %d...\n", (unsigned long) window->window);

      JNI_NewObject1 (m_jniEnv, embeddedWindow_cl, embeddedWindow_init,
	 	      (jint) window->window, m_embeddedWindow);

      PLUGIN_DEBUG2 (" Setting EmbeddedWindow size: width  %d...\n", (unsigned long) window->width);
      PLUGIN_DEBUG2 (" Setting EmbeddedWindow size: height %d...\n", (unsigned long) window->height);

      JNI_CallVoidMethod2 (m_jniEnv, m_embeddedWindow, embeddedWindow_setSize,
			   (jint) (window->width), (jint) (window->height));

      PLUGIN_DEBUG (" Finding AppletLoader...\n");

      /* Now add the applet to this window. */
      jclass appletLoader_cl;
      jmethodID appletLoader_setEmbeddedWindow;
      
      JNI_FindClass (m_jniEnv, "gnu/applet/AppletLoader", appletLoader_cl);

      PLUGIN_DEBUG (" Finding setEmbeddedWindow...\n");

      JNI_GetMethodID (m_jniEnv, appletLoader_cl, "setEmbeddedWindow",
		       "(Lgnu.java.awt.EmbeddedWindow;)V", appletLoader_setEmbeddedWindow);

      PLUGIN_DEBUG (" Calling setEmbeddedWindow...\n");

      if (!m_appletLoader)
        PLUGIN_DEBUG (" no m_appletLoader!...\n");

      if (!m_embeddedWindow)
        PLUGIN_DEBUG (" no m_embeddedWindow!...\n");

      JNI_CallVoidMethod1 (m_jniEnv, m_appletLoader,
			   appletLoader_setEmbeddedWindow, m_embeddedWindow);

    }

  return NS_OK;
}

NS_IMETHODIMP 
GCJPluginInstance::NewStream (nsIPluginStreamListener** listener)
{
  PLUGIN_DEBUG ("GCJPluginInstance::NewStream\n");
  
  return NS_ERROR_NOT_IMPLEMENTED;
}

NS_IMETHODIMP 
GCJPluginInstance::Print (nsPluginPrint* platformPrint)
{
  PLUGIN_DEBUG ("GCJPluginInstance::Print\n");
  
  return NS_ERROR_NOT_IMPLEMENTED;
}

NS_IMETHODIMP 
GCJPluginInstance::GetValue (nsPluginInstanceVariable variable, void* value)
{
  PLUGIN_DEBUG2 ("GCJPluginInstance::GetValue: variable: %i\n", variable);
  
  switch (variable)
    {
      case nsPluginInstanceVariable_WindowlessBool:
        *(PRBool*) value = PR_FALSE;
        break;

      case nsPluginInstanceVariable_TransparentBool:
        *(PRBool*) value = PR_FALSE;
        break;

      case nsPluginInstanceVariable_DoCacheBool:
        *(PRBool*) value = PR_FALSE;
        break;

      case nsPluginInstanceVariable_CallSetWindowAfterDestroyBool:
	*(PRBool*) value = PR_FALSE;
	break;

      case (nsPluginInstanceVariable)NPPVpluginNeedsXEmbed:
	*(PRBool*) value = PR_TRUE;
	break;

      default:
	PLUGIN_DEBUG ("GCJPluginInstance::GetValue: Requested unknown value\n");
        return NS_ERROR_NOT_IMPLEMENTED;
    }

  return NS_OK;
}

NS_IMETHODIMP 
GCJPluginInstance::HandleEvent (nsPluginEvent* event, PRBool* handled)
{
  PLUGIN_DEBUG ("GCJPluginInstance::HandleEvent\n");
 
  (*handled) = PR_TRUE;
  return NS_OK;
}

NS_IMETHODIMP 
GCJPluginInstance::GetJavaObject (jobject* result)
{
  PLUGIN_DEBUG ("GCJPluginInstance::GetJavaObject\n");
 
  (*result) = (jobject) m_applet;
  return NS_OK;
}

NS_IMETHODIMP 
GCJPluginInstance::GetText (const char** result)
{
  PLUGIN_DEBUG ("GCJPluginInstance::GetText\n");
  
  return NS_ERROR_NOT_IMPLEMENTED;
}
