/* gcjwebplugin - Webbrowser plugin to execute Java (tm) applets.
   Copyright (C) 2003  Michael Koch <konqueror@gmx.de>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307  USA

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


#include <stdlib.h>

#include <nsIPluginManager.h>

#include "GCJJVMConsole.h"
#include "GCJPluginFactory.h"
#include "GCJPluginInstance.h"
#include "GCJSecureEnv.h"
#include "config.h"
#include "pluginDebug.h"
#include "pluginMeta.h"

static const char plugin_name[] = PLUGIN_NAME;
static const char plugin_desc[] = PLUGIN_DESC;
static const char* plugin_mime_type[] = { PLUGIN_MIME_TYPE };
static const char* plugin_mime_desc[] = { PLUGIN_MIME_DESC };
static const char* plugin_file_exts[] = { PLUGIN_FILE_EXTS };
static const PRInt32 plugin_mime_count = PLUGIN_MIME_COUNT;

static NS_DEFINE_CID (kPluginManagerCID, NS_PLUGINMANAGER_CID);
static NS_DEFINE_CID (kGCJPluginFactoryCID, NS_OJIPLUGIN_CID);

static nsModuleComponentInfo pluginData[] =
{
  {
    PLUGIN_NAME,
    NS_OJIPLUGIN_CID,
    PLUGIN_URL,
    GCJPluginFactory::CreateOJIPlugin,
    GCJPluginFactory::RegisterSelf,
    GCJPluginFactory::UnregisterSelf
  }
};

NS_IMPL_ISUPPORTS3 (GCJPluginFactory, nsIPlugin, nsIJVMPlugin, nsIFactory)

NS_IMPL_NSGETMODULE ("GCJPluginFactory", pluginData)

JavaVM* GCJPluginFactory::s_jvm;
JNIEnv* GCJPluginFactory::s_jniEnv;
int GCJPluginFactory::s_started = 0;

GCJPluginFactory::GCJPluginFactory ()
{
  PLUGIN_DEBUG ("GCJPluginFactory::GCJPluginFactory\n");

  m_classpath = getenv ("CLASSPATH");
}

GCJPluginFactory::~GCJPluginFactory ()
{
  PLUGIN_DEBUG ("GCJPluginFactory::~FactoryGCJPluginFactory\n");

  free (m_classpath);
}

NS_IMETHODIMP
GCJPluginFactory::RegisterSelf (nsIComponentManager* aCompMgr, nsIFile* aPath,
			 const char* aRegistryLocation,
			 const char* aComponentType,
			 const nsModuleComponentInfo *info)
{
  PLUGIN_DEBUG ("GCJPluginFactory::RegisterSelf\n");

  nsIPluginManager* pm;
  nsresult rv =
    nsServiceManager::GetService (kPluginManagerCID,
                                  NS_GET_IID (nsIPluginManager),
			 	  NS_REINTERPRET_CAST (nsISupports**, &pm));
  
  if (NS_SUCCEEDED (rv))
    {
      rv = pm->RegisterPlugin (kGCJPluginFactoryCID, plugin_name, plugin_desc,
			       plugin_mime_type, plugin_mime_desc,
			       plugin_file_exts, plugin_mime_count);
      NS_RELEASE (pm);
    }
  
  return rv;
}

NS_IMETHODIMP
GCJPluginFactory::UnregisterSelf (nsIComponentManager* aCompMgr, nsIFile* aPath,
			   const char* aRegistryLocation,
			   const nsModuleComponentInfo *info)
{
  PLUGIN_DEBUG ("GCJPluginFactory::UnregisterSelf\n");
  
  nsIPluginManager* pm;
  nsresult rv =
    nsServiceManager::GetService (kPluginManagerCID,
                                  NS_GET_IID (nsIPluginManager),
                                  NS_REINTERPRET_CAST (nsISupports**, &pm));

  if (NS_SUCCEEDED (rv))
    {
      rv = pm->UnregisterPlugin (kGCJPluginFactoryCID);
      NS_RELEASE (pm);
    }
  
  return rv;
}

NS_IMETHODIMP GCJPluginFactory::CreateOJIPlugin
(nsISupports* aOuter, REFNSIID aIID, void** aResult)
{
  PLUGIN_DEBUG ("GCJPluginFactory::CreateOJIPlugin\n");
  
  GCJPluginFactory* plugin = new GCJPluginFactory ();
  return plugin->CreatePluginInstance (aOuter, aIID, NULL, aResult);
}

NS_IMETHODIMP
GCJPluginFactory::CreatePluginInstance (nsISupports* aOuter, REFNSIID aIID,
				 const char* /*pluginMIMEType*/, void** result)
{
  PLUGIN_DEBUG ("GCJPluginFactory::CreatePluginInstance\n");

  StartVM ();
  return CreateInstance (aOuter, aIID, result);
}

NS_IMETHODIMP
GCJPluginFactory::CreateInstance (nsISupports* aOuter, REFNSIID aIID, void** result)
{
  PLUGIN_DEBUG ("GCJPluginFactory::CreateInstance\n");

  GCJPluginInstance* pluginInstance = new GCJPluginInstance (this, s_jniEnv);
 
  if (pluginInstance == NULL)
    return NS_ERROR_OUT_OF_MEMORY;
  
  (*result) = pluginInstance;
  return NS_OK;
}

NS_IMETHODIMP
GCJPluginFactory::LockFactory (PRBool aLock)
{
  PLUGIN_DEBUG ("GCJPluginFactory::LockFactory\n");
  
  return NS_ERROR_NOT_IMPLEMENTED;
}

NS_IMETHODIMP
GCJPluginFactory::Initialize ()
{
  PLUGIN_DEBUG ("GCJPluginFactory::Inititalize\n");
 
  StartVM ();
  return NS_OK;
}

NS_IMETHODIMP
GCJPluginFactory::Shutdown ()
{
  PLUGIN_DEBUG ("GCJPluginFactory::Shutdown\n");
  
  StopVM ();
  return NS_OK;
}

NS_IMETHODIMP
GCJPluginFactory::GetMIMEDescription (const char** result)
{
  PLUGIN_DEBUG ("GCJPluginFactory::GetMIMEDescription\n");

  (*result) = PLUGIN_MIME_DESC;
  return NS_OK;
}

NS_IMETHODIMP
GCJPluginFactory::GetValue (nsPluginVariable variable, void* value)
{
  PLUGIN_DEBUG ("GCJPluginFactory::GetValue\n");
  
  if (variable == nsPluginVariable_NameString)
    (*((char**) value)) = PLUGIN_NAME;
  else if (variable == nsPluginVariable_DescriptionString)
    (*((char**) value)) = PLUGIN_MIME_DESC;
  else
    {
      PLUGIN_DEBUG ("GCJPluginFactory::GetValue: unkown value requested\n");
      return NS_ERROR_FAILURE;
    }
	
  return NS_OK;
}

NS_IMETHODIMP
GCJPluginFactory::AddToClassPath (const char* dirPath)
{
  PLUGIN_DEBUG ("GCJPluginFactory::AddToClassPath\n");

  char* tmp;
  int len_cp, len_path;
  
  len_cp = strlen (m_classpath);
  len_path = strlen (dirPath);
  tmp = (char*) malloc (len_cp + len_path + 2);
  strcpy (tmp, m_classpath);
  strcpy (&tmp [len_cp], ":");
  strcpy (&tmp [len_cp + 1], dirPath);
  free (m_classpath);
  m_classpath = tmp;
  return NS_OK;
}

NS_IMETHODIMP
GCJPluginFactory::RemoveFromClassPath (const char* dirPath)
{
  PLUGIN_DEBUG ("GCJPluginFactory::RemoveFromClasspath\n");

  return NS_ERROR_NOT_IMPLEMENTED;
}

NS_IMETHODIMP
GCJPluginFactory::GetClassPath (const char** result)
{
  PLUGIN_DEBUG ("GCJPluginFactory::GetClasspath\n");
 
  (*result) = strdup (m_classpath);
  return NS_OK;
}

NS_IMETHODIMP
GCJPluginFactory::GetJavaWrapper (JNIEnv* env, jint obj, jobject* jobj)
{
  PLUGIN_DEBUG ("GCJPluginFactory::GetJavaWrapper\n");
  
  return NS_ERROR_NOT_IMPLEMENTED;
}

NS_IMETHODIMP
GCJPluginFactory::CreateSecureEnv (JNIEnv* proxyEnv, nsISecureEnv** result)
{
  PLUGIN_DEBUG ("GCJPluginFactory::CreateSecureEnv\n");

  if (!s_started)
    return NS_ERROR_FAILURE;

  return NS_ERROR_NOT_IMPLEMENTED;
}

NS_IMETHODIMP
GCJPluginFactory::SpendTime (PRUint32 timeMillis)
{
  PLUGIN_DEBUG ("GCJPluginFactory::SpendTime");
  
  return NS_ERROR_NOT_IMPLEMENTED;
}

NS_IMETHODIMP
GCJPluginFactory::UnwrapJavaWrapper (JNIEnv* jenv, jobject jobj, jint* obj)
{
  PLUGIN_DEBUG ("GCJPluginFactory::UnwrapJavaWrapper\n");

  return NS_ERROR_NOT_IMPLEMENTED;
}

void
GCJPluginFactory::StartVM ()
{
  PLUGIN_DEBUG ("GCJPluginFactory::StartVM\n");

  if (JNI_CreateJavaVM (&s_jvm, &s_jniEnv, NULL) != 0)
    {
      s_started = 0;
      PLUGIN_DEBUG ("JVM not started\n");
    }
  else
    {
      s_started = 1;
      PLUGIN_DEBUG ("JVM successfully started\n");
    }
}

void
GCJPluginFactory::StopVM ()
{
  PLUGIN_DEBUG ("GCJPluginFactory::StopVM\n");

  s_jvm->DestroyJavaVM ();
  s_started = 0;
  PLUGIN_DEBUG ("JVM successfully stopped\n");
}
