/* AppletStub.java -- implements the applet-browser interface
   Copyright (C) 2003  Thomas Fitzsimmons <fitzsim@redhat.com>

   This file is part of GCJ Applet Viewer.

   GCJ Applet Viewer is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   GCJ Applet Viewer is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GCJ Applet Viewer; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

package gnu.gcjwebplugin;

import java.applet.AppletContext;
import java.applet.AppletStub;
import java.applet.Applet;
import java.net.MalformedURLException;
import java.net.URL;


class CommonAppletStub
  implements AppletStub
{
  private AppletTag tag;
  private AppletContext context;
  private Applet applet;

  CommonAppletStub(AppletTag tag, AppletContext context, Applet applet)
  {
    this.tag = tag;
    this.context = context;
    this.applet = applet;
  }

  ////////////////////////////////
  ////// AppletStub Methods //////
  ////////////////////////////////
  
  /**
   * Tests whether or not this applet is currently active. An applet
   * becomes active just before the browser invokes start (), and
   * becomes inactive just before the browser invokes stop ().
   *
   * @return true if applet is active, false otherwise
   */
  public boolean isActive()
  {
    return true;
  }

  /**
   * Returns the basename URL of the document in which this applet is
   * embedded.
   *
   * @return the document base url.
   */
  public URL getDocumentBase()
  {
    return tag.documentbase;
  }

  /**
   * Returns the URL of the code base for this applet.
   *
   * @return the codebase url
   */
  public URL getCodeBase()
  {
    try
      {
	return tag.prependCodebase("");
      }
    catch (MalformedURLException e)
      {
	throw new RuntimeException("unknown codebase");
      }
  }

  /**
   * Returns the value of the specified parameter that was specified
   * in the <code>APPLET</code> tag for this applet.
   *
   * @param name the key name
   *
   * @return the key value
   */
  public String getParameter(String name)
  {
    return (String) tag.parameters.get(name);
  }

  /**
   * Returns the applet context for this applet.
   *
   * @return the context
   */
  public AppletContext getAppletContext()
  {
    return context;
  }

  /**
   * Requests that the applet window for this applet be resized.
   *
   * @param width the new witdh
   * @param height the new height
   */
  public void appletResize(int width, int height)
  {
    applet.setBounds (0, 0, width, height);
  }
}
