/* StandaloneAppletWindow.java -- an applet frame
   Copyright (C) 2003  Thomas Fitzsimmons <fitzsim@redhat.com>

   This file is part of GCJ Applet Viewer.

   GCJ Applet Viewer is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   GCJ Applet Viewer is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GCJ Applet Viewer; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

package gnu.gcjwebplugin;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List; import java.util.Locale;

class StandaloneAppletWindow extends Frame
  implements ActionListener
{
  private static int testWindowCount;
  private static HashMap contexts = new HashMap();
  private Applet applet;
  private Label status = new Label();

  private MenuItem restartItem;
  private MenuItem reloadItem;
  private MenuItem cancelItem;
  private MenuItem saveItem;
  private MenuItem startItem;
  private MenuItem cloneItem;
  private MenuItem closeItem;
  private MenuItem quitItem;

  StandaloneAppletWindow(AppletTag tag, List appletWindows)
  {
    appletWindows.add(this);
    applet = AppletViewer.createApplet(tag);

    if (contexts.get(tag.codebase) == null)
      contexts.put(tag.codebase, new StandaloneAppletContext(appletWindows));

    setLayout(new BorderLayout());
    add(applet, BorderLayout.CENTER);
    add(status, BorderLayout.SOUTH);

    addWindowListener(new WindowAdapter()
        {
	  public void windowClosing(WindowEvent event)
	  {
	    applet.stop();
	    StandaloneAppletWindow.this.hide();
	    System.exit(0);
	  }
        });

    restartItem = new MenuItem(AppletViewer.messages.getString("gcjwebplugin.menu_restart"));
    restartItem.addActionListener(this);
    reloadItem = new MenuItem(AppletViewer.messages.getString("gcjwebplugin.menu_reload"));
    reloadItem.addActionListener(this);
    cancelItem = new MenuItem(AppletViewer.messages.getString("gcjwebplugin.menu_cancel"));
    cancelItem.addActionListener(this);
    saveItem = new MenuItem(AppletViewer.messages.getString("gcjwebplugin.menu_save"));
    saveItem.addActionListener(this);
    startItem = new MenuItem(AppletViewer.messages.getString("gcjwebplugin.menu_start"));
    startItem.addActionListener(this);
    cloneItem = new MenuItem(AppletViewer.messages.getString("gcjwebplugin.menu_clone"));
    cloneItem.addActionListener(this);
    closeItem = new MenuItem(AppletViewer.messages.getString("gcjwebplugin.menu_close"));
    closeItem.addActionListener(this);
    quitItem = new MenuItem(AppletViewer.messages.getString("gcjwebplugin.menu_quit"));
    quitItem.addActionListener(this);

    MenuBar menuBar = new MenuBar();
    Menu menuApplet = new Menu(AppletViewer.messages.getString("gcjwebplugin.menu_title"));
    menuBar.add(menuApplet);
    menuApplet.add(restartItem);
    menuApplet.add(reloadItem);
    menuApplet.add(cancelItem);
    menuApplet.add(saveItem);
    menuApplet.add(startItem);
    menuApplet.add(cloneItem);
    menuApplet.addSeparator();
    menuApplet.add(closeItem);
    menuApplet.add(quitItem);
    setMenuBar(menuBar);

    AppletContext context = (AppletContext) contexts.get(tag.codebase);
    ((StandaloneAppletContext) context).addApplet(applet);

    applet.setStub(new CommonAppletStub(tag, context, applet));

    setTitle("GCJ Applet Viewer: " + tag.code);

    String testWindowCount =
      System.getProperty("gnu.gcjwebplugin.test.windowCount");

    if (testWindowCount == null)
      {
	// Create the frame's peer.  Otherwise getPreferredSize will read
	// its insets as 0.
	addNotify();
        Insets i = getInsets ();
	Dimension size = getSizeFromTag(tag);
	setSize(i.left + size.width + i.right,
		i.top + size.height + status.getPreferredSize ().height
		+ i.bottom);
        applet.setSize(size);

        // Synchronize on the system event queue when showing and
        // initializing the applet so that it doesn't receive events
        // before it has been initialized.
        synchronized (Toolkit.getDefaultToolkit ().getSystemEventQueue ())
          {
            setVisible (true);
            applet.init ();
          }

	applet.validate();
	applet.start();
      }
    else
      {
	applet.init();
	applet.start();

	if (++StandaloneAppletWindow.testWindowCount == Integer.decode(testWindowCount).intValue())
	  System.exit(0);
      }
  }

  private Dimension getSizeFromTag(AppletTag tag)
  {
    NumberFormat numberFormat;
    Dimension size = new Dimension();

    try
      {
	String widthStr = (String) tag.parameters.get("width");

	if (widthStr.charAt(widthStr.length() - 1) == '%')
	  numberFormat = NumberFormat.getPercentInstance(Locale.US);
	else
	  numberFormat = NumberFormat.getInstance(Locale.US);

	// FIXME: Handle percentage somehow.
	size.width = numberFormat.parse(widthStr).intValue();
      }
    catch (ParseException e)
      {
	// Use default.
	size.width = 320;
      }

    try
      {
	String heightStr = (String) tag.parameters.get("height");

	if (heightStr.charAt(heightStr.length() - 1) == '%')
	  numberFormat = NumberFormat.getPercentInstance(Locale.US);
	else
	  numberFormat = NumberFormat.getInstance(Locale.US);

	// FIXME: Handle percentage somehow.
	size.height = numberFormat.parse(heightStr).intValue();
      }
    catch (ParseException e)
      {
	// Use default.
	size.height = 200;
      }

    return size;
  }

  public void actionPerformed(ActionEvent e)
  {
    if (e.getSource() == quitItem)
      {
        applet.stop();
        StandaloneAppletWindow.this.hide();
        System.exit(0);
      }
  }

  void showStatus(String status)
  {
    this.status.setText(status);
  }
}
