/* CommonAppletContext.java -- a common applet's context
   Copyright (C) 2004, 2005  Michael Koch <konqueror@gmx.de>

   This file is part of GCJ Applet Viewer.

   GCJ Applet Viewer is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   GCJ Applet Viewer is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GCJ Applet Viewer; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

package gnu.gcjwebplugin;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AudioClip;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;


/*
 * CommonAppletContext represents the common context stuff for both
 * types, plugins and standalone.
 */
abstract class CommonAppletContext
  implements AppletContext
{
  // FIXME: this needs to be static, and we need one AppletContext per
  // Applet.
  List applets = new ArrayList();
  HashMap streams = new HashMap();

  void addApplet(Applet applet)
  {
    applets.add(applet);
  }

  ///////////////////////////////
  //// AppletContext methods ////
  ///////////////////////////////
  public AudioClip getAudioClip(URL url)
  {
    return Applet.newAudioClip(url);
  }

  public Image getImage(URL url)
  {
    return Toolkit.getDefaultToolkit().getImage(url);
  }

  public Applet getApplet(String name)
  {
    Applet a;
    String appletName;
    Iterator i = applets.iterator();

    while (i.hasNext())
      {
	a = (Applet) i.next();

	appletName = a.getParameter("name");
	if (a != null && appletName != null && appletName.equals(name))
	  return a;
      }
    return null;
  }

  public Enumeration getApplets()
  {
    return Collections.enumeration(applets);
  }

  public void showDocument(URL url)
  {
    showDocument(url, "_self");
  }

  /*
  // FIXME: implement.
  public abstract void showDocument (URL url, String target);

  // FIXME: implement.
  public abstract void showStatus (String status);
  */
  public void setStream(String key, InputStream stream)
  {
    streams.put(key, stream);
  }

  public InputStream getStream(String key)
  {
    return (InputStream) streams.get(key);
  }

  public Iterator getStreamKeys()
  {
    return streams.keySet().iterator();
  }
}
