/*
Copyright 2013 Cameron Palmer

This file is a part of Genezip.

Genezip is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Genezip is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Genezip.  If not, see <http://www.gnu.org/licenses/>
*/
#include "genezip/binary_buffer.h"

unsigned genezip_utils::binary_buffer::read(unsigned nbytes, 
					    unsigned nbits, 
					    bool     raw) {
  unsigned return_value = 0;
  //for each requested byte
  for (unsigned byte_counter = 0; byte_counter < nbytes; ++byte_counter) {
    for (unsigned i = 0; i < 8; ++i) {
      if (!raw) return_value <<= 1;
      return_value |= read_bit() << (raw ? (byte_counter << 3) + i : 0);
    }
  }
  for (unsigned bit_counter = 0; bit_counter < nbits; ++bit_counter) {
    if (!raw) return_value <<= 1;
    return_value |= read_bit() << (raw ? (nbytes << 3) + bit_counter : 0);
  }
  return return_value;
}
