/*
Copyright 2013 Cameron Palmer

This file is a part of Genezip.

Genezip is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Genezip is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Genezip.  If not, see <http://www.gnu.org/licenses/>
*/

/*!
  \file custom_hash_function.h
  \brief virtual parent class for gzip compressor hash function
  @see general_input_hash.h
 */
#ifndef __GENEZIP__CUSTOM_HASH_FUNCTION_H__
#define __GENEZIP__CUSTOM_HASH_FUNCTION_H__

#include <stdexcept>
#include <string>
#include <vector>
#include <iostream>
#include <fstream>
#include <sstream>
#include <map>
#include <utility>
#include "genezip/helper_functions.h"

namespace genezip_utils {
  /*!
    \class custom_hash_function
    \brief virtual parent class for gzip compressor hash function
    @see general_input_hash
  */
  class custom_hash_function {
  public:
    /*!
      \brief constructor
    */
    custom_hash_function() {}
    /*!
      \brief destructor
    */
    ~custom_hash_function() throw() {}
    /*!
      \brief (virtual) hash two unsigneds to an unsigned
      \return (hopefully) child class hash result
    */
    virtual inline unsigned hashify(unsigned u1, unsigned u2) const {return 0;}
    /*!
      \brief (virtual) bound on size of hash from hash function
      \return (hopefully) child class hash value bound
    */
    virtual inline unsigned max_hash() const {return 1;}
  private:
  };
}
//include the child hashes here, so code includes just custom_hash_function.h
#include "genezip/general_input_hash.h"

#endif //__CUSTOM_HASH_FUNCTION_H__
