/*
Copyright 2013 Cameron Palmer

This file is a part of Genezip.

Genezip is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Genezip is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Genezip.  If not, see <http://www.gnu.org/licenses/>
*/

#include "genezip/gzfile_block_data.h"

unsigned genezip_utils::gzfile_block_data::process_distance(unsigned
							    stock_distance, 
							    binary_buffer &
							    buffer) const {
  unsigned value_read_from_buffer = 0;
  unsigned distance = stock_distance;
  unsigned base_index = (distance >> 1) << 1;
  unsigned nbits = base_index ? (base_index >> 1) - 1 : base_index;
  base_index = base_index == 2 ? 0 : base_index;
  unsigned init_offset = base_index ? (1 << (nbits+1)) + 1 : 1;
  distance = ((distance - base_index) << nbits) + init_offset;
  if (nbits) {
    value_read_from_buffer = buffer.read(0, nbits, true);
    distance += value_read_from_buffer;
  }
  return distance;
}
genezip_utils::literal_length_disambiguation
genezip_utils::gzfile_block_data::interpret_literal_length(unsigned 
							   initial_attempt, 
							   binary_buffer &
							   buffer) const {
  unsigned length = 0;
  //if the value is < 256, it's a literal, so just dump it to the output stream
  if (initial_attempt < GENEZIP_LITERAL_VALUE_UPPER_BOUND) {
    return literal_length_disambiguation(initial_attempt, RAW_CHARACTER);
  }
  //otherwise, if the value is 256, the block just ended, return
  else if (initial_attempt == GENEZIP_LITERAL_VALUE_UPPER_BOUND) {
    return literal_length_disambiguation(initial_attempt, END_OF_BLOCK);
  }
  //otherwise, convert the value into a length, and get a distance from 
  // the input stream
  else {
    if (initial_attempt <= GENEZIP_LITERAL_VALUE_UPPER_BOUND + 8/*264*/) {
      length = initial_attempt - (GENEZIP_LITERAL_VALUE_UPPER_BOUND - 2)/*254*/;
    } else if (initial_attempt <= GENEZIP_LITERAL_VALUE_UPPER_BOUND + 12/*268*/) {
      length = ((initial_attempt - (GENEZIP_LITERAL_VALUE_UPPER_BOUND + 9)/*265*/) 
		<< 1) +  11 + buffer.read(0,1,true);
    } else if (initial_attempt <= GENEZIP_LITERAL_VALUE_UPPER_BOUND + 16/*272*/) {
      length = ((initial_attempt - (GENEZIP_LITERAL_VALUE_UPPER_BOUND + 13)/*269*/) 
		<< 2) +  19 + buffer.read(0,2,true);
    } else if (initial_attempt <= GENEZIP_LITERAL_VALUE_UPPER_BOUND + 20/*276*/) {
      length = ((initial_attempt - (GENEZIP_LITERAL_VALUE_UPPER_BOUND + 17)/*273*/) 
		<< 3) +  35 + buffer.read(0,3,true);
    } else if (initial_attempt <= GENEZIP_LITERAL_VALUE_UPPER_BOUND + 24/*280*/) {
      length = ((initial_attempt - (GENEZIP_LITERAL_VALUE_UPPER_BOUND + 21)/*277*/) 
		<< 4) +  67 + buffer.read(0,4,true);
    } else if (initial_attempt <= GENEZIP_LITERAL_VALUE_UPPER_BOUND + 28/*284*/) {
      length = ((initial_attempt - (GENEZIP_LITERAL_VALUE_UPPER_BOUND + 25)/*281*/) 
		<< 5) + 131 + buffer.read(0,5,true);
    } else if (initial_attempt == GENEZIP_LITERAL_VALUE_UPPER_BOUND + 29/*285*/) {
      length = 258;
    } else {
      throw std::domain_error("genezip_utils::gzfile_block_data::process_"
			      "fixed_compressed_block: length code above 285"
			      "boundary: " 
			      + to_string<unsigned>(initial_attempt));
    }
    --length;
    return literal_length_disambiguation(length, LENGTH);
  }
}

void genezip_utils::gzfile_block_data::process_dynamic_compressed_block(binary_buffer &buffer, const huffman_code &litlen_code, const huffman_code &distance_code, output_buffer &obuffer) {
  //time to parametrize this bullshiz
  while (true) {
    literal_length_disambiguation disambig = 
      interpret_literal_length(litlen_code.pop_and_translate(buffer), buffer);
    if (disambig.second == RAW_CHARACTER) {
      obuffer.add_literal(disambig.first);
    } else if (disambig.second == END_OF_BLOCK) {
      break;
    } else {
      //NOW get the distance
      unsigned stock_distance = 0;
      unsigned distance = 
	process_distance((stock_distance = 
			  distance_code.pop_and_translate(buffer)), buffer);
      //give the distance and the length to the output buffer,
      //so it can copy the values
      obuffer.repeat_sequence(distance, disambig.first);
    }
  }
}
