/*
Copyright 2013 Cameron Palmer

This file is a part of Genezip.

Genezip is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Genezip is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Genezip.  If not, see <http://www.gnu.org/licenses/>
*/

#include "genezip/uncompressed_buffer.h"

unsigned genezip_utils::uncompressed_buffer::match_with_current
(unsigned reverse_offset) {
  if (!_buffered_data)
    throw std::domain_error("genezip_utils::uncompressed_buffer::match"
			    "_with_current: called with no data");
  unsigned length_of_match = 0;
  unsigned earlier_match_index = _current_buffer_read_index - 
    reverse_offset - 1;
  unsigned current_match_index = _current_buffer_read_index - 1;
  unsigned tempat1 = 0, tempat2 = 0;
  for ( ; current_match_index < _current_buffer_bound_index && 
	  earlier_match_index < _current_buffer_bound_index && //no underflow
	  length_of_match < 257;
	  ++current_match_index, ++earlier_match_index, ++length_of_match) {
    _buffered_data->at(earlier_match_index, tempat2);
    _buffered_data->at(current_match_index, tempat1);
    if (tempat1 != tempat2) break;
  }
  return length_of_match >= 2 ? length_of_match : 0;
}

unsigned genezip_utils::uncompressed_buffer::read() {
  if (!_buffered_data || eof()) {
    throw std::domain_error("genezip_utils::uncompressed_buffer::read: "
			    "there are no more data to read");
  }
  unsigned res = 0;
  _buffered_data->at(_current_buffer_read_index++, res);
  //std::cout << "uncompressed buffer reading " << res << std::endl;
  return res;
}
unsigned genezip_utils::uncompressed_buffer::read_nonincrement(unsigned *u1) {
  if (!_buffered_data || !u1)
    throw std::domain_error("genezip_utils::uncompressed_buffer::"
			    "read_two_nonincrementing: null pointers");
  if (_current_buffer_read_index == _current_buffer_bound_index) return 0;
  _buffered_data->at(_current_buffer_read_index, *u1);
  return 1;
}
unsigned genezip_utils::uncompressed_buffer::read_two_characters(unsigned *u1,
								 unsigned *u2){
  if (!u1 || !u2 || !_buffered_data)
    throw std::domain_error("genezip_utils::uncompressed_buffer::"
			    "read_three_characters: null pointers!");
  if (eof()) return 0;
  *u1 = read();
  return read_nonincrement(u2) + 1;
}
