// $Id: settings.c,v 1.2 2006/04/15 09:28:58 khlut Exp $ Process files with global settins
//
// Copyright 2005 Elphel, Inc.
//
// This file is part of GenReS.
//
//    GenReS is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    GenReS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with GenReS; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include "genres.h"
#include <sys/stat.h>

// process name=value pair
// delims must include eols
// returns pointer to value and *s point to name

char * pair(char **s, const char *spaces, const char *delims, const char *eols)
{
    char * val;
    size_t i;
    
    for(i=0;(*s)[i];i++) if((*s)[i]&128) (*s)[i]=' ';
    *s += strspn(*s, spaces); // skip leading spaces
    val = *s+strcspn(*s, delims); // search delimeter

  if(val==*s || strchr(eols,*val)) return 0; // delimeter not found or name has zero length

    *val++ = 0;
    for(;;) {
        i=strcspn(*s, spaces); // search space
      if( !(*s)[i] )break;
        (*s)[i]=0;
        i+=1+strspn(*s + i + 1, spaces);
      if( !(*s)[i] )break;
        *s+=i;
    }

  return val;
}

// Read config files

static char *configs[] = { "/etc/genres.conf", "~/.mozilla/genres/genres.conf" };
void configure()
{
    int i;
    char s[1024];
    
    for(i=sizeof configs/sizeof configs[0]; i-- ;) {
	char *path=strpath(configs[i]);	if(!path) continue;
	FILE *cf=fopen(path,"r");
	PR_Free(path);
	if(cf) {
	    while(fgets(s, sizeof s, cf)) {
	        char *var=s,*val;
		val=pair(&var," \t","=#\n","#\n");
		if(!val) continue;
		int n=atoi(val);
		if(!n && val[0]=='y' || val[0]=='Y' || val[0]=='t' || val[0]=='T') n=1;
		val[0]=n+'0'; val[1]=0;
		if(strcmp(var,"mozillastreams")==0){
		    mozillastreams=n;
		    setenv("GENRES_MOZILLA_STREAMS",val,1);
		}else if(strcmp(var,"debuglevel")==0){
		    debug=n;
		    setenv("GENRES_DEBUGLEVEL",val,1);
		}
	    }
	    fclose(cf);
	}
    }
}

// $Log: settings.c,v $
// Revision 1.2  2006/04/15 09:28:58  khlut
// new config parameter "mozillastreams"
// pass config parameters to environment variables "GENRES_DEBUGLEVEL" and "GENRES_MOZILLA_STREAMS"
//
// Revision 1.1  2006/04/09 19:08:12  khlut
// plugin config files ~/.mozilla/genres/genres.conf or /etc/genres.conf are supported
// new config parameter "debuglevel" (now is only two debug levels)
// javascript control for debug level is temporary switched off
// string analyse is reordered
//
