# -*- shell-script -*-
# func0-cleanup.sh -- Provides 3 different modes of garbage collection.  Will also be used to perform housekeeping on SIGINT
# Copyright © 2015-2016 Michael Pagan
#
# Author: Michael Pagan
# E-Mail: michael.pagan@member.fsf.org
# Jabber: pegzmasta@member.fsf.org
#
# This file is part of Genshiken.
#
# Genshiken is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Genshiken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Genshiken. If not, see http://www.gnu.org/licenses/.
#===================================================================
function Clean_Up
{
  case $1 in
    directory) # Remove excess files in PWD
               [[ ! -z $(eval $GET_JUNK) ]] && rm $(eval $GET_JUNK) || :
    ;;
    title-dir) # Remove title-dir and category-dir if empty on a failed series (download failed due to: file-deletion/the-abscence-of-an-ethical-host)
               cd ..; [[ -z `ls $OLDPWD` ]] && rmdir $OLDPWD; cd ..; [[ -z `ls $OLDPWD` ]] && rmdir $OLDPWD || :
    ;;
    hierarchy) # Remove temporary download files =================================================================================================\
               # These files will only exist if genshiken is interrupted by the user during the download procedure (detection is a bit tricky).   |
               #                                                                                                                                  |
               # NOTE: The 'gawk' statement after the first pipe is the only piece of code that I can't take credit for in Genshiken.             |
               #       It was submitted and marked as the correct solution to a question on stackexchange.com by "ghostdog74".                    |
               #       URL: <http://stackoverflow.com/questions/1767384/ls-command-how-can-i-get-a-recursive-full-path-listing-one-line-per-file> |
               [[ ! -z `ls ?/* 2> /dev/null | egrep -v 'flv|mp4|avi|ogg|webm|png|jpg|jpeg|/|^$'` ]] &&
               rm $(ls -R  ?/* 2> /dev/null | egrep -v 'flv|mp4|avi|ogg|webm|png|jpg|jpeg' |\
               gawk '/:$/&&f{s=$0;f=0} /:$/&&!f{sub(/:$/,"");s=$0;f=1;next} NF&&f{ print s"/"$0 }') || :
    ;;
  esac
}

# End:
# func0-cleanup.sh ends here
