# -*- shell-script -*-
# gfunc4-update-previous-sessions.sh -- Update the user's previous session files, whenever the '--get|--stream' Option
#                                       adds/removes anime to the category files or to the user's anime directory.
# Copyright © 2015-2016 Michael Pagan
#
# Author: Michael Pagan
# E-Mail: michael.pagan@member.fsf.org
# Jabber: pegzmasta@member.fsf.org
#
# This file is part of Genshiken.
#
# Genshiken is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Genshiken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Genshiken. If not, see http://www.gnu.org/licenses/.
#===================================================================
function Update_Previous_Sessions
{
  case $1 in
    # Update previous session files whenever a newly released anime is added to the category files |
    # NOTE: New releases will make the menu item number stored in 'get/stream' sessions inaccurate |
    new_releases-*)

      # For every `new_release_title' we encounter, increment the `menu_item_number' by 1 if it meets the below criteria
      cat $(find $DIR_DET/../ -name $1 -type f -print) | while read new_release_title
      do
        for previous in `find $DIR_DET/../ -name 'previous-session-*' -type f -print |\
                         xargs egrep -v '\*|\-\-|[0-9]*\+[0-9]*$|anime-dub|anime-sub|cartoon|movie|ova' |\
                         sed 's_.*:[0-9]*+[0-9]$__' | egrep -v '^$|\-view|OVERRIDE' | sort -u -t : -k 2 | gawk -F: '{ print $1 }'`
        do
          local last_anime=$(sed -n '1 p' $previous)
          local menu_item_number=$(grep '+' $previous | sed 's_.*+\(.*\):.*_\1_' | grep -v '[^0-9]')

          # There will be three criteria for updating the previous session files when encountering a new release title: |
          #                                                                                                             |
          # 1) The previous session file must belong to the same Anime-Type as specified on the command-line.           |
          # 2) The previous session file must also belong to the same series category as the `new_release_title'.       |
          # 3) Lastly-- When compared to the previous anime, the newly released anime must sort first lexicographically |
          #                                                                                                             |
          # The menu item number for the previous session file will be incremented by one, if all conditions are met    |
          if [[ ! -z `cat $previous | grep $2` &&
                $(sed 's_\(.\).*_\1_' <<< "$new_release_title") = $(sed 's_\(.\).*_\1_' <<< "$last_anime") &&
                $new_release_title < $last_anime ]]
          then let menu_item_number+=1; sed -i "s_\(.*\)+\(.*\):\(.*\)_\1+${menu_item_number}:\3_" $previous
          fi
        done
      done
    ;;
    # Update previous session files whenever an anime is removed from the category files             |
    # NOTE: Removed series will make the menu item number stored in 'get/stream' sessions inaccurate |
    removed_show-*)

      # For every `removed_show_title' we encounter, decrement the `menu_item_number' by 1 if it meets the below criteria
      cat $(find $DIR_DET/../ -name $1 -type f -print) | while read removed_show_title
      do
        for previous in `find $DIR_DET/../ -name 'previous-session-*' -type f -print |\
                         xargs egrep -v '\*|\-\-|[0-9]*\+[0-9]*$|anime-dub|anime-sub|cartoon|movie|ova' |\
                         sed 's_.*:[0-9]*+[0-9]$__' | egrep -v '^$|\-view|OVERRIDE' | sort -u -t : -k 2 | gawk -F: '{ print $1 }'`
        do
          local last_anime=$(sed -n '1 p' $previous)
          local menu_item_number=$(grep '+' $previous | sed 's_.*+\(.*\):.*_\1_' | grep -v '[^0-9]')

          # There will be three criteria for updating the previous session files when encountering a removed show title: |
          #                                                                                                              |
          # 1) The previous session file must belong to the same Anime-Type as specified on the command-line.            |
          # 2) The previous session file must also belong to the same series category as the `removed_show_title'.       |
          # 3) Lastly-- When compared to the previous anime, the removed show must sort last lexicographically           |
          #                                                                                                              |
          # The menu item number for the previous session file will be decremented by one, if all conditions are met     |
          if [[ ! -z `cat $previous | grep $2` &&
                $(sed 's_\(.\).*_\1_' <<< "$new_release_title") = $(sed 's_\(.\).*_\1_' <<< "$last_anime") &&
                $new_release_title > $last_anime ]]
          then let menu_item_number=$[$menu_item_number-1]; sed -i "s_\(.*\)+\(.*\):\(.*\)_\1+${menu_item_number}:\3_" $previous
          fi
        done
      done
    ;;
    # Update previous session files whenever a newly downloaded anime is added to the user's anime directory |
    # NOTE: New downloads will make the menu item number stored in 'view' sessions inaccurate                |
    $DIR_ANIM/$2/$title/)
      for previous in `find $DIR_DET/../ -name 'previous-session-*' -type f -print | grep '\-view-'`
      do
        local last_anime=$(sed -n '1 p' $previous)
        local menu_item_number=$(grep '+' $previous | gawk -F+ '{ print $1 }')

        #  I'm checking to see whether the newly downloaded anime sorts first lexicographically, and if so, |
        #+ the menu item number for the previous session file will be incremented by one.                   |
        if [[ $title < $last_anime ]]
        then let menu_item_number+=1; sed -i "s_\(.*\)+\(.*\)_${menu_item_number}+\2_" $previous
        fi
      done
    ;;
  esac
}

# End:
# gfunc4-update-previous-sessions.sh ends here
