# -*- shell-script -*-
# gfunc82110-view-anime-list.sh -- View all the anime titles in the selected series (if you don't want to wait/read: Use the '--impatient' Option)
# Copyright © 2015-2016 Michael Pagan
#
# Author: Michael Pagan
# E-Mail: michael.pagan@member.fsf.org
# Jabber: pegzmasta@member.fsf.org
#
# This file is part of Genshiken.
#
# Genshiken is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Genshiken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Genshiken. If not, see http://www.gnu.org/licenses/.
#===================================================================
function View_Anime_List
{
  echo -e "\n${N}${R}[${FUNCNAME[0]}] ${G}At the ${R}[${FUNCNAME[1]}]${G} prompt: A=[${M}A${G}]nother_Series; V=re[${M}V${G}]iew; Q=[${M}Q${G}]uit ${N}"
  [[ ! -z ${WAIT:-} && $WAIT -le 2 ]] && : || sleep 2
  echo -e "${N}${R}[${FUNCNAME[0]}] ${G}You selected: \"${M}`sed 's_.txt__' <<< $1`${G}\"; Find the row number of your desired anime. ${N}"
  [[ ! -z ${WAIT:-} && $WAIT -le 2 ]] && : || sleep 2
  if [[ $PAGE = less ]]; then
    echo -e "${N}${R}[${FUNCNAME[0]}] ${G}There is a total of ${M}`wc -l < $1` ${G}Anime's in \"${M}`sed 's_.txt__' <<< $1`${G}\". ${N}  \b"
    [[ ! -z ${WAIT:-} && $WAIT -le 2 ]] && : || sleep 2
    echo -e "${N}${R}[${FUNCNAME[0]}] ${G}In the pager, you can scroll up & down the list.  Press '${M}Q${G}' to leave the pager.${Y}   \b\b\n"
    [[ ! -z ${WAIT:-} && $WAIT -le 2 ]] && : || sleep 5
  else
    echo -e "${N}${R}[${FUNCNAME[0]}] ${G}There is a total of ${M}`wc -l < $1` ${G}Anime's in \"${M}`sed 's_.txt__' <<< $1`${G}\".${Y}   \b\b\n"
    [[ ! -z ${WAIT:-} && $WAIT -le 2 ]] && : || sleep 2
  fi
  gawk -F">" 'BEGIN { print "RW-#\t ANIME\n----\t -----"}; { if (NR>9) { print "  "NR, "\t", $2 } else { print "   "NR, "\t", $2 }; }
              END   { print "=====\t =======\nDone?\t Press-Q"}' < $1 | sed 's_<.*__' | eval $HUMAN_READABLE | $PAGE
}

# End:
# gfunc82110-view-anime-list.sh ends here
