# -*- shell-script -*-
# gfunc83130-whats-missing.sh -- If Genshiken fails to download any videos, then let the user know about it
# Copyright © 2015-2016 Michael Pagan
#
# Author: Michael Pagan
# E-Mail: michael.pagan@member.fsf.org
# Jabber: pegzmasta@member.fsf.org
#
# This file is part of Genshiken.
#
# Genshiken is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Genshiken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Genshiken. If not, see http://www.gnu.org/licenses/.
#===================================================================
function Whats_Missing
{
  # At this point, we can't determine the server/upload paths; therefore, remove all junk relating to the failed episode/series (tmp/title/category/etc).
  echo -e "\n${N}${R}[${FUNCNAME[0]}] ${A}${G}Sorry!  This file is either: Deleted; it's URL is obfuscated; or, the URL requires non-free code. ${N}" >&2
  echo -e "${N}${R}[${FUNCNAME[0]}] ${G}The episode information will be stored in a log file in ${C}$TMPDIR/genshiken-$USER/missing_files.log ${N}"   >&2
  Clean_Up directory && Clean_Up title-dir; local USER_LOG=$DIR_DET/../missing_files.log

  # If the users' log file does not exist: Create it
  [[ ! -f $USER_LOG ]] &&
  {
    echo -e "Category\tType\tSeries_Title\tEpisode_Title" >  $USER_LOG
    echo -e "--------\t----\t------------\t-------------" >> $USER_LOG
  }
  # Ensure there are no duplicate entries in the users' log file
  if [[ $1 = 'movie' ]]
  then [[ ! -z `grep "${title}" $DIR_DET/../missing_files.log` ]] && USER_LOG=/dev/null
  else [[ ! -z `grep "${2}"     $DIR_DET/../missing_files.log` ]] && USER_LOG=/dev/null
  fi
  # This data will be piped to 2 files: 1 log for genshiken; the other for the user
  if [[ $1 = 'movie' ]]; then
    echo -e "${category}\t$TYPE\t${title}"       >> $USER_LOG
  else
    echo -e "${category}\t$TYPE\t${title}\t${2}" >> $USER_LOG
    echo -e "${category}\t$TYPE\t${title}\t${2}" >> missing_files.log
  fi
  # Ensure the users' log file looks good
  [[ $USER_LOG != '/dev/null' ]] && { column -t < $USER_LOG > $TMPDIR/lost_videos.log; rm $USER_LOG; mv $TMPDIR/lost_videos.log $USER_LOG; }
}

# End:
# gfunc83130-whats-missing.sh ends here
