;; edevel.el -- Automate my workflow with emacs and shell commands
;; Copyright © 2015-2016 Michael Pagan
;;
;; Copying and distribution of this file, with or without modification,
;; are permitted in any medium without royalty provided the copyright
;; notice and this notice are preserved.  This file is offered as-is,
;; without any warranty.

;; Let's automate repetitive shell commands when developing Genshiken
;; via `GNU Eev'

;; Start a shell (Pre-dev commands)
 (eepitch-shell)
 (eek "C-x o C-x C-- C-x C-- C-x o")
cd ~/cvs-projects/genshiken/
rm MANIFEST.html 2> /dev/null
make tarball

;; _SKIP_ if not editing `readme' files: (`In-between-editing' commands)
cd share/doc/genshiken
 (eek "C-x 1")
 (find-file "~/cvs-projects/genshiken/share/doc/genshiken/readme.org")
rm *.texi *.info *.html web* *~ 2> /dev/null
cd -
make org-export-info
emacs --file readme.org --eval "(org-texinfo-export-to-info)" -f save-buffers-kill-terminal
make org-export-text
emacs --file readme.org --eval "(org-ascii-export-to-ascii)" -f save-buffers-kill-terminal
rm readme.org
mv readme.[t]* share/doc/genshiken
mv share/doc/readme.org share/doc/genshiken
 (eek "C-x 1")

;; Update the Repository (post-dev commands)
;; NOTE: Update the Manifest (~C-s create-manifest~)
rm ~/cvs-projects/genshiken/MANIFEST.html 2> /dev/null
 (find-file "~/cvs-projects/genshiken/share/doc/genshiken/readme.org")
cd ~/cvs-projects/genshiken/
rm ../genshiken-* ChangeLog MANIFEST MANIFEST~ share/doc/genshiken/ChangeLog 2> /dev/null
 (eepitch-kill)
 (cvs-examine "~/cvs-projects/genshiken/" t)
