# -*- shell-script -*-
# gfunc2-download-file.sh -- [Start/Continue] Downloading of a file, and server messages OR begin streaming videos
# Copyright © 2015-2016 Michael Pagan
#
# Author: Michael Pagan
# E-Mail: michael.pagan@member.fsf.org
# Jabber: pegzmasta@member.fsf.org
#
# This file is part of Genshiken.
#
# Genshiken is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Genshiken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Genshiken. If not, see http://www.gnu.org/licenses/.
#===================================================================
function Download_File
{
  # Get the source code of a website
  if [[ $3 = '-source' ]]; then
    [[ -f $1 ]] && rm $1
    #-lynx -preparsed $3 $2 > $1 && [[ $? = 1 ]] &&
    wget $2 -O $1 &> /dev/null && [[ $? = 1 ]] &&
    {
      echo -e "\n${N}${R}[${FUNCNAME[0]}] ${A}${G} Internet Connection Lost!  Exitting now..."
      [[ -f $RESTORE.backup ]] && mv $RESTORE.backup $RESTORE
      exit 10
    }
  # Making a header request will provide a means to determine how large our files should be.                 |
  # If you see any variables, like $Specified_Size or $File_Size, expect a header request to have been made. |
  elif [[ $3 = '--head' ]]; then curl -k -L --keepalive-time 20 $3 $2 &>> header

    # Evaluate the server messages for specific values, and then make these variables global
    [[ -f header ]] &&
    {
      declare -g ERROR=$(grep 'ERROR' header | grep -v -e \"$0\" -e '.*:[ ]line.*'  | sed 's_.*\(ERROR.*\)_\1_')  &> /dev/null # NO LONGER NEEDED ...
      declare -g Specified_Size=$(grep 'Content-Length:' header | gawk '{ print $2 }' | sed 's_\([0-9]*\).*_\1_') &> /dev/null; rm header
    }

  #  If we're streaming, there's no need to download-- just play! ===========================================================================\
  #                                                                                                                                          |
  #  NOTE: Not all media players support streaming, and the ones that do, may not support input from a pipe (MPlayer and derivitives do).    |
  #+       Please modify this code to suit your media player of choice.  Make sure to consult the documentation that comes with your player. |
  elif [[ ! -z ${STREAM:-} ]]; then

    # Annouce what video we are streaming
    $MSG "Now Streaming: \"$1\""

    # If the user feels like they don't need a cache, then don't give them one (for MPlayer and derivitives) ...
    [[ ! -z ${WAIT:-} && $WAIT -eq 0 ]] ||
    {
      [[ `gawk '{ print $1 }' <<< "$PLAYER"` = 'mplayer' ||
         `gawk '{ print $1 }' <<< "$PLAYER"` = 'mpv'     ]] && CACHE='-cache 32768'
    }
    # Define the stream log name
    export STREAM_LOG=$DIR_DET/../stream_time.log

    # Remove the stream log if it exists
    [[ -f ${STREAM_LOG:-} ]] && rm $STREAM_LOG

    # I added a mechanism to deal with network time-outs utilizing GNU Wget; however, it only works with MPlayer and derivitives
    if [[ `gawk '{ print $1 }' <<< "$PLAYER"` = 'mplayer' ||
          `gawk '{ print $1 }' <<< "$PLAYER"` = 'mpv'     ]]
    then
      [[ -z ${SLOW:-} ]] &&
      {
        # Attempt to play the video, and if it fails: Make at least 3 attempts before continuing                             |
        # NOTE: I'm timing this, for if the player quits in less than 10 seconds: I will assume the address was not accepted |
        (time $PLAYER ${CACHE:-} $2) 2> >(sed -n '/^real/ s/.*\s*[0-9]*m\(.*\)\..*/\1/ p' > $STREAM_LOG)

        # Unfortunately, mpv can't handle certain HTTP requests; thus, we'll let wget network-pipe it if we fail
        if [[ $? = 2 ]]
        then
          wget --no-check-certificate -T 20 --waitretry=10 $2 -O - | $PLAYER ${CACHE:-} -
        else
          for loop in {1..2}
          do
            if [[ -n `< $STREAM_LOG` && `< $STREAM_LOG` -lt 10 ]]
            then { rm $STREAM_LOG; (time $PLAYER ${CACHE:-} $2) 2> >(sed -n '/^real/ s/.*\s*[0-9]*m\(.*\)\..*/\1/ p' > $STREAM_LOG); }
            else break
            fi
          done
        fi
      } || wget --no-check-certificate -T 20 --waitretry=10 $2 -O - | $PLAYER ${CACHE:-} -

    # GNOME Videos, VLC, and Xine should be able to stream a network address.
    else
      # Attempt to play the video, and if it fails: Make at least 3 attempts before continuing                             |
      # NOTE: I'm timing this, for if the player quits in less than 10 seconds: I will assume the address was not accepted |
      (time $PLAYER $2) |& sed -n '/^real/ s/.*\s*[0-9]*m\(.*\)\..*/\1/ p' > $STREAM_LOG
      for loop in {1..2}
      do
        if [[ -n `< $STREAM_LOG` && `< $STREAM_LOG` -lt 10 ]]
        then { rm $STREAM_LOG; (time $PLAYER $2) 2> >(sed -n '/^real/ s/.*\s*[0-9]*m\(.*\)\..*/\1/ p' > $STREAM_LOG); }
        else [[ -n `< $STREAM_LOG` && `< $STREAM_LOG` -lt 10 && $loop -eq 2 ]] && Stream_Failed
        fi
      done
    fi
    # If wget quits prematurely, then our internet connection has been lost
    [[ $? = 4 ]] &&
    {
      echo -e "\n${N}${R}[${FUNCNAME[0]}] ${A}${G} Internet Connection Lost!  Exitting now..."
      [[ -f $RESTORE.backup ]] && mv $RESTORE.backup $RESTORE
      Early_Termination
    }
  # Regular Download
  else
    if [[ ! -z ${CONTINUE:-} ]]; then
      if [[ -z `wget --show-progress |& grep 'unrecognized'` ]]
      then   curl -k -I -L --keepalive-time 20 $2 &>> header; wget  $CONTINUE  --no-check-certificate -q --show-progress -T 20 --waitretry=10 -O $1 $2
      else   curl -k -I -L --keepalive-time 20 $2 &>> header; wget  $CONTINUE  --no-check-certificate                    -T 20 --waitretry=10 -O $1 $2
      fi
    else
      [[ $3 = '--continue' ]] &&
      {
        if [[ -z `wget --show-progress |& grep 'unrecognized'` ]]
        then curl -k -I -L --keepalive-time 20 $2 &>> header; wget  $3         --no-check-certificate -q --show-progress -T 20 --waitretry=10 -O $1 $2
        else curl -k -I -L --keepalive-time 20 $2 &>> header; wget  $3         --no-check-certificate                    -T 20 --waitretry=10 -O $1 $2
        fi
      } ||
      {
        if [[ -z `wget --show-progress |& grep 'unrecognized'` ]]
        then curl -k -I -L --keepalive-time 20 $2 &>> header; touch $1; wget   --no-check-certificate -q --show-progress -T 20 --waitretry=10 -O $1 $2
        else curl -k -I -L --keepalive-time 20 $2 &>> header; touch $1; wget   --no-check-certificate                    -T 20 --waitretry=10 -O $1 $2
        fi
      } # Capture the error code of wget, since we'll be checking for two different error codes
    fi; ERR=$?

    # If wget quits prematurely, then our internet connection has been lost
    if [[ $ERR = 4 ]]; then
      echo -e "\n${N}${R}[${FUNCNAME[0]}] ${A}${G} Internet Connection Lost!  Exitting now..."
      [[ -f $RESTORE.backup ]] && mv $RESTORE.backup $RESTORE
      Early_Termination

    # This is a rare case, but sometimes the address will change and make the `.last_video' file unaccurate
    elif [[ $ERR = 8 ]]; then
      echo -e "\n${N}${R}[${FUNCNAME[0]}] ${A}${G} The requested file is no longer located at the specified address."
      echo -e "${N}${R}[${FUNCNAME[0]}] ${G} This data was provided by an unaccurate file log that has now been removed."
      echo -e "${N}${R}[${FUNCNAME[0]}] ${G} Try restoring this session again, and ${B}$PROGNAME${G} will re-calculate the address."
      echo "$PWD" > $DIR_DET/../.recalculate_address.log # This will affect the [Interrupted_Downloads] & [Download_Anime] procedures...
      Early_Termination
    fi
    touch $1
    [[ -f header ]] &&
    {
      declare -g ERROR=$(grep 'ERROR' header | grep -v -e \"$0\" -e '.*:[ ]line.*'  | sed 's_.*\(ERROR.*\)_\1_')  &> /dev/null # NO LONGER NEEDED ...
      declare -g Specified_Size=$(grep 'Content-Length:' header | gawk '{ print $2 }' | sed 's_\([0-9]*\).*_\1_') &> /dev/null; rm header
    }
    [[ ! -z ${CONTINUE:-} ]] && unset CONTINUE
  fi
}

# End:
# gfunc2-download-file.sh ends here
