# -*- shell-script -*-
# gfunc5-restore-previous-session.sh -- If the user quit prematurely during a download/stream/view process, then attempt to resume where they left off
# Copyright © 2015-2016 Michael Pagan
#
# Author: Michael Pagan
# E-Mail: michael.pagan@member.fsf.org
# Jabber: pegzmasta@member.fsf.org
#
# This file is part of Genshiken.
#
# Genshiken is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Genshiken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Genshiken. If not, see http://www.gnu.org/licenses/.
#===================================================================
function Restore_Previous_Session
{
  # Let's not enter an infinite loop whilst in the 'here-doc' subshell
  [[ -f $TMPDIR/genshiken-$USER/.genshiken-here-doc.sh ]] && return

  # Only attempt to restore a session, if it matches the current session type
  [[ ! `find $DIR_DET/../ -name "previous-session-${MAIN//-/}-*" -type f -print` ]] && return

  #  Prompt the user if they want to restore their session[s], and loop through each session   |
  #+ alphabetically based off of the name of the anime that was selected during those sessions |
  if [[ `find $DIR_DET/../ -name 'previous-session-*' -type f -print | wc -l` -eq 1 ]]; then

    # Determine what type of session this is ('get/view/stream')
    session_file=$(find $DIR_DET/../ -name "previous-session-*" -type f -print)
    local LAST_SESSION=$(sed -n '3 p' $session_file | gawk '{ print $1 }')
    local ARG=${LAST_SESSION//-/}
    local STYPE=${ARG//get/download} # Session Type
    local CHAR=${STYPE:0:1}
    CHAR=${CHAR^?}
    local ANIME=$(sed -n '1 p' $session_file)  # Anime Name

    # Inform the user that they have a chance to restore their previous session of Genshiken
    echo -e "\n${N}${R}[${FUNCNAME[0]}] ${B}$PROGNAME ${G}detects a break from your last session. ${N} \b" &&
    [[ ! -z ${WAIT:-} && $WAIT -le 1 ]] && : || sleep 2
    if [[ $TERM = 'dumb' ]]; then
      echo -en "${N}${R}[${FUNCNAME[0]}] ${M}${CHAR}${STYPE:1} $ANIME ${G}episodes; Remove Session; Return? ($CHAR/R/*):${Y}   \b\b"
      read
    else
      echo -en "\r${N}${R}[${FUNCNAME[0]}] ${M}${CHAR}${STYPE:1} $ANIME ${G}episodes; Remove Session; Return? ($CHAR/R/*):${Y}   \b\b\033[K"
      read -n 1
    fi
    case $(tr [:lower:] [:upper:] <<< $REPLY) in
      $CHAR) RESTORE=$session_file;;
      R) rm $session_file && echo -e "${N}${R}[${FUNCNAME[0]}] ${M}$ANIME ${G}session: Deleted ${N}" && return;;
      *) return;;
    esac
  else
    # How many sessions do we have in total                                |
    # NOTE: There is no limit, and duplicates will be removed when spotted |
    local total_sessions=$(ls $DIR_DET/../previous-session-*.log | wc -l)
    for session_file in `find $DIR_DET/../ -name 'previous-session-*' -type f -print |\
                         xargs egrep -v '\*|\-\-|[0-9]*\+[0-9]*$|anime-dub|anime-sub|cartoon|movie|ova' |\
                         sed 's_.*:[0-9]*+[0-9]$__' | egrep -v '^$|OVERRIDE' | sort -u -t : -k 2 | gawk -F: '{ print $1 }'`
    do
      # Determine what type of session this is ('get/view/stream')
      local LAST_SESSION=$(sed -n '3 p' $session_file | gawk '{ print $1 }')
      local ARG=${LAST_SESSION//-/}
      local STYPE=${ARG//get/download} # Session Type
      local CHAR=${STYPE:0:1}
      CHAR=${CHAR^?}
      local ANIME=$(sed -n '1 p' $session_file) # Anime Name
      local ATYPE=$(sed -n '4 p' $session_file) # Anime Type
      ATYPE=${ATYPE//ova/special}
      ATYPE=${ATYPE//-*/}
      ATYPE=${ATYPE^?}

      # Inform the user that they have a chance to restore their previous sessions of Genshiken
      local rounds=${rounds:=0}
      let rounds+=1
      [[ $rounds = 1 ]] &&
      {
        echo -e "\n${N}${R}[${FUNCNAME[0]}] ${B}$PROGNAME ${G}Detects a break from your last session. ${N} \b" &&
        [[ ! -z ${WAIT:-} && $WAIT -le 1 ]] && : || sleep 2
      }

      #  Let's surprise the user, by actually remembering what they were doing |
      #+ the last time, and then offering to help them continue                |
      [[ $rounds = 1 ]] &&
      {
        echo -e "${N}${R}[${FUNCNAME[0]}] ${G}There are ${M}$total_sessions ${G}sessions available. ${N} \b"
        [[ ! -z ${WAIT:-} && $WAIT -le 1 ]] && : || sleep 1
      }
      continue_session="${rounds})\t${CHAR}${STYPE:1}"
      [[ $CHAR != 'D' ]] && tabs='  \b\b:\t\t' || tabs='  \b\b:\t'
      if [[ $TERM = 'dumb' ]]; then
        echo -en "${N}${R}[${FUNCNAME[0]}] ${M}$continue_session${G}$tabs ${R}[${M}$ANIME${R}] ${M}$ATYPE${G}/Next/Remove/Return? ($CHAR/N/R/*):${Y}   \b\b"
        read
      else
        echo -en "\r${N}${R}[${FUNCNAME[0]}] ${M}$continue_session${G}$tabs ${R}[${M}$ANIME${R}] ${M}$ATYPE${G}/Next/Remove/Return? ($CHAR/N/R/*):${Y}   \b\b\033[K"
        read -n 1
      fi
      case $(tr [:lower:] [:upper:] <<< $REPLY) in
        $CHAR)
          RESTORE=$session_file
          break
        ;;
        N)
          [[ $rounds = $total_sessions ]] && return || continue
        ;;
        R)
          rm $session_file && echo -e "${N}${R}[${FUNCNAME[0]}] ${M}$ANIME ${G}session: Deleted ${N}" &&
          [[ $rounds = $total_sessions ]] && return || continue
        ;;
        *)
          return
        ;;
      esac
    done
  fi
  # Determine how impatient our user is
  [[ -z ${WAIT:-} ]] && local level=1 || local level=$WAIT

  # Determine what the base directory is
  local OLD_BASE=$(sed -n '3 p' < $RESTORE | gawk '{ print $2 }')

  # Determine the user's last choice in terms of Anime-Type
  local LAST_ANIME_TYPE=$(sed -n '4 p' < $RESTORE)

  # Determine if the user chose to ignore non-special episodes from an Anime-Type of 'ova'
  local OVERRIDE=$(sed -n '5 p' < $RESTORE)

  # Retrieve the user's current color mode settings, and set the Here-Doc subshell with the same parameter; otherwise, we'll clash and get stuck in yellow
  local LAST_RGB=$`< $DIR_DET/../.rgb`

  # The current genshiken process that is using this specified color mode has a specific PID (I know I could of used the "$" variable ...).  What is it?
  local LAST_PID=${LAST_RGB//[a-z]*-/}
  local COLORIZE=${LAST_RGB//-[0-9]*/}
  COLORIZE=--colorize=${COLORIZE//\$/}

  # There's always a chance that the user chose no color settings; in which case, $COLORIZE is now blank ...
  [[ -z `ps x | grep ${LAST_PID/$/} | grep 'genshiken'` ]] && COLORIZE=

  # Set the location of Genshiken's Here Doc, which will be used to restore our previous session
  HERE_DOC=$TMPDIR/genshiken-$USER/.genshiken-here-doc.sh

  #  Determine if their are any other sessions that are the same type as the one we're restoring.  I need to know this, ==================================\
  #+ because if their are extra genshiken sessions of the same type available to the user, then genshiken will prompt them if they want to restore them.  |
  #  This design is based off of conveniance, so that way, a user can cycle through and know what animes they were watching in each one.  That's besides  |
  #+ the point though: This extra prompt means I'll need to add an extra newline to the Here Document down-below.                                         |
  #                                                                                                                                                       |
  #  NOTE: If your wondering why the number I'm checking for is 3, and not 2-- <<Here's why>>:                                                            |
  #                                                                                                                                                       |
  #+ o  1st-- Theirs our original session file, that genshiken created on SIGINT in order to save the users place, which we'll delete in a few more lines |
  #+ o  2nd-- Now there's this session, which the genshiken-here-doc-subshell is currently in and is a duplicate of the original session                  |
  #+ o  3rd-- Finally, if their are any extras, then the variable $SAME_TYPE should now equal 'true' =====================================================/
  [[ `find $DIR_DET/../ -name "previous-session-${MAIN//-/}-*" -type f -print | wc -l` -ge 3 ]] && SAME_TYPE=true

  #  These variables will be used to create our Here Document, that GNU Bash will send to Genshiken =============================\
  #+ in a subshell (the '--view' Option does not require all this work).  The 'Download/Stream' Options are virtually identical, |
  #+ so there's nothing to tweak.                                                                                                |
  #                                                                                                                              |
  #  NOTE: Those of you reading this may be wondering why I didn't just send a Here-Doc to the                                   |
  #+ Anime_Selection/Watch_Anime functions.  Simple answer: The below gives me more flexibility and                              |
  #+ was actually easier to debug for me.  If any of you can write a better routine, maybe feeding a Here                        |
  #+ Document to Anime_Selection/Watch_Anime instead of the main script, please by all means let me know ========================/
  if [[ $LAST_SESSION != '--view' ]]; then
    local last_category=$(sed -n '2 p' < $RESTORE | sed 's_.*\[\(.\).*_\1_')
    local last_anime=$(   sed -n '2 p' < $RESTORE | sed 's_.*+\(.*\):.*_\1_')
    local last_episode=$( sed -n '2 p' < $RESTORE | gawk -F+ '{ print $1 }')
    [[   $last_episode = 0 ]] && last_episode=1 # A safety pre-caution ...

    # Create a BACK-UP of the Restore file, just in case we suffer from internet connection Loss
    cp $RESTORE $RESTORE.backup

    #  Once we've restored the users' last session data into memory: Delete the 'RESTORE' file, so that we won't clash |
    #+ with the duplicate sessions routine in the 'Early_Termination' function.                                        |
    rm $RESTORE

    # The final piece of the puzzle, is to find out what the last category was, and then to set it as the same category for the Here Document |
    # NOTE: This is actually trickier then it looks, for not all Anime-Types will have an anime for each category (e.g. # - Z)                |
    for i in `ls -1 $DIR_DET/$LAST_ANIME_TYPE/series_* | gawk -F_ '{ print $2 }' | sed 's_.txt__' | grep -n '.*'`
    do
      if [[ ${last_category/^/1} = $(gawk -F: '{ print $2 }' <<< "$i") ]]; then
        local same_category=$[$(gawk -F: '{ print $1 }' <<< "$i")]
        break
      fi
    done
    {
      echo "export RESTORE=$RESTORE HERE_DOC=$HERE_DOC"
      echo "$0 $LAST_SESSION=${LAST_ANIME_TYPE} -f --impatient=${level} --base-dir=${OLD_BASE} --start-at=${last_episode} ${COLORIZE/$/} -p <<EOF"
      echo
      echo 'yes'
      echo
      # If there is a session file of the same type as this restore file, then we'll need to add an extra newline character to our Here-Doc
      [[ ! -z ${SAME_TYPE:-} && $SAME_TYPE = 'true' ]] && echo
      echo $same_category
      echo ${last_anime}
      echo ${LAST_SESSION:2:1} | sed -e 's/g/d/' -e 'y/ds/DS/'
      # If the user gave us the OVA OVERRIDE, then another line with a value of 'Y' is needed to deal with this prompt
      [[ ! -z ${OVERRIDE:-} ]] && echo Y
      echo Q
      echo EOF
      echo "rm $HERE_DOC"
      echo "sleep 2"
      echo "echo -e \"${N}${R}[${FUNCNAME[0]}] ${G}Finished ${M}${STYPE}ing $ANIME ${G}episodes...\"; sleep 2"
      echo "echo -e \"${N}${R}[${FUNCNAME[0]}] ${G}Exitting now...\"; sleep 2"
    } >  $HERE_DOC # Create Here Document
    bash $HERE_DOC # Execute it
    exit 0         # Restored Session Completed!

  # This is all I need to set-up the Here Document with the '--view' option (it's category based, but there's only 1 menu-- not 27)
  else
    local last_anime=$(  sed -n '2 p' < $RESTORE | gawk -F+ '{ print $1 }')
    local last_episode=$(sed -n '2 p' < $RESTORE | gawk -F+ '{ print $2 }')
    [[ $last_episode = 0 ]] && last_episode=1

    #  Once we've restored the users' last session data into memory: Delete the 'RESTORE' file, so that we won't clash |
    #+ with the duplicate sessions routine in the 'Early_Termination' function.                                        |
    rm $RESTORE
    {
      echo "export RESTORE=$RESTORE HERE_DOC=$HERE_DOC"
      echo "$0 $LAST_SESSION=${LAST_ANIME_TYPE} --impatient=${level} --base-dir=${OLD_BASE} --start-at=${last_episode} ${COLORIZE/$/} -p <<EOF"
      echo
      # If there is a session file of the same type as this restore file, then we'll need to add an extra newline character to our Here-Doc
      [[ ! -z ${SAME_TYPE:-} && $SAME_TYPE = 'true' ]] && echo
      echo $last_anime
      echo EOF
      echo "rm $HERE_DOC"
      echo "sleep 2"
      echo "echo -e \"${N}${R}[${FUNCNAME[0]}] ${G}Finished ${M}${STYPE}ing $ANIME ${G}episodes...\"; sleep 2"
      echo "echo -e \"${N}${R}[${FUNCNAME[0]}] ${G}Exitting now...\"; sleep 2"
    } >  $HERE_DOC # Create Here Document
    bash $HERE_DOC # Execute it
    exit 0         # Restored Session Completed!
  fi
}

# End:
# gfunc5-restore-previous-session.sh ends here
