# -*- shell-script -*-
# gfunc80000-anime-selection.sh -- Provide the user a method for downloading or streaming anime
# Copyright © 2015-2016 Michael Pagan
#
# Author: Michael Pagan
# E-Mail: michael.pagan@member.fsf.org
# Jabber: pegzmasta@member.fsf.org
#
# This file is part of Genshiken.
#
# Genshiken is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Genshiken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Genshiken. If not, see http://www.gnu.org/licenses/.
#===================================================================
function Anime_Selection
{
  # Algorithm for [Anime_Selection]: View a list of series; choose a series; select an anime from the series; finally, download/stream selection
  while [[ $? -lt 2 ]]
  do Series_Prompt; input=`< selection_`; rm selection_; Anime_Prompt $input $1; Download_Anime $1; [[ $PAGE != less ]] && echo

    # Ensure we reset the $START_AT variable, in case we loop again
    [[ ! -z ${LATEST:-} ]] && START_AT=latest

    #  If we are inside the genshiken here-doc, we will have reached this point                |
    #+ after finishing the last episode.  If that's the case, then the restored session is now |
    #+ complete, and the associated session file should now be removed.                        |
    if [[ -f $TMPDIR/genshiken-$USER/.genshiken-here-doc.sh ]]; then
      echo -e "${N}${R}[${FUNCNAME[0]}] ${G}Your restored session is now complete.  Removing associated session file... ${N} \b\b"
      [[ ! -z ${WAIT:-} && $WAIT -le 1 ]] && : || sleep 1
      [[ -f $DIR_DET/../previous-session-${MAIN//-/}-${$}-$RAND.log ]] && rm $DIR_DET/../previous-session-${MAIN//-/}-${$}-$RAND.log
      [[ -f $RESTORE.backup ]] && rm $RESTORE.backup
      read # This script is automated at this point, and doesn't need an interactive prompt like below; thus, 'read' stands alone
    else

      # We will remove this current session file, now that we're done with it
      [[ -f $DIR_DET/../previous-session-${MAIN//-/}-${$}-$RAND.log ]] && rm $DIR_DET/../previous-session-${MAIN//-/}-${$}-$RAND.log

      # Determine if the user would like to continue downloading/streaming anime
      echo -en "${N}${R}[${FUNCNAME[0]}] ${A}${G}Would you like to continue? (Y/*):${Y}   \b\b"; read
    fi
    # Remove the stream log if it exists
    [[ -f ${STREAM_LOG:-} ]] && rm $STREAM_LOG

    # Either continue to the [Series_Prompt], or exit this script
    case $(sed 'y/y/Y/' <<< $REPLY) in
      Y)
         cd $DIR_DET/$1
         Clean_Up directory
         if [[ ! -z ${STREAM:-} ]]
         then [[ -d $DIR_DET/../stream ]] && rm -r $DIR_DET/../stream/*
         else { cd $DIR_ANIM/$1 && Clean_Up hierarchy; cd - 1> /dev/null; }
         fi
         continue
      ;;
      *)
         if [[ ! -z ${STREAM:-} ]]
         then
           [[ -d $DIR_DET/../stream ]] && { rm -r $DIR_DET/../stream/* 2> /dev/null; rmdir $DIR_DET/../stream; }
         else
           cd $DIR_ANIM/$1 && Clean_Up hierarchy; cd - 1> /dev/null
         fi
         [[ -f $DIR_DET/../last_choice.log ]] && rm $DIR_DET/../last_choice.log
         exit 0
      ;;
    esac
  done
}

# End:
# gfunc80000-anime-selection.sh ends here
