# -*- shell-script -*-
# gfunc81100-view-series-list.sh -- View the extracted list of series (I know I could of used the 'select' function, but that was before I learned 'gawk')
# Copyright © 2015-2016 Michael Pagan
#
# Author: Michael Pagan
# E-Mail: michael.pagan@member.fsf.org
# Jabber: pegzmasta@member.fsf.org
#
# This file is part of Genshiken.
#
# Genshiken is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Genshiken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Genshiken. If not, see http://www.gnu.org/licenses/.
#===================================================================
function View_Series_List
{
  if [[ ! -z `ls -1 series_* 2> /dev/null` ]]; then
    echo -e "\n${N}${R}[${FUNCNAME[0]}] ${G}F.Y.I.-- At the below  ${N}${R}[${FUNCNAME[1]}]${G}: Q=[${M}Q${G}]uit ${N}"
    echo -e "${N}${R}[${FUNCNAME[0]}] ${G}Which series of anime would you like to view?${Y}   \b\b\n"; ls -1 series_* | sed 's_.txt__' |\
    gawk 'BEGIN { print "RW-#\t SERIES\n----\t --------"}; { if (NR>9) { print "  "NR, "\t", $1 } else { print "   "NR, "\t", $1 }; }'
  else
    echo -e "${N}${R}[${FUNCNAME[0]}] ${G}An Interruption occured during ${R}[Extract_Series_List]${G}.  Menus can't be created without a complete list. ${N}"
    exit 9
  fi
}

# End:
# gfunc81100-view-series-list.sh ends here
