# -*- shell-script -*-
# gfunc82100-selection-io.sh -- Provide input/output for retrieving & viewing the selected series
# Copyright © 2015-2016 Michael Pagan
#
# Author: Michael Pagan
# E-Mail: michael.pagan@member.fsf.org
# Jabber: pegzmasta@member.fsf.org
#
# This file is part of Genshiken.
#
# Genshiken is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Genshiken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Genshiken. If not, see http://www.gnu.org/licenses/.
#===================================================================
function Selection_IO
{
  # This hack attempts to fix a small bug with the '--no-pager' option that decrements the input by 1 after the first attempt.
  if [[ ! -f .PAGE_BUG ]]
  then input=$(sed y/adqv/ADQV/ <<< $1); : > .PAGE_BUG
  else [[ $PAGE != less ]] && input=$(expr $(sed y/adqv/ADQV/ <<< $1) '+' 1)
  fi
  # Another hack: The $input should always be a number, hence parameter 1 resolves to the correct value |
  # NOTE: This occurs when entering the 'Re[V]iew' option                                               |
  [[ -n `grep '[A-Z]' <<< $input` || $input= ]] && input=$1

  # Determine the selected anime series
  selected_series=$(ls -l | egrep -v '_$|^d|total' | gawk '{ print $9 }' | grep -n 'series_' | grep "^$input:" | gawk -F: '{ print $2 }')
  View_Anime_List $selected_series; echo; Clean_Up directory
  echo -en "${N}${R}[${FUNCNAME[0]}] ${G}Enter the number of the Anime of your choice, or a different option:${Y}   \b\b"; read

  # Delete leftover files in order to prevent overwrite errors!
  find . -maxdepth 1 -name '*_' -exec rm {} +

  # Output our selection to the filesystem
  tee <<< $(sed y/adqv/ADQV/ <<< $REPLY) > input_ anime_num_; echo $selected_series > selected_series_; [[ $PAGE != less ]] && echo
}

# End:
# gfunc82100-selection-io.sh ends here
