# -*- shell-script -*-
# gfunc83140-retrieve-video-link.sh -- Determine the actual URL for the current video that we're about to download
# Copyright © 2015-2016 Michael Pagan
#
# Author: Michael Pagan
# E-Mail: michael.pagan@member.fsf.org
# Jabber: pegzmasta@member.fsf.org
#
# This file is part of Genshiken.
#
# Genshiken is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Genshiken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Genshiken. If not, see http://www.gnu.org/licenses/.
#===================================================================
function Retrieve_Video_Link
{
  for (( j=$1; j<=$2; j++ )); do

    # Determine if we are using a python-parsable domain, and if so, use `youtube-dl' to extract the upload path
    [[ ! -z ${python_domain:-} ]] && { declare -g upload_path[$j]=$($extract "${server_path[$j]}") && continue; }

    # Download the webpage containing the upload path (requires sending confirm data to a text form on the server)
    echo -e "${N}${R}[${FUNCNAME[0]}] ${G}Downloading the Video Server Webpage for HTML parsing ...\n${Y}   \b\b"
    [[ -f episode-$j ]] && rm episode-$j
    curl --keepalive-time 20 --globoff -d 'confirm=Click%20Here%20to%20Watch%20Free!!' "${server_path[$j]}" | sed 's/\r$//' &> episode-$j

    # Extract the location of the file on the server
    declare -g upload_path[$j]=$(grep 'flashvars' episode-$j |\
                                 sed -e "s_.*\(flashvars='.*'\).*_\1_" -e 's_.*file=.*;image=.*;file=\(.*\)&.*_\1_' |\
                                 eval $BROWSER_READABLE) &> /dev/null

    # Check to see if `jwplayer' is being used, instead of the default (back-up links may be available here)
    [[ -z ${upload_path[$j]:-} ]] &&
    {
      [[ ! -z $(grep 'jwplayer' episode-$j) ]] &&
      {
        declare -g upload_path[$j]=$(grep 'file:[ ]' episode-$j | sed -e 's_.*file:."\(.*\)".*_\1_' |\
                                     eval $BROWSER_READABLE | sed -n '$ p') &> /dev/null
      }
    } ||
    {
      # Genshiken now supports `Veoh' and `Dailymotion' videos
      case $selected_domain in
        www.dailymotion.com)
          #  `Dailymotion' is much trickier than `Veoh', plus there are a possibility of 8 videos   |
          #+ (i.e. resolutions including: 480p, 380p, 240p, 144p, and back-up videos for each one). |
          #                                                                                         |
          #  NOTE: I will attempt to find the highest quality video available ======================/
          video_id=$(echo "${server_path[$j]}" | sed 's_.*/swf/\(.*\)_\1_')
	  for resolution in {480,380,240,144}
          do
            upload_path[$j]=$(curl $(curl http://$selected_domain/player/metadata/video/$video_id 2> /dev/null |\
                                     sed -e 's|.*stream_chromecast_url...\(.*\)","partner.*|\1|; s/\\//g;') 2> /dev/null |\
                              sed -n "/NAME=.$resolution./ { n; p }" | sed 's/#cell.*//' | sed -n '1 p')
            [[ -n ${upload_path[$j]:-} ]] && break
          done
        ;;
        www.veoh.com)
          video_id=$(echo "${server_path[$j]}" | sed 's_.*permalinkId=\(.*\)_\1_')
          upload_path[$j]=$(curl http://$selected_domain/m/watch.php?v=$video_id 2> /dev/null |\
                            sed -n '/example_video_1/ { n; p }' | sed 's_.*src=.\(.*\)..type.*_\1_')
        ;;
        *) # All workarounds will be placed here for the time being...
          :
        ;;
      esac
    }
    # Ensure that if we capture more than one link, to only take the first one
    upload_path[$j]=$(sed -n '1 p' <<< "${upload_path[$j]}")
    
    # Append the file extension to the name of the episode ('flv' is expected, but may not be the case)
    episode_name[$j]=${episode_name[$j]}.$(sed -e 's_.*\.\(.*\)_\1_' -e 's/?.*//' <<< ${upload_path[$j]})
    echo -e "\n${N}${R}[${FUNCNAME[0]}] ${G}Finished parsing the HTML; ${M}$TYPE ${G}Episode [${M}${episode_name[$j]}${G}] Upload Path: Captured! ${N}"
  done
}

# End:
# gfunc83140-retrieve-video-link.sh ends here
