# -*- shell-script -*-
# gfunc83150-next-episode.sh -- Download the next episode [Single/Group]
# Copyright © 2015-2016 Michael Pagan
#
# Author: Michael Pagan
# E-Mail: michael.pagan@member.fsf.org
# Jabber: pegzmasta@member.fsf.org
#
# This file is part of Genshiken.
#
# Genshiken is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Genshiken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Genshiken. If not, see http://www.gnu.org/licenses/.
#===================================================================
function Next_Episode
{
  Size_Analysis $4 $5 --head # Let's tell the user how big the file is before we download it

  # Let's save the users' current anime of choice in a log file for processing later on                                           |
  # NOTE: I will also ensure that if the base directory is different than the default, that it gets added to the log file as well |
  [[ ! -f $DIR_DET/../previous-session-${MAIN//-/}-${$}-$RAND.log ]] &&
  echo "$(echo $title; echo $(< $DIR_DET/../last_choice.log); echo $MAIN $BASE_DIR)" > $DIR_DET/../previous-session-${MAIN//-/}-${$}-$RAND.log

  # Download the episode, and inform the user what type it is and where it's coming from
  echo -e "\n${N}${R}[${FUNCNAME[0]}] ${M}${Streaming:-Downloading} $1 ${G}from web-link ${M}$2${G} of ${M}$3 $stream_into${Y}   \b\b"
  Download_File $4 $5; [[ -f .last_video ]] && rm .last_video
}

# End:
# gfunc83150-next-episode.sh ends here
