/**************************************************************************
 * CommOpt - Functions for the make of the options of the command line. 
 * Version:     0.3.7 20/02/2006
 * File:        CommOpt.h
 * Description: Functions for the reading, verification, execution of the 
 *              options of the command line. 
 * Platform(s):	GNU/Linux, All
 * Author(s):	Della Bianca Giuseppe <bepi@adria.it><bepii@libero.it>
 *
 * Copyright (C) 2002-6 Della Bianca Giuseppe <bepi@adria.it><bepii@libero.it>
 * This file is part of GesConf.
 *
 * GesConf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * GesConf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GesConf; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 **************************************************************************/
#ifndef _COMMOPT_H
#define _COMMOPT_H

#include "global.h"

struct _OptData{
  int ID;            // option ID
  char *opt;
  char *LargeOpt;
  char *des;
  int MinNPar;       // number of parameters demands from the option
  int MaxNPar;       // max number of parameters demands from the option
  int nice;          // elaboration priority
};

struct _OptImp{
  int OptArgN;       // number of the argument of the option
  int ParArgN;       // number of the argument of the parameter
  char *OptArg;      // pointer at the start of the option in the argument
  char *ParArg;      // pointer at the start of the parameter in the argument
  int OptLen;        // lenght of the option in the argument
  char *opt;         // option
  int OptNum;        // number of the option (in option data list)
  int MinNPar;       // number of parameters of the option
  int MaxNPar;       // max number of parameters of the option
  int NumPar;        // real number of parameters of the option
  int nice;          // priority (if is < 0 is a parameter not legacy to one option)
  int ID;            // ID of the option (if is < 0 is not option)
};

typedef int (* _ExeCheckOpt)(int OptLNum, int StepNum);
typedef int (* _ExeOpt)(int OptLNum);

struct _CommPar{
  char **argv;
  int argc;
  int MultOptDisab;                 // disable multiple option (ex. -vi is -v -i)
  struct _OptData *OptData;         // list of managed command line options
  struct _OptImp ListOpt[MAXNOPT];  // result of parsing of the command line options
  int NiceOptL[MAXNOPT];            // order of processing the list of the options
  int NumOptL;                      // number of the option in the list of the options
  _ExeCheckOpt pfExeCheckOpt;       // callback function for the check of option
  _ExeOpt pfExeOpt;                 // callback function for the execute of option
};

int CoExeOpts ();
int CoReadOpts ();
void CoPrintOpts ();
void CoUpdArg (struct _OptImp *ArgOptL, char *arg);
void CoInit ();

#ifdef _CO_PRIVATE_H

static int ParsArgv ();
static int OptLFromArg (struct _OptImp *ArgOptL, struct _OptImp *RealOptL, char *OptArg, int *StartOpt, int *UpdArg);
static void OptLFromData (struct _OptImp *ActOptL, int OptNum, int LargeOpt);
static int GetOpt (char *arg, int *StartOpt, int *LargeOpt);
static int CheckOpt (int OptLNum);
static int OptLCmp (const int *val1, const int *val2);

#endif // _CO_PRIVATE_H

#endif // _COMMOPT_H
