/**************************************************************************
 * FileConf - Functions for the make of the options of the command line. 
 * Version:     0.3.7 06/02/2006
 * File:        FileConf.h
 * Description: Functions for the reading, verification, execution of the 
 *              options of the command line. 
 * Platform(s):	GNU/Linux, All
 * Author(s):	Della Bianca Giuseppe <bepi@adria.it><bepii@libero.it>
 *
 * Copyright (C) 2002-6 Della Bianca Giuseppe <bepi@adria.it><bepii@libero.it>
 * This file is part of GesConf.
 *
 * GesConf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * GesConf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GesConf; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 **************************************************************************/
#ifndef _FILECONF_H
#define _FILECONF_H

#include <limits.h>
#include "global.h"

#define LENGKV  100                    // len group/key/value
#define LLENGKV 2000                   // len long group/key/value
#define LENSSTAT 3                     // max len status

#define ISGRP(a)(a == 'G' || a == 'g' || a == 'E')
#define ISKEY(a)(a == 'K' || a == 'k')

struct _StatRow{
  char type;
  char lock;
  char edit;
};

typedef void (* _ExeConfVal)(char *group, char *key, char *val, struct _StatRow *stat, char *OneKeyType);

struct _ConfPar{
  char FileType[LENSTR + 1];   // type of configuration file
  char ConfFile[PATH_MAX + 1]; // configuration file
  char WarnType[LENSTR + 1];   // type of warning
  char ParSep[LENSTR + 1];     // parameters separator
  char ValSep[LENSTR + 1];     // values separator
  int OneKeyEnab;              // one value from multiple key
  char VerbLev[LENSTR + 1];    // verbosity level
  _ExeConfVal pfExeConfVal;    // callback function for configuration value
};

int FcListConf (char *group, char *key, char *val, char *WStat);
int FcGetConf (char *GrpIn, char *KeyIn, char *ValKeyIn, char *val, char *WStat);
int FcSetConf (char *GrpIn, char *KeyIn, char *ValKeyIn, char *ValIn);
int FcDelConf (char *GrpIn, char *KeyIn, char *ValKeyIn, char *DelType);
int FcConfToComm (char *GrpIn, char *KeyIn, char *ValKeyIn);
int FcSetLockConf (char *GrpIn, char *KeyIn, char *ValKeyIn, char *lock);
int FcReadFile ();
int FcWriteFile ();
void FcStatFromRStat (char *WStat, struct _StatRow *stat);
void FcInit ();

#ifdef _FC_PRIVATE_H


#define MAX_NCONFROWS 1000             // max num conf rows
#define NUMTXTROW MAX_NCONFROWS * 2    // num text rows
#define NUMLTXTROW MAX_NCONFROWS / 25  // num long text rows

#define STYPE 0                        // type of row (I, G, K, g, k, E)
#define SLOCK 1                        // lock of group/key (U, L)
#define SEDIT 2                        // edit of key (U, M, A, D, C)

#define GRPSEP ":"
#define NICETYPE "GIKgkE"

#define OKSTYPE(a, b)(b->type == ' ' || b->type == a)
#define OKSLOCK(a, b)(b->lock == ' ' || b->lock == a)
#define OKSEDIT(a, b)(b->edit == '*' || (b->edit == ' ' && a != 'D' && a != 'C') || b->edit == a)

#define ISTFILE(a)(!strcmp (ConfPar.FileType, a))

#define ISKEYTOGRP(a) (ISTFILE("XFREE") && (!strcmp (a, "Identifier") || !strcmp (a, "Depth")))

struct _ConfRow{
  char *WorkGrp;
  char *RealGrp;
  char *key;
  char *val;
  char *comm;
  struct _StatRow stat;
  int RowIniGrp;
  int RowUpGrp;
  int RowEndGrp;
};

struct _FcRows{
  char text[NUMTXTROW][LENGKV + 1];
  char LongText[NUMLTXTROW][LLENGKV + 1];
// don't use conf and SortConf directly, only group initial ( G ) is forever updated
  struct _ConfRow conf[MAX_NCONFROWS];
  struct _ConfRow *SortConf[MAX_NCONFROWS];
  int NumText;
  int NumLongText;
  int NumConf;
};

static int OneValFromMultiKey (struct _ConfRow *ActSRow, struct _ConfRow *OldSRow, char *OneKeyType);
static int ScanRowConf (char *group, char *key, char *val, struct _StatRow *stat, char *OneKeyType);
static int GetKeyVal (char *GrpIn, char *KeyIn, char *ValKeyIn, char *val, struct _StatRow *stat);
static int SetKeyVal (char *GrpIn, char *KeyIn, char *ValKeyIn, char *ValIn);
static int DelGrpKey (char *GrpIn, char *KeyIn, char *ValKeyIn, char *DelType);
static int SetKeyToComm (char *GrpIn, char *KeyIn, char *ValKeyIn);
static int SetLockGrpKey (char *GrpIn, char *KeyIn, char *ValKeyIn, char *lock, int modify);
static int InsGrpKey (char *grp, char *key, char *val, struct _StatRow *stat, int RowNIns);
static int EditRow (struct _ConfRow *ActCRow, char *val, char *edit, int SetVal);
static int CheckGrpKey (char *group, char *key, char *ValKey, char *val, char *AbilType, 
			struct _StatRow *stat, int *RowNGrp, int *RowNKey, int *RowNIns);
static void FindGrpKey (char *group, char *key, char *ValKey, struct _StatRow *stat, 
			int *RowNGrp, int *RowNKey);
static int IsFindGroup (char *group, struct _StatRow *stat, struct _ConfRow *ActCRow, char *FindType);
static int IsFindKey (char *group, char *key, char *ValKey, struct _StatRow *stat, 
		      struct _ConfRow *ActCRow, char *FindType);
static int IsSameGroup (char *group, char *InGrp);
static int ConfRCmp (const struct _ConfRow **ConfR1, const struct _ConfRow **ConfR2);
static int GrpCmp (char *group1, char *group2);
static void GetPartGrp (char *GrpIn, char *PartGrp, char *PartType);
static struct _ConfRow *RowFc (int ConfNum);
static struct _ConfRow *RowSortFc (int SortRNum);
static void UpdateRowFc (struct _ConfRow *ActCRow);
static void SortConf ();
static int ReadFile (char *file);
static int WriteFile (char *file);
static int FileToConf (char *RowIn, char *grp, char *key, char *val, char *comm,
		       struct _StatRow *stat, char *IniGrp, char *IniRGrp);
static int ConfToFile (char *RowOut, int FormAbil, struct _ConfRow *ActCRow, struct _ConfRow *OldDRow, int *write);
static int WithDelimRow (char *grp, char *key, char *val, struct _StatRow *stat);
static int AddTextConf (char *TextIn, char **TextAdd, int EnabLong);
static void WStatToRStat (char *WStat, struct _StatRow *stat);
static void WStatFromRStat (char *WStat, struct _StatRow *stat);
static void InitConf (char *tipo);

#endif // _FC_PRIVATE_H

#endif // _FILECONF_H
