/**************************************************************************
 * BaseString - Functions base of elaborations of the string. 
 * Version:     0.3.7 05/02/2006
 * File:        ErrLog.h
 * Description: Error Log. 
 * Platform(s):	GNU/Linux, All
 * Author(s):	Della Bianca Giuseppe <bepi@adria.it><bepii@libero.it>
 *
 * Copyright (C) 2002-6 Della Bianca Giuseppe <bepi@adria.it><bepii@libero.it>
 * This file is part of GesConf.
 *
 * GesConf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * GesConf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GesConf; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 **************************************************************************/
#ifndef _ERRLOG_H
#define _ERRLOG_H

#include "global.h"

struct _ErrPar{
  int NumErr;                  // number of errors
  int StdPrint;                // only print error in stderr
  char VerbLev[LENSTR + 1];    // verbosity level
};

void ElAddErr1 (int IDErr, char *TypeErr, char *format, char *par1);
void ElAddErr2 (int IDErr, char *TypeErr, char *format, char *par1, char *par2);
void ElAddErr (int IDErr, char *TypeErr, char *format, char *par1, char *par2, char *par3);
void ElPrintErrs ();
void ElInit ();

#ifdef _EL_PRIVATE_H

struct _ErrRow{
  int ID;                      // ID of error
  char type[LENSTR + 1];       // type of error
  char text[LLENSTR + 1];
};

static void AddErr (int IDErr, char *TypeErr, char *format, char *par1, char *par2, char *par3);
static void PrintErr (char *IDMsg, int IDErr, char *TypeErr, char *TxtErr);

#endif // _EL_PRIVATE_H

#endif // _ERRLOG_H
