/**************************************************************************
 * GesConf - Management configuration file.
 * Version:     0.3.8 13/10/2007
 * File:        GesConf.c
 * Description: It manages the configuration file.
 * Error:       ID file 101, last number 04
 * Platform(s):	GNU/Linux, All
 * Author(s):	Della Bianca Giuseppe <bepi@adria.it><bepii@libero.it>
 * Credits: For LC_MESSAGE support, Francesco Romani <rontani@freemail.it>
 *
 * Copyright (C) 2002-6 Della Bianca Giuseppe <bepi@adria.it><bepii@libero.it>
 * This file is part of GesConf.
 *
 * GesConf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * GesConf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GesConf; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 **************************************************************************/
#include <string.h>
#include <locale.h>
#include "config.h"
#include "ErrLog.h"
#include "BaseString.h"
#include "file.h"
#include "CommOpt.h"
#include "FileConf.h"
#include "GesConf.h"
#include "global.h"         // parameters of GesConf
#include "descr.h"          // parameters of GesConf

// the GesConf command line options
// ID,  opt,   LongOpt,       des,    MinPar, MaxPar, nice 
struct _OptData GcOptData[]= {
  {  1, "-",  "",             DESSTD,       0, 0, 2 },
  { 17, "vs", "val-sep",      DESVALSEP,    1, 0, 3 },
  {  2, "v",  "verbose",      DESVERB,      1, 0, 5 },
  {  5, "fx", "file-xfree",   DESFILEXFREE, 1, 0, 3 },
  {  4, "fm", "file-multi",   DESFILEMULTI, 1, 0, 3 },
  {  3, "f",  "file",         DESFILE,      1, 0, 3 },
  {  6, "w",  "err-warn",     DESERRWARN,   0, 0, 4 },
  {  7, "i",  "err-ignore",   DESERRIGNO,   0, 0, 4 },
  {  8, "o",  "err-force",    DESERRFORCE,  0, 0, 4 },
  { 15, "lk", "lock",         DESLOCK,      3, 4, 0 },
  {  9, "l",  "list",         DESLIST,      0, 4, 0 },
  { 10, "g",  "get",          DESGET,       2, 3, 0 },
  { 14, "sc", "set-comm",     DESSETCOMM,   2, 3, 0 },
  { 11, "s",  "set",          DESSET,       3, 4, 0 },
  { 13, "dc", "del-comm",     DESDELCOMM,   2, 0, 0 },
  { 12, "d",  "delete",       DESDELETE,    1, 3, 0 },
  { 16, "ps", "par-sep",      DESPARSEP,    1, 0, 3 },
  { 18, "h",  "help",         "help",       0, 0, 1 },
  {  0, "",   "",             "",           0, 0, 0 }
};

// variable for the management of the error
extern struct _ErrPar ErrPar;
// variable for the management of the command line options
extern struct _CommPar CommPar;
// variable for the management of the configuration file
extern struct _ConfPar ConfPar;
// variable for the management of the stdin option
static int FromStdin;
static int HeadEnab;

/**************************************************************************
 * Function: main
 * Details:  Reads the command option and/or the stdin parameters, 
 *           elaborates the options, manage the configuration file. 
 * Returns:  0= ok
 **************************************************************************/
int main(int argc, char *argv[]){
  
  int result;

// internationalization
#if defined(HAVE_SETLOCALE)
  setlocale (LC_ALL, "");
#endif
  bindtextdomain (PACKAGE, LOCALEDIR);
  textdomain (PACKAGE);
// initialize
  ElInit();
  CoInit();
  FcInit();
  ErrPar.StdPrint= false;
  CommPar.argv= argv;
  CommPar.argc= argc;
  CommPar.OptData= GcOptData;
  CommPar.pfExeCheckOpt= CheckOpt; 
  CommPar.pfExeOpt= ExeOpt;
  ConfPar.pfExeConfVal= PrintGrpKey;
  FromStdin= false;
  HeadEnab= true;
// reads the options and executes to them
// make the options of the command line 
  if (result= argc > 1){
    result= CoReadOpts ();
    if (result)
      result= CoExeOpts ();
  }
  else
    ElAddErr1 (10101, "BO", _("Invalid options, -h for the help"), "");
// write in the configuration file the new values 
  if (result)
      result= FcWriteFile ();
// prints the messages of error 
  ElPrintErrs();

  if (*ConfPar.VerbLev == '4')
    printf (_("%soutcome: %s\n"), IDMSG, result ? "OK" : "KO");

  return (result ? 0 : 1);
} // main

/**************************************************************************
 * Function: CheckOpt
 * Details:  Check the option.
 * Returns: 
 **************************************************************************/
static int CheckOpt (int OptLNum, int StepNum){

  int result= true;
  char IniMess[LENSTR + 1], *opt;
  struct _OptImp *ActOptL;

  ActOptL= &CommPar.ListOpt[OptLNum];
  opt= ActOptL->OptArg;
  cutparstr (IniMess, LENSTR, _("Option <%s>"), opt, "", "");
  
  switch (ActOptL->ID){
  case 1:
    FromStdin= true;
    break;
  case 2:
    if (ActOptL->NumPar > 0){
      ConfPar.VerbLev[0]= ErrPar.VerbLev[0]= CommPar.ListOpt[OptLNum].ParArg[0];
      ConfPar.VerbLev[1]= ErrPar.VerbLev[1]= '\0';
    }
    break;
  case 9:
  case 10:
  case 11:
  case 12:
  case 13:
  case 14:
  case 15:
// step 1 is before the verification of the sintax of the options
    if (FromStdin && StepNum == 1 && ActOptL->NumPar < ActOptL->MinNPar){
// read the parameters from the stdin only for one option
      FromStdin= false;
// the number the arguments of the command line is 0
      ActOptL->MinNPar= -1;
    }
    break;
  default:
// step 1 is before the verification of the sintax of the options
    if (StepNum != 1){
      if (ActOptL->ID < 2 || ActOptL->ID > 18){
	result= false;
	ElAddErr1 (10102, "BO", _("%s : Not active"), IniMess);
      }
    }
    break;
  } // switch (ActOptL->ID)

  return (result);
} // CheckOpt

/**************************************************************************
 * Function: ExeOpt
 * Details:  Execute the option.  
 * Returns: 
 **************************************************************************/
static int ExeOpt (int OptLNum){

  int result= true;
  struct _OptImp *ActOptL;

  ActOptL= &CommPar.ListOpt[OptLNum];
// set the number of required parameters for option from the stdin
  if (FromStdin && ActOptL->MinNPar < 0)
    ActOptL->MinNPar= CommPar.OptData[ActOptL->OptNum].MinNPar;

// execute the option with the parameters of the stdin
  if (FromStdin && ActOptL->NumPar < ActOptL->MinNPar)
    result= ExeOptStdin (ActOptL);
  else
// execute the option with the arguments of the command line
    result= RunOpt (OptLNum, CommPar.ListOpt);

  return (result);
} // ExeOpt

/**************************************************************************
 * Function: ExeOptStdin
 * Details:  Execute the option of the stdin.
 * Returns: 
 **************************************************************************/
static int ExeOptStdin (struct _OptImp *ActOptL){

  int result= true, OptNumPar, ParNum, NumPar;
  char sep[LENSTR + 1], StatFile[LENSTR + 1], row[MAXLENROWS + 1];
  char par[MAX_NUMPAR][MAXLENROWS + 1], *pPar[MAX_NUMPAR];
  char str[LENSTR + 1], *pRow;
  struct _OptImp ListOptStdin[MAX_NUMPAR + 1];
  FILE *FFile;

  ListOptStdin[0]= *ActOptL;
  ActOptL= &ListOptStdin[0];
// execute the option with the parameters reading from of the stdin
  OptNumPar= (ActOptL->MaxNPar > ActOptL->MinNPar) ? ActOptL->MaxNPar : ActOptL->MinNPar;
  if (result= OptNumPar <= MAX_NUMPAR){
    FromStdin= false;
// set parameters of the option with the parameters reading from of the stdin
    for (ParNum= 0; ParNum < MAX_NUMPAR; ParNum++)
      ListOptStdin[ParNum].ParArg= pPar[ParNum]= par[ParNum];
// read from stdin the parameters of the the option 
    strcpy (sep, *ConfPar.ParSep == '\0' ? " " : ConfPar.ParSep);
    FFile= stdin;
    strcpy (StatFile, "INI");
    result= ReadRowFile (&FFile, "", StatFile, row);
    while (result && strcmp (StatFile, "END")){
      result= ReadRowFile (&FFile, "", StatFile, row);
      if (result && strcmp (StatFile, "END")){
// only for test
//      strcpy (row, "VIDEO mode");
	pRow= row;
	NumPar= OptNumPar;
	if (result= ParamsFromRow (&pRow, pPar, sep, 0, &NumPar, MAXLENROWS)){
	  ActOptL->NumPar= NumPar;
	  if (result= ActOptL->NumPar >= ActOptL->MinNPar)
// execute the option with the parameters of the stdin
	    result= RunOpt (0, ListOptStdin);
	  else{
	    sprintf(str, "%d", ActOptL->MinNPar);
	    ElAddErr1 (10103, "BV", _("The number of the parameters from stdin is less of %s"), str);
	  }
	}
      } // if (result && strcmp (StatFile, "END"))
    } // while (result && strcmp (StatFile, "END"))
    strcpy (StatFile, "END");
    if (!(ReadRowFile (&FFile, "", StatFile, row)))
      result= false;
  } // if (result= OptNumPar <= MAX_NUMPAR)
  else{
    sprintf(str, "%d", MAX_NUMPAR);
    ElAddErr1 (10104, "BV", _("The number of the parameters must get from stdin exceedes %s"), str);
  }

  return (result);
} // ExeOptStdin

/**************************************************************************
 * Function: RunOpt
 * Details:  Active the command required of the option.  
 * Returns: 
 **************************************************************************/
static int RunOpt (int OptLNum, struct _OptImp *ActListOpt){

  int result= true;
  char ActGrp[LENGKV + 1], ActKey[LENGKV + 1], ActValKey[LLENGKV + 1];
  char ActVal[LLENGKV + 1], ActStat[LENSSTAT + 1];
  struct _OptImp *ActOptL;
  struct _StatRow RStat;

  *ActGrp= *ActKey= *ActValKey= *ActVal= *ActStat= '\0';
 
  ActOptL= &ActListOpt[OptLNum];
// set the option parameters
  switch (ActOptL->ID){
  case 3:
    if (*ConfPar.FileType == '\0')
      strcpy (ConfPar.FileType, "ONEGRP");
  case 4:
    if (*ConfPar.FileType == '\0')
      strcpy (ConfPar.FileType, "MULTIGRP");
  case 5:
    if (*ConfPar.FileType == '\0')
      strcpy (ConfPar.FileType, "XFREE");
    result= strcpyV (ConfPar.ConfFile, ActOptL->ParArg, PATH_MAX);
    break;
  case 9:  // list
  case 10: // get
  case 11: // set
  case 12: // delete
  case 13:
  case 14:
  case 15:
    if (ActOptL->NumPar >= 1)
      result= strcpyV (ActGrp, ActOptL->ParArg, LENGKV);
    if (ActOptL->NumPar >= 2){
      if (ActOptL->ID == 13)
	result= result && strcpyV (ActValKey, ActOptL[1].ParArg, LLENGKV);
      else
	result= result && strcpyV (ActKey, ActOptL[1].ParArg, LENGKV);
    }
    if (ActOptL->NumPar >= 3){
      if ((ActOptL->ID == 15 || ActOptL->ID == 9) && ActOptL->NumPar == 3)
	result= result && strcpyV (ActStat, ActOptL[2].ParArg, LENSSTAT);
      else if (ActOptL->ID == 11 && ActOptL->NumPar == 3)
	result= result && strcpyV (ActVal, ActOptL[2].ParArg, LLENGKV);
      else
	result= result && strcpyV (ActValKey, ActOptL[2].ParArg, LLENGKV);
    }
    if (ActOptL->NumPar >= 4){
      if (ActOptL->ID == 9 || ActOptL->ID == 15)
	result= result && strcpyV (ActStat, ActOptL[3].ParArg, LENSSTAT);
      else
	result= result && strcpyV (ActVal, ActOptL[3].ParArg, LLENGKV);
    }
    break;
  }
// execute the command
  switch (ActOptL->ID){
  case 1:
    FromStdin= true;
    break;
  case 3:
  case 4:
  case 5:
    if (result)
      result= FcReadFile ();
    break;
  case 6:
    strcpy (ConfPar.WarnType, "W");
    break;
  case 7:
    strcpy (ConfPar.WarnType, "I");
    break;
  case 8:
    strcpy (ConfPar.WarnType, "O");
    break;
  case 9: // list
    if (result)
      result= FcListConf (ActGrp, ActKey, ActValKey, ActStat);
    break;
  case 10: // get
    if (result)
      result= FcGetConf (ActGrp, ActKey, ActValKey, ActVal, ActStat);
    break;
  case 11: // set
    if (result)
      result= FcSetConf (ActGrp, ActKey, ActValKey, ActVal);
    break;
  case 12: // delete
    if (result)
      result= FcDelConf (ActGrp, ActKey, ActValKey, "");
    break;
  case 13: // del-comm
    if (result)
      result= FcDelConf (ActGrp, "", ActValKey, "DELCOMM");
    break;
  case 14:
    if (result)
      result= FcConfToComm (ActGrp, ActKey, ActValKey);
    break;
  case 15:
    if (result)
      result= FcSetLockConf (ActGrp, ActKey, ActValKey, ActStat);
    break;
  case 16: // print-sep
    result= strcpyV (ConfPar.ParSep, ActOptL->ParArg, LENSTR);
    break;
  case 17: // val-sep
    result= strcpyV (ConfPar.ValSep, ActOptL->ParArg, LENSTR);
    ConfPar.OneKeyEnab= true;
    break;
  case 18:
    CoPrintOpts ();
    break;
  } // switch (ActOptL->ID)
  
  return (result);
} // RunOpt

/**************************************************************************
 * Function: PrintGrpKey
 * Details:  Print the group, key e value
 * Returns: 
 **************************************************************************/
#define IFDEL(a)((*a == '\0' || strstr(a, " ") != NULL) && *ConfPar.ParSep == '\0' && *ConfPar.VerbLev != '1')

static void PrintGrpKey (char *group, char *key, char *val, struct _StatRow *stat, char *OneKeyType){

  char ActGrp[LENGKV + 2 + 1], ActKey[LENGKV + 2 + 1], ActVal[LLENGKV + 2 + 1];
  char WStat[LENSSTAT + 1];

  PrintHead ();
  *ActGrp= *ActKey= *ActVal= '\0';
  FcStatFromRStat (WStat, stat);

  sprintf (ActGrp, IFDEL(group) ? "\"%s\"" : "%s", group);
  sprintf (ActKey, IFDEL(key) ? "\"%s\"" : "%s", key);
  sprintf (ActVal, IFDEL(val) ? "\"%s\"" : "%s", val);
 
// shift the column to print
  if (*ConfPar.VerbLev == '4' || *ConfPar.VerbLev == '3')
// nop
    *ConfPar.VerbLev= *ConfPar.VerbLev;
  else if (*ConfPar.VerbLev == '2'){
    if (ISGRP(stat->type))
      strcpy (ActKey, ActGrp);
  }
  else{
    if (ISGRP(stat->type))
      strcpy (ActVal, ActGrp);
  }

// only if default separator print row with '"' delimitator and with space separator
  if (*ConfPar.ParSep == '\0'){
    if (*ConfPar.VerbLev == '4' || *ConfPar.VerbLev == '3')
      printf ("%-*s %-10s %-10s %s\n", LENSSTAT, WStat, ActGrp, ActKey, ActVal);
    else if (*ConfPar.VerbLev == '2')
      printf ("%-*s %-10s %s\n", LENSSTAT, WStat, ActKey, ActVal);
    else
      printf ("%s\n", ActVal);
  }
  else{
    if (*ConfPar.VerbLev == '4' || *ConfPar.VerbLev == '3')
      printf ("%s%s%s%s%s%s%s\n", WStat, ConfPar.ParSep, ActGrp, ConfPar.ParSep, ActKey, ConfPar.ParSep, ActVal);
    else if (*ConfPar.VerbLev == '2')
      printf ("%s%s%s%s%s\n", WStat, ConfPar.ParSep, ActKey, ConfPar.ParSep, ActVal);
    else
      printf ("%s\n", ActVal);
  }
} // PrintGrpKey

/**************************************************************************
 * Function: PrintHead
 * Details:  Prints the head of the status, group, key, val 
 * Returns: 
 **************************************************************************/
static void PrintHead (){

  if (*ConfPar.VerbLev == '4' && HeadEnab){
    printf ("%shead: %s \n", IDMSG, HEADKEY);
    HeadEnab= false;
  }
} // PrintHead 



