// This file is generated by make_getfem_list

/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2000-2003  Yves Renard.                                   */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU Lesser General Public License as          */
/* published by the Free Software Foundation; version 2.1 of the License.  */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU Lesser General Public License for more details.                     */
/*                                                                         */
/* You should have received a copy of the GNU Lesser General Public        */
/* License along with this program; if not, write to the Free Software     */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,  */
/* USA.                                                                    */
/*                                                                         */
/* *********************************************************************** */



namespace getfem {


  struct im_desc {
      const char *method_name;
      const char *geotrans_name;
      size_type nb_points;
      size_type firstreal;
      size_type firstface;
      size_type firsttype;
  };


  static const int NB_IM=132;

  static im_desc im_desc_tab[NB_IM] = {
    {"IM_CUBE4D(5)", "GT_QK(4,1)", 2, 0, 0, 0},
    {"IM_CUBE4D(9)", "GT_QK(4,1)", 6, 10, 8, 2},
    {"IM_GAUSSLOBATTO1D(1)", "GT_PK(1,1)", 1, 40, 16, 8},
    {"IM_GAUSSLOBATTO1D(11)", "GT_PK(1,1)", 3, 42, 18, 9},
    {"IM_GAUSSLOBATTO1D(13)", "GT_PK(1,1)", 4, 48, 20, 12},
    {"IM_GAUSSLOBATTO1D(15)", "GT_PK(1,1)", 4, 56, 22, 16},
    {"IM_GAUSSLOBATTO1D(17)", "GT_PK(1,1)", 5, 64, 24, 20},
    {"IM_GAUSSLOBATTO1D(19)", "GT_PK(1,1)", 5, 74, 26, 25},
    {"IM_GAUSSLOBATTO1D(21)", "GT_PK(1,1)", 6, 84, 28, 30},
    {"IM_GAUSSLOBATTO1D(23)", "GT_PK(1,1)", 6, 96, 30, 36},
    {"IM_GAUSSLOBATTO1D(25)", "GT_PK(1,1)", 7, 108, 32, 42},
    {"IM_GAUSSLOBATTO1D(27)", "GT_PK(1,1)", 7, 122, 34, 49},
    {"IM_GAUSSLOBATTO1D(29)", "GT_PK(1,1)", 8, 136, 36, 56},
    {"IM_GAUSSLOBATTO1D(3)", "GT_PK(1,1)", 1, 152, 38, 64},
    {"IM_GAUSSLOBATTO1D(31)", "GT_PK(1,1)", 8, 154, 40, 65},
    {"IM_GAUSSLOBATTO1D(33)", "GT_PK(1,1)", 9, 170, 42, 73},
    {"IM_GAUSSLOBATTO1D(35)", "GT_PK(1,1)", 9, 188, 44, 82},
    {"IM_GAUSSLOBATTO1D(37)", "GT_PK(1,1)", 10, 206, 46, 91},
    {"IM_GAUSSLOBATTO1D(39)", "GT_PK(1,1)", 10, 226, 48, 101},
    {"IM_GAUSSLOBATTO1D(41)", "GT_PK(1,1)", 11, 246, 50, 111},
    {"IM_GAUSSLOBATTO1D(43)", "GT_PK(1,1)", 11, 268, 52, 122},
    {"IM_GAUSSLOBATTO1D(45)", "GT_PK(1,1)", 12, 290, 54, 133},
    {"IM_GAUSSLOBATTO1D(47)", "GT_PK(1,1)", 12, 314, 56, 145},
    {"IM_GAUSSLOBATTO1D(49)", "GT_PK(1,1)", 13, 338, 58, 157},
    {"IM_GAUSSLOBATTO1D(5)", "GT_PK(1,1)", 2, 364, 60, 170},
    {"IM_GAUSSLOBATTO1D(51)", "GT_PK(1,1)", 13, 368, 62, 172},
    {"IM_GAUSSLOBATTO1D(53)", "GT_PK(1,1)", 14, 394, 64, 185},
    {"IM_GAUSSLOBATTO1D(55)", "GT_PK(1,1)", 14, 422, 66, 199},
    {"IM_GAUSSLOBATTO1D(57)", "GT_PK(1,1)", 15, 450, 68, 213},
    {"IM_GAUSSLOBATTO1D(59)", "GT_PK(1,1)", 15, 480, 70, 228},
    {"IM_GAUSSLOBATTO1D(61)", "GT_PK(1,1)", 16, 510, 72, 243},
    {"IM_GAUSSLOBATTO1D(63)", "GT_PK(1,1)", 16, 542, 74, 259},
    {"IM_GAUSSLOBATTO1D(65)", "GT_PK(1,1)", 17, 574, 76, 275},
    {"IM_GAUSSLOBATTO1D(67)", "GT_PK(1,1)", 17, 608, 78, 292},
    {"IM_GAUSSLOBATTO1D(69)", "GT_PK(1,1)", 18, 642, 80, 309},
    {"IM_GAUSSLOBATTO1D(7)", "GT_PK(1,1)", 2, 678, 82, 327},
    {"IM_GAUSSLOBATTO1D(71)", "GT_PK(1,1)", 18, 682, 84, 329},
    {"IM_GAUSSLOBATTO1D(73)", "GT_PK(1,1)", 19, 718, 86, 347},
    {"IM_GAUSSLOBATTO1D(75)", "GT_PK(1,1)", 19, 756, 88, 366},
    {"IM_GAUSSLOBATTO1D(77)", "GT_PK(1,1)", 20, 794, 90, 385},
    {"IM_GAUSSLOBATTO1D(79)", "GT_PK(1,1)", 20, 834, 92, 405},
    {"IM_GAUSSLOBATTO1D(81)", "GT_PK(1,1)", 21, 874, 94, 425},
    {"IM_GAUSSLOBATTO1D(83)", "GT_PK(1,1)", 21, 916, 96, 446},
    {"IM_GAUSSLOBATTO1D(85)", "GT_PK(1,1)", 22, 958, 98, 467},
    {"IM_GAUSSLOBATTO1D(87)", "GT_PK(1,1)", 22, 1002, 100, 489},
    {"IM_GAUSSLOBATTO1D(89)", "GT_PK(1,1)", 23, 1046, 102, 511},
    {"IM_GAUSSLOBATTO1D(9)", "GT_PK(1,1)", 3, 1092, 104, 534},
    {"IM_GAUSSLOBATTO1D(91)", "GT_PK(1,1)", 23, 1098, 106, 537},
    {"IM_GAUSSLOBATTO1D(93)", "GT_PK(1,1)", 24, 1144, 108, 560},
    {"IM_GAUSSLOBATTO1D(95)", "GT_PK(1,1)", 24, 1192, 110, 584},
    {"IM_GAUSSLOBATTO1D(97)", "GT_PK(1,1)", 25, 1240, 112, 608},
    {"IM_GAUSSLOBATTO1D(99)", "GT_PK(1,1)", 25, 1290, 114, 633},
    {"IM_GAUSS1D(1)", "GT_PK(1,1)", 1, 1340, 116, 658},
    {"IM_GAUSS1D(11)", "GT_PK(1,1)", 3, 1342, 118, 659},
    {"IM_GAUSS1D(13)", "GT_PK(1,1)", 4, 1348, 120, 662},
    {"IM_GAUSS1D(15)", "GT_PK(1,1)", 4, 1356, 122, 666},
    {"IM_GAUSS1D(17)", "GT_PK(1,1)", 5, 1364, 124, 670},
    {"IM_GAUSS1D(19)", "GT_PK(1,1)", 5, 1374, 126, 675},
    {"IM_GAUSS1D(21)", "GT_PK(1,1)", 6, 1384, 128, 680},
    {"IM_GAUSS1D(23)", "GT_PK(1,1)", 6, 1396, 130, 686},
    {"IM_GAUSS1D(25)", "GT_PK(1,1)", 7, 1408, 132, 692},
    {"IM_GAUSS1D(27)", "GT_PK(1,1)", 7, 1422, 134, 699},
    {"IM_GAUSS1D(29)", "GT_PK(1,1)", 8, 1436, 136, 706},
    {"IM_GAUSS1D(3)", "GT_PK(1,1)", 1, 1452, 138, 714},
    {"IM_GAUSS1D(31)", "GT_PK(1,1)", 8, 1454, 140, 715},
    {"IM_GAUSS1D(33)", "GT_PK(1,1)", 9, 1470, 142, 723},
    {"IM_GAUSS1D(35)", "GT_PK(1,1)", 9, 1488, 144, 732},
    {"IM_GAUSS1D(37)", "GT_PK(1,1)", 10, 1506, 146, 741},
    {"IM_GAUSS1D(39)", "GT_PK(1,1)", 10, 1526, 148, 751},
    {"IM_GAUSS1D(41)", "GT_PK(1,1)", 11, 1546, 150, 761},
    {"IM_GAUSS1D(43)", "GT_PK(1,1)", 11, 1568, 152, 772},
    {"IM_GAUSS1D(45)", "GT_PK(1,1)", 12, 1590, 154, 783},
    {"IM_GAUSS1D(47)", "GT_PK(1,1)", 12, 1614, 156, 795},
    {"IM_GAUSS1D(49)", "GT_PK(1,1)", 13, 1638, 158, 807},
    {"IM_GAUSS1D(5)", "GT_PK(1,1)", 2, 1664, 160, 820},
    {"IM_GAUSS1D(51)", "GT_PK(1,1)", 13, 1668, 162, 822},
    {"IM_GAUSS1D(53)", "GT_PK(1,1)", 14, 1694, 164, 835},
    {"IM_GAUSS1D(55)", "GT_PK(1,1)", 14, 1722, 166, 849},
    {"IM_GAUSS1D(57)", "GT_PK(1,1)", 15, 1750, 168, 863},
    {"IM_GAUSS1D(59)", "GT_PK(1,1)", 15, 1780, 170, 878},
    {"IM_GAUSS1D(61)", "GT_PK(1,1)", 16, 1810, 172, 893},
    {"IM_GAUSS1D(63)", "GT_PK(1,1)", 16, 1842, 174, 909},
    {"IM_GAUSS1D(65)", "GT_PK(1,1)", 17, 1874, 176, 925},
    {"IM_GAUSS1D(67)", "GT_PK(1,1)", 17, 1908, 178, 942},
    {"IM_GAUSS1D(69)", "GT_PK(1,1)", 18, 1942, 180, 959},
    {"IM_GAUSS1D(7)", "GT_PK(1,1)", 2, 1978, 182, 977},
    {"IM_GAUSS1D(71)", "GT_PK(1,1)", 18, 1982, 184, 979},
    {"IM_GAUSS1D(73)", "GT_PK(1,1)", 19, 2018, 186, 997},
    {"IM_GAUSS1D(75)", "GT_PK(1,1)", 19, 2056, 188, 1016},
    {"IM_GAUSS1D(77)", "GT_PK(1,1)", 20, 2094, 190, 1035},
    {"IM_GAUSS1D(79)", "GT_PK(1,1)", 20, 2134, 192, 1055},
    {"IM_GAUSS1D(81)", "GT_PK(1,1)", 21, 2174, 194, 1075},
    {"IM_GAUSS1D(83)", "GT_PK(1,1)", 21, 2216, 196, 1096},
    {"IM_GAUSS1D(85)", "GT_PK(1,1)", 22, 2258, 198, 1117},
    {"IM_GAUSS1D(87)", "GT_PK(1,1)", 22, 2302, 200, 1139},
    {"IM_GAUSS1D(89)", "GT_PK(1,1)", 23, 2346, 202, 1161},
    {"IM_GAUSS1D(9)", "GT_PK(1,1)", 3, 2392, 204, 1184},
    {"IM_GAUSS1D(91)", "GT_PK(1,1)", 23, 2398, 206, 1187},
    {"IM_GAUSS1D(93)", "GT_PK(1,1)", 24, 2444, 208, 1210},
    {"IM_GAUSS1D(95)", "GT_PK(1,1)", 24, 2492, 210, 1234},
    {"IM_GAUSS1D(97)", "GT_PK(1,1)", 25, 2540, 212, 1258},
    {"IM_GAUSS1D(99)", "GT_PK(1,1)", 25, 2590, 214, 1283},
    {"IM_HEXAHEDRON(11)", "GT_QK(3,1)", 7, 2640, 216, 1308},
    {"IM_HEXAHEDRON(5)", "GT_QK(3,1)", 2, 2668, 222, 1315},
    {"IM_HEXAHEDRON(9)", "GT_QK(3,1)", 5, 2676, 228, 1317},
    {"IM_NC(0,0)", "GT_PK(0,0)", 1, 2696, 234, 1322},
    {"IM_QUAD(17)", "GT_QK(2,1)", 10, 2697, 234, 1323},
    {"IM_QUAD(2)", "GT_QK(2,1)", 3, 2727, 238, 1333},
    {"IM_QUAD(3)", "GT_QK(2,1)", 1, 2736, 242, 1336},
    {"IM_QUAD(5)", "GT_QK(2,1)", 3, 2739, 246, 1337},
    {"IM_QUAD(7)", "GT_QK(2,1)", 3, 2748, 250, 1340},
    {"IM_QUAD(9)", "GT_QK(2,1)", 6, 2757, 254, 1343},
    {"IM_SIMPLEX4D(3)", "GT_PK(4,1)", 2, 2775, 258, 1349},
    {"IM_TETRAHEDRON(1)", "GT_PK(3,1)", 1, 2785, 263, 1351},
    {"IM_TETRAHEDRON(2)", "GT_PK(3,1)", 1, 2789, 267, 1352},
    {"IM_TETRAHEDRON(3)", "GT_PK(3,1)", 2, 2793, 271, 1353},
    {"IM_TETRAHEDRON(5)", "GT_PK(3,1)", 4, 2801, 275, 1355},
    {"IM_TETRAHEDRON(6)", "GT_PK(3,1)", 4, 2817, 279, 1359},
    {"IM_TETRAHEDRON(8)", "GT_PK(3,1)", 7, 2833, 283, 1363},
    {"IM_TRIANGLE(1)", "GT_PK(2,1)", 1, 2861, 287, 1370},
    {"IM_TRIANGLE(10)", "GT_PK(2,1)", 6, 2864, 290, 1371},
    {"IM_TRIANGLE(13)", "GT_PK(2,1)", 37, 2882, 293, 1377},
    {"IM_TRIANGLE(17)", "GT_PK(2,1)", 61, 2993, 296, 1414},
    {"IM_TRIANGLE(19)", "GT_PK(2,1)", 73, 3176, 299, 1475},
    {"IM_TRIANGLE(2)", "GT_PK(2,1)", 1, 3395, 302, 1548},
    {"IM_TRIANGLE(3)", "GT_PK(2,1)", 2, 3398, 305, 1549},
    {"IM_TRIANGLE(4)", "GT_PK(2,1)", 2, 3404, 308, 1551},
    {"IM_TRIANGLE(5)", "GT_PK(2,1)", 3, 3410, 311, 1553},
    {"IM_TRIANGLE(6)", "GT_PK(2,1)", 3, 3419, 314, 1556},
    {"IM_TRIANGLE(7)", "GT_PK(2,1)", 4, 3428, 317, 1559},
    {"IM_TRIANGLE(8)", "GT_PK(2,1)", 5, 3440, 320, 1563},
    {"IM_TRIANGLE(9)", "GT_PK(2,1)", 6, 3455, 323, 1568},
  };

  static const int NB_IMR=3473; 

  static const char * im_desc_real[NB_IMR] = {
    // IM_CUBE4D(5)

  ".9472135954999579392818347337462550",
  ".5000000000000000000000000000000000",
  ".5000000000000000000000000000000000",
  ".5000000000000000000000000000000000",
  ".0694444444444444444444444444444443",
  ".8535533905932737622004221810524245",
  ".8535533905932737622004221810524245",
  ".8535533905932737622004221810524245",
  ".8535533905932737622004221810524245",
  ".0277777777777777777777777777777777",
    // IM_CUBE4D(9)

  ".5000000000000000000000000000000000",
  ".5000000000000000000000000000000000",
  ".5000000000000000000000000000000000",
  ".5000000000000000000000000000000000",
  "-.1188190337123157276190528324946187",
  ".7862262698859065681937539899765865",
  ".5000000000000000000000000000000000",
  ".5000000000000000000000000000000000",
  ".5000000000000000000000000000000000",
  ".0499486076365920058340898066793095",
  ".9986896251736089652064035531296960",
  ".9986896251736089652064035531296960",
  ".5000000000000000000000000000000000",
  ".5000000000000000000000000000000000",
  ".0020172156696163625491233219281849",
  ".8972839260992424387132917896649810",
  ".8972839260992424387132917896649810",
  ".8972839260992424387132917896649810",
  ".5000000000000000000000000000000000",
  ".0061981539685801749952003251303653",
  ".9590240438009825431508991023300510",
  ".9590240438009825431508991023300510",
  ".9590240438009825431508991023300510",
  ".9590240438009825431508991023300510",
  ".0010517384819698170066364425704555",
  ".7329438624669667186446168650628540",
  ".7329438624669667186446168650628540",
  ".7329438624669667186446168650628540",
  ".9547931157691535763471652940742300",
  ".0071195039662922548096059557419487",
    // IM_GAUSSLOBATTO1D(1)

  "0.",
  ".500000000000000000000000000000000000000000000000000000000000",
    // IM_GAUSSLOBATTO1D(11)

  "0.",
  ".238095238095238095238095238095238095238095238095238095238095e-1",
  ".84888051860716535063983893016267430206414817564001954204594e-1",
  ".138413023680782974005350203145033146748813640089941234591252",
  ".265575603264642893098114059045616835297201264164077621448666",
  ".215872690604931311708935511140681138965472074195773051123019",
    // IM_GAUSSLOBATTO1D(13)

  "0.",
  ".178571428571428571428571428571428571428571428571428571428571e-1",
  ".64129925745196692331277119389668280948109665161508322540292e-1",
  ".105352113571753019691496032887878162227673083080523884041632",
  ".204149909283428848927744634301023405027149505241333751628870",
  ".170561346241752182382120338553874085887555487802790804737505",
  ".395350391048760565615671369827324372352227297456659450554576",
  ".206229397329351940783526485701104894741914286259542454077970",
    // IM_GAUSSLOBATTO1D(15)

  "0.",
  ".138888888888888888888888888888888888888888888888888888888889e-1",
  ".50121002294269921343827377790831020974259852216947788785344e-1",
  ".827476807804027625231698600146041529195536146125796707231012e-1",
  ".161406860244631123277057286454328774644485176193046710229518",
  ".137269356250080867640352809289686362970625610493254643268368",
  ".318441268086910920644623965645670393489678861199560924839863",
  ".173214255486523172557565766069859143973766353125458203015303",
    // IM_GAUSSLOBATTO1D(17)

  "0.",
  ".111111111111111111111111111111111111111111111111111111111111e-1",
  ".40233045916770593085533669588830932923228462276862064255187e-1",
  ".666529954255350555631135853776964490548129374988987074438202e-1",
  ".130613067447247462498446912570084637491907449311536657267446",
  ".112444671031563226059728910865523921376956456980875320569753",
  ".261037525094777752169412453634371001056613553334716765542872",
  ".146021341839841878937791128687221946103744194843853772295688",
  ".417360521166806487686890117020913233384424828225258134433550",
  ".163769880591948728328255263958446572353375299565261088579427",
    // IM_GAUSSLOBATTO1D(19)

  "0.",
  ".909090909090909090909090909090909090909090909090909090909091e-2",
  ".32999284795970432833862931950308182730041334945018887054186e-1",
  ".548061366334974322307017247901753550247370718236383653988127e-1",
  ".107758263168427790688791091945770948246401272452968189158682",
  ".935849408901526020540707609497174597845971188125641593034686e-1",
  ".217382336501897496764518015261124167858473927218991512154422",
  ".124024052132014157020042433210936376671836584823856939628032",
  ".352120932206530304284044242220471245529496782825697945266050",
  ".143439562389504044339611201665767615591826773727965914171059",
    // IM_GAUSSLOBATTO1D(21)

  "0.",
  ".757575757575757575757575757575757575757575757575757575757576e-2",
  ".27550363888558888296209930848390643194371724024986338143054e-1",
  ".458422587065980653341712970670396431551530707088913693106640e-1",
  ".90360339177996660825679209141548669654766671048177855288342e-1",
  ".789873527821850575823355313501701341255531582117285798633435e-1",
  ".183561923484069661168797572778172070878078127299249503517423",
  ".106254208880510572679151038683433135097672811382670416747947",
  ".300234529517325533867825104216516549736125983602346481756031",
  ".125637801599600640146622206073798091666719238674901822785133",
  ".431723533572536222567969072130153051550792944358970807274209",
  ".135702620455348088500144169249801420197325963446050235535497",
    // IM_GAUSSLOBATTO1D(23)

  "0.",
  ".641025641025641025641025641025641025641025641025641025641026e-2",
  ".23345076678918044051547267622275424186746055651318407405314e-1",
  ".389008433734094638967944941665667925339174087467514605229837e-1",
  ".76826217674063841567037196450623320210981670142795687155676e-1",
  ".674909633448041745599573812946854446280863460463397092613593e-1",
  ".156905765459121286963620480216822223535411900937807786468654",
  ".918234326017750460037471293734053616232368434841189995727658e-1",
  ".258545089454331899126531383181533189613903368940704994761138",
  ".110383896783055043042767004189698148733631436666997602365805",
  ".375356534946880003715663149812886509255594343753512070350742",
  ".122007895153338178229289074180078106265631100208278030113414",
    // IM_GAUSSLOBATTO1D(25)

  "0.",
  ".549450549450549450549450549450549450549450549450549450549451e-2",
  ".20032477366369549322449918992287805466804240713676031817921e-1",
  ".334186422488406423170353303730264125288210267253412169234334e-1",
  ".66099473084826374499889898545867893375063823452781932620587e-1",
  ".582933279493558257704983353273251150023529274500366395982189e-1",
  ".135565700454336929707663799739559202171330234152839098693878",
  ".800109258814760712064104989937973202519012748164405350843474e-1",
  ".224680298535676472341688647070459682768930840223042933088104",
  ".974130746867080593201658891879422560743143780259323781382047e-1",
  ".328637993328643577478048298179162677583443232929846626722542",
  ".109563126504885377435581261977083806479166057229437913068074",
  ".441834065558148066170611645131919916029245477871859615898338",
  ".115806397234228529444814178646319595157949830258305822684010",
    // IM_GAUSSLOBATTO1D(27)

  "0.",
  ".476190476190476190476190476190476190476190476190476190476190e-2",
  ".17377036748080713602074303965199411146174932001453329963751e-1",
  ".290149465143006245484402920126409977178433634130074518874935e-1",
  ".57458977888511850587299184258885174005642957396261013591309e-1",
  ".508300351628590338018330853944003577404917968583029524889669e-1",
  ".118240155024092399647940762011854190911315739842354831622647",
  ".702558499012140547302234028218364453117421773012039790937081e-1",
  ".196873397265077144438235030681633246410134483120040107157085",
  ".863948236268004745260385497041752936783178315134026453644873e-1",
  ".289680972643163759539051530630709793507830897253784815807454",
  ".984936179823066780462501732537032974318019754167452142348594e-1",
  ".392323022318102880887160276863541143673921049398479468262748",
  ".105986792963410460063715038488610458311827872697180131591388",
    // IM_GAUSSLOBATTO1D(29)

  "0.",
  ".416666666666666666666666666666666666666666666666666666666667e-2",
  ".15215976864891033523878630816270379305504626748082634965660e-1",
  ".254251805029599527016224597827276572469359137688934919607797e-1",
  ".50399733453263953502685869240075261625001195477427787287786e-1",
  ".446968486629654004955260400830418574669436050188994892392643e-1",
  ".103995854069092468034455864518427147095963086009900488657794",
  ".621276910662570491747681663286566003871990156349497701014740e-1",
  ".173805648558753455266058390179709259839220993585212831307110",
  ".770134904035821404078224702424972577227081209918206614293875e-1",
  ".256970289056431194109054607076562651555511347850873714311672",
  ".887459566958520626505378347641788850791573725880856067573957e-1",
  ".350084765549618395950823272638849676092269511546111167672845",
  ".968450119126017921584567994267610151531789970092036625918375e-1",
  ".449336863239025276078483497477041118733379542799904430041225",
  ".100979154089114935744599562705470060277210308321480651255298",
    // IM_GAUSSLOBATTO1D(3)

  "0.",
  ".166666666666666666666666666666666666666666666666666666666667",
    // IM_GAUSSLOBATTO1D(31)

  "0.",
  ".367647058823529411764705882352941176470588235294117647058824e-2",
  ".13433911684290842921510249063139284705520425438745256776754e-1",
  ".224609702716271048237004773116062216590998542221354492455681e-1",
  ".44560002042213202188098746801136766234560274065633617839094e-1",
  ".395991352518435595951322149764172520491821092634233867616593e-1",
  ".92151874389114846446624723381236672641798801466438220925068e-1",
  ".552964545035140806878863526100384018197161122536382150683774e-1",
  ".154485509686157647302540321313773351596793468904792285796301",
  ".689938731009632795281007874770125853329516328900044026984709e-1",
  ".229307300334949230438133296247968374162426676017584427339528",
  ".801973309988107697581641829323756451329090206586914032496804e-1",
  ".313912783217261479046382659632371093720091342799859713267448",
  ".885021267578289352184728726816462459105382395892224688500747e-1",
  ".405244013240841305847868492623443014327503788538750714711064",
  ".936081698388096179460442414303108681335648762971252960440287e-1",
    // IM_GAUSSLOBATTO1D(33)

  "0.",
  ".326797385620915032679738562091503267973856209150326797385621e-2",
  ".11947221293900728567740537829149966619093278640402952258748e-1",
  ".199853144054570330687995882050504396471527249542297425578152e-1",
  ".39675407326233063081072687284361288218823256905479703276208e-1",
  ".353185834428168324996114800838931665506483131317767918886260e-1",
  ".82203232390954893143176818836031371283164620417090721135754e-1",
  ".495081358587514011972118026593360539590343414317196854573294e-1",
  ".138160335358378659346894817348964660425237397922620554841258",
  ".621052665664835501316981794483733899803947757525133778641170e-1",
  ".205747582840669119413232053403220265499581605341891046617858",
  ".727059807869011339915016052472133862427388585327721514391982e-1",
  ".282792481543938012328856431629662602075120777418153679028028",
  ".809697586188012446321633533501142359803970357771417227070442e-1",
  ".366818673560859507916167333987202028967431905340870776188773",
  ".866310547447281130053072019133417108622886794056730343091914e-1",
  ".455125453257673944488677494955719132519698049479437597765521",
  ".895079317198515411469094034717625840976067089226702257961895e-1",
    // IM_GAUSSLOBATTO1D(35)

  "0.",
  ".292397660818713450292397660818713450292397660818713450292398e-2",
  ".10694116888959952423682968444888718592861331094595279277834e-1",
  ".178966825930882385577127845175611782307832925048426251844998e-1",
  ".35549235923706878141029870601725693774915908874024696655238e-1",
  ".316909458813148684258478452091586897789922163705181539793793e-1",
  ".73769711101676953457022014979468687381452309580567375865338e-1",
  ".445658785496035422240043952780765889604388715847003959646753e-1",
  ".124252898723693492918181255183027979798170322167102148284960",
  ".561576707386525220354550077318905120953864296130486462051020e-1",
  ".185545931367389751116583846885633726465694421405219326543697",
  ".661336402243753884630233669548626818123027098398137908719772e-1",
  ".255885357159643248611045181187538315114392200174257596784414",
  ".742069712979694425048403218342049251459662226109483406188946e-1",
  ".333247576087750694850749948077536494038518312261134940526345",
  ".801454620220306209899554840917970096865967172080793328268205e-1",
  ".415406988295359214312422923277559788123552224617074323619774",
  ".837782922635714336350686388701304747066352773683085083378131e-1",
    // IM_GAUSSLOBATTO1D(37)

  "0.",
  ".263157894736842105263157894736842105263157894736842105263158e-2",
  ".9628147553042914037276780707884542385044688436875659713374e-2",
  ".161185615942444707458025140586470150516260701463731095265061e-1",
  ".32032750593667282141909207534686535042213083409474321044076e-1",
  ".285909010637834130023768135866213912526030070440817145249659e-1",
  ".66561010955024929345076392691857393018544355841503967984722e-1",
  ".403158819980598015723884230568602858330182251708810199399037e-1",
  ".112315869523972064792841236202654328313639070261734086723908",
  ".509957498497254078418906028664432604337531744810181943084061e-1",
  ".168111798854844355076798338514420573762127129004254353040030",
  ".603546138143373625497148525011966799361590679125845683198745e-1",
  ".232503567984056869175932019085508008496574215431238336956656",
  ".681502411793620922448903964945159908720383313398169969136747e-1",
  ".303823408143045350306762648092087816667398335350544693329895",
  ".741807770354584129073565068669833024655756471169243587084652e-1",
  ".380224147038506752408799321536455964029241095036311281163628",
  ".782900513237377435790849483968216861515489682954554753349193e-1",
  ".459727031380589081012027740920222768488803564953545767490584",
  ".803716431939228745038633632245419669510459295454961411588879e-1",
    // IM_GAUSSLOBATTO1D(39)

  "0.",
  ".238095238095238095238095238095238095238095238095238095238095e-2",
  ".8713851697725985882759361722297061570414205881792792352983e-2",
  ".145924200492527293047292718065854071328605755774022440101599e-1",
  ".29011851520127232851948674669282411675174562977995154850811e-1",
  ".259215845004248125363614859264148780152071795112277146331920e-1",
  ".60352622338204767774423201847527976144709224245401779185061e-1",
  ".366369590925370721262739305209468518286401470259684831383220e-1",
  ".101999036961143797627843705169820680454790169725111741826687",
  ".464927339789430326505688320746072030299104839832459926795938e-1",
  ".152974486968888383686341803402666685621141996947077251470668",
  ".552585416095616676335002433921938873811543469692278740765004e-1",
  ".212084019869084656536489064830957356332113495720758755547356",
  ".627290605954344740075787678539996158519476607413795006408040e-1",
  ".277942108360498949402741825196324357632471256716467573532750",
  ".687292314300206717904498087075726317588624924124032911561135e-1",
  ".349005071745617556362324066070623883989464482969806883829044",
  ".731184312239887296336352653171967516097530304094937638975446e-1",
  ".423607242098907266996820835757165282241125503343361759567474",
  ".757937875558406922266253407526454555250206170414328264983493e-1",
    // IM_GAUSSLOBATTO1D(41)

  "0.",
  ".216450216450216450216450216450216450216450216450216450216450e-2",
  ".7923780771176911723855188893964851697243231940241772053095e-2",
  ".132728738412508789558139522602714567237786507838684367062010e-1",
  ".26397858000385659737893116692135245043968977329318192916398e-1",
  ".236072326468703760618878674323959922005749894668565101574612e-1",
  ".54968854904547764735171087110456604900232958576426356366954e-1",
  ".334328029322765380062020970785485462845766896335495627368887e-1",
  ".93025536194039431977279075971932478780665742546451550753154e-1",
  ".425450301959192239078556180478740683571890905421950696146433e-1",
  ".139756380019398920940059051800767120703327286940249649738061",
  ".507502874008238371862186518748000954411017664375040666139280e-1",
  ".194165280857870514386894197065036700327279847696152201721922",
  ".578738223269695332950181838607280840711049818767407746527904e-1",
  ".255092562405048825095624382158364979164364182102424091281464",
  ".637638483267151377654222296544149216862750861038200720792575e-1",
  ".321239644930540230969521359879910435358346448028531860291529",
  ".682948443068707133430886811030851281405420814902094595923986e-1",
  ".391196707420357479106022453267303618362496652992903467438132",
  ".713702461356807001681179967833944690442864754444394177616981e-1",
  ".463472729994550832619455604767946321903610381833241750515514",
  ".729245097221208968082102197399850735484056860563144640473109e-1",
    // IM_GAUSSLOBATTO1D(43)

  "0.",
  ".197628458498023715415019762845849802371541501976284584980237e-2",
  ".7236422060633710959268616630950450489694603930177479119567e-2",
  ".121243003857658682586998294685485205798888635735206232771851e-1",
  ".24121022144644897932180160074285422075824037275600302787436e-1",
  ".215879355851209173744382328060211355762285181763820359922447e-1",
  ".50270720979827494524919839826316421044100825930352632722344e-1",
  ".306262385647771031906914237201777466689542138275629029502925e-1",
  ".85174451674357056888399690354997557700744058493336357749444e-1",
  ".390677247377849948709671276739823565676700045378139841223174e-1",
  ".128152479413969658027418228466501604356390385523069892862706",
  ".467486230817561709167503534533485520634160783618914272939110e-1",
  ".178368177769931895761927233198615628054344059098850639312758",
  ".535195508621682557675918139577333145872035341048698748128486e-1",
  ".234844114431577915934942339923850094434826742536328644801788",
  ".592487553313745656510630023621302592842459980417485732954788e-1",
  ".296481031042762585402024755892452180224023138002913023559442",
  ".638247373508794383180742765278353838977596887811376972364145e-1",
  ".362079225527103466446561183660432397913404446695291352031596",
  ".671584363193019099507824488503554245640746693419422570410570e-1",
  ".430361897979665800704068693508616533045727771412779130738296",
  ".691849681929036972617513669314722196935189869646369117329220e-1",
    // IM_GAUSSLOBATTO1D(45)

  "0.",
  ".181159420289855072463768115942028985507246376811594202898551e-2",
  ".6634723247419558223456630922762512314040103793349049679906e-2",
  ".111184267323556044964802174086492620050176192239169745974084e-1",
  ".22125889535056820986511434724677584464633478522129651817468e-1",
  ".198158406667339047346310816817358634793092440210505829253431e-1",
  ".46147162443246739002423501766896125395789943060861848397862e-1",
  ".281549243623230995104741698390589971642242228145224933854699e-1",
  ".78267964922563979688347481288328857079461949594834714406916e-1",
  ".359909310276469911078195303343400629900325450513271872191024e-1",
  ".117914758789753346106312359523853174339469775381550067611436",
  ".431845149839645341082814096532915965108641116273791577943270e-1",
  ".164379947367935650082167570906496621712988355526783726167442",
  ".496074138420417937070748854978562144413051915739330975708622e-1",
  ".216834321010352343905295227728858114780552501436759663211850",
  ".551450434464843020552120615137983022031643064384762325675358e-1",
  ".274341813392838690875890754215188775588455890843755295097072",
  ".596985968512456595161469441753589964535657767009518443797119e-1",
  ".335876193312244543983305410320195328149411065613650152688440",
  ".631868210140104000636240453456865580062120086871590542472583e-1",
  ".400339373304583666381713730437504634594062204289261893121279",
  ".655474709368019711772251129082650571537148716289912415278838e-1",
  ".466581003131385710943179095804161345101888395541186134143022",
  ".667384219334931887983928604825387997375176384641762012523592e-1",
    // IM_GAUSSLOBATTO1D(47)

  "0.",
  ".166666666666666666666666666666666666666666666666666666666667e-2",
  ".6105027534253145364097964563419740923508003188290461239091e-2",
  ".102325844664871926542712359095814255514168391823983732543676e-1",
  ".20367930873732760570077410580238398736748534857361504040258e-1",
  ".182523693971356860161914943775548702387906683080989446345772e-1",
  ".42508614632688710838425033131576724176551365436575845115480e-1",
  ".259681141842457373216669448567446890052560190695344219996624e-1",
  ".72161767082341711238093369914125951942966191994092954906250e-1",
  ".332568643376563923469349966567997205463679797064449423155211e-1",
  ".108840170379641609800406023885626321260268486963982328469372",
  ".399993874181464909008132180694180172477943323715565151820834e-1",
  ".151941475592432816619817283105311224369685632997407266147836",
  ".460850699553102109563448113570242728560689916347627386379012e-1",
  ".200757926360003365951189501409466921016909810941654501300426",
  ".514140151739789154137518224535670827918308109374097488886833e-1",
  ".254487942590560808690520038715598419467725766219313446622422",
  ".558987331341604440781221162155195934534543154201289295286150e-1",
  ".312249271070386383385642693869640983656841846756140309068138",
  ".594655897034059127047221223170935785573793405205555420601850e-1",
  ".373093467915561709910056559156362235068040400820232908112370",
  ".620560194689751453476076562196484851797968944534480594902694e-1",
  ".436021470258446513645507687452672701552229338159203754455898",
  ".636274887691657235085572083693789566452204678961431315096817e-1",
    // IM_GAUSSLOBATTO1D(49)

  "0.",
  ".153846153846153846153846153846153846153846153846153846153846e-2",
  ".5636293844262172785376654814349329502683228655198220994610e-2",
  ".944842901213173279067602383813360096837243278295331509485688e-2",
  ".18811062616141335124668664358934918984477681089652652115344e-1",
  ".168661518429779996887613742913779549959195787571827537904211e-1",
  ".39282226591221329437434739125655822436617675722870228517317e-1",
  ".240241995405903136579896563903310209755081435311081600999073e-1",
  ".66737838020438214512774251095114972629569806396220366176788e-1",
  ".308175125712737013910900270521396343659377236204541224203563e-1",
  ".100761408446281280481606180714828301121830713192360841900358",
  ".371435250611455686580420414931243688743957924621669253334512e-1",
  ".140837091818667459737297306048036992001160745798040833428648",
  ".429064319900021810937406261795342036448947295198737044084601e-1",
  ".186357350253841556099740546419389481909497246797714207345238",
  ".480189011769506554018486981854312016057282442710619721520082e-1",
  ".236632128985060727350878302809502843787186249283851277026243",
  ".524034431153685264949529184456820880802892709975886555974429e-1",
  ".290899306466876607218158058833075087878819764706376763456148",
  ".559935970599301676501054399399431205217540930926319129085785e-1",
  ".348336243570373639612979481048944909294222405586751317284494",
  ".587349420469045035383478101482410471114901694452260627407174e-1",
  ".408072252364972549339397164057120123811863920061932007752486",
  ".605859231442216730221433478521131956164303514431104854746501e-1",
  ".469201794109040135897256362609124332668453019391966382950466",
  ".615184819000414381507635746454870247777410085381803960124891e-1",
    // IM_GAUSSLOBATTO1D(5)

  "0.",
  ".833333333333333333333333333333333333333333333333333333333333e-1",
  ".276393202250021030359082633126872376455938164038847427572910",
  ".416666666666666666666666666666666666666666666666666666666666",
    // IM_GAUSSLOBATTO1D(51)

  "0.",
  ".142450142450142450142450142450142450142450142450142450142450e-2",
  ".5219518135724689425562679972740281166560485166095899171246e-2",
  ".875098743803278950968486718135962439935403676762603146489170e-2",
  ".17425798774590540367866598439434972665509634659039877372378e-1",
  ".156314758676011921623924950323976817580554306820644071373744e-1",
  ".36408270637442110570126617963640634219784656903881221350816e-1",
  ".222888289665308493720373711206931177818922725758967985150855e-1",
  ".61898956892738760666728475402929579036643743433243354285580e-1",
  ".286327848400813658695436141269703119508106325294368387942301e-1",
  ".93539756552093855870954067620731043963341083339048312650436e-1",
  ".345746711800216381403173675150636096766678043004382691295039e-1",
  ".130886425076770044580286387125797362998503429483030936381575",
  ".400311609852692290841190352419751768913472107350526745204076e-1",
  ".173414668151595242410647562408769525902811104392579867437986",
  ".449256826296452799860681509730313010164092849300188453714885e-1",
  ".220527469528719409968665962565937612546033718146165368320294",
  ".491895372929763815896544656349943163869494044098204433775991e-1",
  ".271563462192958798160693674580378988878614379597627434424592",
  ".527628739106265056091909947399509438466570357602852376199058e-1",
  ".325806209005485664781456710706416702118262424138498939256300",
  ".555955326287185164641309796710773319448695113123507892155807e-1",
  ".382494258448540933331599209743334168109275316540198144332390",
  ".576477501273259914068766666873650439913498374601174255117312e-1",
  ".440831833050739475780645865862341835890285154053172375713830",
  ".588907182929780795332495397241821186005642008580209696053016e-1",
    // IM_GAUSSLOBATTO1D(53)

  "0.",
  ".132275132275132275132275132275132275132275132275132275132275e-2",
  ".4847298690772937241453544067700950704265633170196590917347e-2",
  ".812794197875210909949507644855484155967295191472253843720574e-2",
  ".16187857071434347828114560428263719229997063411737679482102e-1",
  ".145271103389895723534263899117912141009164344192280618119264e-1",
  ".33837416439220737536928790695504783770783890199380353999330e-1",
  ".207334576215033605189929243893135553677258034767923801250409e-1",
  ".57564491394348580793846830871375163299169405152113342802907e-1",
  ".266690385236637442001627567357501032518809953980167034225613e-1",
  ".87059514971830901977742786901697749544699992123399574285196e-1",
  ".322568290401772691951228467312392156549271450243330429605072e-1",
  ".121937902997215117423952137366904537986166617277573282691844",
  ".374240617548538513902839695715808752117143984373053438094600e-1",
  ".161744935535213341140309377463305755520976402481877715884116",
  ".421033975607551628697455938989599159947536634091556432665574e-1",
  ".205961655081412196760843960119143961297352923216924837444576",
  ".462338429988560878610176973496930444473152172769404774927708e-1",
  ".254011623034210309785191658527760078518633370111423994954706",
  ".497615552062478364379726773754575675541209407497974291198564e-1",
  ".305268431211818596032057922397945127675886216375209298110312",
  ".526405468805279472411887758974550839267643555081391919422675e-1",
  ".359063866689198814022923745545333747322946192537992066531726",
  ".548332868979883125442929318956030209417161177190799199163892e-1",
  ".414696622345997819558648661125617458507549600036909680734022",
  ".563111900386195062703182120568301057054912545924890514933355e-1",
  ".471441439153243551186728174213126618386969718269283169653968",
  ".570549898363139172666573964150201335316779707512487925978023e-1",
    // IM_GAUSSLOBATTO1D(55)

  "0.",
  ".123152709359605911330049261083743842364532019704433497536946e-2",
  ".4513505865715091860627443350214348656266829531532571420476e-2",
  ".756908492998379839542896330342786928172421932727542056944041e-2",
  ".15077096356031853143799306056089627132362118375153218171440e-1",
  ".135354031484124137704257127225129269401276106349213754589370e-1",
  ".31528640739508744228981575858318538795142278692178225442666e-1",
  ".193342199898564898739162871335622054971425531015516504928898e-1",
  ".53667140011955860617885042973456560991991749245221800803941e-1",
  ".248979045466187804613341705877387858052963659217990353324378e-1",
  ".81223631859106717378963341906587715242238150972176740253454e-1",
  ".301592519142613675140322317588168405445030860560186840791403e-1",
  ".113863551396765629322914682931773508357687020470960529884954",
  ".350544690002989995926334292120068043474674125337739548240897e-1",
  ".151190669321816005803012785711453444605785868153381852837216",
  ".395241565139428008920851160875547009022029362151477473449563e-1",
  ".192751873898283525014548191287820640551973256670620433810082",
  ".435140667205678028188130776078165301844127624770588033245342e-1",
  ".238042662814015458210591713438197018025010870016085886109059",
  ".469757710573981562489182534937850130445343345120126115219412e-1",
  ".286513264143252806181211794515820545400373649967902242322173",
  ".498672508185749303267845887670342417580393232955522927913043e-1",
  ".337575308579044496869992988460581312360197634829237218169588",
  ".521534082318382687113535560956211439902889273012784338358176e-1",
  ".390608970857869490095474073837502665769111824407837236749336",
  ".538064929167842696867934270233034418136125147248867068589393e-1",
  ".444970493302203945146106198872159572524305647565748769566770",
  ".548064389229452100660662053782976870957940094447424669757957e-1",
    // IM_GAUSSLOBATTO1D(57)

  "0.",
  ".114942528735632183908045977011494252873563218390804597701149e-2",
  ".4213028579749853330590887045674687301197699926991654903060e-2",
  ".706589966395269382036608433410389513497039777497499727089194e-2",
  ".14076698416865379161703523895404135634716326427958768433372e-1",
  ".126415833702757011021341269250212399522158522858944328383225e-1",
  ".29447609524471458846405225292239463859846046279881258757234e-1",
  ".180710470997042676573663415616798499084917367357548065477142e-1",
  ".50150390900361570223328588425272934980389794061133810691620e-1",
  ".232953472665714637009402457230108320576652326113950852164605e-1",
  ".75950256409900945224288083908467395086812661195093270248722e-1",
  ".282555989615401916510968552361516617867180727695131041119079e-1",
  ".106554821381226459775020239703798119983160454148661883677788",
  ".328956681988950274720506872965661912803866043805925136674291e-1",
  ".141617300681457434183100701935051346105225066318658892988696",
  ".371630016623591269170338210004153353917738916903357848507864e-1",
  ".180740412096220796314453258645129636111624477435108964250188",
  ".410092564167034573998607727635799427521795519348752383237299e-1",
  ".223480869952473573807724884979671114840024757733730891021696",
  ".443908561598826050836282172279602797856663363799773815281491e-1",
  ".269354404915879657386721389446423932579575876195213961883090",
  ".472694875969304458905663576820179446730571133570584258804423e-1",
  ".317841249788775501122007447224107172986332681943585563244013",
  ".496125355021499153288379824771545307176305476980836370874308e-1",
  ".368392028140213104366450265499966194601836824292832847046162",
  ".513934526536174947351404041676880805117233514802254028829063e-1",
  ".420433978687074766087525711450576140668427320320412134669431",
  ".525920607982273249281064904295697030948861180232393493608628e-1",
  ".473377444757256665318496082774323117922018451116582981169381",
  ".531947793618339624737911534049655704238995606941720382775521e-1",
    // IM_GAUSSLOBATTO1D(59)

  "0.",
  ".107526881720430107526881720430107526881720430107526881720430e-2",
  ".3941577826759455705337692175642821774041786345266341255715e-2",
  ".661123551273233515131781493491739852809813092971118023749121e-2",
  ".13172532092131762586965225762385120356636002416317467245980e-1",
  ".118332166151351583650228913547128293450859321049879971550576e-1",
  ".27565414895980385096797231175072194748420655259146220114212e-1",
  ".169269702026120288149054234659366233337907773109497243990578e-1",
  ".46966524279365093427744238376268826981281664148167550960778e-1",
  ".218409090800334564148736440416341460523266076903357701133095e-1",
  ".71170002351272194816497308801762980062733319086840696736928e-1",
  ".265232327467243913871404300338199517069413538823886617413097e-1",
  ".99919228403768505363834333008409397196851622648463205568176e-1",
  ".309243706452273116953742920011158028576281989972116445862646e-1",
  ".132909431845462378932929582581179425692701498368351572890328",
  ".349976887970502852251076766865697836840420067722239858585482e-1",
  ".169790898694237238331479362701612946137098574900113220425048",
  ".387000161707378093171419392087113833718945257680035838046676e-1",
  ".210172671395999043498351568901137282496869964482170302255560",
  ".419921102587648653326290541131881663912333492006271003920411e-1",
  ".253626690450583797148099883464892707126418280477365480939213",
  ".448390755226304111240714664181044381842072605436659224151060e-1",
  ".299692330859719096848667790301953798554142885012178699905694",
  ".472107341889289787160952449082667556226074506949061086924020e-1",
  ".347881284363563689520272426186868212704483482345560886763170",
  ".490819465068563785598709397007104863771375690668465426026522e-1",
  ".397682735376237749429453207136145794400506376080822161383004",
  ".504328773993252566977812980514235680975135840394569136888326e-1",
  ".448568775619658861455442638345975844551246596062543428935102",
  ".512492067977351988379528274952139859375022507267242661965872e-1",
    // IM_GAUSSLOBATTO1D(61)

  "0.",
  ".100806451612903225806451612903225806451612903225806451612903e-2",
  ".3695533013619320314229342361276064438549260014752591023524e-2",
  ".619905325068692189431017461455852863677308015161122664564700e-2",
  ".12352654758645385968772024805922512885266690539114243995420e-1",
  ".110997764446459823119160855805397847065866592950853795220113e-1",
  ".25857580791383810958335879205785640918321138662135586588218e-1",
  ".158875677054577328907811394589531003479596907397578386268849e-1",
  ".44075030468134047962734273812964606989921120454714917771798e-1",
  ".205171007930313616652019208595077891479645029850817715560092e-1",
  ".66823761993662240084592615287728254819884728720905618790911e-1",
  ".249426356681106035059800768622215270143816050928955588640022e-1",
  ".93877634111278827726589105963710940119554449152385918853484e-1",
  ".291202486240279347753994649596021099388281730705321402021982e-1",
  ".124967753031662601141362017660847971716568516923414378001788",
  ".330084386285772719662181658417470516898190065749711602305526e-1",
  ".159785122192224592028802121150575495712070108887407335974531",
  ".365685698013395163201854917846043774864430079361431938949998e-1",
  ".197983706425789436931413543694054965174031783204672520790836",
  ".397652628460531261461783644415243441246609268153685444410193e-1",
  ".239183868559217354696703713303990565175717698977965325081444",
  ".425667489748341152637638292533084566926749502847335622835946e-1",
  ".282976141399076530198340321496804409231000126662368532136878",
  ".449451864786789165360623947923320246109173498437553195644532e-1",
  ".328925296730559256873093889650642303651838106406754938198256",
  ".468769377734069067829541770728968353881797946677382623975272e-1",
  ".376574670574897347791879284420564021912310606153650872746580",
  ".483428044740013002801890738531974120229420067778694200015487e-1",
  ".425450701593176252542809061914980170854683870415604527623806",
  ".493282182703808885853255821217039098973569283919955179470797e-1",
  ".475067637476703373846851127635786909851425415954982763499512",
  ".498233857506383888174695423742704902299961883402013170926582e-1",
    // IM_GAUSSLOBATTO1D(63)

  "0.",
  ".946969696969696969696969696969696969696969696969696969696970e-3",
  ".3471820783170828166331956621882223166451388410789876437908e-2",
  ".582422419613386732561108993514254374111530073791132231122504e-2",
  ".11606918341546849257186195809340660919822449034117999835380e-1",
  ".104323045088016800479058320913063386508288859446326183240854e-1",
  ".24303274301502128312237791543219924195179604960513263843852e-1",
  ".149405229583732387599855782274976114343192870338312668226624e-1",
  ".41441348274529379587160465121589401019191139979944330235987e-1",
  ".193089073859069837819294378376084060925463502715997534752124e-1",
  ".62860949624718889676719685334827797326776034524980480179822e-1",
  ".234969252305120852739865560206122974127100954535248775355173e-1",
  ".88362038497966265220464343366642565410306735074550603473359e-1",
  ".274655297213134839758494206533284764335996426011146270826503e-1",
  ".117706499103235685996670759788456025584165262656253667022448",
  ".311776839262326527205304795838662049372485413839456765206665e-1",
  ".150620341690918702150161376227791399071908448691413311791407",
  ".345987347470080737799848984001631601497648509265887666640795e-1",
  ".186796254359365871368084328794642635951373037423558619700344",
  ".376967434619869142535649592014542904571679509397230501025568e-1",
  ".225896470040444188444797644119684576263621625535116186513302",
  ".404427860967275460898538483860978368489005345007736042463416e-1",
  ".267555919183946622013498139507369827145060241825802331148318",
  ".428112242659065662750959818729323474463124509789127996704173e-1",
  ".311385637873303182479032669641000444584910058542365843718994",
  ".447799448735387003305742313627804816333924283789518495908516e-1",
  ".356976399256162979197327748518477796536686148506339221162646",
  ".463305667211207317649675601425526422922278767014430159910321e-1",
  ".403902534266261387129346502279421395209750563566905250363635",
  ".474486121972959079121777073313019049746989888341200381484857e-1",
  ".451725905911946496841521105954187261966530067396395385116088",
  ".481236424864927309982772471389677145513478064643933397891675e-1",
    // IM_GAUSSLOBATTO1D(65)

  "0.",
  ".891265597147950089126559714795008912655971479500891265597148e-3",
  ".3267818706241898872719379697008658939123332221068393980512e-2",
  ".548237040915327570073747180688260857898810816047143193269134e-2",
  ".10926655560031025527387669645240364666144860235860655029450e-1",
  ".982313908035671564397354124013105319667317131621446390749319e-2",
  ".22884675543596235796378418642566496906853795800594885615553e-1",
  ".140752684311217517003760885539283583042530382431647788553374e-1",
  ".39035852161275538628596639395710566685325639794482640242076e-1",
  ".182033854753912761753960607415591143831167821568040475024335e-1",
  ".59238081743863367800761807746241902934295626559250965049096e-1",
  ".221714510301221711501363965218239498502506930859476832470857e-1",
  ".83313778598428692543829012294041305580720623236938271615932e-1",
  ".259446459154635603879199530393733985591253758474079173539945e-1",
  ".111051346784066294558981590516769002262563521653929507363840",
  ".294898270133726133477194188385045126758474984839586078352300e-1",
  ".142207019639890497001374713709686957513242547417513952582574",
  ".327758450541325602152191620220031543654903452737514882610582e-1",
  ".176506996031992687811406831062165682194303731932337142646188",
  ".357738249385364110177945443051266351590356364134185041302582e-1",
  ".213649844362538577604533904183277431205625978039359064631420",
  ".384574215317954910525379587538314076158942351412473889253948e-1",
  ".253309150663364521281755492049505656622199067964373639328508",
  ".408030519252111915810444986639725295136323519546187000792315e-1",
  ".295136386720203627571311047943812398485693829871777668806268",
  ".427901029859887932950635763572018487278249959353515203023550e-1",
  ".338763972744255503211266465393354937215360538392133619235151",
  ".444011126417920160590792216087440157377275418151948545555205e-1",
  ".383808507565441578468326159219630319924593889721511091763216",
  ".456219234034572435112197559565733591506381605045768667614281e-1",
  ".429874137911903070814345355376581198803807020198381253947380",
  ".464418068148053230718428381547903132118412616700170908800243e-1",
  ".476556037143514659956580426168788227431771756060691196833555",
  ".468535577521516560008129537207587320570048325183673953062711e-1",
    // IM_GAUSSLOBATTO1D(67)

  "0.",
  ".840336134453781512605042016806722689075630252100840336134454e-3",
  ".3081278177806724856687350275451075505712326125984047369883e-2",
  ".516973665727018810568244365869450181145528779579159877676231e-2",
  ".10304428285039688405544395755774045411888074994426819461416e-1",
  ".926569673814102874078195254088283984194151253377487093624533e-2",
  ".21586470781506058781214042701816330811887442452500586725310e-1",
  ".132826976653891079738007655238330862581264958409352559586884e-1",
  ".36833033991959030932667397833309035686738124772976314999260e-1",
  ".171893339452053510849834287132337970205695834529451291195266e-1",
  ".55917623141024772453963575627506695748818149277024899029964e-1",
  ".209534591022939403680975966749173653685423615377626946554339e-1",
  ".78682052308900108770290171627763765931604179993573427882518e-1",
  ".245439317186091366222348381370690408714308287808970649517132e-1",
  ".104937671457602190227540942908308061134228414958666453855834",
  ".279310149445183583616523546214524146116224901385810239509889e-1",
  ".134466910810617380523054118905582492958565023463021452941374",
  ".310866479076898911225957190959103107122726309880251864633871e-1",
  ".167025078067112021330383700915334398155807417698089645880550",
  ".339846844366491727015831529132814971519220350037597377054065e-1",
  ".202342383959958362972985153053506390167008836083996260885468",
  ".366011116370094237665660163683302755703567675152933789583005e-1",
  ".240126176968899168224233356644343461834757430322230436354570",
  ".389142495667555765517958081287375656258894801188233961569836e-1",
  ".280063367934141498619920448961437084383941547739564838389199",
  ".409049311679239166350412703003186393596330568796880286524887e-1",
  ".321823024217272962138223573821321852537437398947445209686044",
  ".425566612186630201335497244196117927574529375428422479678266e-1",
  ".365059111809139604052866719920311919387902362608746804048608",
  ".438557530795359777556558431013673986705871515403973568374979e-1",
  ".409413362617199166774126215294713657944668222014445457357706",
  ".447914421368584543559017623657837996409186703856777680930512e-1",
  ".454518243151649794425565722947147458582269585634229763498607",
  ".453559750184112464696983213299413901162595484399857563928911e-1",
    // IM_GAUSSLOBATTO1D(69)

  "0.",
  ".793650793650793650793650793650793650793650793650793650793651e-3",
  ".2910262263438036033418083930016017978697200118873722266266e-2",
  ".488308713551173186068197505568001358889904526372869520376468e-2",
  ".9733824358735135986892640164582302713303219788080891315464e-2",
  ".875429566108385480037077642284003333050015473635308033164494e-2",
  ".20395442065632356939313386116936524790324072357995374042014e-1",
  ".125549307453474245519737490250783875872235712197166623250851e-1",
  ".34810838008530419599875592761124610874360300839405945820132e-1",
  ".162570232140524380592648535184820737764405304850221383313933e-1",
  ".52867044007191820314993176627321115392089361679794841924464e-1",
  ".198318117525624802951900726667762083718433273400473697209981e-1",
  ".74422703298728953822420104511484276456910166162264267565490e-1",
  ".232513653414937702601272990267223869395597034613376885362591e-1",
  ".99309097767714263389391704083877625718872826487498934943138e-1",
  ".264889354353736331377522293809022724879669836489589776537206e-1",
  ".127331450614135488101355047487408147117068961646321803975988",
  ".295191889104587415204374628198706377636677995231865483727515e-1",
  ".158270445424977000122764255726222916704219486323032481533208",
  ".323184121860376358427482013606513916447380526763649098350317e-1",
  ".191883940698043839752754292146172045583056063593365128816039",
  ".348646986284197123716085630445704664352838446313057666860635e-1",
  ".227908864129792343626431528987788870313750002643692608967694",
  ".371381206577376983820166235668961465059230899568548703854584e-1",
  ".266063271145964972492480231988126047812637791897896516584092",
  ".391208859770901871938560251781583361519925641612042444592820e-1",
  ".306048551316981878523298391397129546995201884414105118313356",
  ".407974769419896962821227049754784192651310483704030218406824e-1",
  ".347551765291472805579005496065106911951921308541679211086520",
  ".421547720652459280285283858365322723772809283247874741840979e-1",
  ".390248093915365719377571028403133535052556024564951394134733",
  ".431821487402531978593684316966103586488499515380791027116605e-1",
  ".433803380348669484369373278891413728541394707882927734652768",
  ".438715663932548929200277230895178469054127656824208582404844e-1",
  ".477876745274274830774021756624438303958961828133688588770673",
  ".442176294204361829831312725415819545684929881865679138449443e-1",
    // IM_GAUSSLOBATTO1D(7)

  "0.",
  ".500000000000000000000000000000000000000000000000000000000000e-1",
  ".172673164646011428100853771876570822215395958802287721242340",
  ".272222222222222222222222222222222222222222222222222222222225",
    // IM_GAUSSLOBATTO1D(71)

  "0.",
  ".750750750750750750750750750750750750750750750750750750750751e-3",
  ".2753095273369076010742070348359939567448410911312801353118e-2",
  ".461962162142096482774166633320405376888802403593125107321741e-2",
  ".9209292506511457976729777087081985291983325629290107688716e-2",
  ".828401173104043057169271897734258663476045961746306756436948e-2",
  ".19300132996575956947301154097457405819670689235117825159184e-1",
  ".118851222907757293472040211516973986052094780752975656013303e-1",
  ".32950117265147502935369567669643190827705436232336628938924e-1",
  ".153979717043490422056076317167922455465039488681966810851777e-1",
  ".50058045511696474685489482907425127451447953397224432851234e-1",
  ".187967531019584140098309063752635545024834937048636476937495e-1",
  ".70497216476742737750762768230428896941080242440662451668978e-1",
  ".220563471084378319907626822802762923559860667660349606216961e-1",
  ".94116290708172458169211497301771045287426582300754362233902e-1",
  ".251526341575207784749339086468759584202910043426844423098187e-1",
  ".120740394213215812205430008669331514972976836798828705585242",
  ".280626953869378149435557560171625979334238713050452231282928e-1",
  ".150172408133835283924832685405240126685185244066953380812414",
  ".307649878582428043167937224515648197594485134033195182525530e-1",
  ".182194426326782976013396594854508462565244515096779315437449",
  ".332395057673486681997113855197759367589182420064875343490071e-1",
  ".216569367910650161528799833416366292983136252138266813789868",
  ".354679291822268218785377179041780157719796883665082742033669e-1",
  ".253042732183289583642855762248173702748307319210456832236852",
  ".374337599313591186981700876202297681561990129953313440008841e-1",
  ".291344482683084614324358305388751588119814966697386706384052",
  ".391224438644256910819319092274274768922805638566221271204253e-1",
  ".331191046352117640953484019401893955558401744927103383868628",
  ".405214786612518585566203757953189981873771099833461737625402e-1",
  ".372287412959601623929832670394218532357811675549771077107922",
  ".416205064228958719707311333886249199288574939242016733153076e-1",
  ".414329319223137300799687475331981199105575951244845549885448",
  ".424113903731039686039882519228623735297451578748724688811220e-1",
  ".457005501447772370230567595674369092886199478197784716638774",
  ".428882751085496931999795228396106032363111106613901909592304e-1",
    // IM_GAUSSLOBATTO1D(73)

  "0.",
  ".711237553342816500711237553342816500711237553342816500711238e-3",
  ".2608321602273843335682434654308642805711202419883345051393e-2",
  ".437690699718011292580664543220992641961983349871801590003985e-2",
  ".8726007400734720049957768692287090332934249739031102007354e-2",
  ".785056067815019268453101514748901462089063154074286213765808e-2",
  ".18290574928219560458573804260516166505966955555603966537207e-1",
  ".112673034372094373644086568864959581288239852275844270395265e-1",
  ".31234186930090166165121232872343448903711115800127072096404e-1",
  ".146047604752108619107181334118267363523320008969872893735867e-1",
  ".47465920601384722820054806549674941760584059440318976198389e-1",
  ".178397123430710996917821485323834374131961274977017813443325e-1",
  ".66871883987164071189210144011381067091431592345928968291050e-1",
  ".209495098582465777635993793733058832727942239535884327065540e-1",
  ".89315944019256369138657623668503937163177948821325011648322e-1",
  ".239123526440978065167627104612377349940458689807127537739014e-1",
  ".114640665470153583641692978533602374667893032282580839879376",
  ".267074631860305855960212314896712047579788533974395626002549e-1",
  ".142668410484809640230488909869050993735231580747518210181001",
  ".293152378141241349251990801137479828123147029674364892389174e-1",
  ".173202582860545391541502615529286763719552873451084549011282",
  ".317173858319337830235362216058266898190938725415925925338490e-1",
  ".206029006314732900193884400875800446590353220388103554854687",
  ".338970584012213865510663825239780093164935838892759172704958e-1",
  ".240917426449731721129636773862544636549708086226151683105326",
  ".358389669649849827539368166526360655869871685824625862281790e-1",
  ".277623125658578283348343721017738168820417341855926569901285",
  ".375294905936182194186344920682786594213547331495136353758906e-1",
  ".315888639555976428671096448459971068785799657056522694420342",
  ".389567715781288160056716974399325093717182865143180156347069e-1",
  ".355445562856707514549454966095217202169370740546777937201686",
  ".401107986302569930162663002391367862095252588878384692934291e-1",
  ".396016432016520100089038831098205508434369854769743658372764",
  ".409834771189178238746970558147719230359834204672370861137515e-1",
  ".437316671421115688108552498160873648447587145766483966595122",
  ".415686858562733071136472292986064994352905945183887508384734e-1",
  ".479056589467324023299999775496620818256871272473649654365525",
  ".418623200380010623630035659551221625308456159346748477542835e-1",
    // IM_GAUSSLOBATTO1D(75)

  "0.",
  ".674763832658569500674763832658569500674763832658569500674764e-3",
  ".2474671939260811542137295113705395134066287839253699393802e-2",
  ".415282100389414842533133553674543297575667173333479473350405e-2",
  ".8279758748572888468848376604720459248569327951463213965681e-2",
  ".745020102935311147595569533790023601935687748851348322354683e-2",
  ".17358061461761768171094844587058409763652272384554288099996e-1",
  ".106962511356081793126797089540327294765655481009771727447285e-1",
  ".29648455302341282854810553401876401967984974786668087180352e-1",
  ".138708788501034683662380554243887296961986287335431823088522e-1",
  ".45069023909857413589394245589152558699192531268635768124764e-1",
  ".169531381606039673492162441926212127639853422961031923164673e-1",
  ".63517109910206074247529349969909576359220813487812262076366e-1",
  ".199225566687833597047707026407630048627224063007593890467696e-1",
  ".84869930896453696428493468270672174746547108837579277852419e-1",
  ".227593853493817302025289049747413538164726606156940802891888e-1",
  ".108985381425265534984926200175023863387742285447656840457308",
  ".254447500300617393753097899963225312486866366336065690391906e-1",
  ".135702974188435128515732018898313732338544426723077710815164",
  ".279607819686537185308900745661888277758121981222774589368437e-1",
  ".164844906396823281549240427978294315385348274172430176515262",
  ".302907383058943499093700880337783553112868356709053115151542e-1",
  ".196217242352351797408545160784277320208117412125283658686064",
  ".324191140445195960568110228537024886636107617800441517318941e-1",
  ".229611203747460901033086994238231443702475031433065662788578",
  ".343317454605052301413905402996946258952240239752760282072585e-1",
  ".264804558895472165051505187349916869383473762682393052448354",
  ".360159044626196058603185211303661740979143942696485887578321e-1",
  ".301563101563286226315779355702508764512398955389329586976268",
  ".374603833452485796339564885106846083559717221511240616917709e-1",
  ".339642209528680822206472645596221824271625464666499565108960",
  ".386555693992635459993251919707716264426262127047399614517638e-1",
  ".378788472473218907575862490258835889879031167426649015591834",
  ".395935088967509506425626401129432579271462773600511057427328e-1",
  ".418741378368887968483734545868272874341887355749927687547049",
  ".402679600294562920534157470218518110753803986707646858486821e-1",
  ".459235047131336271935517137416529639891425829075643517052436",
  ".406744344513880729574169210070273927789585328764928572467844e-1",
    // IM_GAUSSLOBATTO1D(77)

  "0.",
  ".641025641025641025641025641025641025641025641025641025641026e-3",
  ".2351035377825551547868980101655862569431121021490587875082e-2",
  ".394550579430030688064753129730538967071597577151678986664851e-2",
  ".7866859641248322632982368489917567413608918146165105351113e-2",
  ".707965377495988657565025801337258016667944812810978551644365e-2",
  ".16494961756005739676181357795382343700656087271315759411190e-1",
  ".101673795316935809257051641262809808307899382273275286214425e-1",
  ".28180117528199178712896564389647326715468277464927353954348e-1",
  ".131905953265707431312740376768836759249327315039797786194638e-1",
  ".42848330154895274463666595980207731546854786833590610054830e-1",
  ".161303589635586977463123344950758998579924523453430828883091e-1",
  ".60406828260330081054968332055202532354691291407053742588474e-1",
  ".189681218503542234963422781935358456174670946679024920853055e-1",
  ".80744588610946779632174610221610852688966904910687409476240e-1",
  ".216859540973789905044370193542954416668111264246864104334783e-1",
  ".103733023699224056594460409438245380868042220723502733729898",
  ".242666769229571625692708629514366902780879230022329137390326e-1",
  ".129226790426307791254199087282338054277477201363034268339852",
  ".266939759857470914774749951652698352261230467959413673134030e-1",
  ".157064707457843143086567573057614297040209400600348038353923",
  ".289525059908930417016206131374094123367832368232881274258743e-1",
  ".187070773622371243300077767573329245592555964531832725751762",
  ".310279882378547624851133290290010165062938791710666836585661e-1",
  ".219055280352638675614802942523234645068087817168438464186374",
  ".329073011114479513315871810868054604810008363637150161901813e-1",
  ".252816010937373196673324405450707371582160483296961781186646",
  ".345785631380405672279939641982813028139398626108521901651821e-1",
  ".288139518922224507624830845354098223522267668366030927830731",
  ".360312081510271476102923208703382114752802893420972207218481e-1",
  ".324802477542909561009806022173167826166599175502610163779238",
  ".372560521176946692893122992991291496452356004983651116125272e-1",
  ".362573091642837816741192576550944601169348978124418288528204",
  ".382453512166982531275880973755442590143451874227990878652014e-1",
  ".401212563140544614078186948095178532102996863100951644190122",
  ".389928508043402903635499956985507337103926157571962987918124e-1",
  ".440476600777514453241327450849009005346070957463233614866164",
  ".394938249626821720946121126148036473285527343334908855792049e-1",
  ".480116964598909049926317028960270740396467356619038601123016",
  ".397451063807748204355745797756548264229349951716399335845339e-1",
    // IM_GAUSSLOBATTO1D(79)

  "0.",
  ".609756097560975609756097560975609756097560975609756097560976e-3",
  ".2236436277357819255995320113922661750681005260622960018399e-2",
  ".375332938142579426457515630008223393629554752298367693219890e-2",
  ".7484070437637611873046971503870244441006388081147680077264e-2",
  ".673603554723530330878458015686946579273772564206311776003950e-2",
  ".15694565216159084967031730429579535282488221351581985153941e-1",
  ".967664928312583995295180796355001886153343715293863720648751e-2",
  ".26817900176253939399732987826159198387431708961290634060214e-1",
  ".125588491968005432561293633017565885251867555092998440832597e-1",
  ".40787064651048093400070908115362253048510712552267279574016e-1",
  ".153654645489612292839923989483105431296422566529253867415263e-1",
  ".57518013915192438609832217066614927391115550854073240102780e-1",
  ".180796517223447562552530537238077041669192649027479936596727e-1",
  ".76910113948004078890614438028834303395034786139966002270368e-1",
  ".206850980777863203789367903535388282408169024806531173030973e-1",
  ".98846733020954109291896186970382098467806113203742902288688e-1",
  ".231661381743258072398053185315871682141024436203884639325314e-1",
  ".123195939056524317542550188405951390092253447850209345848742",
  ".255078524739932567287635101471641207150273260581957319081162e-1",
  ".149811291609658521102303381165514169168370930624996196319688",
  ".276961584594571552696229330277973698993301253260051864319867e-1",
  ".178532721967707288561505573451967502920668505541506264855076",
  ".297178958317718278723954553146968952248527965648634527771220e-1",
  ".209187495542393655987201121567238746060388622971813945874570",
  ".315609058637748977076148623708337298289786395299507632372531e-1",
  ".241591250576435341511237624892102967642903586906037821149154",
  ".332141046164213530218620252758263084509885206249044563766775e-1",
  ".275549106842585750520185874219273932886731673368652712476916",
  ".346675496435474475625063482580372929024542430434576146668709e-1",
  ".310856837634458397670191064976821026038444343626653415856440",
  ".359124998098819852331497146160352863532301803183690468837452e-1",
  ".347302097985277128937594513154519289827657968801273662582600",
  ".369414678736948031845461928001725814938508599187136851071216e-1",
  ".384665701720234870575461807683108028756410451543451388860425",
  ".377482655229589863952898204502061639157676618865547536274055e-1",
  ".422722939658079999731179114483697361774071788000960700963668",
  ".383280405966587352989169325407892726243114276809848207213996e-1",
  ".461244931031872862203044976533880894441059851041339288105890",
  ".386773062686527742684602733321455023957771112196016582182922e-1",
    // IM_GAUSSLOBATTO1D(81)

  "0.",
  ".580720092915214866434378629500580720092915214866434378629501e-3",
  ".2130014973241862403239154440835813787644494178213878053286e-2",
  ".357485348623332367781372287977056989778815825498933580629272e-2",
  ".7128535246650194555784006861283334909392173178521725268806e-2",
  ".641680277915691233602508120907591529518767736991316833296508e-2",
  ".14950951686121191441143395521812901330719792478110478376354e-1",
  ".922049152233308741726234475016060068690524021342923635222162e-2",
  ".25551847277282754202423014877782890230032191433247511485110e-1",
  ".119711592053952617902178034733779544224798761994888058113815e-1",
  ".38870392870691911584906209221833526216612228185663883537856e-1",
  ".146532056080828509352077630837136223798150304924465777209278e-1",
  ".54830270081004241996044481482895212669203933482674646244014e-1",
  ".172513021995584454253504455300300096158935790504141365584831e-1",
  ".73340050639674828418766379677625862508500921465488178466378e-1",
  ".197505776008757505296596443388991266342808420396691356421340e-1",
  ".94293707103288929389996240196133534098436668931885676268099e-1",
  ".221367200151445862405958631765407587854833553819429240042540e-1",
  ".117571216286762424687877775674816296658247895164946320590636",
  ".243960634801903661581675555033133185054703146165089564227029e-1",
  ".143039245342599228759883512176782992749382700139216588529016",
  ".265156674690784643109565252536619642591390066931226457576378e-1",
  ".170551914898702236871038389766852360653699237594383973693557",
  ".284833914918951335223793176492375529113321734073247607678646e-1",
  ".199951634375680407019134993778783317835812498562421458993998",
  ".302879648312720439303585406967718794279416711145883105145136e-1",
  ".231070004518703353820149648212890407998798182980035504483978",
  ".319190511878982742660790191824769898212221916197320513345725e-1",
  ".263728781902576208602402687512353346042130310013826254467490",
  ".333673079284013231910715227040492709323475291349523632786586e-1",
  ".297740899854232116046606736231242045882872992662246190563204",
  ".346244396209694768203703137820464169359230276938331274431343e-1",
  ".332911539930270323590711140184264293773583929551131664381795",
  ".356832455626750371811882456503049745891805137209323822660773e-1",
  ".369039247804924867330237544680827353338139453153223577505676",
  ".365376610311358305181098396854171362329442288657952001328421e-1",
  ".405917087172924293723636992388996537878487397742960973716033",
  ".371827920265964104007460433048151546485715759771508291106438e-1",
  ".443333825055672951681777059724035616647711785074387826137402",
  ".376149433066355845973999979516174367243841247437328515965734e-1",
  ".481075141720198188743167716094101722738382944261647317152307",
  ".378316395535566218846060315652187665736169681656481289776894e-1",
    // IM_GAUSSLOBATTO1D(83)

  "0.",
  ".553709856035437430786267995570321151716500553709856035437431e-3",
  ".2031011621110680190392559512741142391656960744073378061596e-2",
  ".340880659903645093182071710398386069695757086678081275701077e-2",
  ".6797728682012419172860861462002553424688243897162482032428e-2",
  ".611970483206979935161736808753590906439741429005782490540155e-2",
  ".14258882476158002581027032623438363707269088742218870040269e-1",
  ".879574383413396429056736013998988404807721570838658989636717e-2",
  ".24373140336313281632608513266114346659159621646596595335226e-1",
  ".114235462795142869735079011168031625191558076312263083793359e-1",
  ".37085158573451160872183336632899866315092365958436207533726e-1",
  ".139889081288056788114695954694571204051388612751204518545775e-1",
  ".52325479043522137813684963889143416107135619776185915708824e-1",
  ".164778506637712590421481699578470661279081842441323601343604e-1",
  ".70010853408122301541834334636505946959122648369207887158126e-1",
  ".188767899442060750040635738959656478885411877854076636335674e-1",
  ".90044685430522411089807348432090188682159741452396070712702e-1",
  ".211726274419210792651271587235558989479863748011318654694840e-1",
  ".112317554850322960930066048976142785364354801913595721304040",
  ".233528256564494667799617757658386566275912798617341935930806e-1",
  ".136707813662189288650372633984387123416009224280756405458106",
  ".254054778516898017394303128133876051260929354486413575964850e-1",
  ".163082249961771942101817377534845869083769831872825338411290",
  ".273193735434767179020446199872927753653911758556328695029297e-1",
  ".191296815249017688466086224404338721195305110886988039895498",
  ".290840599140433387120145642072012149683695633248674203901569e-1",
  ".221197411044723034711488888159126525528410946124673881118302",
  ".306898989854110637510360869004425385522575459364285488106104e-1",
  ".252620730455767241399713577441113986903760494705917203065746",
  ".321281202991736017438291825941555514048550420394475095924870e-1",
  ".285395150062953388744398357156598864664713238410587718351984",
  ".333908688385343362579844156371097319692639460331972473015586e-1",
  ".319341667246347227621198552852784979905407759187622471406986",
  ".344712479409720433085095401031806254183302056739295970905483e-1",
  ".354274877821827260539138397910631370449004197599020952639581",
  ".353633569718021368352582136329218013749993186232232080667093e-1",
  ".390003988645686467867795968806079954179633942162686028109754",
  ".360623235551306315500769505178629849308248296454074162957819e-1",
  ".426333859654779673291965960798544879991118202377498742372342",
  ".365643301873181549007084566917425595912755026244036288622497e-1",
  ".463066069649794077389994303412493857514440710577161634104420",
  ".368666350882108868285682432790438585451312062271539892581568e-1",
    // IM_GAUSSLOBATTO1D(85)

  "0.",
  ".528541226215644820295983086680761099365750528541226215644820e-3",
  ".1938752606604335046167493578932337702048977365458123199234e-2",
  ".325406131073805581052964560002151091936796397760560542290230e-2",
  ".6489411035083400924898417091765610026574951624640195471259e-2",
  ".584274448545860725911986776200257517397905868261829574973056e-2",
  ".13613708495944829588640207496012029306254151753444943838038e-1",
  ".839959613496088728697088770095108635249415456410948809155864e-2",
  ".23273946308461230136293433098194745050295489068991639758520e-1",
  ".109124679285766319964744794545246164230982147293061541268449e-1",
  ".35419662057923250309681161404230553337213978612363590702842e-1",
  ".133684002700582083047141407508858976698018035098179005775827e-1",
  ".49987505451089976888429156111125749022151388346679644876448e-1",
  ".157546199835975296589024822626144732693529553605439121196326e-1",
  ".66901516011532147629508551269220636477015549120096605061866e-1",
  ".180586957763399529284792612825609597283356769373870920040996e-1",
  ".86073507290187419679502483895045626480636931666703407965942e-1",
  ".202686187426964956456875050058338980169070149400352730364361e-1",
  ".107403523097560355770242630882954245728188255780104018956813",
  ".223728688631270810618679099502651424273240663999173282440800e-1",
  ".130780357353570756657766972608598916401467243395506293390922",
  ".243604762676462647921192255356368928364360572428638073493328e-1",
  ".156082133336727909811009468320680532954177299840481425744770",
  ".262210788637971863337049910181526034693152624649500167685630e-1",
  ".183176938850735564238113240202313474280649635257397387397866",
  ".279449765379130781136963292649945786567330160913466510661933e-1",
  ".211923513833067574621014274811208964586284433470499464760845",
  ".295231818068887946354687913769264953510704524725620278221758e-1",
  ".242171986755442531710957558754110835888623482126684600970071",
  ".309474667133806346157276735089591438328055557047757724285698e-1",
  ".273764655948580910305133994603280968972205676289697930558884",
  ".322104057424413142524707743253055683814265969471296647918043e-1",
  ".306536811764494607352006062472777275406252337182228312825138",
  ".333054145454872679023658294238724360222983757296364044292226e-1",
  ".340317595283317646953383547612769205815505430839315665444694",
  ".342267842741378236904551900034422559043516221351680869309297e-1",
  ".374930889084302549773033992698954690686487826347629184460340",
  ".349697113470796273402538957717757371033503502637196706520095e-1",
  ".410196235435001879831163897481272113126697025047343649504726",
  ".355303224958656979096712265105608516141572741190089806874846e-1",
  ".445929777110521717543722097092571088022364607084626977972015",
  ".359056949596564966222120314835550887825415289023120800972788e-1",
  ".481945215937189225092677887462567354114329138931406538911954",
  ".360938717239367190188118789204774269654872482744545843139420e-1",
    // IM_GAUSSLOBATTO1D(87)

  "0.",
  ".505050505050505050505050505050505050505050505050505050505050e-3",
  ".1852639065455764190223453663763580301185435400182929169937e-2",
  ".310961515787432974926375820127318877648810171429281677395492e-2",
  ".6201590379346714488154038902104145162567115445360380515052e-2",
  ".558414449829248193413710066299480050503461330708794420073933e-2",
  ".13011292496514063775196935983592104609650554419785656267509e-1",
  ".802954474791866068605392063406602081754682060314855922356481e-2",
  ".22247288695948450216849336671970590685593243732876885106227e-1",
  ".104347623581986327316161011835775330877632260697982469263383e-1",
  ".33863471697232096926713470693209784926007991302622093478801e-1",
  ".127879497090759854985328597668951137560190682506952897685396e-1",
  ".47801943367846714306057349925055704987107775447765500492788e-1",
  ".150774128767679695976959993110117974724369167916837313700534e-1",
  ".63993252928775869825725395835390457175210749255919148797184e-1",
  ".172917548039949113358684816293553622705039312581748128389252e-1",
  ".82356731670004411363065543782943264728088628377164042577679e-1",
  ".194199470731552237632447597287493533590732641989278346460412e-1",
  ".102800891464849473929190557875770339463192974875552509630689",
  ".214513885655687538529240880154259265107544557201334307731317e-1",
  ".125223879340968043831679393544553217169043565098228582459325",
  ".233759594253490311906255844163923333457112384844821988153685e-1",
  ".149513984402646864874221564519874112121450854921711089267499",
  ".251840718926238709268533577769428245051046814229671455528944e-1",
  ".175550194137607570404087040235198308104283161370778817473149",
  ".268667182393854135437130865949649076423130267617822086038248e-1",
  ".203202797180182832379556883427623811773544514767132445531750",
  ".284155157218153210197636065045344644251179751436108730133243e-1",
  ".232334029465653996780528686199510939845112947729663769074386",
  ".298227483795771067916945672592901135801661267075820011176314e-1",
  ".262798760529552091224104320842602921456984428140690072720684",
  ".310814054953220582226340970770093522368947186657767135047418e-1",
  ".294445216520128400157085338077508729959554064927808280838928",
  ".321852165320173305045609651424045569886042604513420772792919e-1",
  ".327115736315665345759113052917725641358487343786950581389517",
  ".331286823782698736420682032094344685704043079964933954018274e-1",
  ".360647556976372941605782910022285799849032506892368678946444",
  ".339071027480413053385913127901461962909674926928323532950564e-1",
  ".394873624615965762131787389890078745661613761220956458243648",
  ".345165995993011310138391519335070386770370978239941172380772e-1",
  ".429623426652153295605953252359258561971949741015104953032242",
  ".349541364555074403315048872807305216513462691363339662266838e-1",
  ".464723841289188086736482114576454458645094916136012422177589",
  ".352175335339640217687071570684412719998122987562225824461046e-1",
    // IM_GAUSSLOBATTO1D(89)

  "0.",
  ".483091787439613526570048309178743961352657004830917874396135e-3",
  ".1772137147592048723585683258751486256219796009078414059292e-2",
  ".297457437272017910788031218577733513965939565925192898913483e-2",
  ".5932490408894802889920640390165570705567443672804413980450e-2",
  ".534231920006649280428341342793611089416546889464720497296071e-2",
  ".12447943001596602498561306500387750910433119182741698223195e-1",
  ".768335329026155829039388130308936607472284565385753407485793e-2",
  ".21286937844302621429841468862969128897309715593356083801892e-1",
  ".998760070080439136484642016165300425755691021533898777649254e-2",
  ".32407263196693067623143405815308738758224316737423731348758e-1",
  ".122442098083296887217891440021187295513584393116453498360141e-1",
  ".45755899930062439594689120156188783517640147596749431178682e-1",
  ".144424550896520150667362001566922186671363092373722348380670e-1",
  ".61269226137982310458311710275787091294923892846644258173520e-1",
  ".165718694467928916813457728779945714870656963935785161361960e-1",
  ".78873309531678610326550083843385364085069279296301590669407e-1",
  ".186223084271987725154747573710696175531991995596359426271837e-1",
  ".98484256535526884945721196234562396150246847748431331828162e-1",
  ".205840021206053335200389139739259640350134595535374144570746e-1",
  ".120008610913335660957144321375699769878137864336430405149836",
  ".224476028164542332533854847267585043542742108925156628288603e-1",
  ".143343798647944004108521350915435200171121770545193835902494",
  ".242042299483425676999670730676884861487223218749938366655599e-1",
  ".168378616532068938026929459819304728980935763039599873261850",
  ".258455125766098410835265926678504150179145890802105615146886e-1",
  ".194993761992253283074712573881451220989363090759950168844740",
  ".273636293525995089110693718355153146499664040978579311961439e-1",
  ".223062401561519866716749865606971408079223164179217380201352",
  ".287513458262062702382921970999086881022390445904353956096245e-1",
  ".252450775265802380138480110825989297251448090364159274784968",
  ".300020489394682165354164998743990765039178017887355476018993e-1",
  ".283018834031850446122376722380670642446294623817986074297069",
  ".311097785506338185088408185323738216544398284960539937993630e-1",
  ".314620907073032286403970731443035815155051217465660378097052",
  ".320692558425211851752476745264673022400211487598274066068827e-1",
  ".347106396069469512394744290200390543078886295041882626222762",
  ".328759084817583729287434872817473756520078141179069966129754e-1",
  ".380320492832679197981032635321399011478355128849903032238425",
  ".335258924100151746024136576714821003912300893690846151336898e-1",
  ".414104917033727989605054416562223372487705177730327520632875",
  ".340161101639171675407431075991762382586363830590580272338941e-1",
  ".448298670478694064741356563842938051788403127350474487877666",
  ".343442256366347234235488694442734811702735848565179247913248e-1",
  ".482738804336601950819712944730684398282065328179462360972591",
  ".345086752109679834994463019029235342351263980761995861963242e-1",
    // IM_GAUSSLOBATTO1D(9)

  "0.",
  ".333333333333333333333333333333333333333333333333333333333333e-1",
  ".117472338035267653574498513020330924817132155731947880336209",
  ".189237478148923490158306404106012326238162346948625830327198",
  ".357384241759677451842924502979560464040498263636787304090125",
  ".277429188517743176508360262560654340428504319718040836339474",
    // IM_GAUSSLOBATTO1D(91)

  "0.",
  ".462534690101757631822386679000925069380203515263644773358002e-3",
  ".1696769728939655449898193064058979113147692941686231949592e-2",
  ".284814004579613276904969787788933959722288779113844221512666e-2",
  ".5680523040958664339276124068956443398270611517275247834068e-2",
  ".511585026628736256296323122679567152040184987392116500015580e-2",
  ".11920357965141415004920015886274028407356967311186933337004e-1",
  ".735901924619743094040248778267157455436635719545670489519940e-2",
  ".20387317246501714903152477743559299031618034064997393291782e-1",
  ".956844605254190108414427001338055507383620620665770445170308e-2",
  ".31042682030677588381984236606523485573155786913270218674872e-1",
  ".117341732314406645340203242277662575805019410755781455926038e-1",
  ".43837809720681058791117594863264983503192358905592071760196e-1",
  ".138463461058774436790338982838289879331934342345625571790049e-1",
  ".58714309922328037835366887425420773274979254396278832136762e-1",
  ".158953354913401888098186244414653161342367497068342973313697e-1",
  ".75604300535408071087346394823240292931186801120282029204392e-1",
  ".178717953593316583099411475939818348359765799964522893060309e-1",
  ".94430714396705480613101912543060593613934938302335376481836e-1",
  ".197667088832067336257586076723582217440375205147855088821752e-1",
  ".115107649804958993134266364754029423854603211924582555467658",
  ".215714306321770436514247155190267657065057329026814142941225e-1",
  ".137540762009425744934813344270391320004938750696659919781565",
  ".232777263997014167475125693709443434154662959182885045208739e-1",
  ".161627693471821438412452406637291737170680054118718598939691",
  ".248778109299393523214602881081278937736420435843877180137207e-1",
  ".187258540795076704124066966585725110260153017141681322452120",
  ".263643835098714713670670080197867641797551486922248888113491e-1",
  ".214316356131434762642242093446086310969405123979614399906438",
  ".277306613145176420475212409499902425398412185383995898076844e-1",
  ".242677680757295432130537908025927953958438563483072474263968",
  ".289704103727715975699676023441150745970196876900695087671035e-1",
  ".272213108368622852835807177769872742856328209628737769287290",
  ".300779740209915151361730092286051071671859910887328499249488e-1",
  ".302787875520952849390571135095282993987655003166877396397740",
  ".310482987183895435468513436537075718446673443064696469155710e-1",
  ".334262476516927449161461084304161739690048959301202007492872",
  ".318769571083136363357987384644647672036229304435256571924040e-1",
  ".366493299934102232426005454625987412623387753218658415485594",
  ".325601682211610430002823178134310228509294105003021060728896e-1",
  ".399333283887744948154017674237221151370745498675328191319840",
  ".330948147272555844853125102605252459699147682072027280152169e-1",
  ".432632587038246536725681008255847904682336281381798396724198",
  ".334784571612513733206425986460781389785265679093853557693488e-1",
  ".466239272281142725079033433812637613533109893369804594978188",
  ".337093450533211611767721608787997709570411889297429585857465e-1",
    // IM_GAUSSLOBATTO1D(93)

  "0.",
  ".443262411347517730496453900709219858156028368794326241134752e-3",
  ".1626109330071267797692072373150016091366800561742908280450e-2",
  ".272959630012405961009479858389372425873586410364006061356753e-2",
  ".5444264993182136054224912442190918077150018274740761981822e-2",
  ".490346598945016402657017219271948547391488206177544494332458e-2",
  ".11425576554581613560070007104095043923383495161694568027564e-1",
  ".705474530274435661850367771325717272284392764292385689623821e-2",
  ".19543423246809204947244124334471781785790146137279068055338e-1",
  ".917501823760954073425201590173472527425514147949208103637512e-2",
  ".29762225332459352400338559594286690381964618830439084104138e-1",
  ".112551318684680422493836155239295800950732403333716346081554e-1",
  ".42037275011876789961233097281756528387856659972859651313942e-1",
  ".132860162954556585611528552193808956139629660259863010569099e-1",
  ".56314887840889951402168458167605467458447478538783387727340e-1",
  ".152587988106518212647424126912057746209904343951026089276239e-1",
  ".72532627580612964865258133078257278641958388279673463454464e-1",
  ".171648558503369184900919708965030603617275212931346605194058e-1",
  ".90619576257197065651154095149458433347381527009430248381667e-1",
  ".189958539633640782628430487539298225760459551428038748231570e-1",
  ".110496643200078089014710348324297512252557573502229674823132",
  ".207437872594236455622705693211860630268345858752098807296161e-1",
  ".132076910443575815618797992735766123078165725128757937730684",
  ".224010127820358052401764957597527850306045091246694393282729e-1",
  ".155266012594454644813548785923602037587381614888049006750448",
  ".239602840783677503303225882899489732715839746227535504882171e-1",
  ".179962549367021431085899757304374861658556892978888520748500",
  ".254147829529723486272190054073984326908260875395145040256082e-1",
  ".206058528927257409486881345156247996361595481134201621748840",
  ".267581493143374656127129209960036507222492460567042414744269e-1",
  ".233439840083611519447607871358310327558895347186810952589156",
  ".279845090025744177913604329779925150998710474985794923503074e-1",
  ".261986751248571460989158039946768179130510664304968826927674",
  ".290884994846373158289330197596056995846896164932903719828291e-1",
  ".291574433983648665043461141450612493361955039487285558319691",
  ".300652933084220115254355592692242133584800401702743643364172e-1",
  ".322073508835546978089045865326849964674751818553522541760306",
  ".309106192149896834036141040942375738842042880302092994269709e-1",
  ".353350611075120367320458598110245687961630200859749624162232",
  ".316207808175189928311301691370251854104006948477846225003503e-1",
  ".385268973864377714836997239192243185696629610112453147371659",
  ".321926727658005882664811970026114708507434548194771017260133e-1",
  ".417689026300954686261069853020323979637339482473438599424843",
  ".326237943258629117880384094278807875687447482603815798217729e-1",
  ".450469003724624943826487252830972982282971600685253570373713",
  ".329122603155040085475607753462479983419325383469304048838413e-1",
  ".483465567616923544454465044416054545545986087120742547936831",
  ".330568093480008970966137318336211903031292036985036578727243e-1",
    // IM_GAUSSLOBATTO1D(95)

  "0.",
  ".425170068027210884353741496598639455782312925170068027210884e-3",
  ".1559772044988536141210199773977409150490164680117038911430e-2",
  ".261830014988887259563935863018485139727201813954910838374717e-2",
  ".5222437690384632145835700007457761000616745954765953793651e-2",
  ".470402348142779723919375145510615183114495461477211400827596e-2",
  ".10960937749313992060591848547946117619560209197606326818372e-1",
  ".676891469079090859891470759180269218726816302388615632381805e-2",
  ".18750756003373635024204975860174371618279735385099275038308e-1",
  ".880526340839155315858465234470358141605790272792996492172219e-2",
  ".28559140168400121020356404088932574869892079538856385979010e-1",
  ".108046421204110038526866569722095561785211755077330167485954e-1",
  ".40344927863707754672192318387458150878713119818488522338788e-1",
  ".127586895835683523671063538157555326838948317502226507537428e-1",
  ".54058676986778786457045135493621556127236949910063505098953e-1",
  ".146592173549215013551753638826809264969175747054954011051597e-1",
  ".69642863597605257426513795804140126017182604470282336093928e-1",
  ".164982567528625391083075752875274411495645969658756188201038e-1",
  ".87032120357464631215331146970598491187961615068836065019521e-1",
  ".182680954066883174214759246093200773560561797483369257793217e-1",
  ".106153509678172995431868812078757248993758707847144824492718",
  ".199613105717952217128759102019208283647371242334497862979402e-1",
  ".126926829224110158673616911259136220282679940462584318222687",
  ".215708006135082351065060713625550215437102879770957692810786e-1",
  ".149264948114473522931935601427497057577452017108565047384866",
  ".230898149367786367327616174083112349281637229109600451117080e-1",
  ".173074172283893765679279128772201125810439557547535218830872",
  ".245119823646127035778100772975780875082381128962639955273047e-1",
  ".198254637416616749703024608095569570400397526707818191617897",
  ".258313378919823267626743142974550409864465078204245546242808e-1",
  ".224700727783385993879640200601789693261321020813356290418250",
  ".270423477210676408622586286609668663454708086573523449464831e-1",
  ".252301519213623799799322759771019620267742049910036628943100",
  ".281399324805679234443375248190117769520407570473986746607751e-1",
  ".280941244339629079687101646274462647985909364682983475305240",
  ".291194885352455119748011905728358332667542480719736835590711e-1",
  ".310499778158615563055157713879855576395961236358344908128363",
  ".299769072980525943834928892783058690420517281073192193044490e-1",
  ".340853141874449220197144967634195539263961368183778278754894",
  ".307085924647234634798085568692838455330341607447550569836385e-1",
  ".371874022904926905770183740610334187888700220811836235359886",
  ".313114750990163424470553374507762154874306011523088229860040e-1",
  ".403432308872989645021561828462592204651725234501777358314910",
  ".317830265055933206782757635432555518066692429018412813384681e-1",
  ".435395633341810033507140423637509871973147751685415387120958",
  ".321212688366941661852634921836253118408120512190053953834151e-1",
  ".467629931004550435468020473483192600957162652997563240667649",
  ".323247833882029222779612695198074406430971512077501264269653e-1",
    // IM_GAUSSLOBATTO1D(97)

  "0.",
  ".408163265306122448979591836734693877551020408163265306122449e-3",
  ".1497412318678206881921358217558194701674587978913997349860e-2",
  ".251367277487082886318422299890915057280669786922133174417333e-2",
  ".5013889970989598988773989337041792253079749347212573348455e-2",
  ".451649334344980104967080915294628614341233753582643594265367e-2",
  ".10524044676640095366345039696956508628589486487249252571917e-1",
  ".650006990610588032825099655424251926419655479744302018600803e-2",
  ".18005259945015693933062775775160758762893203501328082311869e-1",
  ".845732774193188301159757103898438680805373274927166687082510e-2",
  ".27427335659559293115903742940004674265484849501618513860019e-1",
  ".103804947485079967196479167792166315881683003622497783859986e-1",
  ".38752310748623626671513971937442545077317602058313291278024e-1",
  ".122618508590847471574748553952270392106040025094605595382356e-1",
  ".51934575461583683619222842677711603962983025127776567745414e-1",
  ".140938277255301245831251301479793549266149815887303811150183e-1",
  ".66921045911323344516141737824237158935973114976505250116796e-1",
  ".158690513032853193754500903763001784921112453222749569689286e-1",
  ".83651375101771023606481683295151022396208737472067598861524e-1",
  ".175803745446736248147692900469209726464018280448182015174971e-1",
  ".102058194941135765306482920895896074021495385435503873817302",
  ".192209071054988672812292052225222158529342535475864066343762e-1",
  ".122067387102973480469793788671964231463976631150549033693528",
  ".207840434261842463663558942116438500247618335282250363505805e-1",
  ".143598381288177070072785052052548168271866254325871398048060",
  ".222634894672363711152290367718674245084598341754398509483202e-1",
  ".166564479560477592052185913823750859442769030784031712585308",
  ".236532881146183614267571750553987382699615342454941334284665e-1",
  ".190873205399235414583091006568492602750311943799646031952236",
  ".249478431966716880232269772599339848985246013614786729103630e-1",
  ".216426676042164787135531053982202752025924783095344474289128",
  ".261419420332167317077977737047894719696584720102934782778645e-1",
  ".243121996608475627966224314729235699104669572988681730449703",
  ".272307764334653076463357256031863292678284196453193983481533e-1",
  ".270851674410350120362588016904056941148292714904999812755077",
  ".282099620616050705138089800424559163187805788572878068664591e-1",
  ".299504051781800759550391300211777655902213034956096508289519",
  ".290755560937370500804734631635276753169808856958853145216894e-1",
  ".328963755680598078185463754556447943885251037241606456273320",
  ".298240730959167270733516166702495328974062521193160116114718e-1",
  ".359112162252045243988518033879827535926947480619414245659005",
  ".304524990598163955014613888961342696079578112286585397034995e-1",
  ".389827874483471761967173409196401593899713807507542608731809",
  ".309583035397430895091388461375596690765152082711379378157848e-1",
  ".420987211025798548506742691744387048947646596419300489768388",
  ".313394498422840053734287516708961911104140862429346167014762e-1",
  ".452464704213671676119178501855295653052361153467163545972086",
  ".315944032276333166071090952855062433397999678907591436310530e-1",
  ".484133605278688143544033920971533277260372259705714356083484",
  ".317221370896264434221455959768672740100955723332145714659200e-1",
    // IM_GAUSSLOBATTO1D(99)

  "0.",
  ".392156862745098039215686274509803921568627450980392156862745e-3",
  ".1438718440505553000778287765546161339467588801705260798058e-2",
  ".241519198925399992634537536123539989504955183055196160536530e-2",
  ".4817583156244205210783465248650660140408273051598576039058e-2",
  ".433994642071096657562598742170917284213593278170768657069161e-2",
  ".10112733795203954834179361623596764004514441087183314227896e-1",
  ".624689429243356295138283855610665008366026675180669349488784e-2",
  ".17303272262056345232914286622408523502130942017424694956540e-1",
  ".812953461730908564676215112569504982620738298750638378846093e-2",
  ".26361306845552478838602914864690438977775264057745361411459e-1",
  ".998068862226839188348858388036163204477506242318964490823927e-2",
  ".37251772927948219400608199554383702227463848873139480554308e-1",
  ".117932174612492943418359297797194761204775855737874038395979e-1",
  ".49932529658387783709340512574335547200370302127787944783902e-1",
  ".135601157368362000192527643905320668550867029814244088147125e-1",
  ".64354514234396966558659702363730474741074318539767952788773e-1",
  ".152745502365992465022400795734437045110014963677896755022993e-1",
  ".80461929101112867180292180761244532519820592763970367721930e-1",
  ".169298892520024019054491366793985687616972676486817951557901e-1",
  ".98192456877179849949575280519931176690113830577918789149014e-1",
  ".185197291265852075597308729426518934400395687302238187291688e-1",
  ".117477501058215892062348388644163860561404497365725864512901",
  ".200379193533530478706927229476522519852254528423221328019717e-1",
  ".138242451224404284115877756879100162134125677162901970034738",
  ".214785865016768320595928688982810371562439429111377994789793e-1",
  ".160406971604743480130757230809093546030007609921015974706618",
  ".228361569995172596022015255541037053750774267312325756961983e-1",
  ".183885311833304000964812294230758914239579581015037756385945",
  ".241053787250391920478301730187441427385863016397854690678928e-1",
  ".208586638674256880707011897454547229996015224235294465421524",
  ".252813413407355477327850991902774656947952831389594202426744e-1",
  ".234415387422475742967816923929559707793463594623338481285306",
  ".263594952985287598105251130475744401514323151123984298742742e-1",
  ".261271631615326365584482062275156027193435269002417978231028",
  ".273356694455988704330265624279951068279751258604703012739106e-1",
  ".289051469622739700432554628309368562728751697432827094380026",
  ".282060871644186306051759839117850642532525580209101761040391e-1",
  ".317647426618522356642121403022075008484210704251771695938842",
  ".289673809853680093381620882734751266132517504307773513353363e-1",
  ".346948870376954884920913838883342131970142723184144046959478",
  ".296166056158298748594162978980489043886068727334117761634691e-1",
  ".376842439285568544503412205602937848650855659559686989094672",
  ".301512493356009335274362744745266502196236654144761000401301e-1",
  ".407212480917913530917513550945242868886164339873049613007823",
  ".305692437146692533026118545996596983955956967562142611244606e-1",
  ".437941499469383861600073292950993971132836467217719758014642",
  ".308689716158432008820826382862959692917491854041606532010468e-1",
  ".468910610324937954931831239108671291576409502416561969558262",
  ".310492734513196331363829924961362257148189573767670547862835e-1",
    // IM_GAUSS1D(1)

  ".500000000000000000000000000000000000000000000000000000000000",
  "1.",
    // IM_GAUSS1D(11)

  ".33765242898423986093849222753002695432617131143855087563725e-1",
  ".856622461895851725201480710863664467634112507420219911993179e-1",
  ".169395306766867743169300202490047326496775717802414964592736",
  ".180380786524069303784916756918858055830760946373372741144878",
  ".380690406958401545684749139159644032290694684929989324909302",
  ".233956967286345523694935171994775497405827802884605267655812",
    // IM_GAUSS1D(13)

  ".25446043828620737736905157976074368799614531164691108225616e-1",
  ".647424830844348466353057163395410091642937011299733319885768e-1",
  ".129234407200302780068067613359605796462926176429304869940022",
  ".139852695744638333950733885711889791243462532613299382268506",
  ".297077424311301416546696793961519268326308992950314936806478",
  ".190915025252559472475184887744487566939182541766931367375543",
  ".500000000000000000000000000000000000000000000000000000000000",
  ".208979591836734693877551020408163265306122448979591836734694",
    // IM_GAUSS1D(15)

  ".19855071751231884158219565715263504785882382849273980864180e-1",
  ".506142681451881295762656771549810950576970455258424785295031e-1",
  ".101666761293186630204223031762084781581414134192017583964915",
  ".111190517226687235272177997213120442215065435025624782362954",
  ".237233795041835507091130475405376825479017878439803571124572",
  ".156853322938943643668981100993300656630164499501367468845132",
  ".408282678752175097530261928819908009666621093543513108841406",
  ".181341891689180991482575224638597806097073019947165270262411",
    // IM_GAUSS1D(17)

  ".15919880246186955082211898548163564975297599754037335224988e-1",
  ".406371941807872059859460790552618253378308603912053753555203e-1",
  ".81984446336682102850285105965132561727946640937662001947814e-1",
  ".903240803474287020292360156214564047571689108660202422491541e-1",
  ".193314283649704801345648980329262907607139697529717653563594",
  ".130305348201467731159371434709316424885920102218649975969984",
  ".337873288298095535480730992678331695714021869631513455586476",
  ".156173538520001420034315203292221832799377430630952322777001",
  ".500000000000000000000000000000000000000000000000000000000000",
  ".165119677500629881582262534643487024439405391786344167296548",
    // IM_GAUSS1D(19)

  ".13046735741414139961017993957773973285865026653808940384394e-1",
  ".333356721543440687967844049466658964289324171600790725643390e-1",
  ".67468316655507744633951655788253475736228492517334773739020e-1",
  ".747256745752902965728881698288486662012783198347136839179021e-1",
  ".160295215850487796882836317442563212115352644082595266167592",
  ".109543181257991021997767467114081596229385935261338544940551",
  ".283302302935376404600367028417107918899964081171876751748649",
  ".134633359654998177545613460784734676429879969230441897900290",
  ".425562830509184394557586999435140007691217570289654152146006",
  ".147762112357376435086946497325669164710523358513426800677155",
    // IM_GAUSS1D(21)

  ".10885670926971503598030999438571304614288795540107792287100e-1",
  ".278342835580868332413768602212742893642578128484490741742171e-1",
  ".56468700115952350462421115348036366684162124387342807516294e-1",
  ".627901847324523123173471496119700500988078956977017503318812e-1",
  ".134923997212975337953291873984423270975178468986934844010811",
  ".931451054638671257130488207158279458456423740201017058907873e-1",
  ".240451935396594092037137165270695222759886442440035755489538",
  ".116596882295995239959261852421587569715899086158479254513645",
  ".365228422023827513834234007299569237660189068780473859188037",
  ".131402272255123331090344434945254597686382338801572278190025",
  ".500000000000000000000000000000000000000000000000000000000000",
  ".136462543388950315357241764168171094578020984947391873798800",
    // IM_GAUSS1D(23)

  ".9219682876640374654725454925359588519922400093134244768659e-2",
  ".235876681932559135973079807425085301585145369974235447802636e-1",
  ".47941371814762571660767066940451903731201645393351226722962e-1",
  ".534696629976592154801273590969981121072850867351624400025028e-1",
  ".115048662902847656481553083393590962007537124990534181167790",
  ".800391642716731131673262647716795359360058652454320889552036e-1",
  ".206341022856691276351648790529732859815450742975973759244864",
  ".101583713361532960874532227904899188253259073637295073199278",
  ".316084250500909903123654231678141219371819929332295189344100",
  ".116746268269177404380424949462439028129704986099877437365261",
  ".437383295744265542263779315268073435008301541847277863393539",
  ".124573522906701392500281218021475605415230451284809415697675",
    // IM_GAUSS1D(25)

  ".7908472640705925263585275596445194467504719037062545652996e-2",
  ".202420023826579397600107961004930300209932728724944340674059e-1",
  ".41200800388511017396726081749640243804762604944158352052358e-1",
  ".460607499188642239572108879768985604618419999311184195442782e-1",
  ".99210954633345043602896755208570054847192137604749985051308e-1",
  ".694367551098936192318008884344357338109313591316491138226614e-1",
  ".178825330279829889678007696502242174964151300869211571305429",
  ".890729903809728691400233459980489977564063253305082514933362e-1",
  ".275753624481776573561043573936180066099039166279121060520858",
  ".103908023768444251156261609653026381693291304599751774609572",
  ".384770842022432602967235939451005582394228812058234418265370",
  ".113141590131448619206045093019888309217378868807778509932485",
  ".500000000000000000000000000000000000000000000000000000000000",
  ".116275776615436955097294757634417974078313738653398993059332",
    // IM_GAUSS1D(27)

  ".6858095651593830579201366647973599161954296380387059177964e-2",
  ".175597301658759315159164380690958903098528046385636382909002e-1",
  ".35782558168213241331804430311062867761480394795081190641019e-1",
  ".400790435798801049028166385314271547918488926972973826023319e-1",
  ".86399342465117503405102628674802519480149449262459409219646e-1",
  ".607592853439515923447074045362383129783346728450373361465086e-1",
  ".156353547594157264925990098490332931230799393626414662190367",
  ".786015835790967672848009693119210783028340186686616874843807e-1",
  ".242375681820922954017354640724405668845557358715346981524248",
  ".927691987389689068708582950625785181244613014686658295099871e-1",
  ".340443815536055119782164087915762266582869398233078021701675",
  ".102599231860647801982962032830609027855169530654709725858446",
  ".445972525646328168966877674890082626194024197262881221479590",
  ".107631926731578895097938221658130017637498779027064400109889",
    // IM_GAUSS1D(29)

  ".6003740989757285755217140706693709426513591438119255000001e-2",
  ".153766209980586341773141967886022088608740724167170371332114e-1",
  ".31363303799647047846120526144895264378001863242347771049318e-1",
  ".351830237440540623546337082253336692333540163771653599145555e-1",
  ".75896708294786391899675839612891574316871912631503682952136e-1",
  ".535796102335859675059347733429346517077718578790509903459543e-1",
  ".137791134319914976291906972693030995184550352707948718224288",
  ".697853389630771572239023972555141612604251376577556216003480e-1",
  ".214513913695730576231386631373044679380806801858625197573368",
  ".831346029084969667766004302406044055654500900492064536609347e-1",
  ".302924326461218315051396314509477265818623611920650872484418",
  ".930805000077811055134002809332114122531130061389642014077767e-1",
  ".399402953001282738849685848302701896093581772768681160192025",
  ".992157426635557882280591632219196624093462799787709967423680e-1",
  ".500000000000000000000000000000000000000000000000000000000000",
  ".101289120962780636440310099983759657419331079004738678398352",
    // IM_GAUSS1D(3)

  ".211324865405187117745425609749021272176199124364936561990699",
  ".5",
    // IM_GAUSS1D(31)

  ".5299532504175033701922913274833686286862964171177434974388e-2",
  ".135762297058770474258902862280090517561336877833803989881559e-1",
  ".27712488463383711961005792232695827454430363704463699537223e-1",
  ".311267619693239464314219184971888471374932541764534289453924e-1",
  ".67184398806084128059766051143803433806332307576236645948244e-1",
  ".475792558412463924049625538011231131776317515918563290816126e-1",
  ".122297795822498483052449402576278865823093171771248495109122",
  ".623144856277669360262381410960082100724434296111013399734514e-1",
  ".191061877798678125776664117975604490504058891117171102948102",
  ".747979944082883660407508652737392744852455341039182334031950e-1",
  ".270991611171386306828790278508211213229984193482238254549422",
  ".845782596975012690946560395151799811058197367080141408725981e-1",
  ".359198224610370543384769749269751946756965254614700099725582",
  ".913017075224617944333818339846099696917781118273246412092481e-1",
  ".452493745081181279907340332287520968434823472155467271651390",
  ".947253052275342481426983616041415525734544941979514875187562e-1",
    // IM_GAUSS1D(33)

  ".4712262342791332162282990029667361746105074770217848608046e-2",
  ".120741514342739659800550131437826623458486579725126391475006e-1",
  ".24662239115616119388641521052098489278307476720445646165016e-1",
  ".277297646869936005647200826791223302564231259766144234813529e-1",
  ".59880423136507048938522152755922153688291591032786049824045e-1",
  ".425180741585895904417676850955310369252456946092527378620328e-1",
  ".109242998051599296537384972239761974888013763629715743743342",
  ".559419235967019855473941928131779633679217121315385250049005e-1",
  ".171164420391654617074848891678498832426097054262013378097384",
  ".675681842342627366431599908511750986860629266172445101892847e-1",
  ".243654731456761516056876715685224062708538138794413547043634",
  ".770228805384051440407157974009793059702415292355089671931906e-1",
  ".324384118273061842351407241452326997479730124212162488340420",
  ".840020510782250222549853318941615775105990644825370071349659e-1",
  ".410757909252076072074661253172967221262290333654237178218524",
  ".882813526834963231626354950565986195754622090003740590215712e-1",
  ".500000000000000000000000000000000000000000000000000000000000",
  ".897232351781032627291328221309428107243901599488342618338347e-1",
    // IM_GAUSS1D(35)

  ".4217415789534526634991997646924614873710531577280153540162e-2",
  ".108080067632416551566713551332262346938426157377949727896348e-1",
  ".22088025214301122409402053535111845013577932594346760577306e-1",
  ".248572744474848982266674731013193208404331230644551011256253e-1",
  ".53698766751222130396969704436427242296052364323850892906267e-1",
  ".382128651274445282645648388083182628026589531041791437164298e-1",
  ".98147520513738442158791272492704601448350539194038759124786e-1",
  ".504710220531435827814069924624173035314005694438394508044142e-1",
  ".154156478469823396062554459355575805273864713591246120548918",
  ".612776033557392300922595634001007776140819486667195485792206e-1",
  ".220114584463026232696064225737335431536186757114645291680006",
  ".703214573353253256023656518759736140477512051654862799412761e-1",
  ".294124419268578676982034103083474181460505158939987244359426",
  ".773423375631326224627090019181873860966091981336770863333095e-1",
  ".374056887154247245205513572561044384918569117170179770989864",
  ".821382418729163614930268882329637952061694769986764766222611e-1",
  ".457612493479132349378869073532108094133341306546955039978318",
  ".845711914815717959203282350674933051670529096851719401349378e-1",
    // IM_GAUSS1D(37)

  ".3796578078207798405491164873369753205341799298394606660160e-2",
  ".973089411486323851815602073221921787645330453464332054134874e-2",
  ".19895923932584984573610579656174236692454248362930947041092e-1",
  ".224071133828498001664190787009971059758771137339288010608783e-1",
  ".48422048192591049178669535733843756095303032971322091152484e-1",
  ".345222713688206132903541290030065224809240158438065655866051e-1",
  ".88642671731428587510538756643643049112730756896584979315068e-1",
  ".457450108112249997322310470619198263304558256482993923397750e-1",
  ".139516911332385310691452069588109185171429083545666612530705",
  ".557833227736669973580119508408829987406659269199468877610763e-1",
  ".199727347669159488265180917526880360065838958633853716206706",
  ".643769812696681138377578924284385585279197885467315172753363e-1",
  ".267714629312019527141366425947948816011857142687931701507846",
  ".713033510868033058878730547209514862378341724122369304633874e-1",
  ".341717950018185084004941335575077541053857390433556377422136",
  ".763830210329298333894277004488314992305041336182143117615432e-1",
  ".419820677179887312065951942129628225247563249764562310562678",
  ".794844216969771738249782197325236008393900790975630478755874e-1",
  ".500000000000000000000000000000000000000000000000000000000000",
  ".805272249243918479895818126604583675199512792892584510641616e-1",
    // IM_GAUSS1D(39)

  ".3435700407452537606938805764339860888676434549172051925908e-2",
  ".880700356957605915593098117592640818107155277166836617087430e-2",
  ".18014036361043104366166934401361389043969836096905571968231e-1",
  ".203007149001934706655199761374660549395453199949757681496613e-1",
  ".43882785874337047066123779398350943475407601288154112602059e-1",
  ".313360241670545317847532675935208031758005382892181820840377e-1",
  ".80441514088890588302735469149239657335185317467181313373754e-1",
  ".416383707883523743623790716110231030500889142915816454573766e-1",
  ".126834046769924603692847464822179204844634660215411777930227",
  ".509650599086202175183750677401749380833458280116962781486420e-1",
  ".181973159636742487273581651886857031628305441600315768030276",
  ".590972659807592086561886888556911435025206097744843877255830e-1",
  ".244566499024586450997817974522374500787254335398786583263826",
  ".658443192245883134492472498740815674580552555734917634980915e-1",
  ".313146955642290219663725911487536381302126839147158644086026",
  ".710480546591910256646491625335824665172577066960101516687970e-1",
  ".386107074429177460959751902315712687628455531158536263842682",
  ".745864932363018733939143685009847183463399520406841582481140e-1",
  ".461736739433251333122679795300580894497601866593251249597602",
  ".763766935653629253490421659775487967459743225561892986373505e-1",
    // IM_GAUSS1D(41)

  ".3123914689805249869878982031029535403330772608835407209563e-2",
  ".800861412888716666211230842923550763294521105895124102838633e-2",
  ".16386580716846852841688892546152419287653156335076575023514e-1",
  ".184768948854262468999753341496648330944721540743649187233885e-1",
  ".39950332924799585604906433142515552920426195175889151411932e-1",
  ".285672127134286041418179132362239787456437984131280205911233e-1",
  ".73318317708341358176374680706216164861947098410328014628504e-1",
  ".380500568141896510085258266500915896130771762119830142722936e-1",
  ".115780018262161045692061074346885982589511647114315224565636",
  ".467222117280169307766448705569660442417633236807964225415575e-1",
  ".166430597901293840347016665004830418701485328344298578762266",
  ".543986495835741888317372890350528210168497978969281652914971e-1",
  ".224190582056390096470490601637843356688969887884660167497847",
  ".609157080268642670976835885628667991781688127807687251170733e-1",
  ".287828939896280608213165555728105973951777384080182707887871",
  ".661344693166687308905262872483878021645057700715784116087933e-1",
  ".355989341598799451699603741967699840045490868176983385622859",
  ".699436973955365773610667119337915554463965804774598021868743e-1",
  ".427219072919552454531484508830656834941836987781031121289256",
  ".722622019949850295319135832768762718049749810985499173762376e-1",
  ".500000000000000000000000000000000000000000000000000000000000",
  ".730405668248452135959925738416855941224047884709827220536614e-1",
    // IM_GAUSS1D(43)

  ".2852707258800353963484289419350509803472900801984232511488e-2",
  ".731399764913610034249554902359272259510597456216186396383505e-2",
  ".14969751082285636438024506617365644597015538431098515220131e-1",
  ".168874507924070773966511234329564506745846572372373303338209e-1",
  ".36521613906412999739653530370473401682335173313974008977714e-1",
  ".261466675763416429701560256366056280560750467846181572502817e-1",
  ".67093711139849931731787181490310635457601622205776921936454e-1",
  ".348982342122602440474807094651088286993875264775402636205681e-1",
  ".106091597010395918997861022295824239305910664334218420939154",
  ".429708031085338637072218406863514330945722026745398918192088e-1",
  ".152756368406658609974655082118871614366328855011282419439133",
  ".502070722214404824660394189152681411754055443838498128712705e-1",
  ".206179798246544203520561536180676325561192198213141080114983",
  ".564661480402696091967003037108921595571316660604973521378168e-1",
  ".265322081006621486796834644516796826952328104434631726101950",
  ".616261884052562121427804930774072359797224995024839862136541e-1",
  ".329032089553957887420926289786310190220413350414656328001569",
  ".655867523935311853664824962651537229378709470940153265626250e-1",
  ".396069786655889357260576733040227132892162445451033175165674",
  ".682707491730075856762869156157586982931838264943430840547327e-1",
  ".465130363340138889393079101940685959088851850259884262646659",
  ".696259364278159966877051241709049789369601087287129290630986e-1",
    // IM_GAUSS1D(45)

  ".2615332501223938238037142277212819713186313770564789536603e-2",
  ".670592974357088604065474672930753248830916705286861636132717e-2",
  ".13728764390942384021987961589611312409193102323013028754372e-1",
  ".154940029284897221553471098209422526918862644999640320879279e-1",
  ".33514456586991948825401505480788510882149089924304614653550e-1",
  ".240188358655423342858205358160169982806081541517558066355781e-1",
  ".61623820864779166310921557032927164180535485019674682545300e-1",
  ".321162107042629260635848075794554990195791378774034159176963e-1",
  ".97555799190580053924440796501610721029284930134845988707284e-1",
  ".396407058883594774614462623710216134568559959692032513625311e-1",
  ".140669318434024902769187758125690575835035127434353602122610",
  ".464578830300175737385093086848823243017300358715649469172774e-1",
  ".190195062118176921807451344175202173306409670596453852149567",
  ".524460457322707050370430925073719274292357915969875027409252e-1",
  ".245249261076996225155103476066576784727578615407571188386406",
  ".574983201112056824708217564669806507457052614647928033058239e-1",
  ".304849480984854584289255563559697270710974574653748259390398",
  ".615245421533647652337892003360048274079264062732352872181265e-1",
  ".367932159514827534733065230858345198510493374902930197565460",
  ".644528610940410749892976696998968266298577485958917462221543e-1",
  ".433371587850766944534128658879116931494797361873308921744528",
  ".662310197023483086858212323516584629025178347371117621612565e-1",
  ".500000000000000000000000000000000000000000000000000000000000",
  ".668272860930530876757285552729221692915764038184416587409683e-1",
    // IM_GAUSS1D(47)

  ".2406390001489319910001295149631594062701153701998561279200e-2",
  ".617061489999359977340283353501864578795502044568326545155346e-2",
  ".12635722014345250900804003495915469129408473479910640094203e-1",
  ".142656943144668315906539079759391432245988989659540756642033e-1",
  ".30862723998633620738175499145639275172590170961274326682486e-1",
  ".221387194087099030843013741056691144296564209169289522942175e-1",
  ".56792236497799482893422829008901622456333478345539979814481e-1",
  ".296492924577183903731838792500542922706000632826067445460607e-1",
  ".89999007013048539023025063665127395961936761166072206378010e-1",
  ".366732407055401528670168076265582590596682549242497355925449e-1",
  ".129937904210722817878085948450010787238353756492907271566809",
  ".430950807659766379585926014918713335925402941189665026242442e-1",
  ".175953174031512215373752106544626186665170850690521609850533",
  ".488093260520569441349403322321235772139594844268429720354183e-1",
  ".227289264305580232170812191390813814994608003706190912283193",
  ".537221350579828173912886712233031113973143450671100108966138e-1",
  ".283103246186977430756457884043325143773789244536015595959600",
  ".577528340268628006766722419533917799311351556882482352912704e-1",
  ".342478660151918312806603354340094879606760869587591365622885",
  ".608352364639016956022315767381312128035147796019028893888088e-1",
  ".404440566263191845420680089621465184079797448342623321925540",
  ".629187281734141480606876912555918443632016627906727020890417e-1",
  ".467971553568697186957478458687627480704500402289626303287824",
  ".639690976733760784870280826123476859258556197708339412106500e-1",
    // IM_GAUSS1D(49)

  ".2221515104750951045607526553049191371218675297595914394598e-2",
  ".569689925051314397395148205661738680166026314645485088931376e-2",
  ".11668039270241244250842306760202966127314722342796627664506e-1",
  ".131774933075160686309509076476495724679816408516612312539404e-1",
  ".28512714385512830292994415170764734047399214695504929036274e-1",
  ".204695783506531563278117438558229768304228916820521545276222e-1",
  ".52504001060862315574478996608597522912722575123208048469149e-1",
  ".274523479879175959629684457702366620800549927765556779346890e-1",
  ".83278685619582999289489445653215215269517943088239606989568e-1",
  ".340191669061784586035935928283539842773547471773182815800366e-1",
  ".120370368481321184711358567397819511806238990550832939540805",
  ".400703501675005090066174798345556511451128664268379473266340e-1",
  ".163216815763265817757439683376188912058291635963625341470172",
  ".455141309914818249057486103514458266904962794796671553576696e-1",
  ".211168534879388516138155079193672966302132480354240871677258",
  ".502679745335253221011034451963429134942330472640709535712704e-1",
  ".263498634277142519738908942495403979334091130769186354546384",
  ".542598122371318265580469785250583096700387939933610080749932e-1",
  ".319413847095306081132089134936179666288960826478312465102710",
  ".574291295728558241696627729347779043204680958340900747957548e-1",
  ".378066558139505783977404818601274206797183421837007761789432",
  ".597278817678923861140890632564505236950883507068632127598256e-1",
  ".438567653694644801806320090595981597233897326975108130788053",
  ".611212214951550208444797594729257529175296237815295204537932e-1",
  ".500000000000000000000000000000000000000000000000000000000000",
  ".615880268633577256019514365395250712191168137590758326956760e-1",
    // IM_GAUSS1D(5)

  ".112701665379258311482073460021760038916707829470840917341242",
  ".277777777777777777777777777777777777777777777777777777777777",
  ".500000000000000000000000000000000000000000000000000000000000",
  ".444444444444444444444444444444444444444444444444444444444443",
    // IM_GAUSS1D(51)

  ".2057149427191535498391520338546987021571072440220166301736e-2",
  ".527568630867150357782559384262598895217286858984729841099277e-2",
  ".10807277021764504449709822844036847276541718126340748757292e-1",
  ".122089255463159543948079137598942001202479630986351638456128e-1",
  ".26420466669142874932042358240981622739644831157842364990866e-1",
  ".189811916471813819751515706244252473453852108720244429656440e-1",
  ".48681069007846462891167200384394874329437997313547313722417e-1",
  ".254879126485739059991599503620366897629396592714859626374048e-1",
  ".77277028605750990601246469266080919213962448954335215284912e-1",
  ".316370231647874177697268449535225478611114210063472548378178e-1",
  ".111807025589660571903516376378858066511890871872402563918416",
  ".373420748828298729435378980514241693193735809405203438227732e-1",
  ".151786369790021367568093043135287651069623341104590424147722",
  ".425229471567426196052238825399908482919601583883391380766492e-1",
  ".196653853491190968384010626541556472782367713867045054810678",
  ".471069001779570742318324415336515992745828729571036399104923e-1",
  ".245779642587747141152148467637215412311846622907124593139450",
  ".510295805472127116192070351267153961636044056771210051689654e-1",
  ".298474122438256846759461311450558448170031295150341908705430",
  ".542359202642882953282897133639987911447191017106533222654342e-1",
  ".353997580257021552428582308961084851557640306518504810893828",
  ".566809082731598332747203592212990726229751814625076069943000e-1",
  ".411570589821554908015471125790827625011308118099367869259826",
  ".583302217426482910223312537701811068159824406109621082300800e-1",
  ".470384953285343396453140712400798319604882632305482208922864",
  ".591607076396311382581855428502343423249451354144526590471604e-1",
    // IM_GAUSS1D(53)

  ".1910368555505716530556395809385004869655972217064406149182e-2",
  ".489949802564718013057502754562954904911290946754577229389193e-2",
  ".10038262019249388572063322169476407716178889305024618380570e-1",
  ".113431157980903115980171032233807444063838601440832013007928e-1",
  ".24549721092647496574045984678058553453705033257791174533092e-1",
  ".176485268787098555112891446523558205680694447614708916400462e-1",
  ".45258839661254447849677490895155372525977832202519520443386e-1",
  ".237247062603075313520483550570923591123628100830923631881896e-1",
  ".71896045990852754848631388646578601117856500698247086511405e-1",
  ".294917684299167995551504168597658165826202953532060747291953e-1",
  ".104114180464745886427801327946364633540299467126068243796360",
  ".348744118831227964921614441783336380664123466284760007566007e-1",
  ".141493263130288150352591894178830225124663973950718428674392",
  ".398024338865288856315374795049212014880733364935014763696804e-1",
  ".183546014026752429536132681182755693948461991215331651352444",
  ".442115792718784750971614014268745555282683750255495550451659e-1",
  ".229724217710271552549849529220008589520409775506409154812831",
  ".480443636850142537828263232790529295801058147685146671995167e-1",
  ".279425874124986559707012922155359273776157702418450305927306",
  ".512508189088728993356238557663319046622049474573586649349515e-1",
  ".332003048180745550134840482896357729104989990546202904637506",
  ".537891428942665936060814922133287024094830495318823327568367e-1",
  ".386770317280231570571380446319884914410276633535898161676686",
  ".556262441784225963360815480214243374164601900425416335482026e-1",
  ".443013707195235016533552508065011686413359733010929502617123",
  ".567381730544825743101849740460496289602622594052360129482063e-1",
  ".500000000000000000000000000000000000000000000000000000000000",
  ".571104336894784945225228684509176243403607216750826651608737e-1",
    // IM_GAUSS1D(55)

  ".1778751213022775024781804758344504124934783951787047707164e-2",
  ".456214129654725886940807696147585312017224554914550660120882e-2",
  ".9348417314563623152720027096084861777922523373430845161987e-2",
  ".105660562963856298757501904966327172256846753616427201142042e-1",
  ".22870359685530901372949080147392205498298062956024162292643e-1",
  ".164507138911521899888154095852660229907654087100486310071419e-1",
  ".42183486803933963065155288335036426823751602395439245669250e-1",
  ".221364673795021139197939388266036953074970563542834150100848e-1",
  ".67053738712802475528872716310156597829068584607886831511226e-1",
  ".275536728378583727157414591134727956095289821128326670648088e-1",
  ".97179314541410414276057022287361170664149292595844165894656e-1",
  ".326364619834997978966987833877523181768177155813035043632989e-1",
  ".132194560993184113985927744853732815991969490003479053385736",
  ".373231071172843895119659435865110190108179306031667214997289e-1",
  ".171674452980567519390050911746628589215199154875035019084148",
  ".415567086144506091951982491221662399305672067219256667584600e-1",
  ".215139764094299140345998358321784533437643657171676386089985",
  ".452858721965164204710930156683920649114287427272424362007250e-1",
  ".262062887522440869482794076166282978686391927310672024295444",
  ".484653289989649579252445030477203008825165616782308024663614e-1",
  ".311874241955460644889321395221956508564153011478388544827824",
  ".510564837890303849071083192528560675232900011789602704673807e-1",
  ".363969186182410961161586821937115132587619351653238523750162",
  ".530278829614232089552082184984054143949614813425797584154425e-1",
  ".417715358933309614359264111054417271427137292199415911752857",
  ".543555961291470676267857596518366839376392273330219838285650e-1",
  ".472460355057982864786741736329060011074602004469583158127331",
  ".550235065082375981411881328009088069783127647456158166393343e-1",
    // IM_GAUSS1D(57)

  ".1660278869701706918404233725323057174113273374559998900922e-2",
  ".425845193937320482713190665112490150119944489925922329545331e-2",
  ".8727247369293412564536992106811521946609025546784220487440e-2",
  ".986604252806135299192990082019781557480328409518075681357093e-2",
  ".21357202110956137100895981509588218131220223022951464718235e-1",
  ".153702461010468113222042626873083748735581304843547746818040e-1",
  ".39409883523470607453123281958446787295580328343853200765504e-1",
  ".207010312593414180524150050570384607667453901942871416181689e-1",
  ".62681097539948604791103289371710726544691568440479314636390e-1",
  ".257974134512489619562971905897712989598110553230710888811999e-1",
  ".90907256192373777505213892710607512184989219058853114431483e-1",
  ".306015453285395692710549240119535224620322698895650786702768e-1",
  ".123768574132761433043694961393930904893704015885506695794001",
  ".350589666275256392847907434744395865511974443373867882904207e-1",
  ".160892731198656742421907497304007036805868534992677418638095",
  ".391191635678818919140724443298401656834395384798348541769259e-1",
  ".201859101430886089810206894405505109960906594807211180763269",
  ".427361286830862637726724246486040356908491283067966976423569e-1",
  ".246203522437886178948686040186239923324388079807707917907468",
  ".458688785696293816739832055385554034491145104909772856545759e-1",
  ".293423555912995668054646706984191588338280740631843040110808",
  ".484819170472043031509500374413443795881781389609017821339655e-1",
  ".342984181066180032525902038404476275870775590454586259351620",
  ".505456368799574830609102734537486818237836394262625995610741e-1",
  ".394323856916999462746812135548531250471674591143952425980800",
  ".520366550388646869566642356425600344553261103377338458218338e-1",
  ".446860884933660384914508803784811509541402280352196431857112",
  ".529380775486604707032956639260939465374156568711390199140755e-1",
  ".500000000000000000000000000000000000000000000000000000000000",
  ".532396908591571221232555634548387841650925158064979898764866e-1",
    // IM_GAUSS1D(59)

  ".1553257962675229864184974540652358329558980941124604945953e-2",
  ".398409624808330280773294173733681122524034829357528462330010e-2",
  ".8165938360126395014983709197168599029841072645144318241410e-2",
  ".923323415554547957115106595602363454810326698408944270205290e-2",
  ".19989067515846243891564487209101168534820391298038300257169e-1",
  ".143923539416616846748595898056460218197944472731443139569613e-1",
  ".36899976285362837060337861459762997956762731587335469544482e-1",
  ".193995962848135247984009682231738460166004883831978991637044e-1",
  ".58719732103973659228441768734887204971655426426757883965837e-1",
  ".242013364152970264514690702114037589076359045986863096412310e-1",
  ".85217118808615801278550940133749041780465651914829160596524e-1",
  ".287465781088095332408608447010280643985603353608814454323822e-1",
  ".116111283947586902541011329512748434152558191383545773396753",
  ".329871149410902475640642575579811806187214768283302519255515e-1",
  ".151074752603342101533853805986679965808823099673022671810138",
  ".368779873688526031341219250110953670768852630185247067286903e-1",
  ".189736908505378569429761221784405350396317653585235933702474",
  ".403779476147101076773474692302648654379464018542196494999700e-1",
  ".231687925928990050367915103344463602917910996534851447273628",
  ".434498936005414899011937653575628512883766643717726717904837e-1",
  ".276483115230955411609695049838572999918796203069287795122762",
  ".460612611188930643588163535438093835984566172091170537761313e-1",
  ".323647637234560943264481396455313069673184495989287186702908",
  ".481843685873221298197343131759049325482032307150801229544970e-1",
  ".372681536916055076780097435091097446058605348348740786917857",
  ".497967102933976335313901410517847382649346318333521386106470e-1",
  ".423065043195708226518102663628372039790724014377830769140518",
  ".508811948742027522982144760842770223163531447435634204321297e-1",
  ".474264078722341152083487393416638713125429273166715217872420",
  ".514263264467794201706428183527075219341877785324641112931593e-1",
    // IM_GAUSS1D(61)

  ".1456259090261462972186722888448745874277332941465184603938e-2",
  ".373541578962438792934843751610620351107542624202510562803061e-2",
  ".7657045167423757998767416632657644530740865242678164527136e-2",
  ".865931039515529123157899804341057068313643138399752792839955e-2",
  ".18748037453525169105473797947070849051390257423720811613324e-1",
  ".135045095924897109003043540459660780711783230010616525163947e-1",
  ".34621501051675917521527120135368243593301156370958981772332e-1",
  ".182161369561927320121960052339017211635726660238338723735577e-1",
  ".55119985025864478312903995508920369228201294067404525118434e-1",
  ".227468537636005514511579289473148386317763596550146330939371e-1",
  ".80039839926866329956547732029910821972631349462625238584320e-1",
  ".270515412124584268558331295433100213601947312981057090368840e-1",
  ".109133425791687529796819989902657754452294813993300559967562",
  ".310873932805142134551717718433483335793643996823257244053134e-1",
  ".142111607706573358047014567316757022054903261915205783685946",
  ".348142916177051830838780631275628552575428536986717095539229e-1",
  ".178646638537869826907790898383749273004154658331896621745348",
  ".381951932993883082131788374506653224628784568471043264046710e-1",
  ".218375419296425368639527538202419286025698863416556484507116",
  ".411964958807946319519116837159808853078841332783231394338284e-1",
  ".260903108977548759779702980321757125780238314251288437580920",
  ".437883703042389380630990348476665461146290798856021257689810e-1",
  ".305807049195883528469324269356239949007446866053227982121094",
  ".459450569468207391076814358035750627486554126895789020804671e-1",
  ".352640965009149191691048051164147830623572407360820721531852",
  ".476451214561597564036020987437983422706623691234795113558581e-1",
  ".400939400332214685613793501983583031112602593919222560006599",
  ".488716676931643625467370054894983519178643943380475572547919e-1",
  ".450222343923829239837412604940529633080502320611236346969886",
  ".496125056133361539374377572143075070087716099777815348906019e-1",
  ".500000000000000000000000000000000000000000000000000000000000",
  ".498602723967132257137669168671747198216267057501021757428074e-1",
    // IM_GAUSS1D(63)

  ".1368069075259218227509435667479636430731168135269420349440e-2",
  ".350930500473504830020353186942659125668861036446620349033744e-2",
  ".7194244227365832299912477684549010683802142832096840894609e-2",
  ".813719736545283530258528110319330908977148189760051551273466e-2",
  ".17618872206246784613094035940862519805552389778490640338994e-1",
  ".126960326546310297278762948946120146437770237734749673160293e-1",
  ".32546962031130155414540432582295337235664283858581390770798e-1",
  ".171369314565107165513438661261863534974201014558166792768214e-1",
  ".51839422116973938017346378140393865760501751602120211718192e-1",
  ".214179490111133403284393233030627642464054287994694744361674e-1",
  ".75316193133715014933153497516128730522556603475120383449890e-1",
  ".254990296311880880980816223447608476300923883698817413431132e-1",
  ".102758102016028796518451350514785548952260299180582273374621",
  ".293420467392677735726418186500854433750602337287735719448686e-1",
  ".133908940629855159806286667454366426684864758246685449589430",
  ".329111113881809234188250318534693864387682236866232700599344e-1",
  ".168477866534892399512442415668380815511488857019747349491458",
  ".361728970544242531126996782392438958021684916509124253812050e-1",
  ".206142121379618835479627261799086570774529942272789713648410",
  ".390969478935351532358704594141533355198933992410795952579353e-1",
  ".246550045533885304988126262811089384909858150200282268012817",
  ".416559621134733776110995373021743057693734419714172298750297e-1",
  ".289324361934682327317940281913786760832061355683778334729170",
  ".438260465022019055713857313759011437742248608508786111498016e-1",
  ".334065698858936175110041597134906001902112431597470081990885",
  ".455869393478819423564342885558185312724307066376950026610275e-1",
  ".380356318873931462727698395417249239695572289019873492226452",
  ".469221995404022828195901188340586300180500378731182250254294e-1",
  ".427764019208601753257406813200594673898077004342182223931024",
  ".478193600396374297095410011020655502974452540810027754764978e-1",
  ".475846167156130841882593714779748918154576374134575551416103",
  ".482700442573639002833824150317878973684303156177850343661588e-1",
    // IM_GAUSS1D(65)

  ".1287652876772391366915991209797919460885494559319039641480e-2",
  ".330311392379368902932461760423692751552958125160120929175121e-2",
  ".6772136884678755944812150867687039205414442892174450138472e-2",
  ".766085075646733806397288426683093337876767739037924887362976e-2",
  ".16588545155003615535811146660703877390842831710006700176634e-1",
  ".119577740508747401752666287645931210330041805722620220536622e-1",
  ".30652813694415824822082437818223143692782757951726587051695e-1",
  ".161501793161644766407807236247156440341263615253421879103567e-1",
  ".48841616128283208479734334240619196262397220904540942521724e-1",
  ".202007706658347957817048952636992480834313941913305787276297e-1",
  ".70995173661747967678469259926965763336324465551639967101432e-1",
  ".240738714093558478350734400690598248708755743384861102984785e-1",
  ".96918821862916705101899564608611412151144690932276943826438e-1",
  ".277354233158317806424722477196295552102542035751103613388139e-1",
  ".126384751775218921070472437551025865572855956768087760693460",
  ".311532412651587400158138628854488057108842137896566356141133e-1",
  ".159134020015128606865892026540335932665532409642852985538630",
  ".342972864093283564029775365074793262436805464701943196898800e-1",
  ".194878827081810486346356243230951284296828534555983025455234",
  ".371399274219770746712360879592360233550491965981276655556312e-1",
  ".233305047606826178225552867502253937273667453887788765321734",
  ".396561823974433691819541924709987940443440146961493210580118e-1",
  ".274074991363774652137003361379616473100614132804734411286811",
  ".418239380335193538069640072588302987101638432729130081912155e-1",
  ".316830371125963329464889688373064444351532659449929914180897",
  ".436241438094221688036408354727232282833480356469511441953321e-1",
  ".361195451423751485298375966350839497122620835360878390542326",
  ".450409793303192886198718527501118105936853410397457424942648e-1",
  ".406780350586004213832100620390588006081327848588417329195327",
  ".460619933216584231066204888586815303607355016019908602799609e-1",
  ".453184467072633307164628537938731139339247110923681559358987",
  ".466782130327980580804995631371377324760019930443154024831091e-1",
  ".500000000000000000000000000000000000000000000000000000000000",
  ".468842230801049982836522707731743921922366819909133406433742e-1",
    // IM_GAUSS1D(67)

  ".1214123104579040378313781272685384299745058657535113530028e-2",
  ".311457027795434235930323053571889306226366421489374131946721e-2",
  ".6386091796845257475124784450157513525614925669933890382796e-2",
  ".722508137429751770760110516437349534377021679234891345657485e-2",
  ".15645868733327859117676713472003244516095627323263332003966e-1",
  ".112818609927474850420470443574771306245172941941152959202890e-1",
  ".28918801297446454184161987269713548496897153831441220893249e-1",
  ".152456903192230659047211938406587955153134226948135320474266e-1",
  ".46095161140837765599550055490356269918801213598423952979268e-1",
  ".190832968981937581608829601449882794119735030633338369228717e-1",
  ".67032680832717765368213954664350077651682349131608465670203e-1",
  ".227628057616766362269112816976353014991192094981563343768471e-1",
  ".91557886049533167704210546706513370803425044512873048940318e-1",
  ".262537072863390530841229874212337998293598404734848382724788e-1",
  ".119467561685063492906295515510631583197750316636901539159992",
  ".295270679137622465969804861752630954142430911732519921387503e-1",
  ".150530443391868546033499946712111408681117984272121844788278",
  ".325557607770382056892722150324468867918186230364065686919429e-1",
  ".184489136459735727341112122240495861094551372963278234477402",
  ".353146879071278624995193982838426775005813602454529948934944e-1",
  ".221062249665126678631770056891862709331279310977323052261491",
  ".377809873300159656354169871142178620294096347406707333240265e-1",
  ".259946727404836482902948659746301445706322525548047107932946",
  ".399342221698859223694094164032189967752779359860971498499103e-1",
  ".300820361120677029684252623533824235328768935172175892676360",
  ".417565498499228275935101140230746952903577969287733457988421e-1",
  ".343344459330268376270841617174511002614385067207753529714247",
  ".432328698735178748921234281403737901570353454509087862491226e-1",
  ".387166654191775258065679409532826377823905139476009723502324",
  ".443509489178469346435382286824403563721415033519020654831156e-1",
  ".431923821370408512052785587834441084251359691117731858947096",
  ".451015221853203647869711210087469644205147500253153178474879e-1",
  ".477245089023448728625462164574034918084457924906397298987787",
  ".454783701651299368076688019742889799623028081301297200578062e-1",
    // IM_GAUSS1D(69)

  ".1146715450199851369918430343952637403362681414493341703851e-2",
  ".294171671022154248787694812005631201537715889910189082945734e-2",
  ".6032117778074250982441455407257007343495852142912822621943e-2",
  ".682541417418074613320200146025819198699701892068745991098960e-2",
  ".14781191980385083392464758707614928737559380343811696289682e-1",
  ".106614899557417904417189919831025391619048223599230074476353e-1",
  ".27327425896086335230637007235012677568594374376063422944032e-1",
  ".144146300544471270243580198572424581307638633148039261104041e-1",
  ".43572869320341192767531468222117884755969493187220997535104e-1",
  ".180550579317316902663584848237749691542678894849949252062984e-1",
  ".63390437487388834238358825429307366677830548860312526682586e-1",
  ".215542111630851093911532296874541017114032935819964046845075e-1",
  ".86625050453887296582974693625721210476554691008846329323516e-1",
  ".248846852006767649025998380424974792972474765972830672792066e-1",
  ".113094873856543722366288495395056259494094963514227036828300",
  ".280204081061850642891638735825504822201742674522786547269542e-1",
  ".142592749221685608367795684387776626518978015739134744037304",
  ".309368359830400944435070693943443261326856129020481090038397e-1",
  ".174887817667054805662103595507720368315118837035812999367506",
  ".336111426345434519821527543740742792735465595748023230496197e-1",
  ".209727327625117745032748995905154964533964898217833783053871",
  ".360223973862800323327309548926388780736336965137136324325737e-1",
  ".246838613379255692487851222081336311706956030681815376234464",
  ".381517285777210267693292689421131127635400409478182676419400e-1",
  ".285931229241092872906189693499260070607640776755733078023014",
  ".399824711211621314663310404925228781644177497150444236868249e-1",
  ".326699222784593027061510082534880884095795615311353945636560",
  ".415002968644282941899632641080885017425872519067255599710411e-1",
  ".368823529395351971014552399772209743256847800677109358170897",
  ".426933266960495626129719936955587838205954941418753755604314e-1",
  ".411974469417005215012848171777470035162285143835121476294556",
  ".435522234985917671216610158027704683425283575469274657022483e-1",
  ".455814328362170368199535283251225598287941282617450929301375",
  ".440702652151377314853694037965483207127271586372454185852863e-1",
  ".500000000000000000000000000000000000000000000000000000000000",
  ".442433974535521453191036938888078345912045750053027116601966e-1",
    // IM_GAUSS1D(7)

  ".69431844202973712388026755553595247452137310185141181192139e-1",
  ".173927422568726928686531974610999703617674347916946770246264",
  ".330009478207571867598667120448377656399712065114542823703523",
  ".326072577431273071313468025389000296382325652083053229753735",
    // IM_GAUSS1D(71)

  ".1084768757957081900585827209624880675091768801684343704730e-2",
  ".278285983212252268062799219527391870861229594719690072203983e-2",
  ".5706760548893880963302446061446276696418739967356472105904e-2",
  ".645797364203278720225170574889582459598060642572949567694017e-2",
  ".13986154475151025332197475784445836191976801867024129713594e-1",
  ".100907576488677357660494644791105637097932551204307988759067e-1",
  ".25863507800246227398762942527386076855311737333163183724894e-1",
  ".136493107492843895472085904339916789952284140711449211806863e-1",
  ".41251112742170466962066388486921800031545266093172572074004e-1",
  ".171069053851536149606225307813572770350484556634716959828742e-1",
  ".60035099554801434008786331267082205613353578959621536116063e-1",
  ".204378754618224477370572725716315957739685305595419370304281e-1",
  ".82076416503762346790589563750699673326610310303837427890568e-1",
  ".236175417451329892083084148083374160365758937171794430101854e-1",
  ".107211884933896743586115517459853698348834747080199319675934",
  ".266223569888799595460128141431098248444648055294688827571314e-1",
  ".135255414203221708954869760496945507217078476547401497947084",
  ".294300721226624086548376999094600179713770478912799003428203e-1",
  ".165999381707239468951404327829541180417648754893681173299202",
  ".320198986775077447781923993129281698730107352754203357775597e-1",
  ".199216170932009732460027512463202624128522922006624045012381",
  ".343726619178682213068448196818066041708653823210692373365292e-1",
  ".234659857036877419179645459939215091169388563676588961762060",
  ".364709425028265306769366884706371091434734763084952720812258e-1",
  ".272068027783289866396391165336279537021078805851571263671910",
  ".382992053229353372643788668607508208639637784159959168430944e-1",
  ".311163726440155391838631805165046188916913597557356066896304",
  ".398439144560358009543623327509319536637670787573630100995569e-1",
  ".351657502327985864748380476127414773649879088520087336649193",
  ".410936333521698547586117367724711514324815364673110604915678e-1",
  ".393249553841567210528386885548643041620769134363615902724948",
  ".420391094898309674667288121457979106019679569788030227520314e-1",
  ".435631948095307605674003305997423849411355137700313433197048",
  ".426733428696693137459252715382448854993932927486456470642425e-1",
  ".478490900763145696386515510885818282722852602596995405115800",
  ".429916378351973737450425873952632770800274578017479261453761e-1",
    // IM_GAUSS1D(73)

  ".1027708761043175529598462841318358165496075256635422965586e-2",
  ".263652863974896967586102711676519459154415295298961202585859e-2",
  ".5407018392840406657950469707863845518773541209663009761989e-2",
  ".611939005015377826315242621817328797114547655571203264598919e-2",
  ".13253484971757127835554762167120327592307691645695865820248e-1",
  ".956452224454198302175097397005308706514761787286659934008057e-2",
  ".24513828368952589335711951591837033001225710097711307241220e-1",
  ".129430184952794667613797406812436490147420912873822799000121e-1",
  ".39109281293768128665928156649643255609202366418835169429294e-1",
  ".162308199237607405336171267507293643995472795614332760813041e-1",
  ".56937518922256960526925245491556779946593382586551846150725e-1",
  ".194048012509672722444811851642380099836945946368030825206685e-1",
  ".77873506329722016006271861912569884154682752051188907940467e-1",
  ".224426823312185833287051520550981800973616532571807681023993e-1",
  ".101770399745048853303476832249837738257184420529739196209058",
  ".253231488274123008019379315433581720263528814726719277305676e-1",
  ".128460583009017368726476291263093560455049073368493698823926",
  ".280259939991374589042696198321263332133769276438841783194162e-1",
  ".157756845434520321277238393784423145977828094514961156283580",
  ".305322582616129930654940522502482928389970045311817485660054e-1",
  ".189453695795537758425923704202471344979136799697932420388049",
  ".328243614363756247420118831489856090983386605748624176688508e-1",
  ".223328804069209109382450820885367763263856723879508838014000",
  ".348862257778501724425406783965096455930118393488780535811451e-1",
  ".259144561098397222926403565558680414005238782826324802022446",
  ".367033886242440863623133157598977324917349710988241066765465e-1",
  ".296649745340836944949534204193016695738764360324720550201848",
  ".382631037852646189429439956033112577476816577657720257996962e-1",
  ".335581285058146500250764099330029758159988712353845980988532",
  ".395544309187646903836060936983226192580034675320911830186203e-1",
  ".375666103604317120597216124256141890734161174158527421160742",
  ".405683122542325152549388008998961317832300224873124692747284e-1",
  ".416623034880074011515664134794087781266675801984361825497946",
  ".412976361182186254456151505764192353866532263010198840921543e-1",
  ".458164795522615049028475834131800411218239183982423853192353",
  ".417372868129313936261265047422593495102176551015130250299224e-1",
  ".500000000000000000000000000000000000000000000000000000000000",
  ".418841804965694523985086831847296958584376400342383596140357e-1",
    // IM_GAUSS1D(75)

  ".975034732156190093576461724209501254767314862705954919628e-3",
  ".250144037481967283794977104594968523191963593118808573538232e-2",
  ".5130272866807214027787054447160326337809376545988896808084e-2",
  ".580672235823433708883415060021871367861837392921203643921582e-2",
  ".12576835704923246179557229526805678704012320616963242004223e-1",
  ".907828885480661844943806287739110113145616952053154150529166e-2",
  ".23266834533235202164728923441279391307110514638535645127984e-1",
  ".122898698691161879476006027233531437229795811133982697502382e-1",
  ".37129333975707801587445218893474544259541061759447239639432e-1",
  ".154197502725875273293655431566543444602059477483138655810343e-1",
  ".54072130497683891602531484013041244210050473382742319518956e-1",
  ".184470407970123690824700811684074751736780586203086691795029e-1",
  ".73982489033818905570175144376361859779807481336184515559222e-1",
  ".213515792523372171179392171794038543392087422841402838741619e-1",
  ".96727916197341592224217312010150837134113509335340189397246e-1",
  ".241140309303793416871760899557101120946805013926495707818256e-1",
  ".122157048123014659631130951610306293248081214626648036349157",
  ".267160099551661599868784953156243780384576551693726541135234e-1",
  ".150100659810407822043587079686292062180896492349704781134640",
  ".291401995734986030111529341290700279575638510792794754048082e-1",
  ".180372792085159146409827565249869864149414802295169285551882",
  ".313704666960665270264848357625685321604519444984543129105379e-1",
  ".212771989476096459433536249537763744894900201073100617696461",
  ".333919689895702059675230757645096299779760780176396334148326e-1",
  ".247082641036034448379733141766173998603076724681406177491890",
  ".351912535334494773696414837968294204196308508812306022663211e-1",
  ".283076415283811757813371918741078897997038099796580438148790",
  ".367563462923717285726032224241682392883185975462158775044113e-1",
  ".320513779760282493371641189271732854101968525394315963105895",
  ".380768317742231980329967705522362639981726094162772593912655e-1",
  ".359145595104917369319942964290649961615164745608194334099912",
  ".391439223291054740376877016678681312824518724289209127867453e-1",
  ".398714773053941648398011109242696471314172457123148241376166",
  ".399505166217639107930138419625928482751506197948407894902808e-1",
  ".438957987331066290065193809335296441715940929250349995598112",
  ".404912468852985503116347349745290709682575848920443770707847e-1",
  ".479607426047710880043341783835107539607613178658172594153201",
  ".407625146401928933496093849429150278008213257352483992190513e-1",
    // IM_GAUSS1D(77)

  ".926308466783546997263848574089779083995129975167894119391e-3",
  ".237647234581755068538810657745347099284754227009984755571625e-2",
  ".4874231572657008180112441376460897645153089479904101870586e-2",
  ".551739446958229712133840272608864472675356968635934557048921e-2",
  ".11950645333264473077574840055240752854626293659949148611198e-1",
  ".862811454686245952040273559167752360685795094657477350161890e-2",
  ".22112393837673861444554051404458898499114104680561932084720e-1",
  ".116846924160890822973561722214623494455987777307397717264297e-1",
  ".35295425756630885151091517821132719077948595246148236555864e-1",
  ".146674779919516892960779931781257128057057335512474386072933e-1",
  ".51416440353503556075854454569593174467153961012188498750874e-1",
  ".175575557490656653805325926486164081833307438100206420704888e-1",
  ".70373531000046923043101280436978814732457777340088969736923e-1",
  ".203366384239669219695282780411307018437862179980164754734540e-1",
  ".92046851284928447823383660795185086136092969739538071320478e-1",
  ".229871505544583159420883196996163902994308465169762232414126e-1",
  ".116299378534468250083863797885828527263582943270494669126174",
  ".254923326460647026070105168382906675088065419406448881383354e-1",
  ".142977782052732660433066481924084605167827359053150892401162",
  ".278363451704581499536955698948407413534804740367918590769162e-1",
  ".171913393283994544632787032511871907559946194211514784729097",
  ".300043680442980747874708867744097498683391135459234997338121e-1",
  ".202923272521361005653554962690446965917204227660936732314587",
  ".319826940693411944933532022050318224278884584449898857256780e-1",
  ".235811365669781263051828182095888747329641173257287612007354",
  ".337588154831156326815106640232242968875763540417385153969972e-1",
  ".270369743845431975668376683445213818530625423151991381061955",
  ".353215029853043803850574657640655682337148420795140852292936e-1",
  ".306379918014219272073059017181518651993711913641586692059926",
  ".366608767071343086905769664325241532239467121254875653456610e-1",
  ".343614220375907038732001544107185630199047195011230324867591",
  ".377684686614180288523922234954046995470939892950109221684492e-1",
  ".381837243769082116331996836333674775967140387602971202034826",
  ".386372762723410083642558183665586495602476257443955754684959e-1",
  ".420807330001081100038649469319300307766586881567428429766824",
  ".392618066436855883625316504927617357612907382046244304732813e-1",
  ".460278097695622261209041458403679676557498417446629033372385",
  ".396381112841842355050778858772539652619020743391332123501015e-1",
  ".500000000000000000000000000000000000000000000000000000000000",
  ".397638110697214262087090983029254969228033873829324071549423e-1",
    // IM_GAUSS1D(79)

  ".881145144720399825188648789706753832114809202477046698332e-3",
  ".226063854926659562923586643909266636391555510633347784297206e-2",
  ".4636880650271496773472823889313922518888959324456731058462e-2",
  ".524914226557640680737108553363982618839631066033277385367338e-2",
  ".11370025008112868668314858143548096510666033981006951785369e-1",
  ".821052919095394435643174244118196364617114667182003516987635e-2",
  ".21041590393104172097729500273620357452558254698626484215473e-1",
  ".111229245970834786307521620921042866035165983391456738230987e-1",
  ".33593595860661733319573916577397141782623212358653775385328e-1",
  ".139685034900117005492445787538605386512754310271235428743440e-1",
  ".48950596515562851635873334565753448207755959471165266137370e-1",
  ".167300976412739236963390915432054244886208933263924909835740e-1",
  ".67020248393870248089609095822690018214726723494449175270030e-1",
  ".193910839872360088199860156452230811267296056161329726451155e-1",
  ".87693884583344168401839884666950613046379807878506100154104e-1",
  ".219354540928366359958373430208577479055034185851856015151198e-1",
  ".110847174286740306152514227246752575989654341936554102877329",
  ".243479038175361160307170802240731940339215136885825026413145e-1",
  ".136340872405036448359501774122534725721310663233335931226224",
  ".266139234919684121774982398861302522776605859110053618150760e-1",
  ".164021657692910225810322742519252945014837009308074424964454",
  ".287198845496957756833088654552129928000524179272264637254040e-1",
  ".193723055166009881023693774884652561309938109158425194432326",
  ".306531212464644695832689982041992979512968817555871720562805e-1",
  ".225266437452435898962034347235241014883012449202174267548718",
  ".324020067283005190372772647833763650163464821042444546239022e-1",
  ".258462099156910643545716712877588497700488802233442949605332",
  ".339560229076169519128450541159619929920986191896429793615948e-1",
  ".293110397814197499237560127098143158512950187973540880852799",
  ".353058236956433898477418154276434161797795519977930487186638e-1",
  ".329002954587120763496253759410402844966523189986337101768295",
  ".364432911979020295302553417212589179287795404928993152224940e-1",
  ".365923907496373159429407827595701908287597813381876509271370",
  ".373615845289841321000946681306623365956014672101799108646640e-1",
  ".403651209649314450142241573967425052592953989447395562557266",
  ".380551809503131211857790379612474115062797769225355535269792e-1",
  ".441957964662372395758274357795987943115635734572892025484852",
  ".385199090821239827941537671419051242622198770819702077445932e-1",
  ".480613791246974589033403277987688352660317682808429200415681",
  ".387529739892124056318619814791631634818343263940532178664772e-1",
    // IM_GAUSS1D(81)

  ".839205712614279240405745955811216034247824243164916784740e-3",
  ".215307017908244384200223895232724309318110198717710711714280e-2",
  ".4416445150491845874920552713415171153621993214998476343038e-2",
  ".499996938695297266924814831484941977511246789878688774802644e-2",
  ".10830663219458307765414646663016400812181609040672858804568e-1",
  ".782246920390929426541342223976683872040894468473854850141510e-2",
  ".20046554134826886950279151965656708966524454585266824671363e-1",
  ".106005316843897765378485167466883132858585271528757131008376e-1",
  ".32011506251073087158840862357616866864381440956327612721403e-1",
  ".133179496035552227337742876293566385223452460010090296264335e-1",
  ".46657027620949413520829793384638513322846407338857572791291e-1",
  ".159591058658496408935334734285727718505938766506108383896128e-1",
  ".63899244153779295583164712882835269858978672230233499076239e-1",
  ".185088583517539942176306257900803343031357731605717333199834e-1",
  ".83639399799319334377863610475728100011512003510708933347912e-1",
  ".209525975979548447146701371555244189681331887159017318734908e-1",
  ".105764427476295313631889109266614855502643960450636394811157",
  ".232763241845071710303782934323057115654950992903072709570197e-1",
  ".130147598465036909469915627765720499802372780473715517261777",
  ".254667271473087473905851785578443157104017233934442050426546e-1",
  ".156649248982524355207698071735432593966780769925163435606528",
  ".275112596212893709400734050857111349868876683026793165320900e-1",
  ".185117580463901839755675454152448249460742609630264563061716",
  ".293982104749359724955929266903671370004406193013633829690588e-1",
  ".215389529194892065172626392358509874194771538010227378082242",
  ".311167712904831582357867085416732427150799349724716729989483e-1",
  ".247291700400296983645831964898652617524462226992409877165838",
  ".326570982267637052180818563268981702099296183605340733287644e-1",
  ".280641361474296455741440071635980375789107120620265678319214",
  ".340103683804383833677666198631244641283495600692970826649334e-1",
  ".315247488679759279285816543350032397187956514334061960624398",
  ".351688303104087487408294949849407280006166900839051399062390e-1",
  ".350911861329087567038508559760537847930022065776925736962727",
  ".361258484305115366981731991743936774426473852624362744527649e-1",
  ".387430197183288612197106871672263834850043789677878388824906",
  ".368759410136117349696404091624243397389581402141698213691317e-1",
  ".424593322568003918212811016057708812112184527335251084517416",
  ".374148115881107759456525363167526614728415336890153587890105e-1",
  ".462188370505418501538116903174399866259474682196671525624948",
  ".377393735463579120136235313373083745368031804515313881148680e-1",
  ".500000000000000000000000000000000000000000000000000000000000",
  ".378477678236491861593899805381801279455594406976156165662746e-1",
    // IM_GAUSS1D(83)

  ".800190504968792488565936576474861911061958238609374117572e-3",
  ".205299930232454230530138974841798132850838669446143175581720e-2",
  ".4211355829569540103819373359565583273653367631447991211560e-2",
  ".476811015087425120591005014634899909434239936851590788901052e-2",
  ".10328745968125903145508716728571952206762509935468535692246e-1",
  ".746122184867874707233883905293288381004637374388282776502881e-2",
  ".19120317330897755626536421073338659414139355542984000510685e-1",
  ".101139347845263223785278595396770925413357132727481929005140e-1",
  ".30538221322505910733413283187204014874306090774914064579098e-1",
  ".127114797630565239433712214547154321930677051912022216330546e-1",
  ".44520137547936273708076060395746728840549824330272198060776e-1",
  ".152396203498017341814523667616961988958848271220825461724038e-1",
  ".60989715093913628644007448260688232968590141878040700622070e-1",
  ".176845355487960554163310905632537709528742608931248169862027e-1",
  ".79857008369091549537280002456950091088300712403215821597446e-1",
  ".200328675903461308802980624150184672768668509321508197160266e-1",
  ".101018973372256293383647023726811669933812244354672932970950",
  ".222717888859829389371581829926171206592977330184208625245184e-1",
  ".124360032155259755215763912042670672248717740085229537573034",
  ".243890703964016225137246815642013619605588484671198339868705e-1",
  ".149752704721914393129215035472267232849912029099953409436216",
  ".263731478495870351719712695220487385157829939136033657212607e-1",
  ".177058305565376083021251848140794149415456728079928067657637",
  ".282131846790091908232134275698478446994365792881447737126319e-1",
  ".206127701257445338579644327263002140047284347585999177050872",
  ".298991311137933271564157728767674257549267093479718465066233e-1",
  ".236802125034403856203566220604049269282130117535045035535784",
  ".314217790225012882046591256618899445763985219609448752550324e-1",
  ".268914043964789035120462485034682007445167545763195684453585",
  ".327728121824544894635025539258972128048911470428965383168324e-1",
  ".302288073978512471161453022702814009600410711756823255869012",
  ".339448516882609724276817011068831536330673673292965990087136e-1",
  ".336741937767294243901421705312267165470794264750707738030902",
  ".349314962462970798830773931907411022219636565237160468428395e-1",
  ".372087460328560458016792604490645775615616771767299522669651",
  ".357273571325854914609052220587310775112949319387518593150717e-1",
  ".408131596717572724573622180309628529533338019188742449822794",
  ".363280876219020524439528807462665156383918419842136149978393e-1",
  ".444677486395740065825438727498679497566327987758184596298262",
  ".367304067267337641320141285271519693668278917252026196813829e-1",
  ".481525528417324112093452009981220286679145773875388734325178",
  ".369321171160864399981927805748957065642352602510354540369862e-1",
    // IM_GAUSS1D(85)

  ".763833878746143241181906340803794018974641076195428353458e-3",
  ".195974512692206364148358259628821771683018233353069314969903e-2",
  ".4020221203377926789640829335190991806473387020523635892659e-2",
  ".455199831870070165943430414794836190650898774021400775645739e-2",
  ".9860889509872334247235308909431804909566201740213257913756e-2",
  ".712437821578824305427080086100209678603699654242807026080037e-2",
  ".18256693492960003294902518212878030066190543860643726832331e-1",
  ".965995071184195019806230544603567615851177954880590177311774e-2",
  ".29164021576181069090761304801030864266761955093086121090602e-1",
  ".121452283069194079510091621271246242276185197149359140439178e-1",
  ".42526046396930635271948564600357191627109948445788471500100e-1",
  ".145672066307492474579702124128905968937752849418793758487486e-1",
  ".58273117390691568331160994178916291068916652878774200734851e-1",
  ".169132460434301461724842378769010455266508053219266963234590e-1",
  ".76323141895342475500456957089103741243701726261380058132914e-1",
  ".191711110970663287860642123314245574400362814371630661834978e-1",
  ".96582017931530682360462629561243936969556878259123701683464e-1",
  ".213290285989910418819036026692569470524735456184399149892606e-1",
  ".118944126402522439269835768485476906096202370657021121874373",
  ".233757473771732900053233831685514669664315479676814009250826e-1",
  ".143292882365521472574039561004547948678735416443181941801975",
  ".253005963921950782619251994765073728749490045490276215031142e-1",
  ".169501343124250933417432618129327302943421593732893353252620",
  ".270935401594408934316865891631327067941952763353645132182098e-1",
  ".197432870180199532137458464438022389280815096052736355351604",
  ".287452309784552597138044584222082559639344340972824145089223e-1",
  ".226941841669957640429797476410169581672572887937622098687698",
  ".302470576249956472598393709956813966792544399352142058684760e-1",
  ".257874411607132637965183282625743111003211459064138351838997",
  ".315911902246980561628149088867041321283481173197344095794607e-1",
  ".290069311985365373756360302719715986962505546142714525956324",
  ".327706210631613987456168821246039151124812668892274136974614e-1",
  ".323358693567848096677261817928266064109777484928717228880363",
  ".337792011146825845962039523781327960714731462928648041796900e-1",
  ".357569000983543186447138552580831034107060091122869415223624",
  ".346116720968283421411497395613175739046524947854639119113509e-1",
  ".392521877569740895492560809263162523131387856807273477778774",
  ".352636938825425140631431777389703715918680833924820750341907e-1",
  ".428035095244643344614850031194627655658605558264328675883496",
  ".357318671262570706487905588514551242904500096838978366196612e-1",
  ".463923504562706882288836374522219452571172361669692847237765",
  ".360137509857109871726537758354285438767521229737073508224219e-1",
  ".500000000000000000000000000000000000000000000000000000000000",
  ".361078758468994939887311658568684400735353452626251744850777e-1",
    // IM_GAUSS1D(87)

  ".729899681612887531971639696674825471984983412292701000576e-3",
  ".187270240155638875758688941588076923884895817706264929753919e-2",
  ".3841803930742095758330998193230715594051107823894961270872e-2",
  ".435024068376242206128281171215657010423421058596076358761750e-2",
  ".9424083461043016668625497324756085597162222230171130235422e-2",
  ".680979337778999276010253319503068943663335989371660197037714e-2",
  ".17450174788753430302800974709882512641561430705057453612324e-1",
  ".923574086840737458602111187169992205776036919709525598976286e-2",
  ".27880245440902950398372673486505374463772532620038512328054e-1",
  ".116157409510096053144791314693657087441109509996832594046355e-1",
  ".40662370007912112838499456652873975531007368477473497013294e-1",
  ".139378914106405050405571458896935321610294199003095644019566e-1",
  ".55732880856978398830816044904838837620833770895287049966105e-1",
  ".161906114060349104404234697700558005734740258943516494837042e-1",
  ".73016702497644810635848879353658054819415468985465775125997e-1",
  ".183626739069044368214546461743508998553543939916523731433897e-1",
  ".92427730177432494756281182124029724850299712745702878215603e-1",
  ".204432561551731094542235846415342434270396445147929293843578e-1",
  ".113869260375622050491120725384005993135951780217276445118463",
  ".224219920409850157231215932015255535904815108278293666012225e-1",
  ".137234473169641498696517531640023194493767099895952370033488",
  ".242890232241760187638197183456463688075256995534109255371305e-1",
  ".162406964666938817333150480718050038335872299438114562348862",
  ".260350480458522309406159014965993755281320873705794522396011e-1",
  ".189261327048212076098787650439116626427797059991418220421764",
  ".276513677818640262743733163215764957357674232088107945598164e-1",
  ".217663773407264615787681590308962390254627260197866942382216",
  ".291299299387977476671053449221385840023780845516767311157420e-1",
  ".247472804305898841008600823854411380693963352247325693363116",
  ".304633683507809840192789184371870503362862447408250626349966e-1",
  ".278539912737294258082586703176343225230760769845941025379873",
  ".316450398666019274750694355098574653190121441220470914589802e-1",
  ".310710323992646433744117663613901071628589575752164813355081",
  ".326690574395907174921204474228110947480054005648384639877943e-1",
  ".343823766748607093881727418213510732240368189123355681786820",
  ".335303194531468261978524596758596753903565065363807839541643e-1",
  ".377715271535899374246348782629740689734756370359975198164955",
  ".342245351346833304927293303521749362225777718179500204488198e-1",
  ".412215992612241607126746125309511704676312746637743342296488",
  ".347482459307862890185420454625056283910467376905871136799950e-1",
  ".447154049145673376441347075542439123808307000570201193108800",
  ".350988427367791062935710209721996938344133431078142289666693e-1",
  ".482355381517932320470901647684291822057498901205236461611431",
  ".352745788946770344056691437401499424955317127544618223953707e-1",
    // IM_GAUSS1D(89)

  ".698177409031680921726161549589725953855736392762291555522e-3",
  ".179133157764177946557151432967569628529281784188832555923854e-2",
  ".3675000776398129125691439701132327512499178348180324691506e-2",
  ".416159464810912082286792656111692687807896553239154182629264e-2",
  ".9015642482729715880340763182829259230817375389769096006554e-2",
  ".651555249579139216031554123484346301357058600498530233511091e-2",
  ".16695844801552697631787419553760951441660484695292293066012e-1",
  ".883876762896879530854627333478854426032563927824087370505631e-2",
  ".26679154502185469107639701523081460774765827916432474601072e-1",
  ".111199237752893661969753792760844966724378544741233027587434e-1",
  ".38918031640499805951266319519736340367318561374669415824586e-1",
  ".133481069837888324028373893965537638939124553352291424653546e-1",
  ".53354164123379130767675474253471326817299379793103656918644e-1",
  ".155126874672577335812539694468840319429605760517964222520913e-1",
  ".69918762019667887330460564716432806108292788211488949460704e-1",
  ".176033461008045081238498991307875454050440373533595523635140e-1",
  ".88532889748956831482112369986748985003292370971864783227979e-1",
  ".196101183646512237820935926719646691090650622958400221124955e-1",
  ".109107843703046854343818405950698591169863241580469238480356",
  ".215234403545824855758455565405834708941596180826652203188650e-1",
  ".131545575527254823688130575702553990060197159581191459536328",
  ".233341938591866826338842378708270506024930707443206453090160e-1",
  ".155739159614399737383990087059780882022383497190736109639526",
  ".250337496189760148995660512374371586957493464675847125146316e-1",
  ".181573302773388320364388077048308424653984378267161779728576",
  ".266140083656344759729520220096552018992411084700782500473667e-1",
  ".208924893715323406659516332777911434499955587008386426988207",
  ".280674393798932383219619701874348816207400924730812002315893e-1",
  ".237663589768541966454432949769918798696445864599858706554572",
  ".293871163594208692871807588159157112656328627304900506515044e-1",
  ".267652438040182450710199248845125744580093666381404558576377",
  ".305667504155332612509431852681627866300621171326210752541600e-1",
  ".298748528070729042961012745725826772014850321215301780582071",
  ".316007200369099688749818651453334409331501186379114081681124e-1",
  ".330803672874698919178297949984063505233829278431288651026204",
  ".324840978753617154269132851795378475419248627437916364991407e-1",
  ".363665115123811219695617304192177409050894122861678969939246",
  ".332126742249212640414573578195518688065872733753374079845391e-1",
  ".397176255108368127140106387264228034648381807150285084479383",
  ".337829770818037681354551119368243154897362904619732309964647e-1",
  ".431177397008373485621704979288467223446617221729237470191055",
  ".341922886893348372658460496671580485367424565273224731904402e-1",
  ".465506509918427913754792692948094135153039666534515158667295",
  ".344386584888306614410014241490278944422620650553242725793704e-1",
  ".500000000000000000000000000000000000000000000000000000000000",
  ".345209124146160100553992775797023703616614461375023890385731e-1",
    // IM_GAUSS1D(9)

  ".46910077030668003601186560850303517437174044618734568563119e-1",
  ".118463442528094543757132020359958681321630001106207007791416",
  ".230765344947158454481842789649895597516356696547220021898884",
  ".239314335249683234020645757417819096456147776671570769986360",
  ".500000000000000000000000000000000000000000000000000000000000",
  ".284444444444444444444444444444444444444444444444444444444444",
    // IM_GAUSS1D(91)

  ".668478933091009435865791304555612707922196282684136954447e-3",
  ".171515043405352414300939157402170222058647416114296574056247e-2",
  ".3518825546912817963452277666903295439448584545807987400576e-2",
  ".398494911486231122580651946316248271314438560435382500793511e-2",
  ".8633165097916568261010210170405639890218314850785599677090e-2",
  ".623994188549434210336728587549168758876127369520787558079991e-2",
  ".15989304073004028631125966814092245738844086823184949642340e-1",
  ".846675700391811902311535683588021566686322201877486146889852e-2",
  ".25553818276955102188893230281542930237114308353377333609453e-1",
  ".106549993770682505272396805354392009144218888197680351574531e-1",
  ".37283100596623024511254321150437870558828121780522076199398e-1",
  ".127946431985650053173497561001720140514397806491340818513946e-1",
  ".51123644233029017149340024340109355272685177349324455009290e-1",
  ".148759147761013778995258646178614685465143769131024900807733e-1",
  ".67012302566570968542055611591700780656347627831047757984850e-1",
  ".168893139995534482603019469405726643638997402425978005096917e-1",
  ".84876581466966973483807347604596941002096873014809695984878e-1",
  ".188256526786930356638303996142295585134775597253619967071747e-1",
  ".104634971462362872405427926289848794426015243457644445065496",
  ".206760950548393648521100879351157392121031120546370405635691e-1",
  ".126197320192166972999831747365998565547138909998726752515344",
  ".224321976386590633835473067813874282211433502588920301613461e-1",
  ".149465243989797151243938955286749774875212008425030676765782",
  ".240859475508561002652344316116104683409877461838289928188537e-1",
  ".174332576899001142446761422091570316386197971340762030275394",
  ".256297990035715106676826496857240167320907508132641309781954e-1",
  ".200685855143642423411413733199916344925766832717685026088916",
  ".270567076929283772458188216296115376299487345205679953217357e-1",
  ".228404834869098682364518654485561581983010764807541957304580",
  ".283601629219956179084372018016433572932135113045565907253659e-1",
  ".257363040805917668613839903145772595840166220358480648227749",
  ".295342172977731574037753613184538685491084742461151384484017e-1",
  ".287428343358585801338926568285716290415331115446032654158972",
  ".305735138623252405076783039520955188863908164289268042811904e-1",
  ".318463561489502144938146510742674155076305578571178764251008",
  ".314733105321972540894759761235554656166230825158931104034124e-1",
  ".350327088649064992258280371711048035321953841222880825388166",
  ".322295017335695347941397195541275319618978225225092462334785e-1",
  ".382873538896865115686971942213103753712955589004750987188736",
  ".328386371338906036893787828427778838108580698869058577394796e-1",
  ".415954410266448235696601631286148936276255359081765301634008",
  ".332979373842274436878809832113668509721818544004960546349026e-1",
  ".449418762347207880242070171495675304559064319749253130190242",
  ".336053068003390879311870774135487980882698405828226010798833e-1",
  ".483113904991973979240221084054280118092041942001899039658947",
  ".337593429245182294101070945821505401060741347699091275725852e-1",
    // IM_GAUSS1D(93)

  ".640635707893945408026142606445754186454674384254595392016e-3",
  ".164372692126400744162498210416808992568031199676706634164481e-2",
  ".3372394506115682653905157683768195927143957944684632730345e-2",
  ".381930814792441680705217838556582775221029541017058389054166e-2",
  ".8274498464188145617549482981915074034172890445953112809872e-2",
  ".598142423215616048197172742497425626169645225334391685181347e-2",
  ".15326606336717751427127861219864597330848526510247931756560e-1",
  ".811766657321652983536284370394931050794646220769492207593451e-2",
  ".24498015371145778705098538074278788673199242306310485515644e-1",
  ".102184690738342138210173803431276932136155236041522508565449e-1",
  ".35748653493819675901407537694339509312290606528483005137104e-1",
  ".122746058298294092689170785762528835688315761833090681996831e-1",
  ".49029335280737321566414349011282180180682756783857609870203e-1",
  ".142770753503216932523699623129055408034376089321594336743261e-1",
  ".64281992101551841529507267722196914474036736942110195366202e-1",
  ".162171177575923783838087315870850793465443404140123629981217e-1",
  ".81439930050048939361200525716823817909065525268278703181942e-1",
  ".180862482920874758067299648831556243367226411132299019302162e-1",
  ".100428122916129028542218965398203493979739571900632528400024",
  ".198762930612655018904506900709805082958247344145017102234583e-1",
  ".121163540777280683213001738215158899393290044783173283547844",
  ".215794243242397691341508967232515697738596888929325150349047e-1",
  ".143555513295467849169060336114490594147874877122041428456672",
  ".231881945432529556022009241213725462743480226314714394699713e-1",
  ".167506126304833635431648675713955469284742592733364537119913",
  ".246955688736805848022852429310024615599970118952460549635153e-1",
  ".192910650021813195702268728697873156875910027454897625148956",
  ".260949558900285724361059708548380388608674899810190476467498e-1",
  ".219657997032667902758470841290865604428238272704431280250888",
  ".273802363907651129785625884442524029518976831742536126164179e-1",
  ".247631208068211040112855487324349454863398440387698735338658",
  ".285457901466157701110083026541913864551647129826236231721209e-1",
  ".276707963447572148637408928825296020303291497400639450285037",
  ".295865204711694379880772781928706462319161757465370119328879e-1",
  ".306761117957666430208348806196988364899081195992584992531038",
  ".304978765043698226653552890667187605905466021510079373643543e-1",
  ".337659256831132048894619350410001581800185541996468837058945",
  ".312758731104608313202821907249767683767079217292302127908845e-1",
  ".369267270392512714846508516897414512883338633101560137339300",
  ".319171083028585153156468899279067667411681718453429862825998e-1",
  ".401446944860444096019254320814747691222568564788830167322856",
  ".324187781194728633513019695554030094424973763009141594017730e-1",
  ".434057566722742551473088234637936379318332423280755543524872",
  ".327786888832748701255715011630379561409999454043667989478860e-1",
  ".466956538041822162419763111262933145703861863031889795563862",
  ".329952667944052372667853276652491297886791388132514989445770e-1",
  ".500000000000000000000000000000000000000000000000000000000000",
  ".330675648118277398267201771655274855976802263589656202832145e-1",
    // IM_GAUSS1D(95)

  ".614496373786940699729254218443179955531174861639480693530e-3",
  ".157667302615291931633865577194574378914197045973018482261972e-2",
  ".3234913866824621226035624575462940821692625202664035191424e-2",
  ".366377695063813105119198981089327502935395342176108986357423e-2",
  ".7937708138586571127708199986700584705380388291307635021175e-2",
  ".573861728961726974479633380454581404321025204056685020873092e-2",
  ".14704203726876374769294008099669971348783044184558146985814e-1",
  ".778965786147192436408847791723015698818813346329383384857873e-2",
  ".23506148419784569638519666987140828395729334088040631568026e-1",
  ".980808022867776390723035982610635484790651739798400643146660e-2",
  ".34306654646722833442912809949199366140001457190524785064698e-1",
  ".117853804196621895702596506892246151108648707544960283682447e-1",
  ".47060431642215163588962582164494105843868900086294577323758e-1",
  ".137132548541784741000369181312529102255920776237976142064144e-1",
  ".61713989862876057047153222597451622719175733135019003626062e-1",
  ".155836139163990444510328784231772097271426704116122176991856e-1",
  ".78205869187803234644455077740171975064556494131223799242544e-1",
  ".173886112823852194462742929819012052986406984136416438302206e-1",
  ".96466897985278686458723478487730777013493485269792306712068e-1",
  ".191206755329153531586086282618578089319119841826294376732097e-1",
  ".116420483742129830373072281238515473188678834575896313882436",
  ".207725414717323746070294111805323988767364130190148889679119e-1",
  ".137982934538092672662758883253167376707453593859638818635317",
  ".223372804283471402097242935629251974942313934311992823222517e-1",
  ".161063810183668047394074359662045470575022660486975693464480",
  ".238083292462452374129533117394649150789990333714481967927431e-1",
  ".185566301611743188002417533465002673987545500104919114509134",
  ".251795177769272374789038095439328030164970465129293256942858e-1",
  ".211387636958013648091095380729760613573001356929902235973802",
  ".264450947425968335477525281323494573308632428165585888740496e-1",
  ".238419512638883483160887065431245736855406189094057946209885",
  ".275997518499920814341017475958177195022254628037800939584806e-1",
  ".266548547624520797727535569174600745381593947870741527909066",
  ".286386460502016078525751173423502881207635615020559845055360e-1",
  ".295656759004641635041887252092683356770038578502555967614424",
  ".295574198491978178732374087167599553298278012785275043311600e-1",
  ".325622056853919630920091031364796041932845175015803711983938",
  ".303522195829469400264846160139102389426304321282388772450156e-1",
  ".356318756322272211632056769341601156074220847099480110545750",
  ".310197115799463319520988920687992591531916998325457307676940e-1",
  ".387618104802655469387567279912653861280719097979172596917628",
  ".315570961431270128285630113751166590637068216855503956041037e-1",
  ".419388821965554140971781304608251152612812810129052441148378",
  ".319621192923240933119531009127577044594870424913214999454137e-1",
  ".451497650395268650534973022073187739923631885349531506784710",
  ".322330822179750411032520968288525328628459622277651543802817e-1",
  ".483809914518565318983338878423932778977018598819240953787498",
  ".323688484063419612515124693682957767760409594733182550072812e-1",
    // IM_GAUSS1D(97)

  ".589924696682310319084363647944672438159501067749017943526e-3",
  ".151363949446145253874034908791357048641501438204287264351789e-2",
  ".3105669027916104619943070371023190579346302530674916197698e-2",
  ".351754979504322573672533915567420543143192561678441079639851e-2",
  ".7621052042893497820350502315712644823346268927373523391392e-2",
  ".551027551579679024875414408341666637609678317917354221947010e-2",
  ".14118899549222309930013789247612933251068726409547153340386e-1",
  ".748107246781232551479215956010075201814052233033269490334284e-2",
  ".22573170662931383222378160165907790472652774049863104038507e-1",
  ".942179792654472922222532669555367463387495551147460032755963e-2",
  ".32949852622094925470508769681727548769788523594904002796149e-1",
  ".113246007937233382493854821080214436633987457426366281830658e-1",
  ".45207172085963357393490179822099964478614384441640980446578e-1",
  ".131818094635330084804728726198710238472304835917654899575772e-1",
  ".59295777213495544981484232091497536920379981368804330191236e-1",
  ".149859423102919126753452790370736050310360183761167877879514e-1",
  ".75158940077917149482559063878510333336697833767641875628206e-1",
  ".167297333958110871712435754458446009247399343455751733739350e-1",
  ".92732786320072284230249606117611477752663932088623324131616e-1",
  ".184061604815003449097336183494411475006807762241889232525638e-1",
  ".111946552827276682490928593875771964367774769085409067364483",
  ".200084728831865106843025183715516607139323037370797554766597e-1",
  ".132722872881298651893162893570737557673582273338149082780264",
  ".215302184906297989941727420005192479033567906221702809279029e-1",
  ".154978087787433943247624096362529036183247436905482124504226",
  ".229652696777979267712498099860638355044121611768177900050535e-1",
  ".178622583790381167971571525708049945229832263873361233729259",
  ".243078479439141201388255986439342654406844643094118207627463e-1",
  ".203561152945549643772067831603685732683499492340576204773244",
  ".255525471650722953373114030246592806948062246648920107248553e-1",
  ".229693376504136966720887266385282041537949326880817076701026",
  ".266943553541294842639714668650881030827930347241122943412755e-1",
  ".256914029273753978911511951970712468962442402832531697359701",
  ".277286748374017943452157907413490336021257620368970709080284e-1",
  ".285113503329211737670707929096288483468291051060963995078146",
  ".286513407650937377425822961754082681752902194015598306429925e-1",
  ".314178249368857555568132729526519736192627606633036511625066",
  ".294586378800136330122638253712462581312480569297397286564890e-1",
  ".343991233940125618896069661746791867451583296002806375208302",
  ".301473154765760086515530584377707952488882544598627438911345e-1",
  ".374432410693711363246422028587694362708507912713167874352986",
  ".307146004895964681484133230701505374715950045960489668669514e-1",
  ".405379203769093206757344913070006744410160561160590455327782",
  ".311582086600286337005384126079748521120667681106604169220473e-1",
  ".436707001365163974466007355712231904837756439466566643244516",
  ".314763537325978497371997778914455031818627138847850206861729e-1",
  ".468289657508656606985582589560757513423606563610559806254895",
  ".316677546482458742954184637000452600739857082824129102236561e-1",
  ".500000000000000000000000000000000000000000000000000000000000",
  ".317316407023952988591267339397648174998147611541261095928888e-1",
    // IM_GAUSS1D(99)

  ".566797789964474907270277512890747001878243547960737411480e-3",
  ".145431127657757047920036217142774040333649972050717075354292e-2",
  ".2984015283954643707445899789652635921261014465838204831738e-2",
  ".337989959787270075138943908899251590093689399315035876157278e-2",
  ".7322957975997058845495187183755297992203684527297095641096e-2",
  ".529527419182548463178484074962051116970093598211323221129446e-2",
  ".13567807446653963143327947696873973165413296475022899127452e-1",
  ".719041138074278720968945446366217496851591671081726724866078e-2",
  ".21694522378596028501127177921688952974282937686976728572010e-1",
  ".905778035674469517562997171117730992233366525516848669794578e-2",
  ".31671690527561033109562526363751698923134200952398538812473e-1",
  ".108901215850623964907960345313451706136567380839148405063860e-1",
  ".43460721672104053455132178614171452607905904151108805188636e-1",
  ".126803367850061952200974391927213617300806319632623071782279e-1",
  ".57016010238193475681229508766623182902854844622095818776722e-1",
  ".144214967902675990149531865566162162589234328540511922525225e-1",
  ".72285115285026957694318678032621266172583480256547018280835e-1",
  ".161068641117890083240829136615019767242945291879986355537740e-1",
  ".89208964570332025821872944563030231119629308328257125738313e-1",
  ".177299178075730770803673055004878985484800001221029977316033e-1",
  ".107722083549800368047347401829504399576341863721777823630570",
  ".192843783062938376223850751181929674323858524577060773267045e-1",
  ".127752848886965730869731873658902878564906034335207710737610",
  ".207642315450738487112059894820335089044889877245474171847496e-1",
  ".149223765646588874455226871058172135925140385757652178629538",
  ".221637521694016377460111434151970987303806491780120189816742e-1",
  ".172051767157280319609187567998160090479294735808834086734532",
  ".234775256519742164828165068174938412570321530926315886636662e-1",
  ".196148536407524880409809101804083553197897489662002822143934",
  ".247004692247331574606217903757163643461435254833147524781824e-1",
  ".221420847742674972842238545187099196092050808881124869341770",
  ".258278515347905692449526479200476398249127246977173934675106e-1",
  ".247770927546267899174270434075429403682310660864660380908630",
  ".268553109444981232617293986278322763840116067649619999825878e-1",
  ".275096832512980605426434266110812091342467743267413167029260",
  ".277788724031062588117837128061347487975676499919512784266778e-1",
  ".303292844051217436302885373088091364876930265663671998460482",
  ".285949628238641918615146575329965815057876861285458794259834e-1",
  ".332249877290281321581505871354464151079390703481602119049784",
  ".293004249066112229175612183154242331048837567220127365322458e-1",
  ".361855903110234004836177360739434907142599206434001924693247",
  ".298925293521327287547882026562926153983330210363345023014504e-1",
  ".391996381561979121576357733691449333147122013744933363648190",
  ".303689854208851080158750076924055008048996366177017678617728e-1",
  ".422554705000927048964185689529445249399074889972531183801635",
  ".307279497951583318782033930419576875486337878820037571545838e-1",
  ".453412649219956929572774811180199826057164308038930692658555",
  ".309680337103416216920437548904153442864385283456224524713816e-1",
  ".484450830836405561943835505167025402876351888520000978512602",
  ".310883083276736311605165536803067154338412346005133165505828e-1",
    // IM_HEXAHEDRON(11)

  ".9063071670498132481961877986898720",
  ".5000000000000000000000000000000000",
  ".5000000000000000000000000000000000",
  ".0253096342016000238231671413708773",
  ".8673341434985040086731923849337745",
  ".8673341434985040086731923849337745",
  ".5000000000000000000000000000000000",
  ".0181499182325144622865632250992823",
  ".6566967022580273605228866152789755",
  ".6566967022580273605228866152789755",
  ".6566967022580273605228866152789755",
  ".0269990056568711411641833332980551",
  ".8008376320991313508172065028926585",
  ".8008376320991313508172065028926585",
  ".8008376320991313508172065028926585",
  ".0146922934945570350487414755013352",
  ".9277278805088799923375457353451730",
  ".9277278805088799923375457353451730",
  ".9277278805088799923375457353451730",
  ".0055804890098536552051251442852662",
  ".9706224286053016319555750788155670",
  ".9706224286053016319555750788155670",
  ".6769514072983150674551564354064455",
  ".0028267870173527355278995288336230",
  ".7253999675572547151889421728651345",
  ".7253999675572547151889421728651345",
  ".9825498327563551314651409115626720",
  ".0076802492622294169003437555791307",
    // IM_HEXAHEDRON(5)

  ".8979112128771107316322744102380675",
  ".5000000000000000000000000000000000",
  ".5000000000000000000000000000000000",
  ".1108033240997229916897506925207755",
  ".8793934553196640731345171390561335",
  ".8793934553196640731345171390561335",
  ".8793934553196640731345171390561335",
  ".0418975069252077562326869806094182",
    // IM_HEXAHEDRON(9)

  ".8068407347958544969174424448702780",
  ".5000000000000000000000000000000000",
  ".5000000000000000000000000000000000",
  ".0541593744687068178762288491492902",
  ".9388435616288391432433878794971660",
  ".9388435616288391432433878794971660",
  ".5000000000000000000000000000000000",
  ".0114737257670222052714055736149557",
  ".7820554035100150271333094993315360",
  ".7820554035100150271333094993315360",
  ".7820554035100150271333094993315360",
  ".0248574797680029375401085898232011",
  ".9350498923309879588075319044319620",
  ".9350498923309879588075319044319620",
  ".9350498923309879588075319044319620",
  ".0062685994124186287334314359655827",
  ".7161339513154310822080124307584715",
  ".7161339513154310822080124307584715",
  ".9692652109323358726644884348015390",
  ".0120146004391716708040599923089382",
    // IM_NC(0,0)

  "1.0",
    // IM_QUAD(17)

  ".9946765372563002456132179188084275",
  ".5000000000000000000000000000000000",
  ".0051537289799977399712336527838148",
  ".6881426035789866472037743058601245",
  ".5000000000000000000000000000000000",
  ".0320064290449774586796976445666927",
  ".9894241396311165580350357179969500",
  ".9894241396311165580350357179969500",
  ".0013779348835079726300386692984834",
  ".9428973645820580644532271790325020",
  ".9428973645820580644532271790325020",
  ".0098019281142854701238999612650102",
  ".5858780619191740873471919457467925",
  ".5858780619191740873471919457467925",
  ".0190992362699658256001262135754266",
  ".7952496369030012066757582605040080",
  ".6597525183172869728383947371516360",
  ".0353784324874931148111524373531432",
  ".8995395659584316279050666672835730",
  ".7989862259647286901314008779983725",
  ".0209758198409494005205819165480076",
  ".9018719814793723558927249127471835",
  ".5291722408882752648421765781646003",
  ".0150985409124211365077258972729358",
  ".9682531380637473908710441740858150",
  ".6736931580831013373929988958506685",
  ".0143469382423031737803539574584371",
  ".9906605899027261474879552202153555",
  ".8530001438993230595909631103115815",
  ".0054806398704659408776877206227619",
    // IM_QUAD(2)

  "0.9082482904638630163662140124509818986609912467761116880721154277",
  "0.5",
  "0.3333333333333333333333333333333333333333333333333333333333333333",
  "0.2958758547680684918168929937745090506695043766119441559639422863",
  ".8535533905932737622004221810524245196424179688442370182941699344",
  "0.3333333333333333333333333333333333333333333333333333333333333333",
  "0.2958758547680684918168929937745090506695043766119441559639422863",
  ".1464466094067262377995778189475754803575820311557629817058300656",
  "0.3333333333333333333333333333333333333333333333333333333333333333",
    // IM_QUAD(3)

  "0.5",
  ".9082482904638630163662140124509818986609912467761116880721154277",
  "0.25",
    // IM_QUAD(5)

  "0.5",
  "0.5",
  ".2857142857142857142857142857142857142857142857142857142857142857",
  "0.9830458915396479524572888052389923907713377624919657696231974935",
  "0.5",
  "0.0793650793650793650793650793650793650793650793650793650793650793",
  ".7886751345948128822545743902509787278238008756350634380093011631",
  "0.8872983346207416885179265399782399610832921705291590826587573766",
  "0.1388888888888888888888888888888888888888888888888888888888888888",
    // IM_QUAD(7)

  ".9629100498862757307832833882919995",
  ".5000000000000000000000000000000000",
  ".0604938271604938271604938271604937",
  ".6902772166041578281895531795431970",
  ".6902772166041578281895531795431970",
  ".1301482291668486142849798580116827",
  ".9029898914592993718539280906753720",
  ".9029898914592993718539280906753720",
  ".0593579436726575585545263148278232",
    // IM_QUAD(9)

  ".9922699059711261962165003001504935",
  ".5000000000000000000000000000000000",
  ".0179033561774527416961834769929511",
  ".7444431714211862081138843106633405",
  ".5000000000000000000000000000000000",
  ".1135225881378863060330381008714315",
  ".5",
  ".9922699059711261962165003001504935",
  ".0179033561774527416961834769929511",
  ".5",
  ".7444431714211862081138843106633405",
  ".1135225881378863060330381008714315",
  ".9697836437107607670671515381158335",
  ".9697836437107607670671515381158335",
  ".0106961538666945127922920850036681",
  ".9183551625119944870476731455760975",
  ".7536883868373065026387420172469580",
  ".0539389509089832197392431685659745",
    // IM_SIMPLEX4D(3)

  "0.2",
  "0.2",
  "0.2",
  "0.2",
  "-0.0434027777777777777777777777777777",
  "0.142857142857142857142857142857142",
  "0.142857142857142857142857142857142",
  "0.142857142857142857142857142857142",
  "0.142857142857142857142857142857142",
  "0.0170138888888888888888888888888888",
    // IM_TETRAHEDRON(1)

  "0.25",
  "0.25",
  "0.25",
  "0.1666666666666666666666666666666666666666666666666666666666666666",
    // IM_TETRAHEDRON(2)

  "0.13819660112501052",
  "0.13819660112501052",
  "0.13819660112501052",
  "0.0416666666666666666666666666666666666666666666666666666666666666",
    // IM_TETRAHEDRON(3)

  "0.25",
  "0.25",
  "0.25",
  "-0.1333333333333333333333333333333333333333333333333333333333333333",
  "0.1666666666666666666666666666666666666666666666666666666666666666",
  "0.1666666666666666666666666666666666666666666666666666666666666666",
  "0.1666666666666666666666666666666666666666666666666666666666666666",
  "0.075",
    // IM_TETRAHEDRON(5)

  "0.25",
  "0.25",
  "0.25",
  "0.019753086419753086",
  "0.31979362782962991",
  "0.31979362782962991",
  "0.31979362782962991",
  "0.011511367871045398",
  "0.091971078052723033",
  "0.091971078052723033",
  "0.091971078052723033",
  "0.01198951396316977",
  "0.056350832689629156",
  "0.056350832689629156",
  "0.44364916731037084",
  "0.008818342151675485",
    // IM_TETRAHEDRON(6)

  "0.214602871259152029288839219386284",
  "0.214602871259152029288839219386284",
  "0.214602871259152029288839219386284",
  "0.00665379170969458201661510459291332",
  "0.0406739585346113531155794489564100",
  "0.0406739585346113531155794489564100",
  "0.0406739585346113531155794489564100",
  "0.00167953517588677382466887290765614",
  "0.322337890142275510343994470762492",
  "0.322337890142275510343994470762492",
  "0.322337890142275510343994470762492",
  "0.00922619692394245368252554630895433",
  "0.0636610018750175252992355276057269",
  "0.0636610018750175252992355276057269",
  "0.269672331458315808034097805727606",
  "0.00803571428571428571428571428571428",
    // IM_TETRAHEDRON(8)

  "0.25",
  "0.25",
  "0.25",
  "-0.0205001886586399158405865177642941",
  "0.206829931610673204083980900024961",
  "0.206829931610673204083980900024961",
  "0.206829931610673204083980900024961",
  "0.0142503058228669012484397415358704",
  "0.0821035883105467230906058078714215",
  "0.0821035883105467230906058078714215",
  "0.0821035883105467230906058078714215",
  "0.00196703331313390098756280342445466",
  "0.00578195050519799725317663886414270",
  "0.00578195050519799725317663886414270",
  "0.00578195050519799725317663886414270",
  "0.000169834109092887379837744566704016",
  "0.0505327400188942244256245285579071",
  "0.0505327400188942244256245285579071",
  "0.449467259981105775574375471442092",
  "0.00457968382446728180074351446297276",
  "0.229066536116811139600408854554753",
  "0.229066536116811139600408854554753",
  "0.0356395827885340437169173969506114",
  "0.00570448580868191850680255862783040",
  "0.0366077495531974236787738546327104",
  "0.0366077495531974236787738546327104",
  "0.190486041934633455699433285315099",
  "0.00214051914116209259648335300092023",
    // IM_TRIANGLE(1)

  "0.3333333333333333333333333333333333333333333333333333333333333333",
  "0.3333333333333333333333333333333333333333333333333333333333333333",
  "0.5",
    // IM_TRIANGLE(10)

  "0.333333333333333333333333333333333",
  "0.333333333333333333333333333333333",
  "0.0399472523706198539156235226066932",
  "0.425086210602090572969529511638044",
  "0.425086210602090572969529511638044",
  "0.0355619011161886673196456436993290",
  "0.0233088675100001907144663868959796",
  "0.0233088675100001907144663868959796",
  "0.00411190934523209775932331018123594",
  "0.628307400213492556420837666078834",
  "0.223766973576973006225686490268204",
  "0.0227152961480850090035368146219665",
  "0.611313826181397648918755002253901",
  "0.358740141864431464578155300723852",
  "0.0186799281171526384131182495009876",
  "0.821072069985629373373544413472177",
  "0.143295370426867145305856630617323",
  "0.0154433284422819943912565385023143",
    // IM_TRIANGLE(13)

  ".3333333333333335000000000000000000",
  ".3333333333333335000000000000000000",
  ".0262604617004010000000000000000000",
  ".4950481849397050000000000000000000",
  ".4950481849397050000000000000000000",
  ".0056400726046650000000000000000000",
  ".4950481849397050000000000000000000",
  ".0099036301205910000000000000000000",
  ".0056400726046650000000000000000000",
  ".0099036301205910000000000000000000",
  ".4950481849397050000000000000000000",
  ".0056400726046650000000000000000000",
  ".4687166351095740000000000000000000",
  ".4687166351095740000000000000000000",
  ".0157117591812270000000000000000000",
  ".4687166351095740000000000000000000",
  ".0625667297808520000000000000000000",
  ".0157117591812270000000000000000000",
  ".0625667297808520000000000000000000",
  ".4687166351095740000000000000000000",
  ".0157117591812270000000000000000000",
  ".4145213368012770000000000000000000",
  ".4145213368012770000000000000000000",
  ".0235362512520970000000000000000000",
  ".4145213368012770000000000000000000",
  ".1709573263974470000000000000000000",
  ".0235362512520970000000000000000000",
  ".1709573263974470000000000000000000",
  ".4145213368012770000000000000000000",
  ".0235362512520970000000000000000000",
  ".2293995720428310000000000000000000",
  ".2293995720428310000000000000000000",
  ".0236817932681775000000000000000000",
  ".2293995720428310000000000000000000",
  ".5412008559143370000000000000000000",
  ".0236817932681775000000000000000000",
  ".5412008559143370000000000000000000",
  ".2293995720428310000000000000000000",
  ".0236817932681775000000000000000000",
  ".1144244951963300000000000000000000",
  ".1144244951963300000000000000000000",
  ".0155837645228970000000000000000000",
  ".1144244951963300000000000000000000",
  ".7711510096073400000000000000000000",
  ".0155837645228970000000000000000000",
  ".7711510096073400000000000000000000",
  ".1144244951963300000000000000000000",
  ".0155837645228970000000000000000000",
  ".0248113913634590000000000000000000",
  ".0248113913634590000000000000000000",
  ".0039878857325370000000000000000000",
  ".0248113913634590000000000000000000",
  ".9503772172730820000000000000000000",
  ".0039878857325370000000000000000000",
  ".9503772172730820000000000000000000",
  ".0248113913634590000000000000000000",
  ".0039878857325370000000000000000000",
  ".2687949970587610000000000000000000",
  ".6363511745616600000000000000000000",
  ".0184242013643660000000000000000000",
  ".6363511745616600000000000000000000",
  ".0948538283795790000000000000000000",
  ".0184242013643660000000000000000000",
  ".0948538283795790000000000000000000",
  ".2687949970587610000000000000000000",
  ".0184242013643660000000000000000000",
  ".2687949970587610000000000000000000",
  ".0948538283795790000000000000000000",
  ".0184242013643660000000000000000000",
  ".6363511745616600000000000000000000",
  ".2687949970587610000000000000000000",
  ".0184242013643660000000000000000000",
  ".0948538283795790000000000000000000",
  ".6363511745616600000000000000000000",
  ".0184242013643660000000000000000000",
  ".2917300667342880000000000000000000",
  ".6901691599869050000000000000000000",
  ".0087007316519110000000000000000000",
  ".6901691599869050000000000000000000",
  ".0181007732788070000000000000000000",
  ".0087007316519110000000000000000000",
  ".0181007732788070000000000000000000",
  ".2917300667342880000000000000000000",
  ".0087007316519110000000000000000000",
  ".2917300667342880000000000000000000",
  ".0181007732788070000000000000000000",
  ".0087007316519110000000000000000000",
  ".6901691599869050000000000000000000",
  ".2917300667342880000000000000000000",
  ".0087007316519110000000000000000000",
  ".0181007732788070000000000000000000",
  ".6901691599869050000000000000000000",
  ".0087007316519110000000000000000000",
  ".1263573854916690000000000000000000",
  ".8514095378342410000000000000000000",
  ".0077608934195225000000000000000000",
  ".8514095378342410000000000000000000",
  ".0222330766740900000000000000000000",
  ".0077608934195225000000000000000000",
  ".0222330766740900000000000000000000",
  ".1263573854916690000000000000000000",
  ".0077608934195225000000000000000000",
  ".1263573854916690000000000000000000",
  ".0222330766740900000000000000000000",
  ".0077608934195225000000000000000000",
  ".8514095378342410000000000000000000",
  ".1263573854916690000000000000000000",
  ".0077608934195225000000000000000000",
  ".0222330766740900000000000000000000",
  ".8514095378342410000000000000000000",
  ".0077608934195225000000000000000000",
    // IM_TRIANGLE(17)

  ".3333333333333335000000000000000000",
  ".3333333333333335000000000000000000",
  ".0167185996454015000000000000000000",
  ".4971705405567740000000000000000000",
  ".4971705405567740000000000000000000",
  ".0025467077202535000000000000000000",
  ".4971705405567740000000000000000000",
  ".0056589188864520000000000000000000",
  ".0025467077202535000000000000000000",
  ".0056589188864520000000000000000000",
  ".4971705405567740000000000000000000",
  ".0025467077202535000000000000000000",
  ".4821763226246250000000000000000000",
  ".4821763226246250000000000000000000",
  ".0073354322638190000000000000000000",
  ".4821763226246250000000000000000000",
  ".0356473547507510000000000000000000",
  ".0073354322638190000000000000000000",
  ".0356473547507510000000000000000000",
  ".4821763226246250000000000000000000",
  ".0073354322638190000000000000000000",
  ".4502399690207820000000000000000000",
  ".4502399690207820000000000000000000",
  ".0121754391768360000000000000000000",
  ".4502399690207820000000000000000000",
  ".0995200619584370000000000000000000",
  ".0121754391768360000000000000000000",
  ".0995200619584370000000000000000000",
  ".4502399690207820000000000000000000",
  ".0121754391768360000000000000000000",
  ".4002662393773970000000000000000000",
  ".4002662393773970000000000000000000",
  ".0155537754344845000000000000000000",
  ".4002662393773970000000000000000000",
  ".1994675212452060000000000000000000",
  ".0155537754344845000000000000000000",
  ".1994675212452060000000000000000000",
  ".4002662393773970000000000000000000",
  ".0155537754344845000000000000000000",
  ".2521412679709530000000000000000000",
  ".2521412679709530000000000000000000",
  ".0156285556093100000000000000000000",
  ".2521412679709530000000000000000000",
  ".4957174640580950000000000000000000",
  ".0156285556093100000000000000000000",
  ".4957174640580950000000000000000000",
  ".2521412679709530000000000000000000",
  ".0156285556093100000000000000000000",
  ".1620470046584610000000000000000000",
  ".1620470046584610000000000000000000",
  ".0124078271698325000000000000000000",
  ".1620470046584610000000000000000000",
  ".6759059906830770000000000000000000",
  ".0124078271698325000000000000000000",
  ".6759059906830770000000000000000000",
  ".1620470046584610000000000000000000",
  ".0124078271698325000000000000000000",
  ".0758758822607460000000000000000000",
  ".0758758822607460000000000000000000",
  ".0070280365352785000000000000000000",
  ".0758758822607460000000000000000000",
  ".8482482354785080000000000000000000",
  ".0070280365352785000000000000000000",
  ".8482482354785080000000000000000000",
  ".0758758822607460000000000000000000",
  ".0070280365352785000000000000000000",
  ".0156547269678220000000000000000000",
  ".0156547269678220000000000000000000",
  ".0015973380868895000000000000000000",
  ".0156547269678220000000000000000000",
  ".9686905460643560000000000000000000",
  ".0015973380868895000000000000000000",
  ".9686905460643560000000000000000000",
  ".0156547269678220000000000000000000",
  ".0015973380868895000000000000000000",
  ".3343198673636580000000000000000000",
  ".6554932038094230000000000000000000",
  ".0040598276594965000000000000000000",
  ".6554932038094230000000000000000000",
  ".0101869288269190000000000000000000",
  ".0040598276594965000000000000000000",
  ".0101869288269190000000000000000000",
  ".3343198673636580000000000000000000",
  ".0040598276594965000000000000000000",
  ".3343198673636580000000000000000000",
  ".0101869288269190000000000000000000",
  ".0040598276594965000000000000000000",
  ".6554932038094230000000000000000000",
  ".3343198673636580000000000000000000",
  ".0040598276594965000000000000000000",
  ".0101869288269190000000000000000000",
  ".6554932038094230000000000000000000",
  ".0040598276594965000000000000000000",
  ".2922215377969440000000000000000000",
  ".5723375905320200000000000000000000",
  ".0134028711415815000000000000000000",
  ".5723375905320200000000000000000000",
  ".1354408716710360000000000000000000",
  ".0134028711415815000000000000000000",
  ".1354408716710360000000000000000000",
  ".2922215377969440000000000000000000",
  ".0134028711415815000000000000000000",
  ".2922215377969440000000000000000000",
  ".1354408716710360000000000000000000",
  ".0134028711415815000000000000000000",
  ".5723375905320200000000000000000000",
  ".2922215377969440000000000000000000",
  ".0134028711415815000000000000000000",
  ".1354408716710360000000000000000000",
  ".5723375905320200000000000000000000",
  ".0134028711415815000000000000000000",
  ".3195748854231900000000000000000000",
  ".6260011902862280000000000000000000",
  ".0092299966054110000000000000000000",
  ".6260011902862280000000000000000000",
  ".0544239242905830000000000000000000",
  ".0092299966054110000000000000000000",
  ".0544239242905830000000000000000000",
  ".3195748854231900000000000000000000",
  ".0092299966054110000000000000000000",
  ".3195748854231900000000000000000000",
  ".0544239242905830000000000000000000",
  ".0092299966054110000000000000000000",
  ".6260011902862280000000000000000000",
  ".3195748854231900000000000000000000",
  ".0092299966054110000000000000000000",
  ".0544239242905830000000000000000000",
  ".6260011902862280000000000000000000",
  ".0092299966054110000000000000000000",
  ".1907042241922920000000000000000000",
  ".7964272149740710000000000000000000",
  ".0042384342671640000000000000000000",
  ".7964272149740710000000000000000000",
  ".0128685608336370000000000000000000",
  ".0042384342671640000000000000000000",
  ".0128685608336370000000000000000000",
  ".1907042241922920000000000000000000",
  ".0042384342671640000000000000000000",
  ".1907042241922920000000000000000000",
  ".0128685608336370000000000000000000",
  ".0042384342671640000000000000000000",
  ".7964272149740710000000000000000000",
  ".1907042241922920000000000000000000",
  ".0042384342671640000000000000000000",
  ".0128685608336370000000000000000000",
  ".7964272149740710000000000000000000",
  ".0042384342671640000000000000000000",
  ".1804832116487460000000000000000000",
  ".7523510059377290000000000000000000",
  ".0091463983850125000000000000000000",
  ".7523510059377290000000000000000000",
  ".0671657824135240000000000000000000",
  ".0091463983850125000000000000000000",
  ".0671657824135240000000000000000000",
  ".1804832116487460000000000000000000",
  ".0091463983850125000000000000000000",
  ".1804832116487460000000000000000000",
  ".0671657824135240000000000000000000",
  ".0091463983850125000000000000000000",
  ".7523510059377290000000000000000000",
  ".1804832116487460000000000000000000",
  ".0091463983850125000000000000000000",
  ".0671657824135240000000000000000000",
  ".7523510059377290000000000000000000",
  ".0091463983850125000000000000000000",
  ".0807113136795640000000000000000000",
  ".9046255040956080000000000000000000",
  ".0033328160020825000000000000000000",
  ".9046255040956080000000000000000000",
  ".0146631822248280000000000000000000",
  ".0033328160020825000000000000000000",
  ".0146631822248280000000000000000000",
  ".0807113136795640000000000000000000",
  ".0033328160020825000000000000000000",
  ".0807113136795640000000000000000000",
  ".0146631822248280000000000000000000",
  ".0033328160020825000000000000000000",
  ".9046255040956080000000000000000000",
  ".0807113136795640000000000000000000",
  ".0033328160020825000000000000000000",
  ".0146631822248280000000000000000000",
  ".9046255040956080000000000000000000",
  ".0033328160020825000000000000000000",
    // IM_TRIANGLE(19)

  ".3333333333333335000000000000000000",
  ".3333333333333335000000000000000000",
  ".0164531656944595000000000000000000",
  ".4896099870730060000000000000000000",
  ".4896099870730060000000000000000000",
  ".0051653659456360000000000000000000",
  ".4896099870730060000000000000000000",
  ".0207800258539870000000000000000000",
  ".0051653659456360000000000000000000",
  ".0207800258539870000000000000000000",
  ".4896099870730060000000000000000000",
  ".0051653659456360000000000000000000",
  ".4545368926978930000000000000000000",
  ".4545368926978930000000000000000000",
  ".0111936236315080000000000000000000",
  ".4545368926978930000000000000000000",
  ".0909262146042150000000000000000000",
  ".0111936236315080000000000000000000",
  ".0909262146042150000000000000000000",
  ".4545368926978930000000000000000000",
  ".0111936236315080000000000000000000",
  ".4014166806494310000000000000000000",
  ".4014166806494310000000000000000000",
  ".0151330629347340000000000000000000",
  ".4014166806494310000000000000000000",
  ".1971666387011380000000000000000000",
  ".0151330629347340000000000000000000",
  ".1971666387011380000000000000000000",
  ".4014166806494310000000000000000000",
  ".0151330629347340000000000000000000",
  ".2555516544030980000000000000000000",
  ".2555516544030980000000000000000000",
  ".0152454839010990000000000000000000",
  ".2555516544030980000000000000000000",
  ".4888966911938050000000000000000000",
  ".0152454839010990000000000000000000",
  ".4888966911938050000000000000000000",
  ".2555516544030980000000000000000000",
  ".0152454839010990000000000000000000",
  ".1770779421521300000000000000000000",
  ".1770779421521300000000000000000000",
  ".0120796063708205000000000000000000",
  ".1770779421521300000000000000000000",
  ".6458441156957410000000000000000000",
  ".0120796063708205000000000000000000",
  ".6458441156957410000000000000000000",
  ".1770779421521300000000000000000000",
  ".0120796063708205000000000000000000",
  ".1100610532279520000000000000000000",
  ".1100610532279520000000000000000000",
  ".0080254017934005000000000000000000",
  ".1100610532279520000000000000000000",
  ".7798778935440960000000000000000000",
  ".0080254017934005000000000000000000",
  ".7798778935440960000000000000000000",
  ".1100610532279520000000000000000000",
  ".0080254017934005000000000000000000",
  ".0555286242518400000000000000000000",
  ".0555286242518400000000000000000000",
  ".0040422901308920000000000000000000",
  ".0555286242518400000000000000000000",
  ".8889427514963210000000000000000000",
  ".0040422901308920000000000000000000",
  ".8889427514963210000000000000000000",
  ".0555286242518400000000000000000000",
  ".0040422901308920000000000000000000",
  ".0126218637772290000000000000000000",
  ".0126218637772290000000000000000000",
  ".0010396810137425000000000000000000",
  ".0126218637772290000000000000000000",
  ".9747562724455430000000000000000000",
  ".0010396810137425000000000000000000",
  ".9747562724455430000000000000000000",
  ".0126218637772290000000000000000000",
  ".0010396810137425000000000000000000",
  ".3957547873569430000000000000000000",
  ".6006337947946450000000000000000000",
  ".0019424384524905000000000000000000",
  ".6006337947946450000000000000000000",
  ".0036114178484120000000000000000000",
  ".0019424384524905000000000000000000",
  ".0036114178484120000000000000000000",
  ".3957547873569430000000000000000000",
  ".0019424384524905000000000000000000",
  ".3957547873569430000000000000000000",
  ".0036114178484120000000000000000000",
  ".0019424384524905000000000000000000",
  ".6006337947946450000000000000000000",
  ".3957547873569430000000000000000000",
  ".0019424384524905000000000000000000",
  ".0036114178484120000000000000000000",
  ".6006337947946430000000000000000000",
  ".0019424384524905000000000000000000",
  ".3079299838804360000000000000000000",
  ".5576032615887840000000000000000000",
  ".0127870803060110000000000000000000",
  ".5576032615887840000000000000000000",
  ".1344667545307800000000000000000000",
  ".0127870803060110000000000000000000",
  ".1344667545307800000000000000000000",
  ".3079299838804360000000000000000000",
  ".0127870803060110000000000000000000",
  ".3079299838804360000000000000000000",
  ".1344667545307800000000000000000000",
  ".0127870803060110000000000000000000",
  ".5576032615887840000000000000000000",
  ".3079299838804360000000000000000000",
  ".0127870803060110000000000000000000",
  ".1344667545307800000000000000000000",
  ".5576032615887840000000000000000000",
  ".0127870803060110000000000000000000",
  ".2645669484065200000000000000000000",
  ".7209870258173650000000000000000000",
  ".0044404517866690000000000000000000",
  ".7209870258173650000000000000000000",
  ".0144460257761150000000000000000000",
  ".0044404517866690000000000000000000",
  ".0144460257761150000000000000000000",
  ".2645669484065200000000000000000000",
  ".0044404517866690000000000000000000",
  ".2645669484065200000000000000000000",
  ".0144460257761150000000000000000000",
  ".0044404517866690000000000000000000",
  ".7209870258173650000000000000000000",
  ".2645669484065200000000000000000000",
  ".0044404517866690000000000000000000",
  ".0144460257761150000000000000000000",
  ".7209870258173650000000000000000000",
  ".0044404517866690000000000000000000",
  ".3585393522059510000000000000000000",
  ".5945270689558710000000000000000000",
  ".0080622733808655000000000000000000",
  ".5945270689558710000000000000000000",
  ".0469335788381780000000000000000000",
  ".0080622733808655000000000000000000",
  ".0469335788381780000000000000000000",
  ".3585393522059510000000000000000000",
  ".0080622733808655000000000000000000",
  ".3585393522059510000000000000000000",
  ".0469335788381780000000000000000000",
  ".0080622733808655000000000000000000",
  ".5945270689558710000000000000000000",
  ".3585393522059510000000000000000000",
  ".0080622733808655000000000000000000",
  ".0469335788381780000000000000000000",
  ".5945270689558710000000000000000000",
  ".0080622733808655000000000000000000",
  ".1578074059685950000000000000000000",
  ".8393314736808390000000000000000000",
  ".0012459709087455000000000000000000",
  ".8393314736808390000000000000000000",
  ".0028611203505670000000000000000000",
  ".0012459709087455000000000000000000",
  ".0028611203505670000000000000000000",
  ".1578074059685950000000000000000000",
  ".0012459709087455000000000000000000",
  ".1578074059685950000000000000000000",
  ".0028611203505670000000000000000000",
  ".0012459709087455000000000000000000",
  ".8393314736808390000000000000000000",
  ".1578074059685950000000000000000000",
  ".0012459709087455000000000000000000",
  ".0028611203505670000000000000000000",
  ".8393314736808390000000000000000000",
  ".0012459709087455000000000000000000",
  ".0750505969759110000000000000000000",
  ".7010879789261730000000000000000000",
  ".0091214200594755000000000000000000",
  ".7010879789261730000000000000000000",
  ".2238614240979160000000000000000000",
  ".0091214200594755000000000000000000",
  ".2238614240979160000000000000000000",
  ".0750505969759110000000000000000000",
  ".0091214200594755000000000000000000",
  ".0750505969759110000000000000000000",
  ".2238614240979160000000000000000000",
  ".0091214200594755000000000000000000",
  ".7010879789261730000000000000000000",
  ".0750505969759110000000000000000000",
  ".0091214200594755000000000000000000",
  ".2238614240979160000000000000000000",
  ".7010879789261730000000000000000000",
  ".0091214200594755000000000000000000",
  ".1424216011133830000000000000000000",
  ".8229313240698570000000000000000000",
  ".0051292818680995000000000000000000",
  ".8229313240698570000000000000000000",
  ".0346470748167600000000000000000000",
  ".0051292818680995000000000000000000",
  ".0346470748167600000000000000000000",
  ".1424216011133830000000000000000000",
  ".0051292818680995000000000000000000",
  ".1424216011133830000000000000000000",
  ".0346470748167600000000000000000000",
  ".0051292818680995000000000000000000",
  ".8229313240698570000000000000000000",
  ".1424216011133830000000000000000000",
  ".0051292818680995000000000000000000",
  ".0346470748167600000000000000000000",
  ".8229313240698570000000000000000000",
  ".0051292818680995000000000000000000",
  ".0654946280829380000000000000000000",
  ".9243442526207840000000000000000000",
  ".0018999644276510000000000000000000",
  ".9243442526207840000000000000000000",
  ".0101611192962780000000000000000000",
  ".0018999644276510000000000000000000",
  ".0101611192962780000000000000000000",
  ".0654946280829380000000000000000000",
  ".0018999644276510000000000000000000",
  ".0654946280829380000000000000000000",
  ".0101611192962780000000000000000000",
  ".0018999644276510000000000000000000",
  ".9243442526207840000000000000000000",
  ".0654946280829380000000000000000000",
  ".0018999644276510000000000000000000",
  ".0101611192962780000000000000000000",
  ".9243442526207840000000000000000000",
  ".0018999644276510000000000000000000",
    // IM_TRIANGLE(2)

  "0.1666666666666666666666666666666666666666666666666666666666666666",
  "0.1666666666666666666666666666666666666666666666666666666666666666",
  "0.1666666666666666666666666666666666666666666666666666666666666666",
    // IM_TRIANGLE(3)

  "0.3333333333333333333333333333333333333333333333333333333333333333",
  "0.3333333333333333333333333333333333333333333333333333333333333333",
  "-0.28125",
  "0.2",
  "0.2",
  "0.2604166666666666666666666666666666666666666666666666666666666666",
    // IM_TRIANGLE(4)

  "0.445948490915965",
  "0.445948490915965",
  "0.111690794839005",
  "0.091576213509771",
  "0.091576213509771",
  "0.054975871827661",
    // IM_TRIANGLE(5)

  "0.333333333333333",
  "0.333333333333333",
  "0.1125",
  "0.470142064105115",
  "0.470142064105115",
  "0.0661970763942530",
  "0.101286507323456",
  "0.101286507323456",
  "0.0629695902724135",
    // IM_TRIANGLE(6)

  "0.0630890144915022283403316028708191",
  "0.0630890144915022283403316028708191",
  "0.0254224531851034084604684045534344",
  "0.249286745170910421291638553107019",
  "0.249286745170910421291638553107019",
  "0.0583931378631896830126448056927897",
  "0.310352451033784405416607733956552",
  "0.0531450498448169473532496716313981",
  "0.0414255378091867875967767282102212",
    // IM_TRIANGLE(7)

  "0.0651301029022",
  "0.0651301029022",
  "0.02667361780440",
  "0.3128654960049",
  "0.0486903154253",
  "0.03855688044515",
  "0.2603459660790",
  "0.2603459660790",
  "0.08780762871660",
  "0.3333333333333",
  "0.3333333333333",
  "-0.07478502223385",
    // IM_TRIANGLE(8)

  "0.333333333333333333333333333333333",
  "0.333333333333333333333333333333333",
  "0.0721578038388935841255455552445323",
  "0.170569307751760206622293501491464",
  "0.170569307751760206622293501491464",
  "0.0516086852673591251408957751460645",
  "0.0505472283170309754584235505965989",
  "0.0505472283170309754584235505965989",
  "0.0162292488115990401554629641708902",
  "0.459292588292723156028815514494169",
  "0.459292588292723156028815514494169",
  "0.0475458171336423123969480521942921",
  "0.728492392955404281241000379176061",
  "0.263112829634638113421785786284643",
  "0.0136151570872174971324223450369544",
    // IM_TRIANGLE(9)

  "0.333333333333333333333333333333333",
  "0.333333333333333333333333333333333",
  "0.0485678981413994169096209912536443",
  "0.489682519198737627783706924836192",
  "0.489682519198737627783706924836192",
  "0.0156673501135695352684274156436046",
  "0.437089591492936637269930364435354",
  "0.437089591492936637269930364435354",
  "0.0389137705023871396583696781497019",
  "0.188203535619032730240961280467335",
  "0.188203535619032730240961280467335",
  "0.0398238694636051265164458871320226",
  "0.0447295133944527098651065899662763",
  "0.0447295133944527098651065899662763",
  "0.0127888378293490156308393992794999",
  "0.741198598784498020690079873523423",
  "0.0368384120547362836348175987833851",
  "0.0216417696886446886446886446886446",
  };

  static const int NB_IMF=326; 

  static const char * im_desc_face_meth[NB_IMF] = {
    // IM_CUBE4D(5)

    "IM_HEXAHEDRON(5)","IM_HEXAHEDRON(5)","IM_HEXAHEDRON(5)","IM_HEXAHEDRON(5)","IM_HEXAHEDRON(5)","IM_HEXAHEDRON(5)","IM_HEXAHEDRON(5)","IM_HEXAHEDRON(5)",
    // IM_CUBE4D(9)

    "IM_HEXAHEDRON(9)","IM_HEXAHEDRON(9)","IM_HEXAHEDRON(9)","IM_HEXAHEDRON(9)","IM_HEXAHEDRON(9)","IM_HEXAHEDRON(9)","IM_HEXAHEDRON(9)","IM_HEXAHEDRON(9)",
    // IM_GAUSSLOBATTO1D(1)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(11)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(13)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(15)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(17)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(19)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(21)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(23)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(25)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(27)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(29)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(3)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(31)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(33)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(35)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(37)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(39)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(41)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(43)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(45)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(47)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(49)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(5)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(51)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(53)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(55)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(57)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(59)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(61)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(63)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(65)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(67)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(69)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(7)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(71)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(73)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(75)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(77)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(79)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(81)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(83)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(85)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(87)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(89)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(9)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(91)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(93)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(95)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(97)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSSLOBATTO1D(99)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(1)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(11)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(13)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(15)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(17)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(19)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(21)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(23)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(25)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(27)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(29)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(3)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(31)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(33)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(35)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(37)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(39)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(41)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(43)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(45)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(47)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(49)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(5)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(51)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(53)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(55)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(57)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(59)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(61)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(63)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(65)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(67)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(69)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(7)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(71)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(73)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(75)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(77)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(79)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(81)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(83)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(85)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(87)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(89)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(9)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(91)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(93)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(95)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(97)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_GAUSS1D(99)

    "IM_NC(0,0)","IM_NC(0,0)",
    // IM_HEXAHEDRON(11)

    "IM_QUAD(17)","IM_QUAD(17)","IM_QUAD(17)","IM_QUAD(17)","IM_QUAD(17)","IM_QUAD(17)",
    // IM_HEXAHEDRON(5)

    "IM_QUAD(5)","IM_QUAD(5)","IM_QUAD(5)","IM_QUAD(5)","IM_QUAD(5)","IM_QUAD(5)",
    // IM_HEXAHEDRON(9)

    "IM_QUAD(9)","IM_QUAD(9)","IM_QUAD(9)","IM_QUAD(9)","IM_QUAD(9)","IM_QUAD(9)",
    // IM_QUAD(17)

    "IM_GAUSS1D(17)","IM_GAUSS1D(17)","IM_GAUSS1D(17)","IM_GAUSS1D(17)",
    // IM_QUAD(2)

    "IM_GAUSS1D(2)","IM_GAUSS1D(2)","IM_GAUSS1D(2)","IM_GAUSS1D(2)",
    // IM_QUAD(3)

    "IM_GAUSS1D(3)","IM_GAUSS1D(3)","IM_GAUSS1D(3)","IM_GAUSS1D(3)",
    // IM_QUAD(5)

    "IM_GAUSS1D(5)","IM_GAUSS1D(5)","IM_GAUSS1D(5)","IM_GAUSS1D(5)",
    // IM_QUAD(7)

    "IM_GAUSS1D(7)","IM_GAUSS1D(7)","IM_GAUSS1D(7)","IM_GAUSS1D(7)",
    // IM_QUAD(9)

    "IM_GAUSS1D(9)","IM_GAUSS1D(9)","IM_GAUSS1D(9)","IM_GAUSS1D(9)",
    // IM_SIMPLEX4D(3)

    "IM_TETRAHEDRON(3)","IM_TETRAHEDRON(3)","IM_TETRAHEDRON(3)","IM_TETRAHEDRON(3)","IM_TETRAHEDRON(3)",
    // IM_TETRAHEDRON(1)

    "IM_TRIANGLE(1)","IM_TRIANGLE(1)","IM_TRIANGLE(1)","IM_TRIANGLE(1)",
    // IM_TETRAHEDRON(2)

    "IM_TRIANGLE(2)","IM_TRIANGLE(2)","IM_TRIANGLE(2)","IM_TRIANGLE(2)",
    // IM_TETRAHEDRON(3)

    "IM_TRIANGLE(3)","IM_TRIANGLE(3)","IM_TRIANGLE(3)","IM_TRIANGLE(3)",
    // IM_TETRAHEDRON(5)

    "IM_TRIANGLE(5)","IM_TRIANGLE(5)","IM_TRIANGLE(5)","IM_TRIANGLE(5)",
    // IM_TETRAHEDRON(6)

    "IM_TRIANGLE(6)","IM_TRIANGLE(6)","IM_TRIANGLE(6)","IM_TRIANGLE(6)",
    // IM_TETRAHEDRON(8)

    "IM_TRIANGLE(8)","IM_TRIANGLE(8)","IM_TRIANGLE(8)","IM_TRIANGLE(8)",
    // IM_TRIANGLE(1)

    "IM_GAUSS1D(1)","IM_GAUSS1D(1)","IM_GAUSS1D(1)",
    // IM_TRIANGLE(10)

    "IM_GAUSS1D(10)","IM_GAUSS1D(10)","IM_GAUSS1D(10)",
    // IM_TRIANGLE(13)

    "IM_GAUSS1D(13)","IM_GAUSS1D(13)","IM_GAUSS1D(13)",
    // IM_TRIANGLE(17)

    "IM_GAUSS1D(17)","IM_GAUSS1D(17)","IM_GAUSS1D(17)",
    // IM_TRIANGLE(19)

    "IM_GAUSS1D(19)","IM_GAUSS1D(19)","IM_GAUSS1D(19)",
    // IM_TRIANGLE(2)

    "IM_GAUSS1D(2)","IM_GAUSS1D(2)","IM_GAUSS1D(2)",
    // IM_TRIANGLE(3)

    "IM_GAUSS1D(3)","IM_GAUSS1D(3)","IM_GAUSS1D(3)",
    // IM_TRIANGLE(4)

    "IM_GAUSS1D(4)","IM_GAUSS1D(4)","IM_GAUSS1D(4)",
    // IM_TRIANGLE(5)

    "IM_GAUSS1D(5)","IM_GAUSS1D(5)","IM_GAUSS1D(5)",
    // IM_TRIANGLE(6)

    "IM_GAUSS1D(6)","IM_GAUSS1D(6)","IM_GAUSS1D(6)",
    // IM_TRIANGLE(7)

    "IM_GAUSS1D(7)","IM_GAUSS1D(7)","IM_GAUSS1D(7)",
    // IM_TRIANGLE(8)

    "IM_GAUSS1D(8)","IM_GAUSS1D(8)","IM_GAUSS1D(8)",
    // IM_TRIANGLE(9)

    "IM_GAUSS1D(9)","IM_GAUSS1D(9)","IM_GAUSS1D(9)",
  };

  static const int NB_IMN=1574; 

  static size_type im_desc_node_type[NB_IMN] = {
    2, 2,  // IM_CUBE4D(5)

    2, 2, 2, 2, 2, 2,  // IM_CUBE4D(9)

    1,  // IM_GAUSSLOBATTO1D(1)

    1, 1, 1,  // IM_GAUSSLOBATTO1D(11)

    1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(13)

    1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(15)

    1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(17)

    1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(19)

    1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(21)

    1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(23)

    1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(25)

    1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(27)

    1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(29)

    1,  // IM_GAUSSLOBATTO1D(3)

    1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(31)

    1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(33)

    1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(35)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(37)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(39)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(41)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(43)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(45)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(47)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(49)

    1, 1,  // IM_GAUSSLOBATTO1D(5)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(51)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(53)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(55)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(57)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(59)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(61)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(63)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(65)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(67)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(69)

    1, 1,  // IM_GAUSSLOBATTO1D(7)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(71)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(73)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(75)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(77)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(79)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(81)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(83)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(85)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(87)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(89)

    1, 1, 1,  // IM_GAUSSLOBATTO1D(9)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(91)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(93)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(95)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(97)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSSLOBATTO1D(99)

    1,  // IM_GAUSS1D(1)

    1, 1, 1,  // IM_GAUSS1D(11)

    1, 1, 1, 1,  // IM_GAUSS1D(13)

    1, 1, 1, 1,  // IM_GAUSS1D(15)

    1, 1, 1, 1, 1,  // IM_GAUSS1D(17)

    1, 1, 1, 1, 1,  // IM_GAUSS1D(19)

    1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(21)

    1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(23)

    1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(25)

    1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(27)

    1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(29)

    1,  // IM_GAUSS1D(3)

    1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(31)

    1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(33)

    1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(35)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(37)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(39)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(41)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(43)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(45)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(47)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(49)

    1, 1,  // IM_GAUSS1D(5)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(51)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(53)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(55)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(57)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(59)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(61)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(63)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(65)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(67)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(69)

    1, 1,  // IM_GAUSS1D(7)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(71)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(73)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(75)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(77)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(79)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(81)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(83)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(85)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(87)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(89)

    1, 1, 1,  // IM_GAUSS1D(9)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(91)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(93)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(95)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(97)

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // IM_GAUSS1D(99)

    2, 2, 2, 2, 2, 2, 2,  // IM_HEXAHEDRON(11)

    2, 2,  // IM_HEXAHEDRON(5)

    2, 2, 1, 1, 2,  // IM_HEXAHEDRON(9)

    0,  // IM_NC(0,0)

    2, 2, 2, 2, 2, 2, 2, 2, 2, 2,  // IM_QUAD(17)

    0, 0, 0,  // IM_QUAD(2)

    2,  // IM_QUAD(3)

    0, 1, 1,  // IM_QUAD(5)

    2, 1, 1,  // IM_QUAD(7)

    2, 2, 2, 2, 2, 2,  // IM_QUAD(9)

    1, 1,  // IM_SIMPLEX4D(3)

    0,  // IM_TETRAHEDRON(1)

    1,  // IM_TETRAHEDRON(2)

    0, 1,  // IM_TETRAHEDRON(3)

    0, 1, 1, 1,  // IM_TETRAHEDRON(5)

    1, 1, 1, 1,  // IM_TETRAHEDRON(6)

    1, 1, 1, 1, 1, 1, 1,  // IM_TETRAHEDRON(8)

    0,  // IM_TRIANGLE(1)

    0, 1, 1, 1, 1, 1,  // IM_TRIANGLE(10)

    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // IM_TRIANGLE(13)

    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // IM_TRIANGLE(17)

    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // IM_TRIANGLE(19)

    1,  // IM_TRIANGLE(2)

    0, 1,  // IM_TRIANGLE(3)

    1, 1,  // IM_TRIANGLE(4)

    0, 1, 1,  // IM_TRIANGLE(5)

    1, 1, 1,  // IM_TRIANGLE(6)

    1, 1, 1, 0,  // IM_TRIANGLE(7)

    0, 1, 1, 1, 1,  // IM_TRIANGLE(8)

    1, 1, 1, 1, 1, 1,  // IM_TRIANGLE(9)

  };

}

